/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.text.DecimalFormat;
import org.apache.jmeter.samplers.SampleResult;

class SummariserRunningSample {
    private final DecimalFormat errorFormatter = new DecimalFormat("#0.00%");
    private long counter;
    private long runningSum;
    private long max;
    private long min;
    private long errorCount;
    private long startTime;
    private long endTime;
    private final String label;

    public SummariserRunningSample(String label) {
        this.label = label;
        this.init();
    }

    public SummariserRunningSample(SummariserRunningSample src) {
        this.label = src.label;
        this.counter = src.counter;
        this.errorCount = src.errorCount;
        this.startTime = src.startTime;
        this.endTime = src.endTime;
        this.max = src.max;
        this.min = src.min;
        this.runningSum = src.runningSum;
    }

    private void init() {
        this.counter = 0L;
        this.runningSum = 0L;
        this.max = Long.MIN_VALUE;
        this.min = Long.MAX_VALUE;
        this.errorCount = 0L;
        this.endTime = this.startTime = System.currentTimeMillis();
    }

    public void clear() {
        this.init();
    }

    public void addSample(SummariserRunningSample rs) {
        this.counter += rs.counter;
        this.errorCount += rs.errorCount;
        this.runningSum += rs.runningSum;
        if (this.max < rs.max) {
            this.max = rs.max;
        }
        if (this.min > rs.min) {
            this.min = rs.min;
        }
        this.endTime = System.currentTimeMillis();
    }

    public void addSample(SampleResult res) {
        this.counter += (long)res.getSampleCount();
        this.errorCount += (long)res.getErrorCount();
        long aTimeInMillis = res.getTime();
        this.runningSum += aTimeInMillis;
        if (aTimeInMillis > this.max) {
            this.max = aTimeInMillis;
        }
        if (aTimeInMillis < this.min) {
            this.min = aTimeInMillis;
        }
        this.endTime = System.currentTimeMillis();
    }

    public long getNumSamples() {
        return this.counter;
    }

    public long getElapsed() {
        if (this.counter == 0L) {
            return 0L;
        }
        return this.endTime - this.startTime;
    }

    public double getRate() {
        if (this.counter == 0L) {
            return 0.0;
        }
        long howLongRunning = this.endTime - this.startTime;
        if (howLongRunning == 0L) {
            return Double.MAX_VALUE;
        }
        return (double)this.counter / (double)howLongRunning * 1000.0;
    }

    public long getAverage() {
        if (this.counter == 0L) {
            return 0L;
        }
        return this.runningSum / this.counter;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public String getErrorPercentageString() {
        return this.errorFormatter.format(this.getErrorPercentage());
    }

    public double getErrorPercentage() {
        if (this.counter == 0L) {
            return 0.0;
        }
        double rval = (double)this.errorCount / (double)this.counter;
        return rval;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }
}

