/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.Validate;
import org.apache.jmeter.report.core.CsvSampleReader;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SampleMetadata;
import org.apache.jmeter.report.core.TimeHelper;
import org.apache.jmeter.report.processor.AbstractSampleProcessor;
import org.apache.jmeter.report.processor.AbstractSampleSource;
import org.apache.jmeter.report.processor.SampleConsumer;
import org.apache.jmeter.report.processor.SampleContext;
import org.apache.jmeter.report.processor.SampleProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvFileSampleSource
extends AbstractSampleSource {
    public static final String SOURCE_FILE_ATTRIBUTE = "samplesource.file";
    private static final Logger LOG = LoggerFactory.getLogger(CsvFileSampleSource.class);
    private File[] inputFiles;
    private CsvSampleReader[] csvReaders;
    private PrivateProducer producer;

    public CsvFileSampleSource(File inputFile, char separator) {
        String inputRootName = CsvFileSampleSource.getFileRootName(inputFile.getName());
        String inputExtension = CsvFileSampleSource.getFileExtension(inputFile.getName());
        File[] secondaryInputs = null;
        try {
            Pattern pattern = Pattern.compile(inputRootName + "-[0-9]+\\." + inputExtension);
            secondaryInputs = inputFile.getAbsoluteFile().getParentFile().listFiles(pathname -> pathname.isFile() && pattern.matcher(pathname.getName()).matches());
        }
        catch (PatternSyntaxException e) {
            throw new SampleException("Could not locate input sample files !", e);
        }
        if (secondaryInputs == null) {
            secondaryInputs = new File[]{};
        }
        this.inputFiles = new File[secondaryInputs.length + 1];
        this.csvReaders = new CsvSampleReader[secondaryInputs.length + 1];
        int k = 0;
        this.csvReaders[k] = new CsvSampleReader(inputFile, separator, true);
        this.inputFiles[k] = inputFile;
        for (File input : secondaryInputs) {
            this.csvReaders[++k] = new CsvSampleReader(input, separator, true);
            this.inputFiles[k] = secondaryInputs[k - 1];
        }
        this.producer = new PrivateProducer();
    }

    private static String getFileRootName(String fName) {
        int idx = fName.lastIndexOf(46);
        if (idx < 0) {
            return fName;
        }
        return fName.substring(0, idx);
    }

    private static String getFileExtension(String fName) {
        int idx = fName.lastIndexOf(46);
        if (idx < 0) {
            return "";
        }
        if (idx < fName.length() - 1) {
            return fName.substring(idx + 1);
        }
        return "";
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private String time(long t) {
        return TimeHelper.time(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produce() {
        SampleContext context = this.getSampleContext();
        Validate.validState((context != null ? 1 : 0) != 0, (String)"Set a sample context before producing samples.", (Object[])new Object[0]);
        for (int i = 0; i < this.csvReaders.length; ++i) {
            long sampleCount = 0L;
            long start2 = this.now();
            CsvSampleReader csvReader = this.csvReaders[i];
            this.producer.setSampleContext(context);
            this.producer.setProducedMetadata(csvReader.getMetadata(), i);
            this.producer.setChannelAttribute(i, SOURCE_FILE_ATTRIBUTE, this.inputFiles[i]);
            this.producer.startProducing();
            try {
                Sample s = null;
                while ((s = csvReader.readSample()) != null) {
                    this.producer.produce(s, i);
                    ++sampleCount;
                }
            }
            finally {
                this.producer.stopProducing();
                csvReader.close();
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info("produce(): {} samples produced in {} on channel {}", new Object[]{sampleCount, this.time(this.now() - start2), i});
        }
    }

    @Override
    public void setSampleConsumers(List<SampleConsumer> consumers) {
        this.producer.setSampleConsumers(consumers);
    }

    @Override
    public void addSampleConsumer(SampleConsumer consumer) {
        this.producer.addSampleConsumer(consumer);
    }

    @Override
    public void removeSampleConsumer(SampleConsumer consumer) {
        this.producer.removeSampleConsumer(consumer);
    }

    @Override
    public void run() {
        this.produce();
    }

    private static class PrivateProducer
    extends AbstractSampleProcessor
    implements SampleProducer {
        private List<SampleConsumer> sampleConsumers = new ArrayList<SampleConsumer>();

        private PrivateProducer() {
        }

        public void setSampleConsumers(List<SampleConsumer> consumers) {
            Validate.notNull(consumers, (String)"consumers must not be null", (Object[])new Object[0]);
            this.sampleConsumers = consumers;
        }

        public void addSampleConsumer(SampleConsumer consumer) {
            if (consumer == null) {
                return;
            }
            this.sampleConsumers.add(consumer);
        }

        public void removeSampleConsumer(SampleConsumer consumer) {
            if (consumer == null) {
                return;
            }
            this.sampleConsumers.remove(consumer);
        }

        @Override
        public void setSampleContext(SampleContext context) {
            for (SampleConsumer consumer : this.sampleConsumers) {
                try {
                    consumer.setSampleContext(context);
                }
                catch (Exception e) {
                    throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
                }
            }
        }

        @Override
        public void setProducedMetadata(SampleMetadata metadata, int channel) {
            for (SampleConsumer consumer : this.sampleConsumers) {
                try {
                    consumer.setConsumedMetadata(metadata, channel);
                }
                catch (Exception e) {
                    throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
                }
            }
        }

        @Override
        public void setChannelAttribute(int channel, String key, Object value) {
            super.setChannelAttribute(channel, key, value);
            for (SampleConsumer consumer : this.sampleConsumers) {
                try {
                    consumer.setChannelAttribute(channel, key, value);
                }
                catch (Exception e) {
                    throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
                }
            }
        }

        @Override
        public void startProducing() {
            for (SampleConsumer consumer : this.sampleConsumers) {
                try {
                    consumer.startConsuming();
                }
                catch (Exception e) {
                    throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
                }
            }
        }

        @Override
        public void produce(Sample s, int channel) {
            for (SampleConsumer consumer : this.sampleConsumers) {
                try {
                    consumer.consume(s, channel);
                }
                catch (Exception e) {
                    throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
                }
            }
        }

        @Override
        public void stopProducing() {
            for (SampleConsumer consumer : this.sampleConsumers) {
                try {
                    consumer.stopConsuming();
                }
                catch (Exception e) {
                    throw new SampleException("Consumer failed with message :" + e.getMessage(), e);
                }
            }
        }
    }
}

