/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.letsPlot;

import java.util.Iterator;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.PlotSizeHelper;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.letsPlot.GGBunch;
import jetbrains.letsPlot.intern.Plot;
import jetbrains.letsPlot.intern.ToSpecConvertersKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\u001aJ\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a8\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"gggrid", "Ljetbrains/letsPlot/GGBunch;", "plots", "", "Ljetbrains/letsPlot/intern/Plot;", "ncol", "", "cellWidth", "cellHeight", "hGap", "vGap", "fit", "", "preferredFigureSize", "Lkotlin/Pair;", "figureSpec", "", "", "", "width", "height", "plot-api"})
public final class GggridKt {
    @NotNull
    public static final GGBunch gggrid(@NotNull Iterable<Plot> plots, int ncol, int cellWidth, int cellHeight, int hGap, int vGap, boolean fit) {
        Intrinsics.checkNotNullParameter(plots, (String)"plots");
        GGBunch bunch = new GGBunch();
        Iterator<Plot> iterator = plots.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            Plot p = iterator.next();
            Pair<Integer, Integer> figureSize = GggridKt.preferredFigureSize(ToSpecConvertersKt.toSpec(p), cellWidth, cellHeight);
            int col = i % ncol;
            int row = i / ncol;
            int x = col * (cellWidth + hGap);
            int y = row * (cellHeight + vGap);
            if (fit) {
                bunch.addPlot(p, x, y, cellWidth, cellHeight);
                continue;
            }
            bunch.addPlot(p, x, y, (Integer)figureSize.getFirst(), (Integer)figureSize.getSecond());
        }
        return bunch;
    }

    public static /* synthetic */ GGBunch gggrid$default(Iterable iterable, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, Object object) {
        if ((n6 & 0x10) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n5 = 50;
        }
        if ((n6 & 0x40) != 0) {
            bl = false;
        }
        return GggridKt.gggrid(iterable, n, n2, n3, n4, n5, bl);
    }

    private static final Pair<Integer, Integer> preferredFigureSize(Map<String, ? extends Object> figureSpec, int width, int height) {
        Pair pair;
        if (PlotConfig.Companion.isGGBunchSpec(figureSpec)) {
            DoubleVector bunchSize = PlotSizeHelper.INSTANCE.plotBunchSize(figureSpec);
            double d = bunchSize.getX();
            boolean bl = false;
            Integer n = (int)Math.ceil(d);
            d = bunchSize.getY();
            bl = false;
            Pair pair2 = new Pair((Object)n, (Object)((int)Math.ceil(d)));
            pair = pair2;
        } else if (PlotConfig.Companion.isPlotSpec(figureSpec)) {
            double aspectRatio = PlotSizeHelper.INSTANCE.figureAspectRatio(figureSpec);
            if (aspectRatio >= 1.0) {
                double plotHeight = (double)width / aspectRatio;
                double scaling = plotHeight > (double)height ? (double)height / plotHeight : 1.0;
                double d = (double)width * scaling;
                boolean bl = false;
                Integer n = (int)Math.floor(d);
                d = plotHeight * scaling;
                bl = false;
                Pair pair3 = new Pair((Object)n, (Object)((int)Math.floor(d)));
                pair = pair3;
            } else {
                double plotWidth = (double)height * aspectRatio;
                double scaling = plotWidth > (double)width ? (double)width / plotWidth : 1.0;
                double d = plotWidth * scaling;
                boolean bl = false;
                Integer n = (int)Math.floor(d);
                d = (double)height * scaling;
                bl = false;
                Pair pair4 = new Pair((Object)n, (Object)((int)Math.floor(d)));
                pair = pair4;
            }
        } else {
            pair = new Pair((Object)width, (Object)height);
        }
        return pair;
    }
}

