/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.filechooser;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.listener.AncestorAdapter;
import com.github.weisj.darklaf.ui.filechooser.DarkFilterComboBoxRenderer;
import com.github.weisj.darklaf.ui.table.TextTableCellEditorBorder;
import com.github.weisj.darklaf.ui.table.renderer.DarkTableCellEditor;
import com.github.weisj.darklaf.ui.table.renderer.DarkTableCellEditorDelegate;
import com.github.weisj.darklaf.ui.table.renderer.DarkTableCellRenderer;
import com.github.weisj.darklaf.util.AlignmentExt;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class DarkFileChooserUI
extends MetalFileChooserUI {
    private static final int COLUMN_FILENAME = 0;
    private final DarkFileView fileView = this.createFileView();
    private Icon textFileIcon;
    private Icon imageFileIcon;
    private final AncestorListener editorAncestorListener = new AncestorAdapter(){

        @Override
        public void ancestorAdded(AncestorEvent event) {
            SwingUtilities.invokeLater(() -> {
                JComponent component = event.getComponent();
                component.requestFocusInWindow();
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
            });
        }
    };

    public DarkFileChooserUI(JFileChooser fileChooser) {
        super(fileChooser);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarkFileChooserUI((JFileChooser)c);
    }

    @Override
    protected void installIcons(JFileChooser fc) {
        super.installIcons(fc);
        this.textFileIcon = UIManager.getIcon("FileView.textFileIcon");
        this.imageFileIcon = UIManager.getIcon("FileView.imageFileIcon");
    }

    @Override
    public void installComponents(JFileChooser fc) {
        super.installComponents(fc);
        this.adjustComponents(fc);
    }

    private void adjustComponents(JFileChooser fc) {
        JPanel topPanel = this.getComponentWithLayout(fc, 0, JPanel.class, BorderLayout.class);
        if (topPanel != null) {
            int maximumRowCount;
            JComboBox directoryComboBox;
            JComponent buttonPanel = this.getComponentWithLayout(topPanel, 0, JComponent.class, BoxLayout.class);
            if (buttonPanel != null) {
                Component[] comps = buttonPanel.getComponents();
                int firstButtonIndex = -1;
                int secondButtonIndex = -1;
                for (int i = comps.length - 1; i >= 0; --i) {
                    Component c = comps[i];
                    if (c instanceof AbstractButton) {
                        AbstractButton b = (AbstractButton)c;
                        b.setMargin(null);
                        b.putClientProperty("JButton.noBorderlessOverwrite", true);
                        b.putClientProperty("JButton.square", true);
                        b.putClientProperty("JButton.thin", true);
                        b.putClientProperty("JToolTip.style", "balloon");
                        if (secondButtonIndex < 0 && firstButtonIndex >= 0) {
                            secondButtonIndex = i;
                        }
                        if (firstButtonIndex >= 0) continue;
                        firstButtonIndex = i;
                        continue;
                    }
                    if (!(c instanceof Box.Filler) || secondButtonIndex >= 0) continue;
                    buttonPanel.remove(i);
                }
                if (firstButtonIndex >= 0 && secondButtonIndex >= 0) {
                    AbstractButton detailsViewButton = (AbstractButton)comps[firstButtonIndex];
                    AbstractButton listViewButton = (AbstractButton)comps[secondButtonIndex];
                    detailsViewButton.setSelectedIcon(UIManager.getIcon("FileChooser.detailsViewSelectedIcon"));
                    detailsViewButton.putClientProperty("JButton.cornerFlag", AlignmentExt.RIGHT);
                    detailsViewButton.putClientProperty("JButton.leftNeighbour", listViewButton);
                    listViewButton.setSelectedIcon(UIManager.getIcon("FileChooser.listViewSelectedIcon"));
                    listViewButton.putClientProperty("JButton.cornerFlag", AlignmentExt.LEFT);
                    listViewButton.putClientProperty("JButton.rightNeighbour", detailsViewButton);
                }
            }
            if ((directoryComboBox = this.getComponentWithLayout(topPanel, 2, JComboBox.class, null)) != null && (maximumRowCount = UIManager.getInt("ComboBox.maximumRowCount")) > 0) {
                directoryComboBox.setMaximumRowCount(maximumRowCount);
            }
        }
        for (Component comp : fc.getComponents()) {
            if (!comp.isPreferredSizeSet()) continue;
            comp.setPreferredSize(null);
        }
    }

    @Override
    protected MetalFileChooserUI.FilterComboBoxRenderer createFilterComboBoxRenderer() {
        final DarkFilterComboBoxRenderer realRenderer = new DarkFilterComboBoxRenderer();
        return new MetalFileChooserUI.FilterComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return realRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        };
    }

    @Override
    protected JPanel createDetailsView(JFileChooser fc) {
        Component cTable;
        JPanel p = super.createDetailsView(fc);
        OverlayScrollPane sp = this.getComponentWithLayout(p = this.wrapInOverlayScrollPane(p), 0, OverlayScrollPane.class, null);
        if (sp != null && (cTable = sp.getScrollPane().getViewport().getView()) instanceof JTable) {
            this.patchDetailsView((JTable)cTable);
        }
        return p;
    }

    private void patchDetailsView(JTable table) {
        final TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        table.setDefaultRenderer(Object.class, new DarkTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (SystemInfo.isWindows && value instanceof String && ((String)value).startsWith("\u200e")) {
                    String str = (String)value;
                    char[] buf = new char[str.length()];
                    int j = 0;
                    for (int i = 0; i < buf.length; ++i) {
                        char ch = str.charAt(i);
                        if (ch == '\u200e' || ch == '\u200f') continue;
                        buf[j++] = ch;
                    }
                    value = new String(buf, 0, j);
                }
                JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel defaultComp = (JLabel)defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setIcon(defaultComp.getIcon());
                comp.setDisabledIcon(defaultComp.getDisabledIcon());
                comp.setText(defaultComp.getText());
                comp.setHorizontalAlignment(defaultComp.getHorizontalAlignment());
                return comp;
            }
        });
        table.setAutoResizeMode(3);
        table.putClientProperty("JTable.rowFocusBorder", true);
        table.putClientProperty("JTable.fileChooserParent", this::getFileChooser);
        table.putClientProperty("JTable.fileNameColumnIndex", 0);
        table.doLayout();
        int rowHeight = UIManager.getInt("FileChooser.rowHeight");
        table.addPropertyChangeListener(e -> {
            String name = e.getPropertyName();
            if ("rowHeight".equals(name) && table.getRowHeight() != rowHeight) {
                table.setRowHeight(rowHeight);
            }
        });
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setCellEditor(new FileTableEditor(column.getCellEditor()));
        column.addPropertyChangeListener(e -> {
            if ("cellEditor".equals(e.getPropertyName()) && !(column.getCellEditor() instanceof FileTableEditor)) {
                column.setCellEditor(new FileTableEditor(column.getCellEditor()));
            }
        });
        table.setShowGrid(true);
        table.setShowGrid(false);
    }

    @Override
    protected JPanel createList(JFileChooser fc) {
        Component cList;
        JPanel p = super.createList(fc);
        OverlayScrollPane sp = this.getComponentWithLayout(p = this.wrapInOverlayScrollPane(p), 0, OverlayScrollPane.class, null);
        if (sp != null && (cList = sp.getScrollPane().getViewport().getView()) instanceof JList) {
            this.patchListView((JList)cList);
        }
        return p;
    }

    private void patchListView(final JList<?> list) {
        list.setCellRenderer(new DarkFileRenderer());
        list.putClientProperty("JList.fullRowSelection", true);
        list.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                final Component c = e.getChild();
                if (c instanceof JTextComponent) {
                    c.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentMoved(ComponentEvent e) {
                            c.removeComponentListener(this);
                            ListCellRenderer renderer = list.getCellRenderer();
                            if (renderer instanceof JLabel) {
                                int gap = ((JLabel)((Object)renderer)).getIconTextGap() - 1;
                                if (c.getComponentOrientation().isLeftToRight()) {
                                    c.setBounds(c.getX() + gap, c.getY(), c.getWidth() - gap, c.getHeight());
                                } else {
                                    c.setBounds(c.getX(), c.getY(), c.getWidth() - gap, c.getHeight());
                                }
                            }
                        }
                    });
                    c.setName("FileChooser.listEditCell");
                    ((JTextComponent)c).setBorder(new TextTableCellEditorBorder());
                    ((JTextComponent)c).putClientProperty("JTextField.listCellEditor", true);
                    ((JTextComponent)c).putClientProperty("JComponent.listCellEditor", true);
                }
            }
        });
    }

    private JPanel wrapInOverlayScrollPane(JPanel panel) {
        JPanel p = panel;
        JScrollPane sp = this.getComponentWithLayout(p, 0, JScrollPane.class, null);
        if (sp != null) {
            p = new JPanel(new BorderLayout());
            OverlayScrollPane osp = new OverlayScrollPane(sp);
            p.setPreferredSize(UIManager.getDimension("FileChooser.prefContentSize"));
            osp.setAddHorizontalScrollBarSize(true);
            osp.setAddHorizontalScrollBarSize(true);
            p.add(osp);
        }
        return p;
    }

    private <T extends JComponent, L extends LayoutManager> T getComponentWithLayout(Container parent, int index, Class<T> type, Class<L> layoutType) {
        try {
            Component c = parent.getComponent(index);
            if (type.isInstance(c) && (layoutType == null || layoutType.isInstance(((JComponent)c).getLayout()))) {
                return (T)((JComponent)type.cast(c));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    @Override
    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    protected DarkFileView createFileView() {
        return new DarkFileView();
    }

    private class DarkFileView
    extends BasicFileChooserUI.BasicFileView {
        private static final String MIME_TEXT = "text/";
        private static final String MIME_IMAGE = "image/";

        private DarkFileView() {
            super(DarkFileChooserUI.this);
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            icon = DarkFileChooserUI.this.fileIcon;
            if (f != null) {
                FileSystemView fsv = DarkFileChooserUI.this.getFileChooser().getFileSystemView();
                if (fsv.isFloppyDrive(f)) {
                    icon = DarkFileChooserUI.this.floppyDriveIcon;
                } else if (fsv.isDrive(f)) {
                    icon = DarkFileChooserUI.this.hardDriveIcon;
                } else if (fsv.isComputerNode(f)) {
                    icon = DarkFileChooserUI.this.computerIcon;
                } else if (f.isDirectory()) {
                    icon = DarkFileChooserUI.this.directoryIcon;
                } else {
                    try {
                        String mimeType = Files.probeContentType(f.toPath());
                        if (mimeType == null) {
                            mimeType = "";
                        }
                        if (mimeType.startsWith(MIME_IMAGE)) {
                            icon = DarkFileChooserUI.this.imageFileIcon;
                        } else if (mimeType.startsWith(MIME_TEXT)) {
                            icon = DarkFileChooserUI.this.textFileIcon;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.cacheIcon(f, icon);
            return icon;
        }
    }

    private class FileTableEditor
    extends DarkTableCellEditorDelegate {
        private FileTableEditor(TableCellEditor delegate) {
            DefaultCellEditor editor;
            Component component;
            super(delegate);
            if (delegate instanceof DefaultCellEditor && (component = (editor = (DefaultCellEditor)delegate).getComponent()) instanceof JTextField) {
                JTextField tf = (JTextField)component;
                tf.removeAncestorListener(DarkFileChooserUI.this.editorAncestorListener);
                tf.addAncestorListener(DarkFileChooserUI.this.editorAncestorListener);
                this.setDelegate(new DarkTableCellEditor(tf){

                    @Override
                    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                        Object realValue = value instanceof File ? DarkFileChooserUI.this.getFileChooser().getName((File)value) : value;
                        return super.getTableCellEditorComponent(table, realValue, isSelected, row, column);
                    }
                });
            }
        }
    }

    private class DarkFileRenderer
    extends DefaultListCellRenderer {
        private DarkFileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (comp instanceof JLabel) {
                File file = (File)value;
                String fileName = DarkFileChooserUI.this.getFileChooser().getName(file);
                ((JLabel)comp).setText(fileName);
                Icon icon = DarkFileChooserUI.this.getFileChooser().getIcon(file);
                if (icon != null) {
                    ((JLabel)comp).setIcon(icon);
                } else if (DarkFileChooserUI.this.getFileChooser().getFileSystemView().isTraversable(file).booleanValue()) {
                    ((JLabel)comp).setText(fileName + File.separator);
                }
            }
            return comp;
        }
    }
}

