/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui.ui;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="5.5", status=API.Status.INTERNAL)
public class KerningOptimizer {
    private static final Logger log = LoggerFactory.getLogger(KerningOptimizer.class);
    public static final KerningOptimizer INSTANCE = new KerningOptimizer();
    private volatile int maxLengthWithKerning = 10000;

    public void setMaxTextLengthWithKerning(int length) {
        this.maxLengthWithKerning = length;
    }

    public int getMaxTextLengthWithKerning() {
        return this.maxLengthWithKerning;
    }

    public void configureKerning(JComponent component, int documentLength) {
        boolean desiredKerning;
        Boolean kerning = FontKerningCache.kerningOf(component);
        if (kerning == null) {
            return;
        }
        boolean bl = desiredKerning = documentLength <= this.maxLengthWithKerning;
        if (kerning != desiredKerning) {
            if (log.isDebugEnabled()) {
                log.info("Updating kerning (old: {}, new: {}), documentLength={}, component {}, ", new Object[]{kerning, desiredKerning, documentLength, component});
            }
            Font font = component.getFont();
            Font newFont = font.deriveFont(Collections.singletonMap(TextAttribute.KERNING, desiredKerning ? TextAttribute.KERNING_ON : 0));
            SwingUtilities.invokeLater(() -> component.setFont(newFont));
        }
    }

    public void installKerningListener(JTextComponent textComponent) {
        log.debug("Installing KerningOptimizer {} to {}", (Object)this, (Object)textComponent);
        textComponent.addPropertyChangeListener("document", new DisableKerningForLargeTexts(textComponent));
    }

    public void uninstallKerningListener(JTextComponent textComponent) {
        DisableKerningForLargeTexts kerningListener = null;
        for (PropertyChangeListener listener : textComponent.getPropertyChangeListeners("document")) {
            if (!(listener instanceof DisableKerningForLargeTexts)) continue;
            kerningListener = (DisableKerningForLargeTexts)listener;
        }
        if (kerningListener == null) {
            return;
        }
        log.debug("Uninstalling KerningOptimizer {} from {}", (Object)this, (Object)textComponent);
        Document document = textComponent.getDocument();
        if (document != null) {
            document.removeDocumentListener(kerningListener);
        }
        textComponent.removePropertyChangeListener("document", kerningListener);
    }

    static class DisableKerningForLargeTexts
    implements PropertyChangeListener,
    DocumentListener {
        final JTextComponent component;

        DisableKerningForLargeTexts(JTextComponent component) {
            this.component = component;
        }

        private void configureKerning(Document e) {
            boolean desiredKerning;
            Boolean kerning = FontKerningCache.kerningOf(this.component);
            if (kerning == null) {
                return;
            }
            boolean bl = desiredKerning = e.getLength() <= INSTANCE.getMaxTextLengthWithKerning();
            if (kerning != desiredKerning) {
                SwingUtilities.invokeLater(() -> INSTANCE.configureKerning(this.component, e.getLength()));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Document newDocument;
            if (!"document".equals(evt.getPropertyName())) {
                return;
            }
            Document oldDocument = (Document)evt.getOldValue();
            if (oldDocument != null) {
                oldDocument.removeDocumentListener(this);
            }
            if ((newDocument = (Document)evt.getNewValue()) != null) {
                newDocument.addDocumentListener(this);
                this.configureKerning(newDocument);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.configureKerning(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.configureKerning(e.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.configureKerning(e.getDocument());
        }
    }

    static class FontKerningCache {
        private static final String CLIENT_PROPERTY_KEY = "[jmeter]FontKerningCache";
        WeakReference<Font> font;
        boolean kerning;

        FontKerningCache() {
        }

        static Boolean kerningOf(JComponent component) {
            Font font = component.getFont();
            if (font == null) {
                return null;
            }
            if (!font.hasLayoutAttributes()) {
                return false;
            }
            FontKerningCache cache = (FontKerningCache)component.getClientProperty(CLIENT_PROPERTY_KEY);
            if (cache == null) {
                cache = new FontKerningCache();
                component.putClientProperty(CLIENT_PROPERTY_KEY, cache);
            }
            if (cache.font == null || !font.equals(cache.font.get())) {
                cache.font = new WeakReference<Font>(font);
                cache.kerning = TextAttribute.KERNING_ON.equals(font.getAttributes().get(TextAttribute.KERNING));
            }
            return cache.kerning;
        }
    }
}

