# coding: utf-8

"""
    Nomad Pilot

    This is the API descriptor for the Nomad Pilot API, responsible for shipping and logistics processing. Developed by [Samarkand Global](https://samarkand.global) in partnership with [SF Express](https://www.sf-express.com/cn/sc), [eSinotrans](http://www.esinotrans.com/haitao.html), [sto](https://open.sto.cn/). Read the documentation online at [Nomad API Suite](https://api.samarkand.io/) and Check out the detailed [changelog](https://gitlab.com/samarkand-nomad/nomad_readme/-/raw/master/history/nomad_pilot.md). - Install for node with `npm install nomad_pilot_cli` - Install for python with `pip install nomad-pilot-cli` - Install for Maven users `groupId, com.gitlab.samarkand-nomad; artifactId, nomad-pilot-cli`  # noqa: E501

    The version of the OpenAPI document: 1.31.1
    Contact: paul@samarkand.global
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nomad_pilot_cli.configuration import Configuration


class PackageFreight(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'operation': 'str',
        'tracking_refs': 'list[str]'
    }

    attribute_map = {
        'operation': 'operation',
        'tracking_refs': 'tracking_refs'
    }

    def __init__(self, operation='QUERY', tracking_refs=[], local_vars_configuration=None):  # noqa: E501
        """PackageFreight - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._operation = None
        self._tracking_refs = None
        self.discriminator = None

        self.operation = operation
        if tracking_refs is not None:
            self.tracking_refs = tracking_refs

    @property
    def operation(self):
        """Gets the operation of this PackageFreight.  # noqa: E501

        Operation for Freight Forwarding DB, avaiables options: QUERY  # noqa: E501

        :return: The operation of this PackageFreight.  # noqa: E501
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """Sets the operation of this PackageFreight.

        Operation for Freight Forwarding DB, avaiables options: QUERY  # noqa: E501

        :param operation: The operation of this PackageFreight.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and operation is None:  # noqa: E501
            raise ValueError("Invalid value for `operation`, must not be `None`")  # noqa: E501

        self._operation = operation

    @property
    def tracking_refs(self):
        """Gets the tracking_refs of this PackageFreight.  # noqa: E501

        String name of tracking reference by Express Company. One or more tracking references: [SF1035215690597, SF1025950147480]  # noqa: E501

        :return: The tracking_refs of this PackageFreight.  # noqa: E501
        :rtype: list[str]
        """
        return self._tracking_refs

    @tracking_refs.setter
    def tracking_refs(self, tracking_refs):
        """Sets the tracking_refs of this PackageFreight.

        String name of tracking reference by Express Company. One or more tracking references: [SF1035215690597, SF1025950147480]  # noqa: E501

        :param tracking_refs: The tracking_refs of this PackageFreight.  # noqa: E501
        :type: list[str]
        """

        self._tracking_refs = tracking_refs

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackageFreight):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackageFreight):
            return True

        return self.to_dict() != other.to_dict()
