import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * The domain name of the customer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/domain#domain_name DataGoogleworkspaceDomain#domain_name}
    */
    readonly domainName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/d/domain googleworkspace_domain}
*/
export declare class DataGoogleworkspaceDomain extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_domain";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/d/domain googleworkspace_domain} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceDomainConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleworkspaceDomainConfig);
    get creationTime(): number;
    get domainAliases(): string[];
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    get etag(): string;
    get id(): string;
    get isPrimary(): cdktf.IResolvable;
    get verified(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
