import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceDomainAliasConfig extends cdktf.TerraformMetaArguments {
    /**
    * The domain alias name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/domain_alias#domain_alias_name DataGoogleworkspaceDomainAlias#domain_alias_name}
    */
    readonly domainAliasName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/d/domain_alias googleworkspace_domain_alias}
*/
export declare class DataGoogleworkspaceDomainAlias extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_domain_alias";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/d/domain_alias googleworkspace_domain_alias} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceDomainAliasConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleworkspaceDomainAliasConfig);
    get creationTime(): number;
    private _domainAliasName?;
    get domainAliasName(): string;
    set domainAliasName(value: string);
    get domainAliasNameInput(): string | undefined;
    get etag(): string;
    get id(): string;
    get parentDomainName(): string;
    get verified(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
