
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/estimator/SwerveDrivePoseEstimator.h>

#include <frc/kinematics/SwerveModuleState.h>




namespace rpygen {

using namespace frc;


template <size_t NumModules>
struct bind_frc__SwerveDrivePoseEstimator {

    

    py::class_<typename frc::SwerveDrivePoseEstimator<NumModules>> cls_SwerveDrivePoseEstimator;




    py::module &m;
    std::string clsName;

bind_frc__SwerveDrivePoseEstimator(py::module &m, const char * clsName) :
    cls_SwerveDrivePoseEstimator(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_SwerveDrivePoseEstimator.doc() =
    "This class wraps an Unscented Kalman Filter to fuse latency-compensated\n"
"vision measurements with swerve drive encoder velocity measurements. It will\n"
"correct for noisy measurements and encoder drift. It is intended to be an\n"
"easy but more accurate drop-in for :class:`SwerveDriveOdometry`.\n"
"\n"
":meth:`update` should be called every robot loop. If your loops are faster or\n"
"slower than the default of 0.02s, then you should change the nominal delta\n"
"time by specifying it in the constructor.\n"
"\n"
":meth:`addVisionMeasurement` can be called as infrequently as you want; if you\n"
"never call it, then this class will behave mostly like regular encoder\n"
"odometry.\n"
"\n"
"The state-space system used internally has the following states (x), inputs\n"
"(u), and outputs (y):\n"
"\n"
":math:`x = [x, y, \\theta]^T` in the field-coordinate system\n"
"containing x position, y position, and heading.\n"
"\n"
":math:`u = [v_x, v_y, d\\theta]^T`\n"
"in the field-coordinate system.\n"
"\n"
":math:`y = [x, y, \\theta]^T` from vision containing x position, y\n"
"position, and heading; or :math:`y = [theta]^T` containing gyro\n"
"heading.\n";

  cls_SwerveDrivePoseEstimator
      .def(py::init<const Rotation2d&, const Pose2d&, SwerveDriveKinematics<NumModules>&, const wpi::array<double, 3>&, const wpi::array<double, 1>&, const wpi::array<double, 3>&, units::second_t>(),
      py::arg("gyroAngle"), py::arg("initialPose"), py::arg("kinematics"), py::arg("stateStdDevs"), py::arg("localMeasurementStdDevs"), py::arg("visionMeasurementStdDevs"), py::arg("nominalDt")=(units::second_t)0.02_s, release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>()    , py::keep_alive<1, 5>()    , py::keep_alive<1, 6>()    , py::keep_alive<1, 7>(), py::doc(
    "Constructs a SwerveDrivePoseEstimator.\n"
"\n"
":param gyroAngle:                The current gyro angle.\n"
":param initialPose:              The starting pose estimate.\n"
":param kinematics:               A correctly-configured kinematics object\n"
"                                 for your drivetrain.\n"
":param stateStdDevs:             Standard deviations of model states.\n"
"                                 Increase these numbers to trust your\n"
"                                 model's state estimates less. This matrix\n"
"                                 is in the form [x, y, theta]ᵀ, with units\n"
"                                 in meters and radians.\n"
":param localMeasurementStdDevs:  Standard deviations of the encoder and gyro\n"
"                                 measurements. Increase these numbers to\n"
"                                 trust sensor readings from encoders\n"
"                                 and gyros less. This matrix is in the form\n"
"                                 [theta], with units in radians.\n"
":param visionMeasurementStdDevs: Standard deviations of the vision\n"
"                                 measurements. Increase these numbers to\n"
"                                 trust global measurements from vision\n"
"                                 less. This matrix is in the form\n"
"                                 [x, y, theta]ᵀ, with units in meters and\n"
"                                 radians.\n"
":param nominalDt:                The time in seconds between each robot\n"
"                                 loop.")
  )
    
      .def("resetPosition", &frc::SwerveDrivePoseEstimator<NumModules>::ResetPosition,
      py::arg("pose"), py::arg("gyroAngle"), release_gil(), py::doc(
    "Resets the robot's position on the field.\n"
"\n"
"You NEED to reset your encoders (to zero) when calling this method.\n"
"\n"
"The gyroscope angle does not need to be reset in the user's robot code.\n"
"The library automatically takes care of offsetting the gyro angle.\n"
"\n"
":param pose:      The position on the field that your robot is at.\n"
":param gyroAngle: The angle reported by the gyroscope.")
  )
    
      .def("getEstimatedPosition", &frc::SwerveDrivePoseEstimator<NumModules>::GetEstimatedPosition, release_gil(), py::doc(
    "Gets the pose of the robot at the current time as estimated by the Extended\n"
"Kalman Filter.\n"
"\n"
":returns: The estimated robot pose in meters.")
  )
    
      .def("setVisionMeasurementStdDevs", &frc::SwerveDrivePoseEstimator<NumModules>::SetVisionMeasurementStdDevs,
      py::arg("visionMeasurementStdDevs"), release_gil(), py::doc(
    "Sets the pose estimator's trust of global measurements. This might be used\n"
"to change trust in vision measurements after the autonomous period, or to\n"
"change trust as distance to a vision target increases.\n"
"\n"
":param visionMeasurementStdDevs: Standard deviations of the vision\n"
"                                 measurements. Increase these numbers to\n"
"                                 trust global measurements from vision\n"
"                                 less. This matrix is in the form\n"
"                                 [x, y, theta]ᵀ, with units in meters and\n"
"                                 radians.")
  )
    
      .def("addVisionMeasurement", static_cast<void (frc::SwerveDrivePoseEstimator<NumModules>::*)(const Pose2d&, units::second_t)>(
&frc::SwerveDrivePoseEstimator<NumModules>::AddVisionMeasurement),
      py::arg("visionRobotPose"), py::arg("timestamp"), release_gil(), py::doc(
    "Add a vision measurement to the Unscented Kalman Filter. This will correct\n"
"the odometry pose estimate while still accounting for measurement noise.\n"
"\n"
"This method can be called as infrequently as you want, as long as you are\n"
"calling Update() every loop.\n"
"\n"
":param visionRobotPose: The pose of the robot as measured by the vision\n"
"                        camera.\n"
":param timestamp:       The timestamp of the vision measurement in seconds.\n"
"                        Note that if you don't use your own time source by\n"
"                        calling UpdateWithTime() then you must use a\n"
"                        timestamp with an epoch since FPGA startup\n"
"                        (i.e. the epoch of this timestamp is the same\n"
"                        epoch as Timer#GetFPGATimestamp.) This means\n"
"                        that you should use Timer#GetFPGATimestamp as your\n"
"                        time source or sync the epochs.")
  )
    
      .def("addVisionMeasurement", static_cast<void (frc::SwerveDrivePoseEstimator<NumModules>::*)(const Pose2d&, units::second_t, const wpi::array<double, 3>&)>(
&frc::SwerveDrivePoseEstimator<NumModules>::AddVisionMeasurement),
      py::arg("visionRobotPose"), py::arg("timestamp"), py::arg("visionMeasurementStdDevs"), release_gil(), py::doc(
    "Adds a vision measurement to the Unscented Kalman Filter. This will correct\n"
"the odometry pose estimate while still accounting for measurement noise.\n"
"\n"
"This method can be called as infrequently as you want, as long as you are\n"
"calling Update() every loop.\n"
"\n"
"Note that the vision measurement standard deviations passed into this\n"
"method will continue to apply to future measurements until a subsequent\n"
"call to SetVisionMeasurementStdDevs() or this method.\n"
"\n"
":param visionRobotPose:          The pose of the robot as measured by the\n"
"                                 vision camera.\n"
":param timestamp:                The timestamp of the vision measurement in\n"
"                                 seconds. Note that if you don't use your\n"
"                                 own time source by calling\n"
"                                 UpdateWithTime(), then you must use a\n"
"                                 timestamp with an epoch since FPGA startup\n"
"                                 (i.e. the epoch of this timestamp is the\n"
"                                 same epoch as\n"
"                                 frc::Timer::GetFPGATimestamp(). This means\n"
"                                 that you should use\n"
"                                 frc::Timer::GetFPGATimestamp() as your\n"
"                                 time source in this case.\n"
":param visionMeasurementStdDevs: Standard deviations of the vision\n"
"                                 measurements. Increase these numbers to\n"
"                                 trust global measurements from vision\n"
"                                 less. This matrix is in the form\n"
"                                 [x, y, theta]ᵀ, with units in meters and\n"
"                                 radians.")
  )
    
      .def("update", []() {
  if constexpr (NumModules == 2) {
    return [](SwerveDrivePoseEstimator<NumModules> * self, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2) {
      return self->Update(gyroAngle, s1, s2);
    };
  } else if constexpr (NumModules == 3) {
    return [](SwerveDrivePoseEstimator<NumModules> * self, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2, SwerveModuleState s3) {
      return self->Update(gyroAngle, s1, s2, s3);
    };
  } else if constexpr (NumModules == 4) {
    return [](SwerveDrivePoseEstimator<NumModules> * self, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2,
              SwerveModuleState s3, SwerveModuleState s4) {
      return self->Update(gyroAngle, s1, s2, s3, s4);
    };
  } else if constexpr (NumModules == 6) {
    return [](SwerveDrivePoseEstimator<NumModules> * self, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2,
              SwerveModuleState s3, SwerveModuleState s4,
              SwerveModuleState s5, SwerveModuleState s6) {
      return self->Update(gyroAngle, s1, s2, s3, s4, s5, s6);
    };
  }
}()
, py::doc(
    "Updates the the Unscented Kalman Filter using only wheel encoder\n"
"information. This should be called every loop, and the correct loop period\n"
"must be passed into the constructor of this class.\n"
"\n"
":param gyroAngle:    The current gyro angle.\n"
":param moduleStates: The current velocities and rotations of the swerve\n"
"                     modules.\n"
"\n"
":returns: The estimated pose of the robot in meters.")
  )
    
      .def("updateWithTime", []() {
  if constexpr (NumModules == 2) {
    return [](SwerveDrivePoseEstimator<NumModules> * self,
              units::second_t currentTime, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2) {
      return self->UpdateWithTime(currentTime, gyroAngle, s1, s2);
    };
  } else if constexpr (NumModules == 3) {
    return [](SwerveDrivePoseEstimator<NumModules> * self,
              units::second_t currentTime, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2, SwerveModuleState s3) {
      return self->UpdateWithTime(currentTime, gyroAngle, s1, s2, s3);
    };
  } else if constexpr (NumModules == 4) {
    return [](SwerveDrivePoseEstimator<NumModules> * self,
              units::second_t currentTime, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2,
              SwerveModuleState s3, SwerveModuleState s4) {
      return self->UpdateWithTime(currentTime, gyroAngle, s1, s2, s3, s4);
    };
  } else if constexpr (NumModules == 6) {
    return [](SwerveDrivePoseEstimator<NumModules> * self,
              units::second_t currentTime, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2,
              SwerveModuleState s3, SwerveModuleState s4,
              SwerveModuleState s5, SwerveModuleState s6) {
      return self->UpdateWithTime(currentTime, gyroAngle, s1, s2, s3, s4, s5, s6);
    };
  }
}()
, py::doc(
    "Updates the the Unscented Kalman Filter using only wheel encoder\n"
"information. This should be called every loop, and the correct loop period\n"
"must be passed into the constructor of this class.\n"
"\n"
":param currentTime:  Time at which this method was called, in seconds.\n"
":param gyroAngle:    The current gyroscope angle.\n"
":param moduleStates: The current velocities and rotations of the swerve\n"
"                     modules.\n"
"\n"
":returns: The estimated pose of the robot in meters.")
  )
    
;

  

    if (set_doc) {
        cls_SwerveDrivePoseEstimator.doc() = set_doc;
    }
    if (add_doc) {
        cls_SwerveDrivePoseEstimator.doc() = py::cast<std::string>(cls_SwerveDrivePoseEstimator.doc()) + add_doc;
    }

    
}

}; // struct bind_frc__SwerveDrivePoseEstimator

}; // namespace rpygen