
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/system/LinearSystem.h>





namespace rpygen {

using namespace frc;


template <int States, int Inputs, int Outputs>
struct bind_frc__LinearSystem {

    

    py::class_<typename frc::LinearSystem<States, Inputs, Outputs>> cls_LinearSystem;




    py::module &m;
    std::string clsName;

bind_frc__LinearSystem(py::module &m, const char * clsName) :
    cls_LinearSystem(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_LinearSystem.doc() =
    "A plant defined using state-space notation.\n"
"\n"
"A plant is a mathematical model of a system's dynamics.\n"
"\n"
"For more on the underlying math, read\n"
"https://file.tavsys.net/control/controls-engineering-in-frc.pdf.\n"
"\n"
"@tparam States Number of states.\n"
"@tparam Inputs Number of inputs.\n"
"@tparam Outputs Number of outputs.";

  cls_LinearSystem
      .def(py::init<const Eigen::Matrix<double, States, States>&, const Eigen::Matrix<double, States, Inputs>&, const Eigen::Matrix<double, Outputs, States>&, const Eigen::Matrix<double, Outputs, Inputs>&>(),
      py::arg("A"), py::arg("B"), py::arg("C"), py::arg("D"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>()    , py::keep_alive<1, 5>(), py::doc(
    "Constructs a discrete plant with the given continuous system coefficients.\n"
"\n"
":param A: System matrix.\n"
":param B: Input matrix.\n"
":param C: Output matrix.\n"
":param D: Feedthrough matrix.\n"
"          @throws std::domain_error if any matrix element isn't finite.")
  )
    
      .def("A", static_cast<const Eigen::Matrix<double, States, States> & (frc::LinearSystem<States, Inputs, Outputs>::*)() const>(
&frc::LinearSystem<States, Inputs, Outputs>::A), release_gil(), py::doc(
    "Returns the system matrix A.")
  )
    
      .def("A", static_cast<double (frc::LinearSystem<States, Inputs, Outputs>::*)(int, int) const>(
&frc::LinearSystem<States, Inputs, Outputs>::A),
      py::arg("i"), py::arg("j"), release_gil(), py::doc(
    "Returns an element of the system matrix A.\n"
"\n"
":param i: Row of A.\n"
":param j: Column of A.")
  )
    
      .def("B", static_cast<const Eigen::Matrix<double, States, Inputs> & (frc::LinearSystem<States, Inputs, Outputs>::*)() const>(
&frc::LinearSystem<States, Inputs, Outputs>::B), release_gil(), py::doc(
    "Returns the input matrix B.")
  )
    
      .def("B", static_cast<double (frc::LinearSystem<States, Inputs, Outputs>::*)(int, int) const>(
&frc::LinearSystem<States, Inputs, Outputs>::B),
      py::arg("i"), py::arg("j"), release_gil(), py::doc(
    "Returns an element of the input matrix B.\n"
"\n"
":param i: Row of B.\n"
":param j: Column of B.")
  )
    
      .def("C", static_cast<const Eigen::Matrix<double, Outputs, States> & (frc::LinearSystem<States, Inputs, Outputs>::*)() const>(
&frc::LinearSystem<States, Inputs, Outputs>::C), release_gil(), py::doc(
    "Returns the output matrix C.")
  )
    
      .def("C", static_cast<double (frc::LinearSystem<States, Inputs, Outputs>::*)(int, int) const>(
&frc::LinearSystem<States, Inputs, Outputs>::C),
      py::arg("i"), py::arg("j"), release_gil(), py::doc(
    "Returns an element of the output matrix C.\n"
"\n"
":param i: Row of C.\n"
":param j: Column of C.")
  )
    
      .def("D", static_cast<const Eigen::Matrix<double, Outputs, Inputs> & (frc::LinearSystem<States, Inputs, Outputs>::*)() const>(
&frc::LinearSystem<States, Inputs, Outputs>::D), release_gil(), py::doc(
    "Returns the feedthrough matrix D.")
  )
    
      .def("D", static_cast<double (frc::LinearSystem<States, Inputs, Outputs>::*)(int, int) const>(
&frc::LinearSystem<States, Inputs, Outputs>::D),
      py::arg("i"), py::arg("j"), release_gil(), py::doc(
    "Returns an element of the feedthrough matrix D.\n"
"\n"
":param i: Row of D.\n"
":param j: Column of D.")
  )
    
      .def("calculateX", &frc::LinearSystem<States, Inputs, Outputs>::CalculateX,
      py::arg("x"), py::arg("clampedU"), py::arg("dt"), release_gil(), py::doc(
    "Computes the new x given the old x and the control input.\n"
"\n"
"This is used by state observers directly to run updates based on state\n"
"estimate.\n"
"\n"
":param x:        The current state.\n"
":param clampedU: The control input.\n"
":param dt:       Timestep for model update.")
  )
    
      .def("calculateY", &frc::LinearSystem<States, Inputs, Outputs>::CalculateY,
      py::arg("x"), py::arg("clampedU"), release_gil(), py::doc(
    "Computes the new y given the control input.\n"
"\n"
"This is used by state observers directly to run updates based on state\n"
"estimate.\n"
"\n"
":param x:        The current state.\n"
":param clampedU: The control input.")
  )
    
;

  

    if (set_doc) {
        cls_LinearSystem.doc() = set_doc;
    }
    if (add_doc) {
        cls_LinearSystem.doc() = py::cast<std::string>(cls_LinearSystem.doc()) + add_doc;
    }

    
}

}; // struct bind_frc__LinearSystem

}; // namespace rpygen