# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/test_utils.ipynb (unless otherwise specified).

__all__ = ['run_preprocessor', 'show_plain_md']

# Cell
from nbconvert import MarkdownExporter
from traitlets.config import Config
from fastcore.all import Path

# Cell
def run_preprocessor(pp, nbfile, template_file='ob.tpl', display_results=False):
    "Runs a preprocessor with the MarkdownExporter and optionally displays results."
    c = Config()
    c.MarkdownExporter.preprocessors = pp
    tmp_dir = Path(__file__).parent/'templates/'
    tmp_file = tmp_dir/f"{template_file}"
    c.MarkdownExporter.template_file = str(tmp_file)
    exp =  MarkdownExporter(config=c)
    result = exp.from_filename(nbfile)
    if display_results: print(result[0])
    return result

# Cell
def show_plain_md(nbfile):
    md = MarkdownExporter()
    print(md.from_filename(nbfile)[0])