# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/media.ipynb (unless otherwise specified).

__all__ = ['HTMLEscape', 'ImageSave', 'ImagePath']

# Cell
from .test_utils import run_preprocessor
from nbconvert.preprocessors import Preprocessor
from fastcore.all import Path

# Cell
class HTMLEscape(Preprocessor):
    """
    Place HTML in a codeblock and surround it with a <HTMLOutputBlock> component.
    """
    def preprocess_cell(self, cell, resources, index):
        if cell.cell_type =='code':
            outputs = []
            for o in cell.outputs:
                if o.get('data') and o['data'].get('text/html'):
                    cell.metadata.html_output = True
                    html = o['data']['text/html']
                    o['data']['text/html'] = '```html\n'+html.strip()+'\n```'
        return cell, resources

# Cell
class ImageSave(Preprocessor):
    "Saves images stored as bytes in notebooks to disk."
    def preprocess(self, nb, resources):
        meta = resources.get('metadata', {})
        nb_name = meta.get('name')
        nb_path = meta.get('path')
        outfiles = resources.get('outputs')
        if nb_name and outfiles:
            resources['fmap'] = {}
            for k,v in outfiles.items():
                dest = Path(nb_path)/f'_{nb_name}_files/{k}'
                dest.parent.mkdir(exist_ok=True)
                dest.write_bytes(v)
                resources['fmap'][f'{k}'] = str(dest)
        return nb, resources

class ImagePath(Preprocessor):
    "Changes the image path to the location where `ImageSave` saved the files."
    def preprocess_cell(self, cell, resources, index):
        fmap = resources.get('fmap')
        if fmap:
            for o in cell.get('outputs', []):
                fnames = o.get('metadata', {}).get('filenames', {})
                for k,v in fnames.items():
                    fnames[k] = fmap.get(v,v)
        return cell, resources