import codecs
import os.path
from setuptools import setup, find_packages

def read(rel_path):
    here = os.path.abspath(os.path.dirname(__file__))
    with codecs.open(os.path.join(here, rel_path), 'r') as fp:
        return fp.read()

def get_version(rel_path):
    for line in read(rel_path).splitlines():
        if line.startswith('__version__'):
            delim = '"' if '"' in line else "'"
            return line.split(delim)[1]
    else:
        raise RuntimeError("Unable to find version string.")

with open('README.md', 'r') as fh:
    long_description = fh.read()

setup(
    name='pylabnet',
    version=get_version('pylabnet/__init__.py'),
    description='Client-server, python-based laboratory software',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/lukingroup/pylabnet',
    author='Lukin SiV Team',
    author_email='b16lukin@gmail.com',
    license='MIT',
    packages=find_packages(),
    include_package_data=True,
    python_requires='>=3.7',  # This may not be strictly necessary
    entry_points={
        'console_scripts': [
            'pylabnet=pylabnet.launchers.launch_control:main',
            'pylabnet_proxy=pylabnet.launchers.launch_control:main_proxy'
            ]
        },
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: Microsoft :: Windows :: Windows 10",
        "Programming Language :: Python :: 3",
        "Topic :: Scientific/Engineering :: Physics"
    ],
    install_requires=[
        'decorator>=4.4.0',
        'IPython>=7.12.0',
        'ipywidgets>=7.5.1',
        'matplotlib>=3.1.3',
        'nidaqmx>=0.5.7',
        'numpy>=1.16.5',
        'plotly>=4.7.1'
        'ptvsd>=4.3.2',
        'PyQt5>=5.13.0',
        'pyqtgraph>=0.10.0',
        'pyserial>=3.4',
        'pytz>=2019.3',
        'PyVISA>=1.10.1',
        'rpyc>=4.1.2',
        'zhinst>=20.1.1211'
    ]
)
