# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: onos/uenib/ran.proto, onos/uenib/uenib.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterator, Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase
import grpclib


class UeIdType(betterproto.Enum):
    UE_ID_TYPE_CU_UE_F1_AP_ID = 0
    UE_ID_TYPE_DU_UE_F1_AP_ID = 1
    UE_ID_TYPE_RAN_UE_NGAP_ID = 2
    UE_ID_TYPE_AMF_UE_NGAP_ID = 3
    UE_ID_TYPE_ENB_UE_S1_AP_ID = 4


class RsmSchedulerType(betterproto.Enum):
    SCHEDULER_TYPE_ROUND_ROBIN = 0
    SCHEDULER_TYPE_PROPORTIONALLY_FAIR = 1
    SCHEDULER_TYPE_QOS_BASED = 2


class RsmSliceType(betterproto.Enum):
    SLICE_TYPE_DL_SLICE = 0
    SLICE_TYPE_UL_SLICE = 1


class EventType(betterproto.Enum):
    """EventType is a UE operation event type"""

    NONE = 0
    ADDED = 1
    UPDATED = 2
    REMOVED = 3


@dataclass(eq=False, repr=False)
class CellConnection(betterproto.Message):
    """CellConnection represents UE cell connection."""

    id: str = betterproto.string_field(1)
    signal_strength: float = betterproto.double_field(2)


@dataclass(eq=False, repr=False)
class CellInfo(betterproto.Message):
    """CellInfo provides data on serving cell and candidate cells."""

    serving_cell: "CellConnection" = betterproto.message_field(1)
    candidate_cells: List["CellConnection"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class DuUeF1ApId(betterproto.Message):
    value: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class CuUeF1ApId(betterproto.Message):
    value: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class RanUeNgapId(betterproto.Message):
    value: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class EnbUeS1ApId(betterproto.Message):
    value: int = betterproto.int32_field(1)


@dataclass(eq=False, repr=False)
class AmfUeNgapId(betterproto.Message):
    value: int = betterproto.int64_field(1)


@dataclass(eq=False, repr=False)
class UeIdentity(betterproto.Message):
    du_ue_f1_ap_id: "DuUeF1ApId" = betterproto.message_field(1)
    cu_ue_f1_ap_id: "CuUeF1ApId" = betterproto.message_field(2)
    ran_ue_ngap_id: "RanUeNgapId" = betterproto.message_field(3)
    enb_ue_s1_ap_id: "EnbUeS1ApId" = betterproto.message_field(4)
    amf_ue_ngap_id: "AmfUeNgapId" = betterproto.message_field(5)
    preferred_id_type: "UeIdType" = betterproto.enum_field(6)


@dataclass(eq=False, repr=False)
class BearerId(betterproto.Message):
    drb_id: "DrbId" = betterproto.message_field(1, group="bearer_id")


@dataclass(eq=False, repr=False)
class DrbId(betterproto.Message):
    four_gdrb_id: "FourGDrbId" = betterproto.message_field(1, group="drb_id")
    five_gdrb_id: "FiveGDrbId" = betterproto.message_field(2, group="drb_id")


@dataclass(eq=False, repr=False)
class FiveGDrbId(betterproto.Message):
    value: int = betterproto.int32_field(1)
    qfi: "Qfi" = betterproto.message_field(2)
    flows_map_to_drb: List["QoSflowLevelParameters"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Qfi(betterproto.Message):
    value: int = betterproto.int32_field(1)


@dataclass(eq=False, repr=False)
class QoSflowLevelParameters(betterproto.Message):
    dynamic_five_qi: "DynamicFiveQi" = betterproto.message_field(
        1, group="qos_flow_level_parameters"
    )
    non_dynamic_five_qi: "NonDynamicFiveQi" = betterproto.message_field(
        2, group="qos_flow_level_parameters"
    )


@dataclass(eq=False, repr=False)
class DynamicFiveQi(betterproto.Message):
    priority_level: int = betterproto.int32_field(1)
    packet_delay_budge: int = betterproto.int32_field(2)
    packet_error_rate: int = betterproto.int32_field(3)


@dataclass(eq=False, repr=False)
class NonDynamicFiveQi(betterproto.Message):
    five_qi: "FiveQi" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class FiveQi(betterproto.Message):
    value: int = betterproto.int32_field(1)


@dataclass(eq=False, repr=False)
class FourGDrbId(betterproto.Message):
    value: int = betterproto.int32_field(1)
    qci: "Qci" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Qci(betterproto.Message):
    value: int = betterproto.int32_field(1)


@dataclass(eq=False, repr=False)
class RsmUeInfo(betterproto.Message):
    global_ue_id: str = betterproto.string_field(1)
    ue_id_list: "UeIdentity" = betterproto.message_field(2)
    bearer_id_list: List["BearerId"] = betterproto.message_field(3)
    cell_global_id: str = betterproto.string_field(4)
    cu_e2_node_id: str = betterproto.string_field(5)
    du_e2_node_id: str = betterproto.string_field(6)
    slice_list: List["SliceInfo"] = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class SliceInfo(betterproto.Message):
    du_e2_node_id: str = betterproto.string_field(1)
    cu_e2_node_id: str = betterproto.string_field(2)
    id: str = betterproto.string_field(3)
    slice_desc: str = betterproto.string_field(4)
    slice_parameters: "RsmSliceParameters" = betterproto.message_field(5)
    slice_type: "RsmSliceType" = betterproto.enum_field(6)
    drb_id: "DrbId" = betterproto.message_field(7)


@dataclass(eq=False, repr=False)
class RsmSliceParameters(betterproto.Message):
    scheduler_type: "RsmSchedulerType" = betterproto.enum_field(1)
    weight: int = betterproto.int32_field(2)
    qos_level: int = betterproto.int32_field(3)


@dataclass(eq=False, repr=False)
class Event(betterproto.Message):
    """Event is a record of an operation on a UE"""

    type: "EventType" = betterproto.enum_field(1)
    ue: "Ue" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CreateUeRequest(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateUeResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetUeRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    aspect_types: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetUeResponse(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateUeRequest(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateUeResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteUeRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    aspect_types: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteUeResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListUeRequest(betterproto.Message):
    aspect_types: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ListUeResponse(betterproto.Message):
    ue: "Ue" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class WatchUeRequest(betterproto.Message):
    noreplay: bool = betterproto.bool_field(2)
    aspect_types: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class WatchUeResponse(betterproto.Message):
    event: "Event" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Ue(betterproto.Message):
    """UE entity is merely an ID and a map of arbitrary aspects."""

    id: str = betterproto.string_field(1)
    # Map of aspects as typed values
    aspects: Dict[str, "betterproto_lib_google_protobuf.Any"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


class UeServiceStub(betterproto.ServiceStub):
    async def create_ue(self) -> "CreateUeResponse":

        request = CreateUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/CreateUE", request, CreateUeResponse
        )

    async def get_ue(self) -> "GetUeResponse":

        request = GetUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/GetUE", request, GetUeResponse
        )

    async def update_ue(self) -> "UpdateUeResponse":

        request = UpdateUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/UpdateUE", request, UpdateUeResponse
        )

    async def delete_ue(self) -> "DeleteUeResponse":

        request = DeleteUeRequest()

        return await self._unary_unary(
            "/onos.uenib.UEService/DeleteUE", request, DeleteUeResponse
        )

    async def list_u_es(self) -> AsyncIterator["ListUeResponse"]:

        request = ListUeRequest()

        async for response in self._unary_stream(
            "/onos.uenib.UEService/ListUEs",
            request,
            ListUeResponse,
        ):
            yield response

    async def watch_u_es(self) -> AsyncIterator["WatchUeResponse"]:

        request = WatchUeRequest()

        async for response in self._unary_stream(
            "/onos.uenib.UEService/WatchUEs",
            request,
            WatchUeResponse,
        ):
            yield response


class UeServiceBase(ServiceBase):
    async def create_ue(self) -> "CreateUeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_ue(self) -> "GetUeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_ue(self) -> "UpdateUeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_ue(self) -> "DeleteUeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_u_es(self) -> AsyncIterator["ListUeResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def watch_u_es(self) -> AsyncIterator["WatchUeResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_ue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.create_ue(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_get_ue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.get_ue(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_update_ue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.update_ue(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_delete_ue(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        response = await self.delete_ue(**request_kwargs)
        await stream.send_message(response)

    async def __rpc_list_u_es(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        await self._call_rpc_handler_server_stream(
            self.list_u_es,
            stream,
            request_kwargs,
        )

    async def __rpc_watch_u_es(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()

        request_kwargs = {}

        await self._call_rpc_handler_server_stream(
            self.watch_u_es,
            stream,
            request_kwargs,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/onos.uenib.UEService/CreateUE": grpclib.const.Handler(
                self.__rpc_create_ue,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateUeRequest,
                CreateUeResponse,
            ),
            "/onos.uenib.UEService/GetUE": grpclib.const.Handler(
                self.__rpc_get_ue,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetUeRequest,
                GetUeResponse,
            ),
            "/onos.uenib.UEService/UpdateUE": grpclib.const.Handler(
                self.__rpc_update_ue,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateUeRequest,
                UpdateUeResponse,
            ),
            "/onos.uenib.UEService/DeleteUE": grpclib.const.Handler(
                self.__rpc_delete_ue,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteUeRequest,
                DeleteUeResponse,
            ),
            "/onos.uenib.UEService/ListUEs": grpclib.const.Handler(
                self.__rpc_list_u_es,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListUeRequest,
                ListUeResponse,
            ),
            "/onos.uenib.UEService/WatchUEs": grpclib.const.Handler(
                self.__rpc_watch_u_es,
                grpclib.const.Cardinality.UNARY_STREAM,
                WatchUeRequest,
                WatchUeResponse,
            ),
        }


import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
