# Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
# with the License. A copy of the License is located at http://aws.amazon.com/apache2.0/
# or in the "LICENSE.txt" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
# OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions and
# limitations under the License.

# pylint: disable=R0801


from pcluster.api import util
from pcluster.api.models.base_model_ import Model
from pcluster.api.models.image_info_summary import ImageInfoSummary


class DeleteImageResponseContent(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, image=None):
        """DeleteImageResponseContent - a model defined in OpenAPI

        :param image: The image of this DeleteImageResponseContent.
        :type image: ImageInfoSummary
        """
        self.openapi_types = {"image": ImageInfoSummary}

        self.attribute_map = {"image": "image"}

        self._image = image

    @classmethod
    def from_dict(cls, dikt) -> "DeleteImageResponseContent":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The DeleteImageResponseContent of this DeleteImageResponseContent.
        :rtype: DeleteImageResponseContent
        """
        return util.deserialize_model(dikt, cls)

    @property
    def image(self):
        """Gets the image of this DeleteImageResponseContent.


        :return: The image of this DeleteImageResponseContent.
        :rtype: ImageInfoSummary
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this DeleteImageResponseContent.


        :param image: The image of this DeleteImageResponseContent.
        :type image: ImageInfoSummary
        """
        if image is None:
            raise ValueError("Invalid value for `image`, must not be `None`")

        self._image = image
