# This code is autogenerated by Constellate, and changes made here will not persist.
#constellate: setup
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns
from scipy import stats
import colorcet as cc
import scipy
from sympy import *
import rho_plus

IS_DARK = True
theme, cs = rho_plus.mpl_setup(IS_DARK)

import panel as pn
import param
import bokeh
pn.extension('gridstack', sizing_mode='scale_both')
from panel.layout.gridstack import GridStack
#constellate: setup_panel

from bokeh.sampledata.iris import flowers
from rho_plus.util import labelcase
import holoviews as hv
from holoviews import opts

flowers.columns = labelcase(flowers.columns)

from scipy.spatial import Voronoi

# generate dataset with clusters
np.random.seed(3143)
nd = np.array([50, 30, 20, 10])
xlim = np.array([-5, 5])
ylim = np.array([-5, 5])

mu = np.array([[3, -3], [-3, 3], [3, 3], [-3, -3]])
sigma = np.array([1, 2, 1, 1])

pts = []
for mean, sd, n in zip(mu, sigma, nd):
    pts += list(stats.multivariate_normal(mean, sd).rvs(n))

pts = np.array(pts)

rng: np.random.BitGenerator = np.random.default_rng(310)


class KMeans(rho_plus.ThemedPanel):
    centers = param.Array(default=None, precedence=-1)
    assignments = param.Array(default=None, precedence=-1)
    phase = param.ObjectSelector(['expectation', 'maximization'],
                                 precedence=-1)

    def __init__(self):
        super().__init__()
        self.initialize_centers()

    def initialize_centers(self):
        self.centers = rng.multivariate_normal(np.array([2, 2]),
                                               np.eye(2) * 0.5, len(nd))
        self.phase = 'expectation'
        self.step()

    def step(self):
        if self.phase == 'expectation':
            # expectation step: assign new cluster identities
            self.assignments = np.square(
                pts.reshape(1, -1, 2) -
                self.centers.reshape(-1, 1, 2)).sum(axis=2).argmin(axis=0)
            self.phase = 'maximization'
        else:
            # maximization step: reassign cluster centers
            centers = []
            for i in range(len(nd)):
                centers.append(np.mean(pts[self.assignments == i], axis=0))
            self.centers = np.array(centers)
            self.phase = 'expectation'

    def plot(self):
        colors, theme = self.colors_theme()
        fig = bokeh.plotting.figure(title='K-Means',
                                    x_range=xlim,
                                    y_range=ylim)

        # get around points at infinity by replacing them with "points very far away"
        left_x = xlim[0] - 2 * (xlim[1] - xlim[0])
        right_x = xlim[1] + 2 * (xlim[1] - xlim[0])
        top_y = ylim[1] + 2 * (ylim[1] - ylim[0])
        bottom_y = ylim[0] - 2 * (ylim[1] - ylim[0])
        distant_pts = np.array([[left_x, bottom_y], [left_x, top_y],
                                [right_x, top_y], [right_x, bottom_y]])
        vor = Voronoi(np.vstack([self.centers, distant_pts]))

        for i, (center, vor_j,
                color) in enumerate(zip(self.centers, vor.point_region,
                                        colors)):
            fig.circle(*pts[self.assignments == i].T,
                       color=color,
                       size=6,
                       legend_label='Point')
            fig.square(x=center[0],
                       y=center[1],
                       color=color,
                       size=12,
                       legend_label='Center')

            fig.patch(*vor.vertices[vor.regions[vor_j]].T,
                      alpha=0.3,
                      color=color)

        return pn.pane.Bokeh(fig, theme=theme)


mod = KMeans()

step = pn.widgets.Button(name='Step',
                         button_type='primary',
                         sizing_mode='stretch_both',
                         margin=10)
step.on_click(lambda evt: mod.step())

reset = pn.widgets.Button(name='Reset',
                          button_type='default',
                          sizing_mode='stretch_both',
                          margin=10)
reset.on_click(lambda evt: mod.initialize_centers())

obj = pn.GridSpec(sizing_mode='stretch_both', margin=20)
obj[11, 0:1] = step
obj[11, 1:2] = reset
obj[:11, :] = mod.plot

obj.servable()
