#  CASA Next Generation Infrastructure
#  Copyright (C) 2021 AUI, Inc. Washington DC, USA
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.

import numpy as np

#Changed column_descriptions['UVW']['MEASINFO']['Ref'] = ITRF -> J2000 from deafult assigned by CASA simulator. Follows convention in fixvis.
# column_descriptions['UVW']['shape']
main_column_description = {'UVW': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 5, 'maxlen': 0, 'comment': 'Vector with uvw coordinates (in meters)', 'ndim': 1, 'shape': np.array([3]), '_c_order': True, 'keywords': {'QuantumUnits': ['m', 'm', 'm'], 'MEASINFO': {'type': 'uvw', 'Ref': 'ITRF'}}}, 'FLAG': {'valueType': 'boolean', 'dataManagerType': 'TiledShapeStMan', 'dataManagerGroup': 'FlagColumn', 'option': 0, 'maxlen': 0, 'comment': 'The data flags, array of bools with same shape as data', 'ndim': 2, '_c_order': True, 'keywords': {}}, 'FLAG_CATEGORY': {'valueType': 'boolean', 'dataManagerType': 'TiledShapeStMan', 'dataManagerGroup': 'flagHyperColumn', 'option': 0, 'maxlen': 0, 'comment': 'The flag category, NUM_CAT flags for each datum', 'ndim': 3, '_c_order': True, 'keywords': {'CATEGORY': []}}, 'WEIGHT': {'valueType': 'float', 'dataManagerType': 'TiledShapeStMan', 'dataManagerGroup': 'WeightColumn', 'option': 0, 'maxlen': 0, 'comment': 'Weight for each polarization spectrum', 'ndim': 1, '_c_order': True, 'keywords': {}}, 'SIGMA': {'valueType': 'float', 'dataManagerType': 'TiledShapeStMan', 'dataManagerGroup': 'SigmaColumn', 'option': 0, 'maxlen': 0, 'comment': 'Estimated rms noise for channel with unity bandpass response', 'ndim': 1, '_c_order': True, 'keywords': {}}, 'ANTENNA1': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'SSM', 'option': 0, 'maxlen': 0, 'comment': 'ID of first antenna in interferometer', 'keywords': {}}, 'ANTENNA2': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'SSM', 'option': 0, 'maxlen': 0, 'comment': 'ID of second antenna in interferometer', 'keywords': {}}, 'ARRAY_ID': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'ID of array or subarray', 'keywords': {}}, 'DATA_DESC_ID': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'The data description table index', 'keywords': {}}, 'EXPOSURE': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'The effective integration time', 'keywords': {'QuantumUnits': ['s']}}, 'FEED1': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'The feed index for ANTENNA1', 'keywords': {}}, 'FEED2': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'The feed index for ANTENNA2', 'keywords': {}}, 'FIELD_ID': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'Unique id for this pointing', 'keywords': {}}, 'FLAG_ROW': {'valueType': 'boolean', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'Row flag - flag all data in this row if True', 'keywords': {}}, 'INTERVAL': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'The sampling interval', 'keywords': {'QuantumUnits': ['s']}}, 'OBSERVATION_ID': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'ID for this observation, index in OBSERVATION table', 'keywords': {}}, 'PROCESSOR_ID': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'Id for backend processor, index in PROCESSOR table', 'keywords': {}}, 'SCAN_NUMBER': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'Sequential scan number from on-line system', 'keywords': {}}, 'STATE_ID': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'ID for this observing state', 'keywords': {}}, 'TIME': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'Modified Julian Day', 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}, 'TIME_CENTROID': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ismdata', 'option': 0, 'maxlen': 0, 'comment': 'Modified Julian Day', 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}, 'DATA': {'valueType': 'complex', 'dataManagerType': 'TiledShapeStMan', 'dataManagerGroup': 'dataHyperColumn', 'option': 0, 'maxlen': 0, 'comment': 'The data column', 'ndim': 2, '_c_order': True, 'keywords': {}}, 'MODEL_DATA': {'valueType': 'complex', 'dataManagerType': 'TiledShapeStMan', 'dataManagerGroup': 'ModelDataColumn', 'option': 0, 'maxlen': 0, 'comment': 'The model data column', 'ndim': 2, '_c_order': True, 'keywords': {}}, 'CORRECTED_DATA': {'valueType': 'complex', 'dataManagerType': 'TiledShapeStMan', 'dataManagerGroup': 'CorrectedDataColumn', 'option': 0, 'maxlen': 0, 'comment': 'The corrected data column', 'ndim': 2, '_c_order': True, 'keywords': {}}, 'ROWID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'ROWID column', 'keywords': {}}}

# spectral_window_column_description['CHAN_FREQ']['keywords']['MEASINFO']['TabRefCodes']
# spectral_window_column_description['REF_FREQUENCY']['keywords']['MEASINFO']['TabRefCodes']
spectral_window_column_description = {'MEAS_FREQ_REF': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Frequency Measure reference', 'keywords': {}}, 'CHAN_FREQ': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Center frequencies for each channel in the data matrix', 'ndim': 1, '_c_order': True, 'keywords': {'QuantumUnits': ['Hz'], 'MEASINFO': {'type': 'frequency', 'VarRefCol': 'MEAS_FREQ_REF', 'TabRefTypes': ['REST', 'LSRK', 'LSRD', 'BARY', 'GEO', 'TOPO', 'GALACTO', 'LGROUP', 'CMB', 'Undefined'], 'TabRefCodes': np.array([ 0,  1,  2,  3,  4,  5,  6,  7,  8, 64], dtype=np.uint32)}}}, 'REF_FREQUENCY': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'The reference frequency', 'keywords': {'QuantumUnits': ['Hz'], 'MEASINFO': {'type': 'frequency', 'VarRefCol': 'MEAS_FREQ_REF', 'TabRefTypes': ['REST', 'LSRK', 'LSRD', 'BARY', 'GEO', 'TOPO', 'GALACTO', 'LGROUP', 'CMB', 'Undefined'], 'TabRefCodes': np.array([ 0,  1,  2,  3,  4,  5,  6,  7,  8, 64], dtype=np.uint32)}}}, 'CHAN_WIDTH': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Channel width for each channel', 'ndim': 1, '_c_order': True, 'keywords': {'QuantumUnits': ['Hz']}}, 'EFFECTIVE_BW': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Effective noise bandwidth of each channel', 'ndim': 1, '_c_order': True, 'keywords': {'QuantumUnits': ['Hz']}}, 'RESOLUTION': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'The effective noise bandwidth for each channel', 'ndim': 1, '_c_order': True, 'keywords': {'QuantumUnits': ['Hz']}}, 'FLAG_ROW': {'valueType': 'boolean', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Row flag', 'keywords': {}}, 'FREQ_GROUP': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Frequency group', 'keywords': {}}, 'FREQ_GROUP_NAME': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Frequency group name', 'keywords': {}}, 'IF_CONV_CHAIN': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'The IF conversion chain number', 'keywords': {}}, 'NAME': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Spectral window name', 'keywords': {}}, 'NET_SIDEBAND': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Net sideband', 'keywords': {}}, 'NUM_CHAN': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Number of spectral channels', 'keywords': {}}, 'TOTAL_BANDWIDTH': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'The total bandwidth for this window', 'keywords': {'QuantumUnits': ['Hz']}}}


polarization_column_description = {'CORR_TYPE': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'The polarization type for each correlation product, as a Stokes enum.', 'ndim': 1, '_c_order': True, 'keywords': {}}, 'CORR_PRODUCT': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Indices describing receptors of feed going into correlation', 'ndim': 2, '_c_order': True, 'keywords': {}}, 'FLAG_ROW': {'valueType': 'boolean', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Row flag', 'keywords': {}}, 'NUM_CORR': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Number of correlation products', 'keywords': {}}}


data_description_column_description = {'FLAG_ROW': {'valueType': 'boolean', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Flag this row', 'keywords': {}}, 'POLARIZATION_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Pointer to polarization table', 'keywords': {}}, 'SPECTRAL_WINDOW_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Pointer to spectralwindow table', 'keywords': {}}}

#antenna_column_description['OFFSET']['shape']
#antenna_column_description['POSITION']['shape']
antenna_column_description = {'OFFSET': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 5, 'maxlen': 0, 'comment': 'Axes offset of mount to FEED REFERENCE point', 'ndim': 1, 'shape': np.array([3]), '_c_order': True, 'keywords': {'QuantumUnits': ['m', 'm', 'm'], 'MEASINFO': {'type': 'position', 'Ref': 'ITRF'}}}, 'POSITION': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 5, 'maxlen': 0, 'comment': 'Antenna X,Y,Z phase reference position', 'ndim': 1, 'shape': np.array([3]), '_c_order': True, 'keywords': {'QuantumUnits': ['m', 'm', 'm'], 'MEASINFO': {'type': 'position', 'Ref': 'ITRF'}}}, 'TYPE': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Antenna type (e.g. SPACE-BASED)', 'keywords': {}}, 'DISH_DIAMETER': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Physical diameter of dish', 'keywords': {'QuantumUnits': ['m']}}, 'FLAG_ROW': {'valueType': 'boolean', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Flag for this row', 'keywords': {}}, 'MOUNT': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Mount type e.g. alt-az, equatorial, etc.', 'keywords': {}}, 'NAME': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Antenna name, e.g. VLA22, CA03', 'keywords': {}}, 'STATION': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Station (antenna pad) name', 'keywords': {}}}

#feed_column_description['POSITION']['shape']
feed_column_description = {'POSITION': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 5, 'maxlen': 0, 'comment': 'Position of feed relative to feed reference position', 'ndim': 1, 'shape': np.array([3]), '_c_order': True, 'keywords': {'QuantumUnits': ['m', 'm', 'm'], 'MEASINFO': {'type': 'position', 'Ref': 'ITRF'}}}, 'BEAM_OFFSET': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Beam position offset (on sky but in antennareference frame)', 'ndim': 2, '_c_order': True, 'keywords': {'QuantumUnits': ['rad', 'rad'], 'MEASINFO': {'type': 'direction', 'Ref': 'J2000'}}}, 'POLARIZATION_TYPE': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Type of polarization to which a given RECEPTOR responds', 'ndim': 1, '_c_order': True, 'keywords': {}}, 'POL_RESPONSE': {'valueType': 'complex', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'D-matrix i.e. leakage between two receptors', 'ndim': 2, '_c_order': True, 'keywords': {}}, 'RECEPTOR_ANGLE': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'The reference angle for polarization', 'ndim': 1, '_c_order': True, 'keywords': {'QuantumUnits': ['rad']}}, 'ANTENNA_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'ID of antenna in this array', 'keywords': {}}, 'BEAM_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Id for BEAM model', 'keywords': {}}, 'FEED_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Feed id', 'keywords': {}}, 'INTERVAL': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Interval for which this set of parameters is accurate', 'keywords': {'QuantumUnits': ['s']}}, 'NUM_RECEPTORS': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Number of receptors on this feed (probably 1 or 2)', 'keywords': {}}, 'SPECTRAL_WINDOW_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'ID for this spectral window setup', 'keywords': {}}, 'TIME': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Midpoint of time for which this set of parameters is accurate', 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}}


field_column_description = {'DELAY_DIR': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Direction of delay center (e.g. RA, DEC)as polynomial in time.', 'ndim': 2, '_c_order': True, 'keywords': {'QuantumUnits': ['rad', 'rad'], 'MEASINFO': {'type': 'direction', 'Ref': 'J2000'}}}, 'PHASE_DIR': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Direction of phase center (e.g. RA, DEC).', 'ndim': 2, '_c_order': True, 'keywords': {'QuantumUnits': ['rad', 'rad'], 'MEASINFO': {'type': 'direction', 'Ref': 'J2000'}}}, 'REFERENCE_DIR': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Direction of REFERENCE center (e.g. RA, DEC).as polynomial in time.', 'ndim': 2, '_c_order': True, 'keywords': {'QuantumUnits': ['rad', 'rad'], 'MEASINFO': {'type': 'direction', 'Ref': 'J2000'}}}, 'CODE': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Special characteristics of field, e.g. Bandpass calibrator', 'keywords': {}}, 'FLAG_ROW': {'valueType': 'boolean', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Row Flag', 'keywords': {}}, 'NAME': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Name of this field', 'keywords': {}}, 'NUM_POLY': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Polynomial order of _DIR columns', 'keywords': {}}, 'SOURCE_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Source id', 'keywords': {}}, 'TIME': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Time origin for direction and rate', 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}}



history_column_description = {'APP_PARAMS': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Application parameters', 'ndim': 1, '_c_order': True, 'keywords': {}}, 'CLI_COMMAND': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'CLI command sequence', 'ndim': 1, '_c_order': True, 'keywords': {}}, 'APPLICATION': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Application name', 'keywords': {}}, 'MESSAGE': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Log message', 'keywords': {}}, 'OBJECT_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Originating ObjectID', 'keywords': {}}, 'OBSERVATION_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Observation id (index in OBSERVATION table)', 'keywords': {}}, 'ORIGIN': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': '(Source code) origin from which message originated', 'keywords': {}}, 'PRIORITY': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Message priority', 'keywords': {}}, 'TIME': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Timestamp of message', 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}}

#observation_column_description['TIME_RANGE']['shape']
observation_column_description = {'TIME_RANGE': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 5, 'maxlen': 0, 'comment': 'Start and end of observation', 'ndim': 1, 'shape': np.array([2]), '_c_order': True, 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}, 'LOG': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Observing log', 'ndim': 1, '_c_order': True, 'keywords': {}}, 'SCHEDULE': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Observing schedule', 'ndim': 1, '_c_order': True, 'keywords': {}}, 'FLAG_ROW': {'valueType': 'boolean', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Row flag', 'keywords': {}}, 'OBSERVER': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Name of observer(s)', 'keywords': {}}, 'PROJECT': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Project identification string', 'keywords': {}}, 'RELEASE_DATE': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Release date when data becomes public', 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}, 'SCHEDULE_TYPE': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Observing schedule type', 'keywords': {}}, 'TELESCOPE_NAME': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Telescope Name (e.g. WSRT, VLBA)', 'keywords': {}}}


pointing_column_description = {'DIRECTION': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ISMPointing', 'option': 0, 'maxlen': 0, 'comment': 'Antenna pointing direction as polynomial in time', 'ndim': 2, '_c_order': True, 'keywords': {'QuantumUnits': ['rad', 'rad'], 'MEASINFO': {'type': 'direction', 'Ref': 'J2000'}}}, 'ANTENNA_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'SSMPointing', 'option': 0, 'maxlen': 0, 'comment': 'Antenna Id', 'keywords': {}}, 'INTERVAL': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ISMPointing', 'option': 0, 'maxlen': 0, 'comment': 'Time interval', 'keywords': {'QuantumUnits': ['s']}}, 'NAME': {'valueType': 'string', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ISMPointing', 'option': 0, 'maxlen': 0, 'comment': 'Pointing position name', 'keywords': {}}, 'NUM_POLY': {'valueType': 'int', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ISMPointing', 'option': 0, 'maxlen': 0, 'comment': 'Series order', 'keywords': {}}, 'TARGET': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ISMPointing', 'option': 0, 'maxlen': 0, 'comment': 'target direction as polynomial in time', 'ndim': -1, '_c_order': True, 'keywords': {'QuantumUnits': ['rad', 'rad'], 'MEASINFO': {'type': 'direction', 'Ref': 'J2000'}}}, 'TIME': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ISMPointing', 'option': 0, 'maxlen': 0, 'comment': 'Time interval midpoint', 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}, 'TIME_ORIGIN': {'valueType': 'double', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ISMPointing', 'option': 0, 'maxlen': 0, 'comment': 'Time origin for direction', 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}, 'TRACKING': {'valueType': 'boolean', 'dataManagerType': 'IncrementalStMan', 'dataManagerGroup': 'ISMPointing', 'option': 0, 'maxlen': 0, 'comment': 'Tracking flag - True if on position', 'keywords': {}}}

source_column_description = {'CALIBRATION_GROUP': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Number of grouping for calibration purpose.', 'keywords': {}}, 'CODE': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Special characteristics of source, e.g. Bandpass calibrator', 'keywords': {}}, 'DIRECTION': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Direction (e.g. RA, DEC).', 'ndim': -1, '_c_order': True, 'keywords': {'QuantumUnits': ['rad', 'rad'], 'MEASINFO': {'type': 'direction', 'Ref': 'J2000'}}}, 'INTERVAL': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Interval of time for which this set of parameters is accurate', 'keywords': {'QuantumUnits': ['s']}}, 'NAME': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Name of source as given during observations', 'keywords': {}}, 'NUM_LINES': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Number of spectral lines', 'keywords': {}}, 'PROPER_MOTION': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Proper motion', 'ndim': -1, '_c_order': True, 'keywords': {'QuantumUnits': ['rad/s']}}, 'SOURCE_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Source id', 'keywords': {}}, 'SPECTRAL_WINDOW_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'ID for this spectral window setup', 'keywords': {}}, 'TIME': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Midpoint of time for which this set of parameters is accurate.', 'keywords': {'QuantumUnits': ['s'], 'MEASINFO': {'type': 'epoch', 'Ref': 'UTC'}}}, 'POSITION': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Position (e.g. for solar system objects', 'ndim': -1, '_c_order': True, 'keywords': {'QuantumUnits': ['m', 'm', 'm'], 'MEASINFO': {'type': 'position', 'Ref': 'ITRF'}}}, 'PULSAR_ID': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Pulsar Id, pointer to pulsar table', 'keywords': {}}, 'REST_FREQUENCY': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Line rest frequency', 'ndim': -1, '_c_order': True, 'keywords': {'QuantumUnits': ['Hz'], 'MEASINFO': {'type': 'frequency', 'Ref': 'LSRK'}}}, 'SYSVEL': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Systemic velocity at reference', 'ndim': -1, '_c_order': True, 'keywords': {'QuantumUnits': ['m/s'], 'MEASINFO': {'type': 'radialvelocity', 'Ref': 'LSRK'}}}, 'TRANSITION': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Line Transition name', 'ndim': -1, '_c_order': True, 'keywords': {}}}



state_column_description = {'CAL': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Noise calibration temperature', 'keywords': {'QuantumUnits': ['K']}}, 'FLAG_ROW': {'valueType': 'boolean', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Row flag', 'keywords': {}}, 'LOAD': {'valueType': 'double', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Load temperature', 'keywords': {'QuantumUnits': ['K']}}, 'OBS_MODE': {'valueType': 'string', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Observing mode, e.g., OFF_SPECTRUM', 'keywords': {}}, 'REF': {'valueType': 'boolean', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'True for a reference observation', 'keywords': {}}, 'SIG': {'valueType': 'boolean', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'True for a source observation', 'keywords': {}}, 'SUB_SCAN': {'valueType': 'int', 'dataManagerType': 'StandardStMan', 'dataManagerGroup': 'StandardStMan', 'option': 0, 'maxlen': 0, 'comment': 'Sub scan number, relative to scan number', 'keywords': {}}}

