# Generated by Django 3.1.5 on 2021-02-13 00:29

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sessions', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('view', models.CharField(blank=True, default='', help_text='The view where the message was submitted from.', max_length=64)),
                ('message', models.CharField(blank=True, help_text='The actual text of the message.', max_length=1024)),
                ('level', models.IntegerField(help_text='An integer describing the type of the message.')),
                ('read_at', models.DateTimeField(blank=True, default=None, help_text='When the message was read.', null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('session', models.ForeignKey(blank=True, default=None, help_text='The session where the message was submitted to.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='messages', to='sessions.session')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='MessageTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.CharField(help_text='Custom tags for the message.', max_length=128)),
                ('message', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='extra_tags', to='drf_messages.message')),
            ],
        ),
    ]
