/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

@SASScope
public class LocalizableLabelAndValueCollection {
    private Locale defaultLocale;
    private Map localeToValuesMap;

    public LocalizableLabelAndValueCollection() {
        this.defaultLocale = Locale.US;
    }

    public LocalizableLabelAndValueCollection(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public Map getValuesAndLabels(Locale locale) {
        if (this.localeToValuesMap != null) {
            if (this.localeToValuesMap.containsKey(locale)) {
                return (Map)this.localeToValuesMap.get(locale);
            }
            if (this.defaultLocale != null && this.localeToValuesMap.containsKey(this.defaultLocale)) {
                return (Map)this.localeToValuesMap.get(this.defaultLocale);
            }
            Collection values = this.localeToValuesMap.values();
            if (values != null && values.size() > 0) {
                return (Map)values.iterator().next();
            }
        }
        throw new IllegalStateException("Values for Locale not set: " + locale);
    }

    public void setValuesAndLabels(Map valueToLabelMap, Locale locale) {
        this.initLocaleToValuesMap();
        this.localeToValuesMap.put(locale, valueToLabelMap);
    }

    public String getLabelForValue(Object value, Locale locale) {
        Map values = this.getValuesAndLabels(locale);
        return (String)values.get(value);
    }

    public void setLabelForValue(Object value, String label, Locale locale) {
        this.initLocaleToValuesMap();
        if (this.localeToValuesMap.containsKey(value)) {
            Map valueToLabelsMap = (Map)this.localeToValuesMap.get(value);
            valueToLabelsMap.put(value, label);
        } else {
            LinkedHashMap<Object, String> valueToLabelsMap = new LinkedHashMap<Object, String>();
            valueToLabelsMap.put(value, label);
        }
    }

    protected void initLocaleToValuesMap() {
        if (this.localeToValuesMap == null) {
            this.localeToValuesMap = new LinkedHashMap();
        }
    }
}

