/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.util;

import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import com.sas.swing.util.RB;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public final class ActionUtils {
    public static final String RB_KEY = "ActionUtils.";

    public static Iterator iterator(ActionList actionList) {
        return new ActionListIterator(actionList);
    }

    public static void invokeLater(final Action action) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                action.performAction();
            }
        });
    }

    private ActionUtils() {
    }

    private static class ActionListIterator
    implements Iterator {
        ActionNode _root;
        ActionNode _next;

        public ActionListIterator(ActionList list) {
            this._next = this._root = new ActionNode(list);
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        public Object next() {
            ActionNode next = this._next;
            this._next = this._next.getNext();
            return next.getAction();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class ActionNode {
            Action _action;
            ActionNode _parent;
            int _indexInParent;
            boolean _isSeparator;
            ArrayList _children;

            public ActionNode(ActionList root) {
                this(root, null, 0);
            }

            public ActionNode(Object action, ActionNode parent, int indexInParent) {
                if (action instanceof Action) {
                    this._action = (Action)action;
                } else if (action == ActionList.SEPARATOR) {
                    this._isSeparator = true;
                } else {
                    throw new IllegalArgumentException(RB.getStringResource(ActionUtils.RB_KEY, "invalidAction.txt"));
                }
                this._parent = parent;
                this._indexInParent = indexInParent;
            }

            public Object getAction() {
                if (this._isSeparator) {
                    return ActionList.SEPARATOR;
                }
                return this._action;
            }

            private void addChildren(ActionList aList) {
                List list = aList.getActions();
                if (list != null && !list.isEmpty()) {
                    this._children = new ArrayList();
                    int cnt = list.size();
                    for (int i = 0; i < cnt; ++i) {
                        this._children.add(new ActionNode(list.get(i), this, i));
                    }
                }
            }

            public ActionNode getNext() {
                if (this._children == null && this._action != null && this._action instanceof ActionList) {
                    this.addChildren((ActionList)this._action);
                }
                if (this._children != null && !this._children.isEmpty()) {
                    return (ActionNode)this._children.get(0);
                }
                if (this._parent != null) {
                    return this._parent.getNext(this);
                }
                return null;
            }

            public ActionNode getNext(ActionNode node) {
                if (node != null && !this._children.isEmpty() && node._indexInParent + 1 < this._children.size()) {
                    return (ActionNode)this._children.get(node._indexInParent + 1);
                }
                if (this._parent != null) {
                    return this._parent.getNext(this);
                }
                return null;
            }
        }
    }
}

