/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.RB;
import com.sas.models.EncodingInterface;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class StringType
extends BaseDataType {
    public static final StringType DEFAULT_INSTANCE = new StringType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof String) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
            return ((String[])inputValue)[0];
        }
        if (inputValue instanceof MissingValues) {
            return MissingValues._BLANK_;
        }
        if (inputValue instanceof SpecialValues) {
            return inputValue;
        }
        if (inputValue instanceof Integer) {
            return IntegerType.DEFAULT_INSTANCE.getDisplayString(inputValue, inputLocale);
        }
        if (inputValue instanceof Boolean) {
            return Boolean.toString((Boolean)inputValue);
        }
        if (inputValue instanceof EncodingInterface) {
            return ((EncodingInterface)inputValue).getValue();
        }
        if (inputValue == null) {
            return null;
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("StringType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        if (value instanceof MissingValues) {
            return MissingValues.toQueryString((MissingValues)value);
        }
        if (value instanceof SpecialValues) {
            return this.getSpecialValuesAsString((SpecialValues)value, outputLocale);
        }
        return value.toString();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        return this.coerceValue(input, Locale.US);
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public int getSQLType() {
        return 12;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (this.isSpecialMacroValue(value)) {
            return this.getMacroVariablesForSpecialValues(macroInfoSource, value);
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(baseMacroVariableName, this.getValueAsString(value, Locale.US));
        return map;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        return this.coerceValue(value, inputLocale);
    }
}

