# nGPT Wiki

nGPT, a Swiss army knife for LLMs: a powerful CLI, interactive chatbot, and flexible library all in one package.

<div align="center" style="margin: 40px 0">
  <a href="https://nazdridoy.github.io/ngpt/" style="display: inline-block; text-decoration: none;">
    <div style="
      background-color: #4CAF50; 
      color: white; 
      padding: 20px 40px; 
      font-size: 24px; 
      font-weight: bold; 
      border-radius: 12px; 
      box-shadow: 0 8px 16px rgba(0,0,0,0.2); 
      transition: all 0.3s ease;
      cursor: pointer;
      margin: 20px auto;
      width: 80%;
      max-width: 500px;
      text-align: center;
    ">
      📚 View Complete Documentation 📚
    </div>
  </a>
</div>

## About nGPT

nGPT allows you to seamlessly work with OpenAI, Ollama, Groq, Claude, or any OpenAI-compatible API to:
- Generate code
- Craft git commit messages
- Rewrite and improve text
- Execute shell commands
- Chat interactively with powerful LLMs

It's fast, lightweight, and designed for both casual users and developers.

## Documentation Highlights

Our comprehensive documentation includes:

- [Installation Guide](https://nazdridoy.github.io/ngpt/installation.html) - Quick setup on Linux, Windows, macOS, and Android (Termux)
- [CLI Usage Guide](https://nazdridoy.github.io/ngpt/usage/cli_usage.html) - Command-line tips and tricks
- [Library Integration](https://nazdridoy.github.io/ngpt/usage/library_usage.html) - Using nGPT in your Python projects
- [Configuration Guide](https://nazdridoy.github.io/ngpt/configuration.html) - Setting up API keys and preferences
- [Examples & Tutorials](https://nazdridoy.github.io/ngpt/examples/basic.html) - Practical examples to get started

## Quick Start

```bash
# Install with pip
pip install ngpt

# Or install with uv (faster)
uv pip install ngpt

# Start chatting
ngpt "Tell me about quantum computing"

# Start an interactive session
ngpt -i
```

<div align="center" style="margin: 40px 0">
  <a href="https://nazdridoy.github.io/ngpt/" style="display: inline-block; text-decoration: none;">
    <div style="
      background-color: #4CAF50; 
      color: white; 
      padding: 15px 30px; 
      font-size: 20px; 
      font-weight: bold; 
      border-radius: 8px; 
      box-shadow: 0 4px 8px rgba(0,0,0,0.2); 
      transition: all 0.3s ease;
      cursor: pointer;
      margin: 20px auto;
      width: 60%;
      max-width: 400px;
      text-align: center;
    ">
      Explore Full Documentation →
    </div>
  </a>
</div>

---

<p align="center">
  <a href="https://pypi.org/project/ngpt/"><img src="https://img.shields.io/pypi/v/ngpt.svg" alt="PyPI version"></a>
  <a href="https://opensource.org/licenses/MIT"><img src="https://img.shields.io/badge/License-MIT-yellow.svg" alt="License: MIT"></a>
  <a href="https://nazdridoy.github.io/ngpt/"><img src="https://img.shields.io/badge/docs-available-brightgreen.svg" alt="Documentation"></a>
</p>

<p align="center">
  <a href="https://nazdridoy.github.io/ngpt/installation.html"><img src="https://img.shields.io/badge/Linux-support-blue?logo=linux" alt="Linux"></a>
  <a href="https://nazdridoy.github.io/ngpt/installation.html"><img src="https://img.shields.io/badge/Windows-support-blue?logo=windows" alt="Windows"></a>
  <a href="https://nazdridoy.github.io/ngpt/installation.html"><img src="https://img.shields.io/badge/macOS-support-blue?logo=apple" alt="macOS"></a>
  <a href="https://nazdridoy.github.io/ngpt/installation.html"><img src="https://img.shields.io/badge/Android-Termux-blue?logo=android" alt="Android"></a>
</p> 