# nGPT Overview

## What is nGPT?

🤖 nGPT is a Swiss army knife for LLMs: powerful CLI, interactive chatbot, and flexible library all in one package. Seamlessly work with OpenAI, Ollama, Groq, Claude, or any OpenAI-compatible API to generate code, craft git commits, rewrite text, and execute shell commands. Fast, lightweight, and designed for both casual users and developers.

## Key Features

- **Versatile**: Use as a CLI tool, Python library, or CLI framework for building custom tools
- **Lightweight**: Minimal dependencies with everything you need included
- **API Flexibility**: Works with OpenAI, Ollama, Groq, and any compatible endpoint
- **Interactive Chat**: Supports ongoing conversations with memory in an easy-to-use interface
- **Streaming Responses**: Provides real-time output for a better user experience
- **Web Search Integration**: Works with compatible API endpoints that support web search capabilities
- **Stdin Processing**: Process piped content by using `{}` placeholder in prompts
- **Markdown Rendering**: Beautiful formatting of markdown responses and syntax highlighting for code
- **Real-time Markdown Rendering**: Stream responses with live updating syntax highlighting and formatting
- **Multiple Configuration Support**: Maintain different API configurations for various services or models
- **Shell Command Generation**: Generate OS-aware commands that work on your specific platform
- **Text Rewriting**: Improve text quality while maintaining original tone and meaning
- **Clean Code Generation**: Output code without markdown formatting or explanations
- **Rich Multiline Editor**: Interactive multiline text input with syntax highlighting and intuitive controls
- **Git Commit Messages**: AI-powered generation of conventional, detailed commit messages from git diffs
- **System Prompts**: Customize model behavior with custom system prompts
- **Conversation Logging**: Automatically or manually log conversations with timestamps and role information
- **CLI Components**: Reusable components for building custom AI-powered command-line tools
- **Modular Architecture**: Well-structured codebase with clean separation of concerns

## Architecture

nGPT is built around a few core components:

1. **NGPTClient**: The main class that handles communication with the LLM API endpoints.

2. **Configuration System**: A cross-platform solution for managing API keys, endpoints, and model preferences.

3. **CLI Interface**: A user-friendly command-line interface for direct interaction with LLMs.

4. **Utility Modules**: Helper functions and classes for rendering, text processing, and more.

## Use Cases

nGPT is ideal for:

- Developers who need a simple, lightweight library for integrating LLM capabilities into their Python applications
- Users who want a convenient CLI tool for quick interactions with language models
- Projects that require flexibility to work with different LLM providers
- Applications that need to generate and potentially execute shell commands or code snippets
- Building custom AI-powered command-line tools using the CLI framework capabilities
- Automating tasks like code generation, text rewriting, and documentation generation

## Supported Providers

nGPT works with any provider that offers an OpenAI-compatible API, including:

- OpenAI
- Groq
- Ollama
- Self-hosted models (using compatible API servers)
- Any other service with OpenAI-compatible endpoints

For more detailed information on using nGPT, see the [Library Usage](usage/library_usage.md), [CLI Usage](usage/cli_usage.md), and [CLI Framework](usage/cli_framework.md) guides. 