# nGPT Documentation

Welcome to the documentation for nGPT, a Swiss army knife for LLMs: powerful CLI, interactive chatbot, and flexible library all in one package. Seamlessly work with OpenAI, Ollama, Groq, Claude, or any OpenAI-compatible API to generate code, craft git commits, rewrite text, and execute shell commands. Fast, lightweight, and designed for both casual users and developers. nGPT offers three main modes of use:

- A command-line interface (CLI) tool for quick AI interactions
- A Python library for integration into your applications
- A CLI framework for building your own AI-powered command-line tools

## Table of Contents

- [Overview](overview.md)
- [Installation](installation.md)
- [Usage](usage/README.md)
  - [CLI Usage](usage/cli_usage.md)
  - [Library Usage](usage/library_usage.md)
  - [CLI Framework](usage/cli_framework.md)
  - [CLI Configuration](usage/cli_config.md)
  - [Git Commit Messages](usage/gitcommsg.md)
- [API Reference](api/README.md)
  - [NGPTClient](api/client.md)
  - [Configuration](api/config.md)
  - [CLI Components](api/cli.md)
  - [CLI Configuration](api/cli_config.md)
- [Examples](examples/README.md)
  - [Basic Examples](examples/basic.md)
  - [Advanced Examples](examples/advanced.md)
  - [Custom Integrations](examples/integrations.md)
  - [CLI Component Examples](examples/cli_components.md)
- [Configuration](configuration.md)
- [Contributing](CONTRIBUTING.md)
- [License](LICENSE.md)

## Getting Started

For a quick start, refer to the [Installation](installation.md) and [Usage](usage/README.md) guides.

If you're primarily interested in using nGPT as a library in your Python projects, head directly to the [Library Usage](usage/library_usage.md) guide.

For creating your own CLI tools using nGPT's components, check out the [CLI Framework](usage/cli_framework.md) guide and the [CLI Component Examples](examples/cli_components.md). 