# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WebChatTyping(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WebChatTyping - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'conversation': 'WebChatConversation',
            'sender': 'WebChatMemberInfo',
            'timestamp': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'conversation': 'conversation',
            'sender': 'sender',
            'timestamp': 'timestamp'
        }

        self._id = None
        self._conversation = None
        self._sender = None
        self._timestamp = None

    @property
    def id(self):
        """
        Gets the id of this WebChatTyping.
        The event identifier of this typing indicator event (useful to guard against event re-delivery

        :return: The id of this WebChatTyping.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WebChatTyping.
        The event identifier of this typing indicator event (useful to guard against event re-delivery

        :param id: The id of this WebChatTyping.
        :type: str
        """
        
        if not id:
            raise ValueError("Invalid value for `id`, must not be `None`")


        self._id = id

    @property
    def conversation(self):
        """
        Gets the conversation of this WebChatTyping.
        The identifier of the conversation

        :return: The conversation of this WebChatTyping.
        :rtype: WebChatConversation
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation):
        """
        Sets the conversation of this WebChatTyping.
        The identifier of the conversation

        :param conversation: The conversation of this WebChatTyping.
        :type: WebChatConversation
        """
        
        if not conversation:
            raise ValueError("Invalid value for `conversation`, must not be `None`")


        self._conversation = conversation

    @property
    def sender(self):
        """
        Gets the sender of this WebChatTyping.
        The member who sent the message

        :return: The sender of this WebChatTyping.
        :rtype: WebChatMemberInfo
        """
        return self._sender

    @sender.setter
    def sender(self, sender):
        """
        Sets the sender of this WebChatTyping.
        The member who sent the message

        :param sender: The sender of this WebChatTyping.
        :type: WebChatMemberInfo
        """
        
        if not sender:
            raise ValueError("Invalid value for `sender`, must not be `None`")


        self._sender = sender

    @property
    def timestamp(self):
        """
        Gets the timestamp of this WebChatTyping.
        The timestamp of the message, in ISO-8601 format

        :return: The timestamp of this WebChatTyping.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this WebChatTyping.
        The timestamp of the message, in ISO-8601 format

        :param timestamp: The timestamp of this WebChatTyping.
        :type: datetime
        """
        
        if not timestamp:
            raise ValueError("Invalid value for `timestamp`, must not be `None`")


        self._timestamp = timestamp

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

