# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class TrustorAuditQueryRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TrustorAuditQueryRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'trustor_organization_id': 'str',
            'trustee_user_ids': 'list[str]',
            'start_date': 'datetime',
            'end_date': 'datetime',
            'query_phrase': 'str',
            'facets': 'list[Facet]',
            'filters': 'list[Filter]'
        }

        self.attribute_map = {
            'trustor_organization_id': 'trustorOrganizationId',
            'trustee_user_ids': 'trusteeUserIds',
            'start_date': 'startDate',
            'end_date': 'endDate',
            'query_phrase': 'queryPhrase',
            'facets': 'facets',
            'filters': 'filters'
        }

        self._trustor_organization_id = None
        self._trustee_user_ids = None
        self._start_date = None
        self._end_date = None
        self._query_phrase = None
        self._facets = None
        self._filters = None

    @property
    def trustor_organization_id(self):
        """
        Gets the trustor_organization_id of this TrustorAuditQueryRequest.
        Limit returned audits to this trustor organizationId.

        :return: The trustor_organization_id of this TrustorAuditQueryRequest.
        :rtype: str
        """
        return self._trustor_organization_id

    @trustor_organization_id.setter
    def trustor_organization_id(self, trustor_organization_id):
        """
        Sets the trustor_organization_id of this TrustorAuditQueryRequest.
        Limit returned audits to this trustor organizationId.

        :param trustor_organization_id: The trustor_organization_id of this TrustorAuditQueryRequest.
        :type: str
        """
        
        if not trustor_organization_id:
            raise ValueError("Invalid value for `trustor_organization_id`, must not be `None`")


        self._trustor_organization_id = trustor_organization_id

    @property
    def trustee_user_ids(self):
        """
        Gets the trustee_user_ids of this TrustorAuditQueryRequest.
        Limit returned audits to these trustee userIds.

        :return: The trustee_user_ids of this TrustorAuditQueryRequest.
        :rtype: list[str]
        """
        return self._trustee_user_ids

    @trustee_user_ids.setter
    def trustee_user_ids(self, trustee_user_ids):
        """
        Sets the trustee_user_ids of this TrustorAuditQueryRequest.
        Limit returned audits to these trustee userIds.

        :param trustee_user_ids: The trustee_user_ids of this TrustorAuditQueryRequest.
        :type: list[str]
        """
        
        if not trustee_user_ids:
            raise ValueError("Invalid value for `trustee_user_ids`, must not be `None`")


        self._trustee_user_ids = trustee_user_ids

    @property
    def start_date(self):
        """
        Gets the start_date of this TrustorAuditQueryRequest.
        Starting date/time for the audit search. ISO-8601 formatted date-time, UTC.

        :return: The start_date of this TrustorAuditQueryRequest.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this TrustorAuditQueryRequest.
        Starting date/time for the audit search. ISO-8601 formatted date-time, UTC.

        :param start_date: The start_date of this TrustorAuditQueryRequest.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def end_date(self):
        """
        Gets the end_date of this TrustorAuditQueryRequest.
        Ending date/time for the audit search. ISO-8601 formatted date-time, UTC.

        :return: The end_date of this TrustorAuditQueryRequest.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """
        Sets the end_date of this TrustorAuditQueryRequest.
        Ending date/time for the audit search. ISO-8601 formatted date-time, UTC.

        :param end_date: The end_date of this TrustorAuditQueryRequest.
        :type: datetime
        """
        

        self._end_date = end_date

    @property
    def query_phrase(self):
        """
        Gets the query_phrase of this TrustorAuditQueryRequest.
        Word or phrase to look for in audit bodies.

        :return: The query_phrase of this TrustorAuditQueryRequest.
        :rtype: str
        """
        return self._query_phrase

    @query_phrase.setter
    def query_phrase(self, query_phrase):
        """
        Sets the query_phrase of this TrustorAuditQueryRequest.
        Word or phrase to look for in audit bodies.

        :param query_phrase: The query_phrase of this TrustorAuditQueryRequest.
        :type: str
        """
        

        self._query_phrase = query_phrase

    @property
    def facets(self):
        """
        Gets the facets of this TrustorAuditQueryRequest.
        Facet information to be returned with the query results.

        :return: The facets of this TrustorAuditQueryRequest.
        :rtype: list[Facet]
        """
        return self._facets

    @facets.setter
    def facets(self, facets):
        """
        Sets the facets of this TrustorAuditQueryRequest.
        Facet information to be returned with the query results.

        :param facets: The facets of this TrustorAuditQueryRequest.
        :type: list[Facet]
        """
        

        self._facets = facets

    @property
    def filters(self):
        """
        Gets the filters of this TrustorAuditQueryRequest.
        Additional custom filters to be applied to the query.

        :return: The filters of this TrustorAuditQueryRequest.
        :rtype: list[Filter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this TrustorAuditQueryRequest.
        Additional custom filters to be applied to the query.

        :param filters: The filters of this TrustorAuditQueryRequest.
        :type: list[Filter]
        """
        

        self._filters = filters

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

