# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class SubjectDivisions(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        SubjectDivisions - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'subject_ids': 'list[str]',
            'division_ids': 'list[str]'
        }

        self.attribute_map = {
            'subject_ids': 'subjectIds',
            'division_ids': 'divisionIds'
        }

        self._subject_ids = None
        self._division_ids = None

    @property
    def subject_ids(self):
        """
        Gets the subject_ids of this SubjectDivisions.
        A collection of subject IDs to associate with the given divisions

        :return: The subject_ids of this SubjectDivisions.
        :rtype: list[str]
        """
        return self._subject_ids

    @subject_ids.setter
    def subject_ids(self, subject_ids):
        """
        Sets the subject_ids of this SubjectDivisions.
        A collection of subject IDs to associate with the given divisions

        :param subject_ids: The subject_ids of this SubjectDivisions.
        :type: list[str]
        """
        
        if not subject_ids:
            raise ValueError("Invalid value for `subject_ids`, must not be `None`")


        self._subject_ids = subject_ids

    @property
    def division_ids(self):
        """
        Gets the division_ids of this SubjectDivisions.
        A collection of division IDs to associate with the given subjects

        :return: The division_ids of this SubjectDivisions.
        :rtype: list[str]
        """
        return self._division_ids

    @division_ids.setter
    def division_ids(self, division_ids):
        """
        Sets the division_ids of this SubjectDivisions.
        A collection of division IDs to associate with the given subjects

        :param division_ids: The division_ids of this SubjectDivisions.
        :type: list[str]
        """
        
        if not division_ids:
            raise ValueError("Invalid value for `division_ids`, must not be `None`")


        self._division_ids = division_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

