# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ProgramRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ProgramRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'topic_ids': 'list[str]',
            'tags': 'list[str]'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'topic_ids': 'topicIds',
            'tags': 'tags'
        }

        self._name = None
        self._description = None
        self._topic_ids = None
        self._tags = None

    @property
    def name(self):
        """
        Gets the name of this ProgramRequest.
        The program name

        :return: The name of this ProgramRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ProgramRequest.
        The program name

        :param name: The name of this ProgramRequest.
        :type: str
        """
        
        if not name:
            raise ValueError("Invalid value for `name`, must not be `None`")


        self._name = name

    @property
    def description(self):
        """
        Gets the description of this ProgramRequest.
        The program description

        :return: The description of this ProgramRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ProgramRequest.
        The program description

        :param description: The description of this ProgramRequest.
        :type: str
        """
        

        self._description = description

    @property
    def topic_ids(self):
        """
        Gets the topic_ids of this ProgramRequest.
        The ids of topics associated to the program

        :return: The topic_ids of this ProgramRequest.
        :rtype: list[str]
        """
        return self._topic_ids

    @topic_ids.setter
    def topic_ids(self, topic_ids):
        """
        Sets the topic_ids of this ProgramRequest.
        The ids of topics associated to the program

        :param topic_ids: The topic_ids of this ProgramRequest.
        :type: list[str]
        """
        

        self._topic_ids = topic_ids

    @property
    def tags(self):
        """
        Gets the tags of this ProgramRequest.
        The program tags

        :return: The tags of this ProgramRequest.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ProgramRequest.
        The program tags

        :param tags: The tags of this ProgramRequest.
        :type: list[str]
        """
        

        self._tags = tags

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

