# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class LocalEncryptionConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        LocalEncryptionConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'url': 'str',
            'api_id': 'str',
            'api_key': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'url': 'url',
            'api_id': 'apiId',
            'api_key': 'apiKey',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._url = None
        self._api_id = None
        self._api_key = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this LocalEncryptionConfiguration.
        The globally unique identifier for the object.

        :return: The id of this LocalEncryptionConfiguration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LocalEncryptionConfiguration.
        The globally unique identifier for the object.

        :param id: The id of this LocalEncryptionConfiguration.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this LocalEncryptionConfiguration.


        :return: The name of this LocalEncryptionConfiguration.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LocalEncryptionConfiguration.


        :param name: The name of this LocalEncryptionConfiguration.
        :type: str
        """
        

        self._name = name

    @property
    def url(self):
        """
        Gets the url of this LocalEncryptionConfiguration.
        The url for decryption. This must specify the path to where Purecloud can requests decryption

        :return: The url of this LocalEncryptionConfiguration.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this LocalEncryptionConfiguration.
        The url for decryption. This must specify the path to where Purecloud can requests decryption

        :param url: The url of this LocalEncryptionConfiguration.
        :type: str
        """
        
        if not url:
            raise ValueError("Invalid value for `url`, must not be `None`")


        self._url = url

    @property
    def api_id(self):
        """
        Gets the api_id of this LocalEncryptionConfiguration.
        The api id for Hawk Authentication.

        :return: The api_id of this LocalEncryptionConfiguration.
        :rtype: str
        """
        return self._api_id

    @api_id.setter
    def api_id(self, api_id):
        """
        Sets the api_id of this LocalEncryptionConfiguration.
        The api id for Hawk Authentication.

        :param api_id: The api_id of this LocalEncryptionConfiguration.
        :type: str
        """
        
        if not api_id:
            raise ValueError("Invalid value for `api_id`, must not be `None`")


        self._api_id = api_id

    @property
    def api_key(self):
        """
        Gets the api_key of this LocalEncryptionConfiguration.
        The api shared symmetric key used for hawk authentication

        :return: The api_key of this LocalEncryptionConfiguration.
        :rtype: str
        """
        return self._api_key

    @api_key.setter
    def api_key(self, api_key):
        """
        Sets the api_key of this LocalEncryptionConfiguration.
        The api shared symmetric key used for hawk authentication

        :param api_key: The api_key of this LocalEncryptionConfiguration.
        :type: str
        """
        
        if not api_key:
            raise ValueError("Invalid value for `api_key`, must not be `None`")


        self._api_key = api_key

    @property
    def self_uri(self):
        """
        Gets the self_uri of this LocalEncryptionConfiguration.
        The URI for this object

        :return: The self_uri of this LocalEncryptionConfiguration.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this LocalEncryptionConfiguration.
        The URI for this object

        :param self_uri: The self_uri of this LocalEncryptionConfiguration.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

