# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ImportScheduleUploadSchema(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ImportScheduleUploadSchema - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'description': 'str',
            'week_count': 'int',
            'published': 'bool',
            'short_term_forecast': 'BuShortTermForecastReference',
            'headcount_forecast': 'BuHeadcountForecast',
            'agent_schedules': 'list[BuImportAgentScheduleUploadSchema]'
        }

        self.attribute_map = {
            'description': 'description',
            'week_count': 'weekCount',
            'published': 'published',
            'short_term_forecast': 'shortTermForecast',
            'headcount_forecast': 'headcountForecast',
            'agent_schedules': 'agentSchedules'
        }

        self._description = None
        self._week_count = None
        self._published = None
        self._short_term_forecast = None
        self._headcount_forecast = None
        self._agent_schedules = None

    @property
    def description(self):
        """
        Gets the description of this ImportScheduleUploadSchema.
        The description for the imported schedule

        :return: The description of this ImportScheduleUploadSchema.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ImportScheduleUploadSchema.
        The description for the imported schedule

        :param description: The description of this ImportScheduleUploadSchema.
        :type: str
        """
        
        if not description:
            raise ValueError("Invalid value for `description`, must not be `None`")


        self._description = description

    @property
    def week_count(self):
        """
        Gets the week_count of this ImportScheduleUploadSchema.
        The number of weeks the imported schedule will cover

        :return: The week_count of this ImportScheduleUploadSchema.
        :rtype: int
        """
        return self._week_count

    @week_count.setter
    def week_count(self, week_count):
        """
        Sets the week_count of this ImportScheduleUploadSchema.
        The number of weeks the imported schedule will cover

        :param week_count: The week_count of this ImportScheduleUploadSchema.
        :type: int
        """
        
        if not week_count:
            raise ValueError("Invalid value for `week_count`, must not be `None`")


        self._week_count = week_count

    @property
    def published(self):
        """
        Gets the published of this ImportScheduleUploadSchema.
        Whether the imported schedule should be immediately published

        :return: The published of this ImportScheduleUploadSchema.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this ImportScheduleUploadSchema.
        Whether the imported schedule should be immediately published

        :param published: The published of this ImportScheduleUploadSchema.
        :type: bool
        """
        

        self._published = published

    @property
    def short_term_forecast(self):
        """
        Gets the short_term_forecast of this ImportScheduleUploadSchema.
        The short term forecast to associate with the imported schedule

        :return: The short_term_forecast of this ImportScheduleUploadSchema.
        :rtype: BuShortTermForecastReference
        """
        return self._short_term_forecast

    @short_term_forecast.setter
    def short_term_forecast(self, short_term_forecast):
        """
        Sets the short_term_forecast of this ImportScheduleUploadSchema.
        The short term forecast to associate with the imported schedule

        :param short_term_forecast: The short_term_forecast of this ImportScheduleUploadSchema.
        :type: BuShortTermForecastReference
        """
        

        self._short_term_forecast = short_term_forecast

    @property
    def headcount_forecast(self):
        """
        Gets the headcount_forecast of this ImportScheduleUploadSchema.
        The headcount forecast to associate with the imported schedule

        :return: The headcount_forecast of this ImportScheduleUploadSchema.
        :rtype: BuHeadcountForecast
        """
        return self._headcount_forecast

    @headcount_forecast.setter
    def headcount_forecast(self, headcount_forecast):
        """
        Sets the headcount_forecast of this ImportScheduleUploadSchema.
        The headcount forecast to associate with the imported schedule

        :param headcount_forecast: The headcount_forecast of this ImportScheduleUploadSchema.
        :type: BuHeadcountForecast
        """
        

        self._headcount_forecast = headcount_forecast

    @property
    def agent_schedules(self):
        """
        Gets the agent_schedules of this ImportScheduleUploadSchema.
        Individual agent schedules

        :return: The agent_schedules of this ImportScheduleUploadSchema.
        :rtype: list[BuImportAgentScheduleUploadSchema]
        """
        return self._agent_schedules

    @agent_schedules.setter
    def agent_schedules(self, agent_schedules):
        """
        Sets the agent_schedules of this ImportScheduleUploadSchema.
        Individual agent schedules

        :param agent_schedules: The agent_schedules of this ImportScheduleUploadSchema.
        :type: list[BuImportAgentScheduleUploadSchema]
        """
        

        self._agent_schedules = agent_schedules

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

