# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class EdgeAutoUpdateConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        EdgeAutoUpdateConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'time_zone': 'str',
            'rrule': 'str',
            'start': 'LocalDateTime',
            'end': 'LocalDateTime'
        }

        self.attribute_map = {
            'time_zone': 'timeZone',
            'rrule': 'rrule',
            'start': 'start',
            'end': 'end'
        }

        self._time_zone = None
        self._rrule = None
        self._start = None
        self._end = None

    @property
    def time_zone(self):
        """
        Gets the time_zone of this EdgeAutoUpdateConfig.
        The timezone of the window in which any updates to the edges assigned to the site can be applied. The minimum size of the window is 2 hours.

        :return: The time_zone of this EdgeAutoUpdateConfig.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """
        Sets the time_zone of this EdgeAutoUpdateConfig.
        The timezone of the window in which any updates to the edges assigned to the site can be applied. The minimum size of the window is 2 hours.

        :param time_zone: The time_zone of this EdgeAutoUpdateConfig.
        :type: str
        """
        
        if not time_zone:
            raise ValueError("Invalid value for `time_zone`, must not be `None`")


        self._time_zone = time_zone

    @property
    def rrule(self):
        """
        Gets the rrule of this EdgeAutoUpdateConfig.
        The recurrence rule for updating the Edges assigned to the site. The only supported frequencies are daily and weekly. Weekly frequencies require a day list with at least oneday specified. All other configurations are not supported.

        :return: The rrule of this EdgeAutoUpdateConfig.
        :rtype: str
        """
        return self._rrule

    @rrule.setter
    def rrule(self, rrule):
        """
        Sets the rrule of this EdgeAutoUpdateConfig.
        The recurrence rule for updating the Edges assigned to the site. The only supported frequencies are daily and weekly. Weekly frequencies require a day list with at least oneday specified. All other configurations are not supported.

        :param rrule: The rrule of this EdgeAutoUpdateConfig.
        :type: str
        """
        
        if not rrule:
            raise ValueError("Invalid value for `rrule`, must not be `None`")


        self._rrule = rrule

    @property
    def start(self):
        """
        Gets the start of this EdgeAutoUpdateConfig.
        Date time is represented as an ISO-8601 string without a timezone. For example: yyyy-MM-ddTHH:mm:ss.SSS

        :return: The start of this EdgeAutoUpdateConfig.
        :rtype: LocalDateTime
        """
        return self._start

    @start.setter
    def start(self, start):
        """
        Sets the start of this EdgeAutoUpdateConfig.
        Date time is represented as an ISO-8601 string without a timezone. For example: yyyy-MM-ddTHH:mm:ss.SSS

        :param start: The start of this EdgeAutoUpdateConfig.
        :type: LocalDateTime
        """
        
        if not start:
            raise ValueError("Invalid value for `start`, must not be `None`")


        self._start = start

    @property
    def end(self):
        """
        Gets the end of this EdgeAutoUpdateConfig.
        Date time is represented as an ISO-8601 string without a timezone. For example: yyyy-MM-ddTHH:mm:ss.SSS

        :return: The end of this EdgeAutoUpdateConfig.
        :rtype: LocalDateTime
        """
        return self._end

    @end.setter
    def end(self, end):
        """
        Sets the end of this EdgeAutoUpdateConfig.
        Date time is represented as an ISO-8601 string without a timezone. For example: yyyy-MM-ddTHH:mm:ss.SSS

        :param end: The end of this EdgeAutoUpdateConfig.
        :type: LocalDateTime
        """
        
        if not end:
            raise ValueError("Invalid value for `end`, must not be `None`")


        self._end = end

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

