# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class CreateWebChatRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CreateWebChatRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'queue_id': 'str',
            'provider': 'str',
            'skill_ids': 'list[str]',
            'language_id': 'str',
            'priority': 'int',
            'attributes': 'dict(str, str)',
            'customer_name': 'str'
        }

        self.attribute_map = {
            'queue_id': 'queueId',
            'provider': 'provider',
            'skill_ids': 'skillIds',
            'language_id': 'languageId',
            'priority': 'priority',
            'attributes': 'attributes',
            'customer_name': 'customerName'
        }

        self._queue_id = None
        self._provider = None
        self._skill_ids = None
        self._language_id = None
        self._priority = None
        self._attributes = None
        self._customer_name = None

    @property
    def queue_id(self):
        """
        Gets the queue_id of this CreateWebChatRequest.
        The ID of the queue to use for routing the chat conversation.

        :return: The queue_id of this CreateWebChatRequest.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id):
        """
        Sets the queue_id of this CreateWebChatRequest.
        The ID of the queue to use for routing the chat conversation.

        :param queue_id: The queue_id of this CreateWebChatRequest.
        :type: str
        """
        
        if not queue_id:
            raise ValueError("Invalid value for `queue_id`, must not be `None`")


        self._queue_id = queue_id

    @property
    def provider(self):
        """
        Gets the provider of this CreateWebChatRequest.
        The name of the provider that is sourcing the web chat.

        :return: The provider of this CreateWebChatRequest.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """
        Sets the provider of this CreateWebChatRequest.
        The name of the provider that is sourcing the web chat.

        :param provider: The provider of this CreateWebChatRequest.
        :type: str
        """
        
        if not provider:
            raise ValueError("Invalid value for `provider`, must not be `None`")


        self._provider = provider

    @property
    def skill_ids(self):
        """
        Gets the skill_ids of this CreateWebChatRequest.
        The list of skill ID's to use for routing.

        :return: The skill_ids of this CreateWebChatRequest.
        :rtype: list[str]
        """
        return self._skill_ids

    @skill_ids.setter
    def skill_ids(self, skill_ids):
        """
        Sets the skill_ids of this CreateWebChatRequest.
        The list of skill ID's to use for routing.

        :param skill_ids: The skill_ids of this CreateWebChatRequest.
        :type: list[str]
        """
        

        self._skill_ids = skill_ids

    @property
    def language_id(self):
        """
        Gets the language_id of this CreateWebChatRequest.
        The ID of the langauge to use for routing.

        :return: The language_id of this CreateWebChatRequest.
        :rtype: str
        """
        return self._language_id

    @language_id.setter
    def language_id(self, language_id):
        """
        Sets the language_id of this CreateWebChatRequest.
        The ID of the langauge to use for routing.

        :param language_id: The language_id of this CreateWebChatRequest.
        :type: str
        """
        

        self._language_id = language_id

    @property
    def priority(self):
        """
        Gets the priority of this CreateWebChatRequest.
        The priority to assign to the conversation for routing.

        :return: The priority of this CreateWebChatRequest.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this CreateWebChatRequest.
        The priority to assign to the conversation for routing.

        :param priority: The priority of this CreateWebChatRequest.
        :type: int
        """
        

        self._priority = priority

    @property
    def attributes(self):
        """
        Gets the attributes of this CreateWebChatRequest.
        The list of attributes to associate with the customer participant.

        :return: The attributes of this CreateWebChatRequest.
        :rtype: dict(str, str)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this CreateWebChatRequest.
        The list of attributes to associate with the customer participant.

        :param attributes: The attributes of this CreateWebChatRequest.
        :type: dict(str, str)
        """
        

        self._attributes = attributes

    @property
    def customer_name(self):
        """
        Gets the customer_name of this CreateWebChatRequest.
        The name of the customer participating in the web chat.

        :return: The customer_name of this CreateWebChatRequest.
        :rtype: str
        """
        return self._customer_name

    @customer_name.setter
    def customer_name(self, customer_name):
        """
        Sets the customer_name of this CreateWebChatRequest.
        The name of the customer participating in the web chat.

        :param customer_name: The customer_name of this CreateWebChatRequest.
        :type: str
        """
        

        self._customer_name = customer_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

