# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AcdEndDetailEventTopicAcdEndEvent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AcdEndDetailEventTopicAcdEndEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_time': 'int',
            'conversation_id': 'str',
            'participant_id': 'str',
            'session_id': 'str',
            'disconnect_type': 'str',
            'media_type': 'str',
            'provider': 'str',
            'direction': 'str',
            'ani': 'str',
            'dnis': 'str',
            'address_to': 'str',
            'address_from': 'str',
            'callback_user_name': 'str',
            'callback_numbers': 'list[str]',
            'callback_scheduled_time': 'int',
            'subject': 'str',
            'message_type': 'str',
            'queue_id': 'str',
            'division_id': 'str',
            'acd_outcome': 'str',
            'answered_user_id': 'str',
            'requested_routings': 'list[str]',
            'used_routing': 'str',
            'requested_routing_skill_ids': 'list[str]',
            'requested_language_id': 'str',
            'requested_routing_user_ids': 'list[str]',
            'routing_priority': 'int',
            'connected_duration_ms': 'int'
        }

        self.attribute_map = {
            'event_time': 'eventTime',
            'conversation_id': 'conversationId',
            'participant_id': 'participantId',
            'session_id': 'sessionId',
            'disconnect_type': 'disconnectType',
            'media_type': 'mediaType',
            'provider': 'provider',
            'direction': 'direction',
            'ani': 'ani',
            'dnis': 'dnis',
            'address_to': 'addressTo',
            'address_from': 'addressFrom',
            'callback_user_name': 'callbackUserName',
            'callback_numbers': 'callbackNumbers',
            'callback_scheduled_time': 'callbackScheduledTime',
            'subject': 'subject',
            'message_type': 'messageType',
            'queue_id': 'queueId',
            'division_id': 'divisionId',
            'acd_outcome': 'acdOutcome',
            'answered_user_id': 'answeredUserId',
            'requested_routings': 'requestedRoutings',
            'used_routing': 'usedRouting',
            'requested_routing_skill_ids': 'requestedRoutingSkillIds',
            'requested_language_id': 'requestedLanguageId',
            'requested_routing_user_ids': 'requestedRoutingUserIds',
            'routing_priority': 'routingPriority',
            'connected_duration_ms': 'connectedDurationMs'
        }

        self._event_time = None
        self._conversation_id = None
        self._participant_id = None
        self._session_id = None
        self._disconnect_type = None
        self._media_type = None
        self._provider = None
        self._direction = None
        self._ani = None
        self._dnis = None
        self._address_to = None
        self._address_from = None
        self._callback_user_name = None
        self._callback_numbers = None
        self._callback_scheduled_time = None
        self._subject = None
        self._message_type = None
        self._queue_id = None
        self._division_id = None
        self._acd_outcome = None
        self._answered_user_id = None
        self._requested_routings = None
        self._used_routing = None
        self._requested_routing_skill_ids = None
        self._requested_language_id = None
        self._requested_routing_user_ids = None
        self._routing_priority = None
        self._connected_duration_ms = None

    @property
    def event_time(self):
        """
        Gets the event_time of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The event_time of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: int
        """
        return self._event_time

    @event_time.setter
    def event_time(self, event_time):
        """
        Sets the event_time of this AcdEndDetailEventTopicAcdEndEvent.


        :param event_time: The event_time of this AcdEndDetailEventTopicAcdEndEvent.
        :type: int
        """
        

        self._event_time = event_time

    @property
    def conversation_id(self):
        """
        Gets the conversation_id of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The conversation_id of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id):
        """
        Sets the conversation_id of this AcdEndDetailEventTopicAcdEndEvent.


        :param conversation_id: The conversation_id of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def participant_id(self):
        """
        Gets the participant_id of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The participant_id of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._participant_id

    @participant_id.setter
    def participant_id(self, participant_id):
        """
        Sets the participant_id of this AcdEndDetailEventTopicAcdEndEvent.


        :param participant_id: The participant_id of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._participant_id = participant_id

    @property
    def session_id(self):
        """
        Gets the session_id of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The session_id of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this AcdEndDetailEventTopicAcdEndEvent.


        :param session_id: The session_id of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def disconnect_type(self):
        """
        Gets the disconnect_type of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The disconnect_type of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._disconnect_type

    @disconnect_type.setter
    def disconnect_type(self, disconnect_type):
        """
        Sets the disconnect_type of this AcdEndDetailEventTopicAcdEndEvent.


        :param disconnect_type: The disconnect_type of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        allowed_values = ["UNKNOWN", "ENDPOINT", "CLIENT", "SYSTEM", "TRANSFER", "ERROR", "PEER", "OTHER", "SPAM", "TIMEOUT", "TRANSPORT_FAILURE", "CONFERENCE_TRANSFER", "CONSULT_TRANSFER", "FORWARD_TRANSFER", "NO_ANSWER_TRANSFER", "NOT_AVAILABLE_TRANSFER", "UNCALLABLE"]
        if disconnect_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for disconnect_type -> " + disconnect_type)
            self._disconnect_type = "outdated_sdk_version"
        else:
            self._disconnect_type = disconnect_type

    @property
    def media_type(self):
        """
        Gets the media_type of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The media_type of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type):
        """
        Sets the media_type of this AcdEndDetailEventTopicAcdEndEvent.


        :param media_type: The media_type of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        allowed_values = ["UNKNOWN", "VOICE", "CHAT", "EMAIL", "CALLBACK", "COBROWSE", "VIDEO", "SCREENSHARE", "MESSAGE"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def provider(self):
        """
        Gets the provider of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The provider of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """
        Sets the provider of this AcdEndDetailEventTopicAcdEndEvent.


        :param provider: The provider of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._provider = provider

    @property
    def direction(self):
        """
        Gets the direction of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The direction of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """
        Sets the direction of this AcdEndDetailEventTopicAcdEndEvent.


        :param direction: The direction of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        allowed_values = ["UNKNOWN", "INBOUND", "OUTBOUND"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    @property
    def ani(self):
        """
        Gets the ani of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The ani of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._ani

    @ani.setter
    def ani(self, ani):
        """
        Sets the ani of this AcdEndDetailEventTopicAcdEndEvent.


        :param ani: The ani of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._ani = ani

    @property
    def dnis(self):
        """
        Gets the dnis of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The dnis of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._dnis

    @dnis.setter
    def dnis(self, dnis):
        """
        Sets the dnis of this AcdEndDetailEventTopicAcdEndEvent.


        :param dnis: The dnis of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._dnis = dnis

    @property
    def address_to(self):
        """
        Gets the address_to of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The address_to of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._address_to

    @address_to.setter
    def address_to(self, address_to):
        """
        Sets the address_to of this AcdEndDetailEventTopicAcdEndEvent.


        :param address_to: The address_to of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._address_to = address_to

    @property
    def address_from(self):
        """
        Gets the address_from of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The address_from of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._address_from

    @address_from.setter
    def address_from(self, address_from):
        """
        Sets the address_from of this AcdEndDetailEventTopicAcdEndEvent.


        :param address_from: The address_from of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._address_from = address_from

    @property
    def callback_user_name(self):
        """
        Gets the callback_user_name of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The callback_user_name of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._callback_user_name

    @callback_user_name.setter
    def callback_user_name(self, callback_user_name):
        """
        Sets the callback_user_name of this AcdEndDetailEventTopicAcdEndEvent.


        :param callback_user_name: The callback_user_name of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._callback_user_name = callback_user_name

    @property
    def callback_numbers(self):
        """
        Gets the callback_numbers of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The callback_numbers of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: list[str]
        """
        return self._callback_numbers

    @callback_numbers.setter
    def callback_numbers(self, callback_numbers):
        """
        Sets the callback_numbers of this AcdEndDetailEventTopicAcdEndEvent.


        :param callback_numbers: The callback_numbers of this AcdEndDetailEventTopicAcdEndEvent.
        :type: list[str]
        """
        

        self._callback_numbers = callback_numbers

    @property
    def callback_scheduled_time(self):
        """
        Gets the callback_scheduled_time of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The callback_scheduled_time of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: int
        """
        return self._callback_scheduled_time

    @callback_scheduled_time.setter
    def callback_scheduled_time(self, callback_scheduled_time):
        """
        Sets the callback_scheduled_time of this AcdEndDetailEventTopicAcdEndEvent.


        :param callback_scheduled_time: The callback_scheduled_time of this AcdEndDetailEventTopicAcdEndEvent.
        :type: int
        """
        

        self._callback_scheduled_time = callback_scheduled_time

    @property
    def subject(self):
        """
        Gets the subject of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The subject of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """
        Sets the subject of this AcdEndDetailEventTopicAcdEndEvent.


        :param subject: The subject of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._subject = subject

    @property
    def message_type(self):
        """
        Gets the message_type of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The message_type of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._message_type

    @message_type.setter
    def message_type(self, message_type):
        """
        Sets the message_type of this AcdEndDetailEventTopicAcdEndEvent.


        :param message_type: The message_type of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        allowed_values = ["UNKNOWN", "SMS", "TWITTER", "FACEBOOK", "LINE", "WHATSAPP", "WEBMESSAGING", "OPEN", "INSTAGRAM"]
        if message_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for message_type -> " + message_type)
            self._message_type = "outdated_sdk_version"
        else:
            self._message_type = message_type

    @property
    def queue_id(self):
        """
        Gets the queue_id of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The queue_id of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id):
        """
        Sets the queue_id of this AcdEndDetailEventTopicAcdEndEvent.


        :param queue_id: The queue_id of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def division_id(self):
        """
        Gets the division_id of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The division_id of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._division_id

    @division_id.setter
    def division_id(self, division_id):
        """
        Sets the division_id of this AcdEndDetailEventTopicAcdEndEvent.


        :param division_id: The division_id of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._division_id = division_id

    @property
    def acd_outcome(self):
        """
        Gets the acd_outcome of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The acd_outcome of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._acd_outcome

    @acd_outcome.setter
    def acd_outcome(self, acd_outcome):
        """
        Sets the acd_outcome of this AcdEndDetailEventTopicAcdEndEvent.


        :param acd_outcome: The acd_outcome of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        allowed_values = ["UNKNOWN", "ABANDON", "ANSWERED", "FLOW_OUT"]
        if acd_outcome.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for acd_outcome -> " + acd_outcome)
            self._acd_outcome = "outdated_sdk_version"
        else:
            self._acd_outcome = acd_outcome

    @property
    def answered_user_id(self):
        """
        Gets the answered_user_id of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The answered_user_id of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._answered_user_id

    @answered_user_id.setter
    def answered_user_id(self, answered_user_id):
        """
        Sets the answered_user_id of this AcdEndDetailEventTopicAcdEndEvent.


        :param answered_user_id: The answered_user_id of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._answered_user_id = answered_user_id

    @property
    def requested_routings(self):
        """
        Gets the requested_routings of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The requested_routings of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: list[str]
        """
        return self._requested_routings

    @requested_routings.setter
    def requested_routings(self, requested_routings):
        """
        Sets the requested_routings of this AcdEndDetailEventTopicAcdEndEvent.


        :param requested_routings: The requested_routings of this AcdEndDetailEventTopicAcdEndEvent.
        :type: list[str]
        """
        

        self._requested_routings = requested_routings

    @property
    def used_routing(self):
        """
        Gets the used_routing of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The used_routing of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._used_routing

    @used_routing.setter
    def used_routing(self, used_routing):
        """
        Sets the used_routing of this AcdEndDetailEventTopicAcdEndEvent.


        :param used_routing: The used_routing of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        allowed_values = ["UNKNOWN", "MANUAL", "PREDICTIVE", "PREFERRED", "LAST", "BULLSEYE", "STANDARD", "OTHER"]
        if used_routing.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for used_routing -> " + used_routing)
            self._used_routing = "outdated_sdk_version"
        else:
            self._used_routing = used_routing

    @property
    def requested_routing_skill_ids(self):
        """
        Gets the requested_routing_skill_ids of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The requested_routing_skill_ids of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: list[str]
        """
        return self._requested_routing_skill_ids

    @requested_routing_skill_ids.setter
    def requested_routing_skill_ids(self, requested_routing_skill_ids):
        """
        Sets the requested_routing_skill_ids of this AcdEndDetailEventTopicAcdEndEvent.


        :param requested_routing_skill_ids: The requested_routing_skill_ids of this AcdEndDetailEventTopicAcdEndEvent.
        :type: list[str]
        """
        

        self._requested_routing_skill_ids = requested_routing_skill_ids

    @property
    def requested_language_id(self):
        """
        Gets the requested_language_id of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The requested_language_id of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: str
        """
        return self._requested_language_id

    @requested_language_id.setter
    def requested_language_id(self, requested_language_id):
        """
        Sets the requested_language_id of this AcdEndDetailEventTopicAcdEndEvent.


        :param requested_language_id: The requested_language_id of this AcdEndDetailEventTopicAcdEndEvent.
        :type: str
        """
        

        self._requested_language_id = requested_language_id

    @property
    def requested_routing_user_ids(self):
        """
        Gets the requested_routing_user_ids of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The requested_routing_user_ids of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: list[str]
        """
        return self._requested_routing_user_ids

    @requested_routing_user_ids.setter
    def requested_routing_user_ids(self, requested_routing_user_ids):
        """
        Sets the requested_routing_user_ids of this AcdEndDetailEventTopicAcdEndEvent.


        :param requested_routing_user_ids: The requested_routing_user_ids of this AcdEndDetailEventTopicAcdEndEvent.
        :type: list[str]
        """
        

        self._requested_routing_user_ids = requested_routing_user_ids

    @property
    def routing_priority(self):
        """
        Gets the routing_priority of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The routing_priority of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: int
        """
        return self._routing_priority

    @routing_priority.setter
    def routing_priority(self, routing_priority):
        """
        Sets the routing_priority of this AcdEndDetailEventTopicAcdEndEvent.


        :param routing_priority: The routing_priority of this AcdEndDetailEventTopicAcdEndEvent.
        :type: int
        """
        

        self._routing_priority = routing_priority

    @property
    def connected_duration_ms(self):
        """
        Gets the connected_duration_ms of this AcdEndDetailEventTopicAcdEndEvent.


        :return: The connected_duration_ms of this AcdEndDetailEventTopicAcdEndEvent.
        :rtype: int
        """
        return self._connected_duration_ms

    @connected_duration_ms.setter
    def connected_duration_ms(self, connected_duration_ms):
        """
        Sets the connected_duration_ms of this AcdEndDetailEventTopicAcdEndEvent.


        :param connected_duration_ms: The connected_duration_ms of this AcdEndDetailEventTopicAcdEndEvent.
        :type: int
        """
        

        self._connected_duration_ms = connected_duration_ms

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

