# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['PyARMViz', 'PyARMViz.datasets', 'PyARMViz.tests']

package_data = \
{'': ['*']}

install_requires = \
['networkx', 'numpy', 'plotly']

setup_kwargs = {
    'name': 'pyarmviz',
    'version': '0.1.4',
    'description': 'Advanced Python Association Rule Visualization Library',
    'long_description': '# Introduction\n\nAdvanced Python Association Rule Visualization Library\n\n# Summary\n\nLoosely based on [ARulesViz](https://cran.r-project.org/web/packages/arulesViz/index.html) for R\nand the ideas described in this [paper](https://link.springer.com/article/10.1007/s11573-016-0822-8).\n\n[Association Rules Mining (ARM)](https://en.wikipedia.org/wiki/Association_rule_learning) produces \nAssociation Rules (AR) from mined Item Sets in a DataBase (DB). \nMost ARM libraries represent these output rules textually using the **Antecedent (predictor)**, \n**Consequent (predicted)** and **Descriptive Metadata (Support, Confidence, Lift, etc.)**\nThis presents a problem since typical DBs can yield 100-1000s of rules, forcing us to either apply\nfiltration criterion or devise more efficient visualizations.\n\nWhile filtration is the most common and effective approach, dedicated visualizations are also valuable,\nespecially in data exploration scenarios where the characteristics of interesting data not may not be\nknown in advance\n\n# Generating Rules\nPyARMViz is designed to run on Association Rules like the ones produced by [Efficient-Apriori](https://pypi.org/project/efficient-apriori/)\n\nThe library includes a set of synthetic retail transaction data for testing and demonstration\npurposes.\nThis data includes both transactions sets (to be run through a compatible ARM workflow of your choice)\nor a rules set which can be input directly into the library.\n\n```\nfrom PyARMViz import datasets\nrules = datasets.load_shopping_rules()\n```\n\n#Visualizations\n\nThe visualizations in this library can be divided into two families based on the data they display\nabout the individual Association Rules\n\n## Rule Metadata Visualizations\n\nRule Metadata visualizations focus entirely on the descriptive metadata of each rule and do not\nconsider the antecedents and consequents.\n\nThis makes this visualization less helpful for discovering interesting regions in the original\ndata, but enables distributional evaluation of rules to develop better filtration criterion.\n\nThese visualization also tend to be among the most scalable because they do not need to display\nmultiple entity types (rule v. antecedent/precedent) simultaneously.\n\n### Confidence/Lift/Support Scatterplot\n\nThe three primary descriptive metadata for rules are **Confidence** (percentage of time the \nantecedent leads to the consequent versus the support of the antecedent), the **Support** \n(percentage of times the antecedent leads to the consequent versus the size of the database) \nand the **Lift** (percentage of times the antecedent leads to the consequent versus the \nsupport of the consequent)\n\nAll three of these are commonly used filtration criterion for ARs, and by graphing their \ndistribution, this visualization can help spot outlier and visually show the distribution of rules\nthat would pass a given set of criterion.\n\nThese new criterion can then be applied against the existing rules (as shown below), or upstream in the\nanalysts ARM workflow\n\n```\nfrom PyARMViz import datasets\nfrom PyARMViz import PyARMViz\n\nrules = datasets.load_shopping_rules()\nPyARMViz.metadata_scatter_plot(rules)\n```\n\n## Rule Entity Visualizations\nThese visualizations include the **Antecedent** and **Consequent** **Entities** of the\n**Rule** (ex. Antecedent:Eggs,Flour -> Consequent:Milk) with some portion of its descriptive\nmetadata.\n\nThese visualizations are useful for identifying the rules which are adjacent through their\nterminating entities, and potentially complex structures such as hubs or chains formed by those\nadjacencies.\nThese complex structures, in turn, can indicate regions of interest within the data which can be\nextracted and inspected more closely.\n\n### Parallel Plots\n[Parallel plots](https://en.wikipedia.org/wiki/Parallel_coordinates) are a popular choice for \nlarge scale visualization of sets which highlights common elements in those sets.\n\nAll parallel plots work by taking multiple ordered sets of fixed length, assigning an axis to\neach "place" in the set (ex. first item, second item, etc.). Assigning each value found in that\nplace to a location on the axis, and drawing a line between the locations assigned to each value\nfor each set. \n\nWe can input our Association Rules into this visualization by converting each rule into an \nordered set by appending the consequents to the antecedents (ex. antecedent1, antacedent2, \nconsequent1) and visualizing them.\n\nA major disadvantage of these diagrams for this purpose is that ARs are not of a fixed length.\nCurrently the library overcomes this by breaking the rules down by length and creating a different\nplot for each.\nThis was chosen because Plotly does not allow us to input, forcing us to use some awkward padding\ntechniques that compromise readability.\n\n#### Parallel Cordinate Plot\nParallel coordinate plots are the more common, popular and supported version of parallel plots.\n\n\n#### Parallel Category Plot\nThe less popular, less well documented and (arguably) more appropriate choice for this application \nis [Parallel Category plots](https://plotly.com/python/parallel-categories-diagram/), sometimes \ncalled ribbon or Alluvial plots.\nThese are essentially the same as Parallel Coordinate plots except for how they allocate space on\nthe axis for each value.\n\nWhile coordinate plots allocate a specific point per axis for each value in order to accomodate a theoretically\ninfinite number of values, category plots will allocate a segment of the axis based on the number\nof values.\n\nOptimally this subdivision will be based on the total number of sets that contain that value, \ngiving us a way to demonstrate the frequency of individual and combinatorial values in the \ndatabase.\n\nThe downside of this diagram, at least in the Plotly implementation, is that it provides less \nopportunity for visual highlighting of the characteristics of the individual role (size, color,\nbrightness).\n\n### Network Diagrams\nThis group of diagrams (my favorite) work by turning the rules into a directional network graph\nusing the [NetworkX]() libary.\n\nThis allows us to leverage one of several potential graph visualizations to show the adjacency \n(shared Antecedents or Consequents) of rules and more complex structures (chains, hubs) formed\nby that adjacency.\n\n#### Plotly Network Diagram\n\nThis version uses the Plotly network diagram visualization to visualize the directional network\ngraph.\n\nIt has the advantage of being self contained in the browser and requiring no additional\ndependencies aside from the base Plotly.\n\nIt has the disadvantage of limited arrangement algorithm and visual highlighting options when \ncompared to dedicated graph visualization software.\n\n```\nfrom PyARMViz import datasets\nfrom PyARMViz import PyARMViz\n\nrules = datasets.load_shopping_rules()\nadjacency_graph_plotly(rules)\n```\n\n#### Gephi Network Diagram Export\nNetwork diagrams provide one of the most flexible, scalable and powerful visualizations in this\ncategory but can result in highly interconnected graphs that are difficult and computationally\nexpensive to visualize. \nOne solution is to use a dedicated, open source graph visualization tool like [Gephi](https://gephi.org/),\nwhich provides a rich set of arrangement and visual highlighting options unavailable in a purely\nJavascript solution such as Plotly\n\nTHe downside is that we will need to export the directional network graph from NetworkX to some\nform that Gephi can use, in this case the GEFX file format.\nAfter the file is output by this function, simply install Gephi, open it and load the output file\non disc.\n\nNote that if an explicit destination location and filename is not provided, the function defaults to \n"rule.gexf" in the current working directory of the Python script calling the function.\n\n```\nfrom PyARMViz import datasets\nfrom PyARMViz import PyARMViz\n\nrules = datasets.load_shopping_rules()\nadjacency_graph_gephi(rules)\n```\n\n# Installation\n\n## From Github\n1. In CLI (with Git setup locally) clone to local directory \n`git clone https://github.com/Mazeofthemind/PyARMViz.git`\n2. Navigate into the root directory of the cloned project\n`cd PyARMViz`\n3. Execute Python build and install (may require sudo or alternate Python/PIP psudonym)\n`pip install .`\n\n## From PyPi (Currently only Testing)\n`pip install --index-url https://test.pypi.org/simple/ PyARMViz`\n\n# Build\n\nThis project is currently built under [Poetry]() a newer Python build tool leverage virtual \nenvironments\n\n```\ngit clone https://github.com/Mazeofthemind/PyARMViz.git\npip install poetry\ncd PyARMViz\npython -m poetry build\n\'\'\'',
    'author': 'Mazeofthemind',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mazeofthemind/PyARMViz',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
}


setup(**setup_kwargs)
