# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetTriggerRecipientResult',
    'AwaitableGetTriggerRecipientResult',
    'get_trigger_recipient',
    'get_trigger_recipient_output',
]

@pulumi.output_type
class GetTriggerRecipientResult:
    """
    A collection of values returned by GetTriggerRecipient.
    """
    def __init__(__self__, dataset=None, id=None, target=None, type=None):
        if dataset and not isinstance(dataset, str):
            raise TypeError("Expected argument 'dataset' to be a str")
        pulumi.set(__self__, "dataset", dataset)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


class AwaitableGetTriggerRecipientResult(GetTriggerRecipientResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTriggerRecipientResult(
            dataset=self.dataset,
            id=self.id,
            target=self.target,
            type=self.type)


def get_trigger_recipient(dataset: Optional[str] = None,
                          target: Optional[str] = None,
                          type: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTriggerRecipientResult:
    """
    ## # Data Source: _get_trigger_recipient

    Search the triggers of a dataset for a trigger recipient. The ID of the existing trigger recipient can be used when adding trigger recipients to new triggers. Specifying a trigger recipient by its ID is necessary when adding Slack recipients, since these can not be created using the API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_honeycomb as honeycomb

    config = pulumi.Config()
    dataset = config.require("dataset")
    slack = honeycomb.get_trigger_recipient(dataset=dataset,
        type="slack",
        target="honeycomb-triggers")
    example_get_query = honeycomb.get_query(calculations=[honeycomb.GetQueryCalculationArgs(
        op="AVG",
        column="duration_ms",
    )])
    example_trigger = honeycomb.Trigger("exampleTrigger",
        query_json=example_get_query.json,
        dataset=dataset,
        threshold=honeycomb.TriggerThresholdArgs(
            op=">",
            value=1000,
        ),
        recipients=[
            honeycomb.TriggerRecipientArgs(
                type="email",
                target="hello@example.com",
            ),
            honeycomb.TriggerRecipientArgs(
                id=slack.id,
            ),
        ])
    ```


    :param str dataset: Search through all triggers linked to this dataset.
    :param str target: Target of the trigger, this has another meaning depending on the type of recipient (see the table below).
    :param str type: The type of recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`.
    """
    __args__ = dict()
    __args__['dataset'] = dataset
    __args__['target'] = target
    __args__['type'] = type
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('honeycomb:index/getTriggerRecipient:GetTriggerRecipient', __args__, opts=opts, typ=GetTriggerRecipientResult).value

    return AwaitableGetTriggerRecipientResult(
        dataset=__ret__.dataset,
        id=__ret__.id,
        target=__ret__.target,
        type=__ret__.type)


@_utilities.lift_output_func(get_trigger_recipient)
def get_trigger_recipient_output(dataset: Optional[pulumi.Input[str]] = None,
                                 target: Optional[pulumi.Input[Optional[str]]] = None,
                                 type: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTriggerRecipientResult]:
    """
    ## # Data Source: _get_trigger_recipient

    Search the triggers of a dataset for a trigger recipient. The ID of the existing trigger recipient can be used when adding trigger recipients to new triggers. Specifying a trigger recipient by its ID is necessary when adding Slack recipients, since these can not be created using the API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_honeycomb as honeycomb

    config = pulumi.Config()
    dataset = config.require("dataset")
    slack = honeycomb.get_trigger_recipient(dataset=dataset,
        type="slack",
        target="honeycomb-triggers")
    example_get_query = honeycomb.get_query(calculations=[honeycomb.GetQueryCalculationArgs(
        op="AVG",
        column="duration_ms",
    )])
    example_trigger = honeycomb.Trigger("exampleTrigger",
        query_json=example_get_query.json,
        dataset=dataset,
        threshold=honeycomb.TriggerThresholdArgs(
            op=">",
            value=1000,
        ),
        recipients=[
            honeycomb.TriggerRecipientArgs(
                type="email",
                target="hello@example.com",
            ),
            honeycomb.TriggerRecipientArgs(
                id=slack.id,
            ),
        ])
    ```


    :param str dataset: Search through all triggers linked to this dataset.
    :param str target: Target of the trigger, this has another meaning depending on the type of recipient (see the table below).
    :param str type: The type of recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`.
    """
    ...
