import React from 'react';

export default function AggregateIcon({
  color = 'rgba(0,0,0,0.4)',
  width = 13,
  height = 10,
  ...props
}: React.SVGProps<SVGSVGElement>) {
  return (
    <svg
      width={width}
      height={height}
      viewBox={`0 0 ${width} ${height}`}
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <path
        d="M9.85053 4.50938C9.68417 4.50938 9.53767 4.50938 9.39095 4.50938C8.07753 4.50938 6.76367 4.52915 5.45047 4.50351C4.27715 4.48033 3.28386 3.8277 2.4587 2.67169C2.24071 2.36639 2.08539 1.99929 2.03553 1.56204C2.02052 1.43071 2.02494 1.29382 2.00155 1.1662C1.93249 0.789513 1.66928 0.555901 1.38665 0.606579C1.11461 0.655403 0.907878 0.979555 0.90545 1.36551C0.900376 2.21343 1.14087 2.93034 1.51506 3.57153C1.91617 4.25877 2.42097 4.764 2.97696 5.17591C3.0191 5.20712 3.06146 5.2371 3.10338 5.26862C3.10934 5.27325 3.11375 5.2819 3.1292 5.30292C3.07978 5.34092 3.03389 5.37708 2.98755 5.41138C2.33073 5.89776 1.74628 6.50589 1.32553 7.38101C1.06011 7.9329 0.90192 8.53794 0.904789 9.21282C0.906775 9.64575 1.14241 9.98504 1.45063 9.99956C1.74209 10.0135 2.01236 9.69488 2.02052 9.2808C2.03156 8.72428 2.21005 8.28486 2.47149 7.90138C3.06345 7.03306 3.79882 6.50929 4.62199 6.2284C4.88984 6.13693 5.17203 6.09429 5.44804 6.09182C6.87156 6.07884 8.29507 6.08595 9.71881 6.08626C9.75808 6.08626 9.79735 6.08626 9.84876 6.08626C9.84876 6.15887 9.84876 6.21388 9.84876 6.26888C9.84876 6.80316 9.8481 7.33775 9.84898 7.87203C9.84942 8.13067 9.91914 8.29043 10.0592 8.36304C10.2018 8.4369 10.324 8.3788 10.444 8.17826C10.9526 7.32724 11.4609 6.47623 11.9688 5.62459C12.1385 5.34 12.1376 5.17622 11.9686 4.89224C11.4587 4.03628 10.9495 3.1794 10.4387 2.32467C10.2966 2.08674 10.1043 2.05553 9.95819 2.23877C9.87193 2.34723 9.8503 2.49 9.8503 2.64388C9.85031 3.20412 9.85031 3.76404 9.85031 4.32428C9.85053 4.3799 9.85053 4.43491 9.85053 4.50938Z"
        fill={color}
      />
    </svg>
  );
}
