(self.webpackChunkjupyter_bifrost=self.webpackChunkjupyter_bifrost||[]).push([[223],{2791:function(n,t,e){var r=e(4155);!function(n){"use strict";const t=/(\w+)\(([\w\.\/]+)(,([\w\.]+))?\)/;function o(n){let e="",r="data/cars.json";const o={};for(const i of n){const n=i.replace(/\"/g,""),a=i.trim().startsWith(":-"),[s,c,u,l,f]=t.exec(n);"mark"===c?e=u:"data"===c?r=u:"soft"!==c&&(o[u]||(o[u]={}),o[u][c]=f||!a)}const i={};for(const n of Object.keys(o)){const t=o[n];"quantitative"===t.type&&void 0===t.zero&&void 0===t.bin&&(t.zero=!1);const e={...t.log?{type:"log"}:{},...void 0===t.zero?{}:t.zero?{zero:!0}:{zero:!1}};i[t.channel]={type:t.type,...t.aggregate?{aggregate:t.aggregate}:{},...t.field?{field:t.field}:{},...t.stack?{stack:t.stack}:{},...void 0!==t.bin?10==+t.bin?{bin:!0}:{bin:{maxbins:+t.bin}}:{},...Object.keys(e).length?{scale:e}:{}}}return{$schema:"https://vega.github.io/schema/vega-lite/v3.json",data:{url:`${r}`},mark:e,encoding:i}}const i="% ====== Expressiveness and Well-Formedness Constraints ======\n\n% === Within Encodings ===\n\n% @constraint Primitive type has to support data type.\nhard(enc_type_valid,E,F) :- type(E,quantitative), field(E,F), fieldtype(F,(string;boolean)).\nhard(enc_type_valid,E,F) :- type(E,temporal), field(E,F), not fieldtype(F,datetime).\n\n% @constraint Can only bin quantitative or ordinal.\nhard(bin_q_o,E,T) :- type(E,T), bin(E,_), T != quantitative, T != ordinal.\n\n% @constraint Can only use log with quantitative.\nhard(log_q,E) :- log(E), not type(E,quantitative).\n\n% @constraint Can only use zero with quantitative.\nhard(zero_q,E) :- zero(E), not type(E,quantitative).\n\n% @constraint Cannot use log scale with discrete (which includes binned).\nhard(log_discrete,E) :- log(E), discrete(E).\n\n% @constraint Cannot use log and zero together.\nhard(log_zero,E) :- log(E), zero(E).\n\n% @constraint Cannot use log if the data is negative or zero.\nhard(log_non_positive,E,F) :- log(E), field(E,F), extent(F,MIN,_), MIN <= 0.\n\n% @constraint Cannot bin and aggregate.\nhard(bin_and_aggregate,E) :- bin(E,_), aggregate(E,_).\n\n% @constraint Oridnal only supports min, max, and median.\nhard(aggregate_o_valid,E,A) :- type(E,ordinal), aggregate(E,A), A != min, A != max, A != median.\n\n% @constraint Temporal only supports min and max.\nhard(aggregate_t_valid,E,A) :- type(E,temporal), aggregate(E,A), A != min, A != max.\n\n% @constraint Cannot aggregate nominal.\nhard(aggregate_nominal,E) :- aggregate(E,_), type(E,nominal).\n\n% @constraint Detail cannot be aggregated.\nhard(aggregate_detail,E) :- channel(E,detail), aggregate(E,_).\n\n% @constraint Count has to be quantitative and not use a field.\nhard(count_q_without_field,E) :- aggregate(E,count), field(E,_).\nhard(count_q_without_field,E) :- aggregate(E,count), not type(E,quantitative).\n\n% @constraint Shape requires discrete and not ordered (nominal). Using ordinal would't make a difference in Vega-Lite.\nhard(shape_discrete_non_ordered,E) :- channel(E,shape), not type(E,nominal).\n\n% @constraint Detail requires nominal.\nhard(detail_non_ordered,E) :- channel(E,detail), not type(E,nominal).\n\n% @constraint Size implies order so nominal is misleading.\nhard(size_nominal) :- channel(E,size), type(E,nominal).\n\n% @constraint Do not use size when data is negative as size implies that data is positive.\nhard(size_negative,E) :- channel(E,size), enc_extent(E,MIN,MAX), MIN < 0, MAX > 0.\n\n% === Across encodings and between encodings and marks ===\n\n% @constraint Cannot use single channels twice.\nhard(repeat_channel,C):- single_channel(C), 2 { channel(_,C) }.\n\n% @constraint There has to be at least one encoding. Otherwise, the visualization doesn't show anything.\nhard(no_encodings) :- not encoding(_).\n\n% @constraint Row and column require discrete.\nhard(row_or_column_c) :- channel_continuous(row;column).\n\n% @constraint Don't use row without y. Just using y is simpler.\nhard(row_no_y) :- channel(_,row), not channel(_,y).\n\n% @constraint Don't use column without x. Just using x is simpler.\nhard(column_no_x) :- channel(_,column), not channel(_,x).\n\n% @constraint All encodings (if they have a channel) require field except if we have a count aggregate.\nhard(encoding_no_field_and_not_count,E) :- not field(E,_), not aggregate(E,count), encoding(E).\n\n% @constraint Count should not have a field. Having a field doesn't make a difference.\nhard(count_with_field,E) :- aggregate(E,count), field(E,_).\n\n% @constraint Text mark requires text channel.\nhard(text_mark_without_text_channel) :- mark(text), not channel(_,text).\n\n% @constraint Text channel requires text mark.\nhard(text_channel_without_text_mark) :- channel(_,text), not mark(text).\n\n% @constraint Point, tick, and bar require x or y channel.\nhard(point_tick_bar_without_x_or_y) :- mark(point;tick;bar), not channel(_,x), not channel(_,y).\n\n% @constraint Line and area require x and y channel.\nhard(line_area_without_x_y) :- mark(line;area), not channel(_,(x;y)).\n\n% @constraint Line and area cannot have two discrete.\nhard(line_area_with_discrete) :- mark(line;area), channel_discrete(x), channel_discrete(y).\n\n% @constraint Bar and tick cannot have both x and y continuous.\nhard(bar_tick_continuous_x_y) :- mark(bar;tick), channel_continuous(x), channel_continuous(y).\n\n% @constraint Bar, tick, line, area require some continuous variable on x or y.\nhard(bar_tick_area_line_without_continuous_x_y) :- mark(bar;tick;area;line), not channel_continuous(x), not channel_continuous(y).\n\n% @constraint Bar and area mark requires scale of continuous to start at zero.\nhard(bar_area_without_zero) :- mark(bar;area), channel(E,x), orientation(horizontal), not zero(E).\nhard(bar_area_without_zero) :- mark(bar;area), channel(E,y), orientation(vertical), not zero(E).\n\n% @constraint Shape channel requires point mark.\nhard(shape_without_point) :- channel(_,shape), not mark(point).\n\n% @constraint Size only works with some marks. Vega-Lite can also size lines, and ticks but that would violate best practices.\nhard(size_without_point_text) :- channel(_,size), not mark(point), not mark(text).\n\n% @constraint Detail requires aggregation. Detail adds a field to the group by. Detail could also be used to add information to tooltips. We may remove this later.\nhard(detail_without_agg) :- channel(_,detail), not aggregate(_,_).\n\n% @constraint Do not use log for bar or area mark as they are often misleading. We may remove this rule in the future.\nhard(area_bar_with_log) :- mark(bar;area), log(E), channel(E,(x;y)).\n\n% @constraint Rect mark needs discrete x and y.\nhard(rect_without_d_d) :- mark(rect), not is_d_d.\n\n% @constraint Don't use the same field on x and y.\nhard(same_field_x_and_y) :- { field(E,F) : channel(E,x); field(E,F) : channel(E,y) } >= 2, field(F).\n\n% @constraint Don't use count on x and y.\nhard(count_on_x_and_y):- channel(EX,x), channel(EY,y), aggregate(EX,count), aggregate(EY,count).\n\n% @constraint If we use aggregation, then all continuous fields need to be aggeragted.\nhard(aggregate_not_all_continuous):- aggregate(_,_), continuous(E), not aggregate(E,_).\n\n% @constraint Don't use count twice.\nhard(count_twice) :- { aggregate(_,count) } = 2.\n\n% === Global properties ===\n\n% @constraint Bars and area cannot overlap.\nhard(bar_area_overlap) :- mark(bar;area), overlap.\n\n% @constraint Rects shouldn't overlap. They are used for dioscrete heatmaps.\nhard(rect_overlap) :- mark(rect), overlap.\n\n% == Stacking ==\n\n% @constraint Only use stacking for bar and area.\nhard(stack_without_bar_area) :- stack(_), not mark(bar), not mark(area).\n\n% @constraint Don't stack if aggregation is not summative (summative are count, sum, distinct, valid, missing).\nhard(stack_without_summative_agg,E,A) :- stack(E,_), aggregate(E,A), not summative_aggregate_op(A).\n\n% @constraint Need to stack if we use bar, area with discrete color.\nhard(no_stack_with_bar_area_discrete_color,E) :- mark(bar;area), channel(E,color), discrete(E), not stack(_).\n\n% @constraint Can only use stack if we also use discrete color, or detail.\nhard(stack_without_discrete_color_or_detail) :- stack(_), not channel_discrete(color), not channel(_,detail).\n\n% @constraint If we use stack and detail, we also have to use quantitative color.\nhard(stack_detail_without_q_color) :- stack(_), channel(_,detail), not channel(_,color).\nhard(stack_detail_without_q_color,E) :- stack(_), channel(_,detail), channel(E,color), not aggregate(E,_).\n\n% @constraint Stack can only be on continuous.\nhard(stack_discrete,E) :- stack(E,_), discrete(E).\n\n% @constraint Stack can only be on x or y.\nhard(stack_without_x_y,E) :- stack(E,_), not channel(E,x), not channel(E,y).\n\n% @constraint Cannot use non positional continuous with stack unless it's aggregated.\nhard(stack_with_non_positional_non_agg,E,C) :- stack(_), non_positional(C), channel(E,C), not aggregate(E,_), continuous(E).\n\n% @constraint Vega-Lite currently supports 8 shapes.\nhard(shape_with_cardinality_gt_eight,E,C) :- channel(E,shape), enc_cardinality(E,C), C > 8.\n\n% @constraint At most 20 categorical colors.\nhard(color_with_cardinality_gt_twenty,E,C) :- channel(E,color), discrete(E), enc_cardinality(E,C), C > 20.\n\n% === Type checks ===\n\n% @constraint Check mark.\nhard(invalid_mark,M) :- mark(M), not marktype(M).\n\n% @constraint Check types of encoding properties.\nhard(invalid_channel,C) :- channel(_,C), not channel(C).\nhard(invalid_field,F) :- field(_,F), not field(F).\nhard(invalid_type,T) :- type(_,T), not type(T).\nhard(invalid_agg,A) :- aggregate(_,A), not aggregate_op(A).\nhard(invalid_bin,B) :- bin(_,B), not B >= 0.  % @constraint Bin has to be a natural number.\n\n% @constraint Fieldtype has to be primitive type.\nhard(invalid_fieldtype,T) :- fieldtype(_,T), not primitive_type(T).\n\n% @constraint Task has to be one of the tasks.\nhard(invalid_task,T) :- task(T), not tasks(T).\n\n% @constraint Num_rows has to be larger than 0.\nhard(invalid_num_rows,S) :- num_rows(S), S < 0.\n\n% @constraint Cardinality has to be larger than 0.\nhard(invalid_cardinality,C) :- cardinality(_,C), C < 0.\n\n% @constraint Entropy has to be positive.\nhard(invalid_entropy,E) :- entropy(_,E), E < 0.\n\n% @constraint Extent only allowed for numbers (for now).\nhard(invalid_extent_non_number,F) :- extent(F,_,_), not fieldtype(F,number).\n\n% @constraint Order has to be correct.\nhard(invalid_extent_order,MIN,MAX):- extent(_,MIN,MAX), MIN > MAX.\n\n% @constraint The name of a field cannot be the name of an encoding. This is to prevent errors coming from the shortcuts in define.lp.\nhard(encoding_field_same_name,N) :- encoding(N), field(N).\n\n",a="% After adding a soft constraint to this file, make sure to update 'weights.lp' and run 'process_softs.py'..\n\n% ====== Preferences ======\n\n% @constraint Prefer to use raw (no aggregate).\nsoft(aggregate,E) :- aggregate(E,_).\n\n% @constraint Prefer to not bin.\nsoft(bin,E) :- bin(E,_).\n\n% @constraint Prefer binning with at most 12 buckets.\nsoft(bin_high,E) :- bin(E,B), B > 12.\n\n% @constraint Prefer binning with more than 7 buckets.\nsoft(bin_low,E) :- bin(E,B), B <= 7.\n\n% @constraint Prefer to use fewer encodings.\nsoft(encoding,E) :- encoding(E).\n\n% @constraint Prefer to use fewer encodings with fields (count does not have a field).\nsoft(encoding_field,E) :- encoding(E), field(E,_).\n\n% @constraint Prefer not to use the same field twice.\nsoft(same_field_2,F) :- field(F), { field(_,F) } = 2.\n\n% @constraint Prefer not to use the same field three or more times.\n% @weight {16}\nsoft(same_field_gte3,F) :- field(F), { field(_,F) } >= 3.\n% @end\n\n% @constraint Prefer not to use count more than once.\nsoft(count_twice) :- { aggregate(_,count) } = 2.\n\n% @constraint Shape channel should not have too high cardinality.\nsoft(shape_cardinality,E) :- channel(E,shape), discrete_cardinality(E,C), C > 5.\n\n% @constraint Numbers should not be nominal.\nsoft(number_nominal,E) :- type(E,nominal), field(E,F), fieldtype(F,number).\n\n% @constraint Prefer nominal string fields\nsoft(string_non_nominal,V,E) :- type(V,E,ordinal), field(V,E,F), fieldtype(F,string).\nsoft(string_non_nominal,V,E) :- type(V,E,temporal), field(V,E,F), fieldtype(F,string).\nsoft(string_non_nominal,V,E) :- type(V,E,quantitative), field(V,E,F), fieldtype(F,string).\n\n% @constraint Binned quantitative field should not have too low cardinality.\nsoft(bin_cardinality,E) :- type(E,quantitative), bin(E,_), enc_cardinality(E,C), C < 15.\n\n% @constraint Prefer quantitative for bin.\nsoft(quant_bin,E) :- bin(E,_), not type(E,quantitative).\n\n% @constraint Plots with only nominal, ordinal, binned q, or t with time unit should add either an aggregation (e.g. count) or a quantitative field.\nsoft(only_discrete) :- not continuous(_).\n\n% @constraint Prefer not to use multiple non-positional encoding channels.\nsoft(multiple_non_pos) :- {channel(_,C): non_positional(C)} > 1.\n\n% @constraint Prefer not to use non-positional channels until all positional channels are used.\nsoft(non_positional_pref) :- channel(_,C), non_positional(C), not channel(_,(x;y)).\n\n% @constraint Aggregate plots should not use raw continuous as group by.\nsoft(aggregate_group_by_raw,E) :- aggregate(_,_), continuous(E), not aggregate(E,_).\n\n% @constraint Aggregate should also have a discrete encoding to group by.\nsoft(agg_dim) :- aggregate(_,_), not discrete(_).\n\n% @constraint Prefer not to use plot with both x and y discrete and no aggregate as it leads to occlusion.\nsoft(x_y_raw,E) :- channel(EX,x), discrete(EX), channel(EY,y), discrete(EY), not aggregate(E,_), continuous(E).\n\n% @constraint Prefer not to use log scale.\nsoft(log,E) :- log(E).\n\n% @constraint Prefer to include zero for continuous (binned doesn't need zero).\nsoft(zero,E) :- continuous(E), not zero(E).\n\n% @constraint Prefer zero size (even when binned).\nsoft(zero_size) :- channel(E,size), not zero(E).\n\n% @constraint Prefer zero positional.\nsoft(zero_positional) :- continuous(E), channel(E,(x;y)), not zero(E).\n\n% @constraint Prefer not to use zero when the difference between min and max is larger than distance to 0.\nsoft(zero_skew) :- enc_extent(E,MIN,MAX), EX = MAX - MIN, |MAX| > EX, |MIN| > EX, zero(E).\n\n% @constraint Do not include zero when the range of data includes zero.\nsoft(includes_zero) :- zero(E), extent(E,MIN,MAX), MIN < 0, MAX > 0.\n\n% @constraint Prefer to use only x instead of only y.\nsoft(only_x) :- channel(_,y), not channel(_,x).\n\n% @constraint Chart orientation for bar and tick (with and without bin). Binned fields have short labels if they are quantitative while otherwise labels can be long.\nsoft(orientation_binned) :- bin(E,_), type(E,quantitative), not channel(E,x).\n\n% @constraint Prefer not to use ordinal for fields with high cardinality.\nsoft(high_cardinality_ordinal,E) :- type(E,ordinal), discrete_cardinality(E,C), C > 30.\n\n% @constraint Prefer not to use nominal for fields with high cardinality.\nsoft(high_cardinality_nominal,E) :- type(E,nominal), enc_cardinality(E,C), C > 12.\n\n% @constraint Prefer not to use high cardinality nominal for color.\nsoft(high_cardinality_nominal_color,E) :- type(E,nominal), channel(E,color), enc_cardinality(E,C), C > 10.\n\n% @constraint Avoid high cardinality on x or column as it causes horizontal scrolling.\nsoft(horizontal_scrolling,E) :- channel(E,x), discrete_cardinality(E,C), C > 50.\nsoft(horizontal_scrolling,E) :- channel(E,columm), discrete_cardinality(E,C), C > 5.\n\n% @constraint Prefer to use temporal type with dates.\nsoft(temporal_date,E) :- field(E,F), fieldtype(F,datetime), not type(E,temporal).\n\n% @constraint Prefer quantitative for numbers with high cardinality.\nsoft(quantitative_numbers) :- field(E,F), fieldtype(F,number), cardinality(F,C), C > 20, not bin(E,_), not type(E,quantitative).\n\n% @constraint Overplotting. Prefer not to use x and y for continuous with high cardinality and low entropy without aggregation because the points will overplot.\nsoft(position_entropy,E) :- channel(E,(x;y)), continuous(E), enc_cardinality(E,C), C > 100, enc_entropy(E,EN), EN <= 12, not aggregate(E,_).\n\n% @constraint Prefer not to use size when the cardinality is large on x or y.\nsoft(high_cardinality_size,E) :- continuous(E), channel(_,size), enc_cardinality(E,C), C > 100, channel(E,(x;y)).\n\n% @constraint Prefer not to aggregate for value tasks.\nsoft(value_agg) :- task(value), aggregate(_,_).\n\n% @constraint Prefer not to use row and column for summary tasks as it makes it difficult to compare.\nsoft(facet_summary,E) :- task(summary), channel(E,row).\n\n% @constraint Positional interactions as suggested by Kim et al.\nsoft(x_row) :- channel(_,x), channel(_,row).\n\n% @constraint Positional interactions as suggested by Kim et al.\nsoft(y_row) :- channel(_,y), channel(_,row).\n\n% @constraint Positional interactions as suggested by Kim et al.\nsoft(x_column) :- channel(_,x), channel(_,column).\n\n% @constraint Positional interactions as suggested by Kim et al.\nsoft(y_column) :- channel(_,y), channel(_,column).\n\n% @constraint Entropy, primary quantitaty interactions as suggested by Kim et al.\nsoft(color_entropy_high, E) :- channel(E,color), enc_entropy(E,EN), EN > 12, type(E,quantitative), enc_interesting(E).\n\n% @constraint Entropy, primary quantitaty interactions as suggested by Kim et al.\nsoft(color_entropy_low, E) :- channel(E,color), enc_entropy(E,EN), EN <= 12, type(E,quantitative), enc_interesting(E).\n\n% @constraint Entropy, primary quantitaty interactions as suggested by Kim et al.\nsoft(size_entropy_high, E) :- channel(E,size), enc_entropy(E,EN), EN > 12, type(E,quantitative), enc_interesting(E).\n\n% @constraint Entropy, primary quantitaty interactions as suggested by Kim et al.\nsoft(size_entropy_low, E) :- channel(E,size), enc_entropy(E,EN), EN <= 12, type(E,quantitative), enc_interesting(E).\n\n% @constraint Prefer not to use continuous on x, discrete on y, and column.\nsoft(c_d_column) :- channel_continuous(x), channel_discrete(y), channel(_,column).\n\n% @constraint Prefer time on x.\nsoft(temporal_y) :- type(E,temporal), not channel(E,x).\n\n% @constraint Prefer not to overlap with DxD.\nsoft(d_d_overlap) :- is_d_d, overlap.\n\n% ====== Rankings ======\n% === Data Types ===\n\n% @constraint Prefer quantitative > ordinal > nominal.\nsoft(type_q,E) :- type(E,quantitative).\n\n% @constraint Prefer quantitative > ordinal > nominal.\nsoft(type_o,E) :- type(E,ordinal).\n\n% @constraint Prefer quantitative > ordinal > nominal.\nsoft(type_n,E) :- type(E,nominal).\n\n% === Mark types ===\n\n% @constraint Continuous by continuous for point mark.\nsoft(c_c_point) :- is_c_c, mark(point).\n\n% @constraint Continuous by continuous for line mark.\nsoft(c_c_line) :- is_c_c, mark(line).\n\n% @constraint Continuous by continuous for area mark.\nsoft(c_c_area) :- is_c_c, mark(area).\n\n% @constraint Continuous by continuous for text mark.\nsoft(c_c_text) :- is_c_c, mark(text).\n\n% @constraint Continuous by continuous for tick mark.\nsoft(c_c_tick) :- is_c_c, mark(tick).\n\n% @constraint Continuous by discrete for point mark.\nsoft(c_d_point) :- is_c_d, not no_overlap, mark(point).\n\n% @constraint Continuous by discrete for bar mark.\nsoft(c_d_bar) :- is_c_d, not no_overlap, mark(bar).\n\n% @constraint Continuous by discrete for line mark.\nsoft(c_d_line) :- is_c_d, not no_overlap, mark(line).\n\n% @constraint Continuous by discrete for area mark.\nsoft(c_d_area) :- is_c_d, not no_overlap, mark(area).\n\n% @constraint Continuous by discrete for text mark.\nsoft(c_d_text) :- is_c_d, not no_overlap, mark(text).\n\n% @constraint Continuous by discrete for tick mark.\nsoft(c_d_tick) :- is_c_d, not no_overlap, mark(tick).\n\n% @constraint Continuous by discrete for point mark with no overlap.\nsoft(c_d_no_overlap_point) :- is_c_d, no_overlap, mark(point).\n\n% @constraint Continuous by discrete for bar mark with no overlap.\nsoft(c_d_no_overlap_bar) :- is_c_d, no_overlap, mark(bar).\n\n% @constraint Continuous by discrete for line mark with no overlap.\nsoft(c_d_no_overlap_line) :- is_c_d, no_overlap, mark(line).\n\n% @constraint Continuous by discrete for area mark with no overlap.\nsoft(c_d_no_overlap_area) :- is_c_d, no_overlap, mark(area).\n\n% @constraint Continuous by discrete for text mark with no overlap.\nsoft(c_d_no_overlap_text) :- is_c_d, no_overlap, mark(text).\n\n% @constraint Continuous by discrete for tick mark with no overlap.\nsoft(c_d_no_overlap_tick) :- is_c_d, no_overlap, mark(tick).\n\n% @constraint Discrete by discrete for point mark.\nsoft(d_d_point) :- is_d_d, mark(point).\n\n% @constraint Discrete by discrete for point mark.\nsoft(d_d_text) :- is_d_d, mark(text).\n\n% @constraint Discrete by discrete for point mark.\nsoft(d_d_rect) :- is_d_d, mark(rect).\n\n% === Channel rankings à la APT ===\n\n% @constraint Continuous on x channel.\nsoft(continuous_x,E) :- channel(E,x), continuous(E).\n\n% @constraint Continuous on y channel.\nsoft(continuous_y,E) :- channel(E,y), continuous(E).\n\n% @constraint Continuous on color channel.\nsoft(continuous_color,E) :- channel(E,color), continuous(E).\n\n% @constraint Continuous on size channel.\nsoft(continuous_size,E) :- channel(E,size), continuous(E).\n\n% @constraint Continuous on text channel.\nsoft(continuous_text,E) :- channel(E,text), continuous(E).\n\n% @constraint Ordered on x channel.\nsoft(ordered_x,E) :- channel(E,x), discrete(E), not type(E,nominal).\n\n% @constraint Ordered on y channel.\nsoft(ordered_y,E) :- channel(E,y), discrete(E), not type(E,nominal).\n\n% @constraint Ordered on color channel.\nsoft(ordered_color,E) :- channel(E,color), discrete(E), not type(E,nominal).\n\n% @constraint Ordered on size channel.\nsoft(ordered_size,E) :- channel(E,size), discrete(E), not type(E,nominal).\n\n% @constraint Ordered on text channel.\nsoft(ordered_text,E) :- channel(E,text), discrete(E), not type(E,nominal).\n\n% @constraint Ordered on row channel.\nsoft(ordered_row,E) :- channel(E,row), discrete(E), not type(E,nominal).\n\n% @constraint Ordered on column channel.\nsoft(ordered_column,E) :- channel(E,column), discrete(E), not type(E,nominal).\n\n% @constraint Nominal on x channel.\nsoft(nominal_x,E) :- channel(E,x), type(E,nominal).\n\n% @constraint Nominal on y channel.\nsoft(nominal_y,E) :- channel(E,y), type(E,nominal).\n\n% @constraint Nominal on color channel.\nsoft(nominal_color,E) :- channel(E,color), type(E,nominal).\n\n% @constraint Nominal on shape channel.\nsoft(nominal_shape,E) :- channel(E,shape), type(E,nominal).\n\n% @constraint Nominal on text channel.\nsoft(nominal_text,E) :- channel(E,text), type(E,nominal).\n\n% @constraint Nominal on row channel.\nsoft(nominal_row,E) :- channel(E,row), type(E,nominal).\n\n% @constraint Nominal on column channel.\nsoft(nominal_column,E) :- channel(E,column), type(E,nominal).\n\n% @constraint Nominal on detail channel.\nsoft(nominal_detail,E) :- channel(E,detail), type(E,nominal).\n\n% @constraint Interesting on x channel.\nsoft(interesting_x,E) :- channel(E,x), enc_interesting(E).\n\n% @constraint Interesting on y channel.\nsoft(interesting_y,E) :- channel(E,y), enc_interesting(E).\n\n% @constraint Interesting on color channel.\nsoft(interesting_color,E) :- channel(E,color), enc_interesting(E).\n\n% @constraint Interesting on size channel.\nsoft(interesting_size,E) :- channel(E,size), enc_interesting(E).\n\n% @constraint Interesting on shape channel.\nsoft(interesting_shape,E) :- channel(E,shape), enc_interesting(E).\n\n% @constraint Interesting on text channel.\nsoft(interesting_text,E) :- channel(E,text), enc_interesting(E).\n\n% @constraint Interesting on row channel.\nsoft(interesting_row,E) :- channel(E,row), enc_interesting(E).\n\n% @constraint Interesting on column channel.\nsoft(interesting_column,E) :- channel(E,column), enc_interesting(E).\n\n% @constraint Interesting on detail channel.\nsoft(interesting_detail,E) :- channel(E,detail), enc_interesting(E).\n\n% === Aggregations ===\n\n% @constraint Count as aggregate op.\nsoft(aggregate_count,E) :- aggregate(E,count).\n\n% @constraint Sum as aggregate op.\nsoft(aggregate_sum,E) :- aggregate(E,sum).\n\n% @constraint Mean as aggregate op.\nsoft(aggregate_mean,E) :- aggregate(E,mean).\n\n% @constraint Median as aggregate op.\nsoft(aggregate_median,E) :- aggregate(E,median).\n\n% @constraint Min as aggregate op.\nsoft(aggregate_min,E) :- aggregate(E,min).\n\n% @constraint Max as aggregate op.\nsoft(aggregate_max,E) :- aggregate(E,max).\n\n% @constraint Standard Deviation as aggregate op.\nsoft(aggregate_stdev,E) :- aggregate(E,stdev).\n\n% === Stack ===\n\n% @constraint Zero base for stack op.\nsoft(stack_zero) :- stack(zero).\n\n% @constraint Normalize between groupbys as stack op.\nsoft(stack_normalize) :- stack(normalize).\n\n% === Task - marktype correlations ===\n\n% @constraint Point mark for value tasks.\nsoft(value_point) :- task(value), mark(point).\n\n% @constraint Bar mark for value tasks.\nsoft(value_bar) :- task(value), mark(bar).\n\n% @constraint Line mark for value tasks.\nsoft(value_line) :- task(value), mark(line).\n\n% @constraint Area mark for value tasks.\nsoft(value_area) :- task(value), mark(area).\n\n% @constraint Text mark for value tasks.\nsoft(value_text) :- task(value), mark(text).\n\n% @constraint Tick mark for value tasks.\nsoft(value_tick) :- task(value), mark(tick).\n% @end\n\n% @constraint Rect mark for value tasks.\nsoft(value_rect) :- task(value), mark(rect).\n\n% @constraint Point mark for summary tasks.\nsoft(summary_point) :- task(summary), mark(point).\n\n% @constraint Bar mark for summary tasks.\nsoft(summary_bar) :- task(summary), mark(bar).\n\n% @constraint Line mark for summary tasks.\nsoft(summary_line) :- task(summary), mark(line).\n\n% @constraint Area mark for summary tasks.\nsoft(summary_area) :- task(summary), mark(area).\n\n% @constraint Text mark for summary tasks.\nsoft(summary_text) :- task(summary), mark(text).\n\n% @constraint Tick mark for summary tasks.\nsoft(summary_tick) :- task(summary), mark(tick).\n\n% @constraint Rect mark for summary tasks.\nsoft(summary_rect) :- task(summary), mark(rect).\n\n% === Task - channel correlations ===\n\n% @constraint Continuous x for value tasks.\nsoft(value_continuous_x,E) :- task(value), channel(E,x), continuous(E), enc_interesting(E).\n\n% @constraint Continuous y for value tasks.\nsoft(value_continuous_y,E) :- task(value), channel(E,y), continuous(E), enc_interesting(E).\n\n% @constraint Continuous color for value tasks.\nsoft(value_continuous_color,E) :- task(value), channel(E,color), continuous(E), enc_interesting(E).\n\n% @constraint Continuous size for value tasks.\nsoft(value_continuous_size,E) :- task(value), channel(E,size), continuous(E), enc_interesting(E).\n\n% @constraint Continuous text for value tasks.\nsoft(value_continuous_text,E) :- task(value), channel(E,text), continuous(E), enc_interesting(E).\n\n% @constraint Discrete x for value tasks.\nsoft(value_discrete_x,E) :- task(value), channel(E,x), discrete(E), enc_interesting(E).\n\n% @constraint Discrete y for value tasks.\nsoft(value_discrete_y,E) :- task(value), channel(E,y), discrete(E), enc_interesting(E).\n\n% @constraint Discrete color for value tasks.\nsoft(value_discrete_color,E) :- task(value), channel(E,color), discrete(E), enc_interesting(E).\n\n% @constraint Discrete shape for value tasks.\nsoft(value_discrete_shape,E) :- task(value), channel(E,shape), discrete(E), enc_interesting(E).\n\n% @constraint Discrete size for value tasks.\nsoft(value_discrete_size,E) :- task(value), channel(E,size), discrete(E), enc_interesting(E).\n\n% @constraint Discrete text for value tasks.\nsoft(value_discrete_text,E) :- task(value), channel(E,text), discrete(E), enc_interesting(E).\n\n% @constraint Discrete row for value tasks.\nsoft(value_discrete_row,E) :- task(value), channel(E,row), discrete(E), enc_interesting(E).\n\n% @constraint Discrete column for value tasks.\nsoft(value_discrete_column,E) :- task(value), channel(E,column), discrete(E), enc_interesting(E).\n\n% @constraint Continuous x for summary tasks.\nsoft(summary_continuous_x,E) :- task(summary), channel(E,x), continuous(E), enc_interesting(E).\n\n% @constraint Continuous y for summary tasks.\nsoft(summary_continuous_y,E) :- task(summary), channel(E,y), continuous(E), enc_interesting(E).\n\n% @constraint Continuous color for summary tasks.\nsoft(summary_continuous_color,E) :- task(summary), channel(E,color), continuous(E), enc_interesting(E).\n\n% @constraint Continuous size for summary tasks.\nsoft(summary_continuous_size,E) :- task(summary), channel(E,size), continuous(E), enc_interesting(E).\n\n% @constraint Continuous text for summary tasks.\nsoft(summary_continuous_text,E) :- task(summary), channel(E,text), continuous(E), enc_interesting(E).\n\n% @constraint Discrete x for summary tasks.\nsoft(summary_discrete_x,E) :- task(summary), channel(E,x), discrete(E), enc_interesting(E).\n\n% @constraint Discrete y for summary tasks.\nsoft(summary_discrete_y,E) :- task(summary), channel(E,y), discrete(E), enc_interesting(E).\n\n% @constraint Discrete color for summary tasks.\nsoft(summary_discrete_color,E) :- task(summary), channel(E,color), discrete(E), enc_interesting(E).\n\n% @constraint Discrete shape for summary tasks.\nsoft(summary_discrete_shape,E) :- task(summary), channel(E,shape), discrete(E), enc_interesting(E).\n\n% @constraint Discrete size for summary tasks.\nsoft(summary_discrete_size,E) :- task(summary), channel(E,size), discrete(E), enc_interesting(E).\n\n% @constraint Discrete text for summary tasks.\nsoft(summary_discrete_text,E) :- task(summary), channel(E,text), discrete(E), enc_interesting(E).\n\n% @constraint Discrete row for summary tasks.\nsoft(summary_discrete_row,E) :- task(summary), channel(E,row), discrete(E), enc_interesting(E).\n\n% @constraint Discrete column for summary tasks.\nsoft(summary_discrete_column,E) :- task(summary), channel(E,column), discrete(E), enc_interesting(E).\n\n",s="% Weights as constants\n\n#const type_q_weight = 0.\n#const type_o_weight = 1.\n#const type_n_weight = 2.\n#const aggregate_weight = 1.\n#const bin_weight = 2.\n#const bin_high_weight = 10.\n#const bin_low_weight = 6.\n#const encoding_weight = 0.\n#const encoding_field_weight = 6.\n#const same_field_2_weight = 8.\n#const same_field_gte3_weight = 16.\n#const count_twice_weight = 50.\n#const shape_cardinality_weight = 5.\n#const number_nominal_weight = 10.\n#const string_non_nominal_weight = 2.\n#const bin_cardinality_weight = 5.\n#const quant_bin_weight = 1.\n#const agg_dim_weight = 2.\n#const only_discrete_weight = 30.\n#const multiple_non_pos_weight = 3.\n#const non_positional_pref_weight = 10.\n#const aggregate_group_by_raw_weight = 3.\n#const x_y_raw_weight = 1.\n#const log_weight = 1.\n#const zero_weight = 1.\n#const zero_size_weight = 3.\n#const zero_positional_weight = 1.\n#const zero_skew_weight = 5.\n#const includes_zero_weight = 10.\n\n#const only_x_weight = 1.\n#const orientation_binned_weight = 1.\n#const high_cardinality_ordinal_weight = 10.\n#const high_cardinality_nominal_weight = 10.\n#const high_cardinality_nominal_color_weight = 10.\n#const horizontal_scrolling_weight = 20.\n#const temporal_date_weight = 1.\n#const quantitative_numbers_weight = 2.\n#const position_entropy_weight = 2.\n#const high_cardinality_size_weight = 1.\n#const value_agg_weight = 1.\n#const facet_summary_weight = 0.\n#const x_row_weight = 1.\n#const y_row_weight = 1.\n#const x_column_weight = 1.\n#const y_column_weight = 1.\n#const color_entropy_high_weight = 0.\n#const color_entropy_low_weight = 0.\n#const size_entropy_high_weight = 0.\n#const size_entropy_low_weight = 0.\n\n#const c_d_column_weight = 5.\n#const temporal_y_weight = 1.\n#const d_d_overlap_weight = 20.\n\n#const c_c_point_weight = 0.\n#const c_c_line_weight = 20.\n#const c_c_area_weight = 20.\n#const c_c_text_weight = 2.\n#const c_c_tick_weight = 5.\n\n#const c_d_point_weight = 10.\n#const c_d_bar_weight = 20.\n#const c_d_line_weight = 20.\n#const c_d_area_weight = 20.\n#const c_d_text_weight = 50.\n#const c_d_tick_weight = 0.\n\n#const c_d_no_overlap_point_weight = 20.\n#const c_d_no_overlap_bar_weight = 0.\n#const c_d_no_overlap_line_weight = 20.\n#const c_d_no_overlap_area_weight = 20.\n#const c_d_no_overlap_text_weight = 30.\n#const c_d_no_overlap_tick_weight = 25.\n\n#const d_d_point_weight = 0.\n#const d_d_text_weight = 1.\n#const d_d_rect_weight = 0.\n\n#const continuous_x_weight = 0.\n#const continuous_y_weight = 0.\n#const continuous_color_weight = 10.\n#const continuous_size_weight = 1.\n#const continuous_text_weight = 20.\n\n#const ordered_x_weight = 1.\n#const ordered_y_weight = 0.\n#const ordered_color_weight = 8.\n#const ordered_size_weight = 10.\n#const ordered_text_weight = 32.\n#const ordered_row_weight = 10.\n#const ordered_column_weight = 10.\n\n#const nominal_x_weight = 3.\n#const nominal_y_weight = 0.\n#const nominal_color_weight = 10.\n#const nominal_shape_weight = 11.\n#const nominal_text_weight = 12.\n#const nominal_row_weight = 7.\n#const nominal_column_weight = 10.\n#const nominal_detail_weight = 20.\n\n#const interesting_x_weight = 0.\n#const interesting_y_weight = 1.\n#const interesting_color_weight = 2.\n#const interesting_size_weight = 2.\n#const interesting_shape_weight = 3.\n#const interesting_text_weight = 6.\n#const interesting_row_weight = 6.\n#const interesting_column_weight = 7.\n#const interesting_detail_weight = 20.\n\n#const aggregate_count_weight = 0.\n#const aggregate_sum_weight = 2.\n#const aggregate_mean_weight = 1.\n#const aggregate_median_weight = 3.\n#const aggregate_min_weight = 4.\n#const aggregate_max_weight = 4.\n#const aggregate_stdev_weight = 5.\n\n#const value_point_weight = 0.\n#const value_bar_weight = 0.\n#const value_line_weight = 0.\n#const value_area_weight = 0.\n#const value_text_weight = 0.\n#const value_tick_weight = 0.\n#const value_rect_weight = 0.\n#const summary_point_weight = 0.\n#const summary_bar_weight = 0.\n#const summary_line_weight = 0.\n#const summary_area_weight = 0.\n#const summary_text_weight = 0.\n#const summary_tick_weight = 0.\n#const summary_rect_weight = 0.\n\n#const value_continuous_x_weight = 0.\n#const value_continuous_y_weight = 0.\n#const value_continuous_color_weight = 0.\n#const value_continuous_size_weight = 0.\n#const value_continuous_text_weight = 0.\n#const value_discrete_x_weight = 0.\n#const value_discrete_y_weight = 0.\n#const value_discrete_color_weight = 0.\n#const value_discrete_shape_weight = 0.\n#const value_discrete_size_weight = 0.\n#const value_discrete_text_weight = 0.\n#const value_discrete_row_weight = 0.\n#const value_discrete_column_weight = 0.\n#const summary_continuous_x_weight = 0.\n#const summary_continuous_y_weight = 0.\n#const summary_continuous_color_weight = 0.\n#const summary_continuous_size_weight = 0.\n#const summary_continuous_text_weight = 0.\n#const summary_discrete_x_weight = 0.\n#const summary_discrete_y_weight = 0.\n#const summary_discrete_color_weight = 0.\n#const summary_discrete_shape_weight = 0.\n#const summary_discrete_size_weight = 0.\n#const summary_discrete_text_weight = 0.\n#const summary_discrete_row_weight = 0.\n#const summary_discrete_column_weight = 0.\n\n#const stack_zero_weight = 0.\n#const stack_normalize_weight = 1.\n\n";var c=Object.freeze({TOPK_LUA:'#script(lua)\n\nfunction main(prg)\n    local count = tonumber(prg.configuration.solve.models)\n    local backend = prg:backend()\n\n    local observer = {\n        minimize_literals = {}\n    }\n    function observer:minimize (priority, literals)\n        self.minimize_literals = literals\n    end\n\n    prg:register_observer(observer)\n\n    prg:ground({{"base", {}}}, self)\n\n    while count > 0 do\n        local cost = 0\n\n        prg.configuration.solve.models = count\n        local it = prg:solve{yield=true}\n        local ret, err = pcall(function()\n            if it:get().unsatisfiable then\n                count = 0\n                return\n            end\n\n            for m in it:iter() do\n                if m.optimality_proven then\n                    cost = m.cost[1]\n                    count = count-1\n                end\n            end\n        end)\n        it:close()\n        if not ret then\n            error(err)\n        end\n\n        if count > 0 then\n            local aux = backend:add_atom()\n            backend:add_weight_rule{{aux}, cost+1, observer.minimize_literals}\n            backend:add_rule{{aux}, {-aux}}\n        end\n    end\nend\n#end.\n\n',DEFINE:"% ====== Definitions ======\n\n% Types of marks to encode data.\nmarktype(point;bar;line;area;text;tick;rect).\n% High level data types: quantitative, ordinal, nominal, temporal.\ntype(quantitative;ordinal;nominal;temporal).\n% Basic types of the data.\nprimitive_type(string;number;boolean;datetime).\n% Supported aggregation functions.\naggregate_op(count;mean;median;min;max;stdev;sum).\nsummative_aggregate_op(count;sum).\n% Numbers of bins that can be recommended; any natural number is allowed.\nbinning(10;25;200).\n\n% Encoding channels.\nsingle_channel(x;y;color;size;shape;text;row;column).\nmulti_channel(detail).\nchannel(C) :- single_channel(C).\nchannel(C) :- multi_channel(C).\nnon_positional(color;size;shape;text;detail).\n\n% Possible tasks.\ntasks(value;summary).\n\n% Possible stackings.\nstacking(zero;normalize).\n\n% ====== Helpers ======\n\ndiscrete(E) :- type(E,(nominal;ordinal)).\ndiscrete(E) :- bin(E,_).\ncontinuous(E) :- encoding(E), not discrete(E).\n\nchannel_discrete(C) :- discrete(E), channel(E,C).\nchannel_continuous(C) :- continuous(E), channel(E,C).\n\nordered(E) :- type(E,(ordinal;quantitative)).\n\n% Fields\nfield(F) :- fieldtype(F,_).\n\n% Stacking is applied to the continuous x or y.\nstack(EC,S) :- channel(EC,(x;y)), channel(ED,(x;y)), continuous(EC), discrete(ED), stack(S).\n% X and y are continuous.\nstack(E,S) :- channel_continuous(x), channel(E,y), continuous(E), stack(S).\n\nstack(S) :- stack(_,S).\n\n% Data properties\nenc_cardinality(E,C) :- field(E,F), cardinality(F,C).\nenc_entropy(E,EN) :- field(E,F), entropy(F,EN).\nenc_interesting(E) :- field(E,F), interesting(F).\nenc_extent(E,MIN,MAX) :- field(E,F), extent(F,MIN,MAX).\n\n% Cardinality of discrete field. A binned field has the cadinality of its field.\ndiscrete_cardinality(E,CE) :- discrete(E), enc_cardinality(E,CE), channel(E,C), not bin(E,_).\ndiscrete_cardinality(E,CB) :- channel(E,C), bin(E,CB).\n\n% Define a fake soft/2 for all soft/1.\nsoft(F,_placeholder) :- soft(F).\n\n% Silence warnings about properties never appearing in head.\nentropy(0,0) :- #false.\ninteresting(0) :- #false.\nextent(0,0,0) :- #false.\nsoft(0) :- #false.\ntask(value) :- #false.\ntask(summary) :- #false.\ndata(0) :- #false.\n\n% == Chart Types ==\n\n% Continuous by continuous.\nis_c_c :- channel_continuous(x), channel_continuous(y).\n\n% Continuous by discrete (or continuous only).\nis_c_d :- channel_continuous(x), not channel_continuous(y).\nis_c_d :- channel_continuous(y), not channel_continuous(x).\n\n% Discrete by discrete.\nis_d_d :- channel_discrete(x), channel_discrete(y).\n\n% == Overlap ==\n\n% The continuous variable is a measure (it is aggregated) and all other channels are .aggregated, or we use stack -> no overlap\nnon_pos_unaggregated :- channel(E,C), non_positional(C), not aggregate(E,_).\nno_overlap :- is_c_d, continuous(E), channel(E,(x;y)), aggregate(E,_), not non_pos_unaggregated.\nno_overlap :- is_c_d, stack(_).\n\n% the size of the discrete positional encoding\ndiscrete_size(S) :- is_c_d, x_y_cardinality(_,S).\ndiscrete_size(1) :- is_c_d, channel_continuous(x), not channel(_,y).\ndiscrete_size(1) :- is_c_d, channel_continuous(y), not channel(_,x).\n\n% Data size is as small as discrete dimension -> no overlap.\nno_overlap :- is_c_d, num_rows(S), discrete_size(S).\n\n% We definitely overlap if the data size > discrete size.\noverlap :- is_c_d, not no_overlap, num_rows(S1), discrete_size(S2), S1 > S2.\n\n% helpers to go from quadratic to linear number of grounding\nx_y_cardinality(x,S) :- channel(E,x), discrete_cardinality(E,S).\nx_y_cardinality(y,S) :- channel(E,y), discrete_cardinality(E,S).\n\n% No overlap if all other dimensions are aggregated.\ndiscrete_size(S) :- is_d_d, x_y_cardinality(x,SX), x_y_cardinality(y,SY), S = SX*SY.\nno_overlap :- is_d_d, not non_pos_unaggregated.\nno_overlap :- is_d_d, num_rows(S1), discrete_size(S2), S1 <= S2.  % This cannot guarantee no overlap.\n\n% We can guarantee overlap using this rule unless we are using row / column.\nrow_col :- channel(_,(row;column)).\noverlap :- is_d_d, channel(E,C), not row_col, not no_overlap, num_rows(S1), discrete_size(S2), S1 > S2.\n\n% == Orientation ==\n\n% Orientation tells us which one is the dependent and independent variable.\n\norientation(vertical) :- mark(bar;tick;area;line), channel_discrete(x).\norientation(vertical) :- mark(area;line), channel_continuous(x), channel_continuous(y).\n\norientation(horizontal) :- mark(bar;tick;area;line), channel_discrete(y).\n\n",GENERATE:"% ====== Generators ======\n\n% encodings\n\n% maximum number for each multi channel encoding\n#const max_extra_encs = 5.\n\nobj_id(1..max_extra_encs).\n\n{ encoding(E): obj_id(E) }.\n\n:- not encoding(ID), encoding(ID-1), obj_id(ID), obj_id(ID-1).\n\n% properties of encodings\n\n% channel and type have to be present\n{ channel(E,C): channel(C) } = 1 :- encoding(E).\n{ type(E,T): type(T) } = 1 :- encoding(E).\n\n% other properties that are not required\n0 { field(E,F): field(F) } 1 :- encoding(E).\n0 { aggregate(E,A): aggregate_op(A) } 1 :- encoding(E).\n0 { bin(E,B): binning(B) } 1 :- encoding(E).\n0 { zero(E) } 1 :- encoding(E).\n0 { log(E) } 1 :- encoding(E).\n\n% pick one mark type\n\n{ mark(M) : marktype(M) } = 1.\n\n% stacking\n\n0 { stack(S): stacking(S) } 1.\n\n",HARD:i,HARD_INTEGRITY:":- hard(_).\n:- hard(_,_).\n:- hard(_,_,_).\n\n",SOFT:a,WEIGHTS:s,ASSIGN_WEIGHTS:"%% GENERATED FILE. DO NOT EDIT.\n\nsoft_weight(type_q,type_q_weight).\nsoft_weight(type_o,type_o_weight).\nsoft_weight(type_n,type_n_weight).\nsoft_weight(aggregate,aggregate_weight).\nsoft_weight(bin,bin_weight).\nsoft_weight(bin_high,bin_high_weight).\nsoft_weight(bin_low,bin_low_weight).\nsoft_weight(encoding,encoding_weight).\nsoft_weight(encoding_field,encoding_field_weight).\nsoft_weight(same_field_2,same_field_2_weight).\nsoft_weight(same_field_gte3,same_field_gte3_weight).\nsoft_weight(count_twice,count_twice_weight).\nsoft_weight(shape_cardinality,shape_cardinality_weight).\nsoft_weight(number_nominal,number_nominal_weight).\nsoft_weight(string_non_nominal,string_non_nominal_weight).\nsoft_weight(bin_cardinality,bin_cardinality_weight).\nsoft_weight(quant_bin,quant_bin_weight).\nsoft_weight(agg_dim,agg_dim_weight).\nsoft_weight(only_discrete,only_discrete_weight).\nsoft_weight(multiple_non_pos,multiple_non_pos_weight).\nsoft_weight(non_positional_pref,non_positional_pref_weight).\nsoft_weight(aggregate_group_by_raw,aggregate_group_by_raw_weight).\nsoft_weight(x_y_raw,x_y_raw_weight).\nsoft_weight(log,log_weight).\nsoft_weight(zero,zero_weight).\nsoft_weight(zero_size,zero_size_weight).\nsoft_weight(zero_positional,zero_positional_weight).\nsoft_weight(zero_skew,zero_skew_weight).\nsoft_weight(includes_zero,includes_zero_weight).\nsoft_weight(only_x,only_x_weight).\nsoft_weight(orientation_binned,orientation_binned_weight).\nsoft_weight(high_cardinality_ordinal,high_cardinality_ordinal_weight).\nsoft_weight(high_cardinality_nominal,high_cardinality_nominal_weight).\nsoft_weight(high_cardinality_nominal_color,high_cardinality_nominal_color_weight).\nsoft_weight(horizontal_scrolling,horizontal_scrolling_weight).\nsoft_weight(temporal_date,temporal_date_weight).\nsoft_weight(quantitative_numbers,quantitative_numbers_weight).\nsoft_weight(position_entropy,position_entropy_weight).\nsoft_weight(high_cardinality_size,high_cardinality_size_weight).\nsoft_weight(value_agg,value_agg_weight).\nsoft_weight(facet_summary,facet_summary_weight).\nsoft_weight(x_row,x_row_weight).\nsoft_weight(y_row,y_row_weight).\nsoft_weight(x_column,x_column_weight).\nsoft_weight(y_column,y_column_weight).\nsoft_weight(color_entropy_high,color_entropy_high_weight).\nsoft_weight(color_entropy_low,color_entropy_low_weight).\nsoft_weight(size_entropy_high,size_entropy_high_weight).\nsoft_weight(size_entropy_low,size_entropy_low_weight).\nsoft_weight(c_d_column,c_d_column_weight).\nsoft_weight(temporal_y,temporal_y_weight).\nsoft_weight(d_d_overlap,d_d_overlap_weight).\nsoft_weight(c_c_point,c_c_point_weight).\nsoft_weight(c_c_line,c_c_line_weight).\nsoft_weight(c_c_area,c_c_area_weight).\nsoft_weight(c_c_text,c_c_text_weight).\nsoft_weight(c_c_tick,c_c_tick_weight).\nsoft_weight(c_d_point,c_d_point_weight).\nsoft_weight(c_d_bar,c_d_bar_weight).\nsoft_weight(c_d_line,c_d_line_weight).\nsoft_weight(c_d_area,c_d_area_weight).\nsoft_weight(c_d_text,c_d_text_weight).\nsoft_weight(c_d_tick,c_d_tick_weight).\nsoft_weight(c_d_no_overlap_point,c_d_no_overlap_point_weight).\nsoft_weight(c_d_no_overlap_bar,c_d_no_overlap_bar_weight).\nsoft_weight(c_d_no_overlap_line,c_d_no_overlap_line_weight).\nsoft_weight(c_d_no_overlap_area,c_d_no_overlap_area_weight).\nsoft_weight(c_d_no_overlap_text,c_d_no_overlap_text_weight).\nsoft_weight(c_d_no_overlap_tick,c_d_no_overlap_tick_weight).\nsoft_weight(d_d_point,d_d_point_weight).\nsoft_weight(d_d_text,d_d_text_weight).\nsoft_weight(d_d_rect,d_d_rect_weight).\nsoft_weight(continuous_x,continuous_x_weight).\nsoft_weight(continuous_y,continuous_y_weight).\nsoft_weight(continuous_color,continuous_color_weight).\nsoft_weight(continuous_size,continuous_size_weight).\nsoft_weight(continuous_text,continuous_text_weight).\nsoft_weight(ordered_x,ordered_x_weight).\nsoft_weight(ordered_y,ordered_y_weight).\nsoft_weight(ordered_color,ordered_color_weight).\nsoft_weight(ordered_size,ordered_size_weight).\nsoft_weight(ordered_text,ordered_text_weight).\nsoft_weight(ordered_row,ordered_row_weight).\nsoft_weight(ordered_column,ordered_column_weight).\nsoft_weight(nominal_x,nominal_x_weight).\nsoft_weight(nominal_y,nominal_y_weight).\nsoft_weight(nominal_color,nominal_color_weight).\nsoft_weight(nominal_shape,nominal_shape_weight).\nsoft_weight(nominal_text,nominal_text_weight).\nsoft_weight(nominal_row,nominal_row_weight).\nsoft_weight(nominal_column,nominal_column_weight).\nsoft_weight(nominal_detail,nominal_detail_weight).\nsoft_weight(interesting_x,interesting_x_weight).\nsoft_weight(interesting_y,interesting_y_weight).\nsoft_weight(interesting_color,interesting_color_weight).\nsoft_weight(interesting_size,interesting_size_weight).\nsoft_weight(interesting_shape,interesting_shape_weight).\nsoft_weight(interesting_text,interesting_text_weight).\nsoft_weight(interesting_row,interesting_row_weight).\nsoft_weight(interesting_column,interesting_column_weight).\nsoft_weight(interesting_detail,interesting_detail_weight).\nsoft_weight(aggregate_count,aggregate_count_weight).\nsoft_weight(aggregate_sum,aggregate_sum_weight).\nsoft_weight(aggregate_mean,aggregate_mean_weight).\nsoft_weight(aggregate_median,aggregate_median_weight).\nsoft_weight(aggregate_min,aggregate_min_weight).\nsoft_weight(aggregate_max,aggregate_max_weight).\nsoft_weight(aggregate_stdev,aggregate_stdev_weight).\nsoft_weight(value_point,value_point_weight).\nsoft_weight(value_bar,value_bar_weight).\nsoft_weight(value_line,value_line_weight).\nsoft_weight(value_area,value_area_weight).\nsoft_weight(value_text,value_text_weight).\nsoft_weight(value_tick,value_tick_weight).\nsoft_weight(value_rect,value_rect_weight).\nsoft_weight(summary_point,summary_point_weight).\nsoft_weight(summary_bar,summary_bar_weight).\nsoft_weight(summary_line,summary_line_weight).\nsoft_weight(summary_area,summary_area_weight).\nsoft_weight(summary_text,summary_text_weight).\nsoft_weight(summary_tick,summary_tick_weight).\nsoft_weight(summary_rect,summary_rect_weight).\nsoft_weight(value_continuous_x,value_continuous_x_weight).\nsoft_weight(value_continuous_y,value_continuous_y_weight).\nsoft_weight(value_continuous_color,value_continuous_color_weight).\nsoft_weight(value_continuous_size,value_continuous_size_weight).\nsoft_weight(value_continuous_text,value_continuous_text_weight).\nsoft_weight(value_discrete_x,value_discrete_x_weight).\nsoft_weight(value_discrete_y,value_discrete_y_weight).\nsoft_weight(value_discrete_color,value_discrete_color_weight).\nsoft_weight(value_discrete_shape,value_discrete_shape_weight).\nsoft_weight(value_discrete_size,value_discrete_size_weight).\nsoft_weight(value_discrete_text,value_discrete_text_weight).\nsoft_weight(value_discrete_row,value_discrete_row_weight).\nsoft_weight(value_discrete_column,value_discrete_column_weight).\nsoft_weight(summary_continuous_x,summary_continuous_x_weight).\nsoft_weight(summary_continuous_y,summary_continuous_y_weight).\nsoft_weight(summary_continuous_color,summary_continuous_color_weight).\nsoft_weight(summary_continuous_size,summary_continuous_size_weight).\nsoft_weight(summary_continuous_text,summary_continuous_text_weight).\nsoft_weight(summary_discrete_x,summary_discrete_x_weight).\nsoft_weight(summary_discrete_y,summary_discrete_y_weight).\nsoft_weight(summary_discrete_color,summary_discrete_color_weight).\nsoft_weight(summary_discrete_shape,summary_discrete_shape_weight).\nsoft_weight(summary_discrete_size,summary_discrete_size_weight).\nsoft_weight(summary_discrete_text,summary_discrete_text_weight).\nsoft_weight(summary_discrete_row,summary_discrete_row_weight).\nsoft_weight(summary_discrete_column,summary_discrete_column_weight).\nsoft_weight(stack_zero,stack_zero_weight).\nsoft_weight(stack_normalize,stack_normalize_weight).\n\n",OPTIMIZE:"% Minimize the feature weight\n\n#minimize { W,F,Q: soft_weight(F,W), soft(F,Q); #inf,F,Q: soft(F,Q), not soft_weight(F,_); #inf,F: hard(F); #inf,F,Q: hard(F,Q); #inf,F,Q1,Q2: hard(F,Q1,Q2) }.\n\n",OUTPUT:"% ====== Output ======\n\n#show data/1.\n\n#show mark/1.\n\n#show type/2.\n#show channel/2.\n#show field/2.\n#show aggregate/2.\n#show bin/2.\n#show stack/2.\n\n#show log/1.\n#show zero/1.\n\n#show soft/2.\n\n"});function u(n,t){const e=n.match(d);if(!e)throw Error("invalid constraints");const r=e.map((n=>({...l(n),...f(n)})));if(t){const n=t.match(y),e=function(n){const t={};for(const e of n){const n=w.exec(e);if(!n)throw Error(`invalid weight: ${e}`);const r=n[1],o=v.exec(e);if(!o)throw Error(`invalid weight: ${e}`);const i=+o[1];t[r]=i}return t}(n);if(!n)throw Error("invalid weights");for(const n of r){const t=n.name;n.weight=e[t]}}return r}function l(n){const t=n.match(_);if(t){const n=t[0],e=h.exec(n);if(e)return{description:e[1]}}return null}function f(n){const t=n.match(m);if(t){const n=t.join("\n"),e=g.exec(n);if(!e)throw Error(`invalid asp: ${n}`);const r=e[1],o=p.exec(n);if(!o)throw Error(`invalid asp: ${n}`);return{type:r,name:o[1],asp:n}}return null}const d=/%\s*@constraint(?:(.+)\n)+/g,_=/(%.*\n)+/g,h=/@constraint\s+(.*)/,m=/^[^%].*/gm,g=/(\w+)\(/,p=/\((\w+),?.*?\)/,y=/#const.*/g,w=/#const\s+(\w+?)_weight/,v=/=\s*(\d+)/;function E(n){return"?"!==n?n:null}function b(n,t){return n(t={exports:{}},t.exports),t.exports}"undefined"!=typeof window?window:void 0!==e.g?e.g:"undefined"!=typeof self&&self;var k=b((function(n){var t=n.exports,e="__name__";t.namedfunc=function(n,t){return t[e]=n,t},t.name=function(n){return null==n?null:n[e]},t.identity=function(n){return n},t.true=t.namedfunc("true",(function(){return!0})),t.false=t.namedfunc("false",(function(){return!1})),t.duplicate=function(n){return JSON.parse(JSON.stringify(n))},t.equal=function(n,t){return JSON.stringify(n)===JSON.stringify(t)},t.extend=function(n){for(var t,e,r=1,o=arguments.length;r<o;++r)for(e in t=arguments[r])n[e]=t[e];return n},t.length=function(n){return null!=n&&null!=n.length?n.length:null},t.keys=function(n){var t,e=[];for(t in n)e.push(t);return e},t.vals=function(n){var t,e=[];for(t in n)e.push(n[t]);return e},t.toMap=function(n,e){return(e=t.$(e))?n.reduce((function(n,t){return n[e(t)]=1,n}),{}):n.reduce((function(n,t){return n[t]=1,n}),{})},t.keystr=function(n){var t=n.length;if(!t)return"";for(var e=String(n[0]),r=1;r<t;++r)e+="|"+String(n[r]);return e};var r=Object.prototype.toString;t.isObject=function(n){return n===Object(n)},t.isFunction=function(n){return"[object Function]"===r.call(n)},t.isString=function(n){return"string"==typeof value||"[object String]"===r.call(n)},t.isArray=Array.isArray||function(n){return"[object Array]"===r.call(n)},t.isNumber=function(n){return"number"==typeof n||"[object Number]"===r.call(n)},t.isBoolean=function(n){return!0===n||!1===n||"[object Boolean]"==r.call(n)},t.isDate=function(n){return"[object Date]"===r.call(n)},t.isValid=function(n){return null!=n&&n==n},t.isBuffer="function"==typeof Buffer&&Buffer.isBuffer||t.false,t.number=function(n){return null==n||""===n?null:+n},t.boolean=function(n){return null==n||""===n?null:"false"!==n&&!!n},t.date=function(n,t){var e=t||Date;return null==n||""===n?null:e.parse(n)},t.array=function(n){return null!=n?t.isArray(n)?n:[n]:[]},t.str=function(n){return t.isArray(n)?"["+n.map(t.str)+"]":t.isObject(n)||t.isString(n)?JSON.stringify(n).replace("\u2028","\\u2028").replace("\u2029","\\u2029"):n};var o=/\[(.*?)\]|[^.\[]+/g;function i(n,t){var e,r="";for(e=0;e<n;++e)r+=t;return r}function a(n,t,e){var r=0,o=n.split(s);return(n=e?(o=o.reverse()).filter((function(n){return(r+=n.length)<=t})).reverse():o.filter((function(n){return(r+=n.length)<=t}))).length?n.join("").trim():o[0].slice(0,t)}t.field=function(n){return String(n).match(o).map((function(n){return"["!==n[0]?n:"'"!==n[1]&&'"'!==n[1]?n.slice(1,-1):n.slice(2,-2).replace(/\\(["'])/g,"$1")}))},t.accessor=function(n){return null==n||t.isFunction(n)?n:t.namedfunc(n,Function("x","return x["+t.field(n).map(t.str).join("][")+"];"))},t.$=t.accessor,t.mutator=function(n){var e;return t.isString(n)&&(e=t.field(n)).length>1?function(n,t){for(var r=0;r<e.length-1;++r)n=n[e[r]];n[e[r]]=t}:function(t,e){t[n]=e}},t.$func=function(n,e){return function(r){r=t.$(r)||t.identity;var o=n+(t.name(r)?"_"+t.name(r):"");return t.namedfunc(o,(function(n){return e(r(n))}))}},t.$valid=t.$func("valid",t.isValid),t.$length=t.$func("length",t.length),t.$in=function(n,e){n=t.$(n);var r=t.isArray(e)?t.toMap(e):e;return function(t){return!!r[n(t)]}},t.comparator=function(n){var e=[];return void 0===n&&(n=[]),n=t.array(n).map((function(n){var r=1;return"-"===n[0]?(r=-1,n=n.slice(1)):"+"===n[0]&&(r=1,n=n.slice(1)),e.push(r),t.accessor(n)})),function(r,o){var i,a,s,c;for(i=0,a=n.length;i<a;++i)if(s=n[i],c=t.cmp(s(r),s(o)))return c*e[i];return 0}},t.cmp=function(n,t){return(n<t||null==n)&&null!=t?-1:(n>t||null==t)&&null!=n?1:(t=t instanceof Date?+t:t,(n=n instanceof Date?+n:n)!==n&&t==t?-1:t!=t&&n==n?1:0)},t.numcmp=function(n,t){return n-t},t.stablesort=function(n,t,e){var r=n.reduce((function(n,t,r){return n[e(t)]=r,n}),{});return n.sort((function(n,o){var i=t(n),a=t(o);return i<a?-1:i>a?1:r[e(n)]-r[e(o)]})),n},t.permute=function(n){for(var t,e,r=n.length;r;)e=Math.floor(Math.random()*r--),t=n[r],n[r]=n[e],n[e]=t},t.pad=function(n,t,e,r){r=r||" ";var o=t-n.length;if(o<=0)return n;switch(e){case"left":return i(o,r)+n;case"middle":case"center":return i(Math.floor(o/2),r)+n+i(Math.ceil(o/2),r);default:return n+i(o,r)}},t.truncate=function(n,t,e,r,o){var i=n.length;if(i<=t)return n;o=void 0!==o?String(o):"…";var s=Math.max(0,t-o.length);switch(e){case"left":return o+(r?a(n,s,1):n.slice(i-s));case"middle":case"center":var c=Math.ceil(s/2),u=Math.floor(s/2);return(r?a(n,c):n.slice(0,c))+o+(r?a(n,u,1):n.slice(i-u));default:return(r?a(n,s):n.slice(0,s))+o}};var s=/([\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u2028\u2029\u3000\uFEFF])/})),x="__types__",M={boolean:k.boolean,integer:k.number,number:k.number,date:k.date,string:function(n){return null==n||""===n?null:n+""}},S={boolean:function(n){return"true"===n||"false"===n||k.isBoolean(n)},integer:function(n){return S.number(n)&&(n=+n)==~~n},number:function(n){return!isNaN(+n)&&!k.isDate(n)},date:function(n){return!isNaN(Date.parse(n))}};function D(n){return k.keys(n)}function T(n){return"["+n+"]"}function C(n,t){var e,r,o;if(n=k.array(n),t=k.$(t),n[x]&&(e=t(n[x]),k.isString(e)))return e;for(r=0,o=n.length;!k.isValid(e)&&r<o;++r)e=t?t(n[r]):n[r];return k.isDate(e)?"date":k.isNumber(e)?"number":k.isBoolean(e)?"boolean":k.isString(e)?"string":null}function A(n,t,e){var r,o,i;n=k.array(n),t=k.$(t);var a=["boolean","integer","number","date"];for(r=0;r<n.length;++r){for(i=t?t(n[r]):n[r],o=0;o<a.length;++o)e&&e.test(i)||!k.isValid(i)||S[a[o]](i)||(a.splice(o,1),o-=1);if(0===a.length)return"string"}return a[0]}C.annotation=function(n,t){if(!t)return n&&n[x]||null;n[x]=t},C.all=function(n,t){if(n.length){var e=t?k.identity:(t=D(n[0]),T);return t.reduce((function(t,r){return t[r]=C(n,e(r)),t}),{})}},C.infer=A,C.inferAll=function(n,t,e){var r=t?k.identity:(t=D(n[0]),T);return t.reduce((function(t,o){return t[o]=A(n,r(o),e),t}),{})},C.parsers=M;var N=C,O=b((function(n,t){!function(n){function t(n){return new i(n)}function e(n){return new Function("d","return {"+n.map((function(n,t){return JSON.stringify(n)+": d["+t+"]"})).join(",")+"}")}function r(n,t){var r=e(n);return function(e,o){return t(r(e),o,n)}}function o(n){var t=Object.create(null),e=[];return n.forEach((function(n){for(var r in n)r in t||e.push(t[r]=r)})),e}function i(n){var t=new RegExp('["'+n+"\n]"),i=n.charCodeAt(0);function a(t){return t.map(s).join(n)}function s(n){return t.test(n)?'"'+n.replace(/\"/g,'""')+'"':n}this.parse=function(n,t){var o,i,a=this.parseRows(n,(function(n,a){if(o)return o(n,a-1);i=n,o=t?r(n,t):e(n)}));return a.columns=i,a},this.parseRows=function(n,t){var e,r,o={},a={},s=[],c=n.length,u=0,l=0;function f(){if(u>=c)return a;if(r)return r=!1,o;var t,e=u;if(34===n.charCodeAt(e)){for(var s=e;s++<c;)if(34===n.charCodeAt(s)){if(34!==n.charCodeAt(s+1))break;++s}return u=s+2,13===(t=n.charCodeAt(s+1))?(r=!0,10===n.charCodeAt(s+2)&&++u):10===t&&(r=!0),n.slice(e+1,s).replace(/""/g,'"')}for(;u<c;){var l=1;if(10===(t=n.charCodeAt(u++)))r=!0;else if(13===t)r=!0,10===n.charCodeAt(u)&&(++u,++l);else if(t!==i)continue;return n.slice(e,u-l)}return n.slice(e)}for(;(e=f())!==a;){for(var d=[];e!==o&&e!==a;)d.push(e),e=f();t&&null==(d=t(d,l++))||s.push(d)}return s},this.format=function(t,e){return null==e&&(e=o(t)),[e.map(s).join(n)].concat(t.map((function(t){return e.map((function(n){return s(t[n])})).join(n)}))).join("\n")},this.formatRows=function(n){return n.map(a).join("\n")}}t.prototype=i.prototype;var a=t(","),s=t("\t"),c="0.1.14";n.version=c,n.dsv=t,n.csv=a,n.tsv=s}(t)}));function F(n,t){if(n){var e=t.header;n=(e?e.join(t.delimiter)+"\n":"")+n}return O.dsv(t.delimiter).parse(n)}F.delimiter=function(n){var t={delimiter:n};return function(n,e){return F(n,e?k.extend(e,t):t)}};var z=F,j=function(n,t){var e=k.isObject(n)&&!k.isBuffer(n)?n:JSON.parse(n);return t&&t.property&&(e=k.accessor(t.property)(e)),e};function P(n){return n}function I(n){if(null==n)return P;var t,e,r=n.scale[0],o=n.scale[1],i=n.translate[0],a=n.translate[1];return function(n,s){s||(t=e=0);var c=2,u=n.length,l=new Array(u);for(l[0]=(t+=n[0])*r+i,l[1]=(e+=n[1])*o+a;c<u;)l[c]=n[c],++c;return l}}function L(n){var t,e=I(n.transform),r=1/0,o=r,i=-r,a=-r;function s(n){(n=e(n))[0]<r&&(r=n[0]),n[0]>i&&(i=n[0]),n[1]<o&&(o=n[1]),n[1]>a&&(a=n[1])}function c(n){switch(n.type){case"GeometryCollection":n.geometries.forEach(c);break;case"Point":s(n.coordinates);break;case"MultiPoint":n.coordinates.forEach(s)}}for(t in n.arcs.forEach((function(n){for(var t,s=-1,c=n.length;++s<c;)(t=e(n[s],s))[0]<r&&(r=t[0]),t[0]>i&&(i=t[0]),t[1]<o&&(o=t[1]),t[1]>a&&(a=t[1])})),n.objects)c(n.objects[t]);return[r,o,i,a]}function R(n,t){var e=t.id,r=t.bbox,o=null==t.properties?{}:t.properties,i=B(n,t);return null==e&&null==r?{type:"Feature",properties:o,geometry:i}:null==r?{type:"Feature",id:e,properties:o,geometry:i}:{type:"Feature",id:e,bbox:r,properties:o,geometry:i}}function B(n,t){var e=I(n.transform),r=n.arcs;function o(n,t){t.length&&t.pop();for(var o=r[n<0?~n:n],i=0,a=o.length;i<a;++i)t.push(e(o[i],i));n<0&&function(n,t){for(var e,r=n.length,o=r-t;o<--r;)e=n[o],n[o++]=n[r],n[r]=e}(t,a)}function i(n){return e(n)}function a(n){for(var t=[],e=0,r=n.length;e<r;++e)o(n[e],t);return t.length<2&&t.push(t[0]),t}function s(n){for(var t=a(n);t.length<4;)t.push(t[0]);return t}function c(n){return n.map(s)}return function n(t){var e,r=t.type;switch(r){case"GeometryCollection":return{type:r,geometries:t.geometries.map(n)};case"Point":e=i(t.coordinates);break;case"MultiPoint":e=t.coordinates.map(i);break;case"LineString":e=a(t.arcs);break;case"MultiLineString":e=t.arcs.map(a);break;case"Polygon":e=c(t.arcs);break;case"MultiPolygon":e=t.arcs.map(c);break;default:return null}return{type:r,coordinates:e}}(t)}function Y(n,t){var e={},r={},o={},i=[],a=-1;function s(n,t){for(var r in n){var o=n[r];delete t[o.start],delete o.start,delete o.end,o.forEach((function(n){e[n<0?~n:n]=1})),i.push(o)}}return t.forEach((function(e,r){var o,i=n.arcs[e<0?~e:e];i.length<3&&!i[1][0]&&!i[1][1]&&(o=t[++a],t[a]=e,t[r]=o)})),t.forEach((function(t){var e,i,a=function(t){var e,r=n.arcs[t<0?~t:t],o=r[0];return n.transform?(e=[0,0],r.forEach((function(n){e[0]+=n[0],e[1]+=n[1]}))):e=r[r.length-1],t<0?[e,o]:[o,e]}(t),s=a[0],c=a[1];if(e=o[s])if(delete o[e.end],e.push(t),e.end=c,i=r[c]){delete r[i.start];var u=i===e?e:e.concat(i);r[u.start=e.start]=o[u.end=i.end]=u}else r[e.start]=o[e.end]=e;else if(e=r[c])if(delete r[e.start],e.unshift(t),e.start=s,i=o[s]){delete o[i.end];var l=i===e?e:i.concat(e);r[l.start=i.start]=o[l.end=e.end]=l}else r[e.start]=o[e.end]=e;else r[(e=[t]).start=s]=o[e.end=c]=e})),s(o,r),s(r,o),t.forEach((function(n){e[n<0?~n:n]||i.push([n])})),i}function U(n,t,e){var r,o,i;if(arguments.length>1)r=q(0,t,e);else for(o=0,r=new Array(i=n.arcs.length);o<i;++o)r[o]=o;return{type:"MultiLineString",arcs:Y(n,r)}}function q(n,t,e){var r,o=[],i=[];function a(n){var t=n<0?~n:n;(i[t]||(i[t]=[])).push({i:n,g:r})}function s(n){n.forEach(a)}function c(n){n.forEach(s)}return function n(t){switch(r=t,t.type){case"GeometryCollection":t.geometries.forEach(n);break;case"LineString":s(t.arcs);break;case"MultiLineString":case"Polygon":c(t.arcs);break;case"MultiPolygon":!function(n){n.forEach(c)}(t.arcs)}}(t),i.forEach(null==e?function(n){o.push(n[0].i)}:function(n){e(n[0].g,n[n.length-1].g)&&o.push(n[0].i)}),o}function $(n,t){var e={},r=[],o=[];function i(n){n.forEach((function(t){t.forEach((function(t){(e[t=t<0?~t:t]||(e[t]=[])).push(n)}))})),r.push(n)}function a(t){return function(n){for(var t,e=-1,r=n.length,o=n[r-1],i=0;++e<r;)t=o,o=n[e],i+=t[0]*o[1]-t[1]*o[0];return Math.abs(i)}(B(n,{type:"Polygon",arcs:[t]}).coordinates[0])}return t.forEach((function n(t){switch(t.type){case"GeometryCollection":t.geometries.forEach(n);break;case"Polygon":i(t.arcs);break;case"MultiPolygon":t.arcs.forEach(i)}})),r.forEach((function(n){if(!n._){var t=[],r=[n];for(n._=1,o.push(t);n=r.pop();)t.push(n),n.forEach((function(n){n.forEach((function(n){e[n<0?~n:n].forEach((function(n){n._||(n._=1,r.push(n))}))}))}))}})),r.forEach((function(n){delete n._})),{type:"MultiPolygon",arcs:o.map((function(t){var r,o=[];if(t.forEach((function(n){n.forEach((function(n){n.forEach((function(n){e[n<0?~n:n].length<2&&o.push(n)}))}))})),(r=(o=Y(n,o)).length)>1)for(var i,s,c=1,u=a(o[0]);c<r;++c)(i=a(o[c]))>u&&(s=o[0],o[0]=o[c],o[c]=s,u=i);return o}))}}function H(n,t){for(var e=0,r=n.length;e<r;){var o=e+r>>>1;n[o]<t?e=o+1:r=o}return e}function V(n){if(null==n)return P;var t,e,r=n.scale[0],o=n.scale[1],i=n.translate[0],a=n.translate[1];return function(n,s){s||(t=e=0);var c=2,u=n.length,l=new Array(u),f=Math.round((n[0]-i)/r),d=Math.round((n[1]-a)/o);for(l[0]=f-t,t=f,l[1]=d-e,e=d;c<u;)l[c]=n[c],++c;return l}}var W=Object.freeze({bbox:L,feature:function(n,t){return"GeometryCollection"===t.type?{type:"FeatureCollection",features:t.geometries.map((function(t){return R(n,t)}))}:R(n,t)},mesh:function(n){return B(n,U.apply(this,arguments))},meshArcs:U,merge:function(n){return B(n,$.apply(this,arguments))},mergeArcs:$,neighbors:function(n){var t={},e=n.map((function(){return[]}));function r(n,e){n.forEach((function(n){n<0&&(n=~n);var r=t[n];r?r.push(e):t[n]=[e]}))}function o(n,t){n.forEach((function(n){r(n,t)}))}var i={LineString:r,MultiLineString:o,Polygon:o,MultiPolygon:function(n,t){n.forEach((function(n){o(n,t)}))}};for(var a in n.forEach((function n(t,e){"GeometryCollection"===t.type?t.geometries.forEach((function(t){n(t,e)})):t.type in i&&i[t.type](t.arcs,e)})),t)for(var s=t[a],c=s.length,u=0;u<c;++u)for(var l=u+1;l<c;++l){var f,d=s[u],_=s[l];(f=e[d])[a=H(f,_)]!==_&&f.splice(a,0,_),(f=e[_])[a=H(f,d)]!==d&&f.splice(a,0,d)}return e},quantize:function(n,t){if(n.transform)throw new Error("already quantized");if(t&&t.scale)s=n.bbox;else{if(!((e=Math.floor(t))>=2))throw new Error("n must be ≥2");var e,r=(s=n.bbox||L(n))[0],o=s[1],i=s[2],a=s[3];t={scale:[i-r?(i-r)/(e-1):1,a-o?(a-o)/(e-1):1],translate:[r,o]}}var s,c,u=V(t),l=n.objects,f={};function d(n){return u(n)}function _(n){var t;switch(n.type){case"GeometryCollection":t={type:"GeometryCollection",geometries:n.geometries.map(_)};break;case"Point":t={type:"Point",coordinates:d(n.coordinates)};break;case"MultiPoint":t={type:"MultiPoint",coordinates:n.coordinates.map(d)};break;default:return n}return null!=n.id&&(t.id=n.id),null!=n.bbox&&(t.bbox=n.bbox),null!=n.properties&&(t.properties=n.properties),t}for(c in l)f[c]=_(l[c]);return{type:"Topology",bbox:s,transform:t,objects:f,arcs:n.arcs.map((function(n){var t,e=0,r=1,o=n.length,i=new Array(o);for(i[0]=u(n[0],0);++e<o;)((t=u(n[e],e))[0]||t[1])&&(i[r++]=t);return 1===r&&(i[r++]=[0,0]),i.length=r,i}))}},transform:I,untransform:V}),G=function(n,t){var e=G.topojson;if(null==e)throw Error("TopoJSON library not loaded.");var r,o=j(n,t);if(t&&t.feature){if(r=o.objects[t.feature])return e.feature(o,r).features;throw Error("Invalid TopoJSON object: "+t.feature)}if(t&&t.mesh){if(r=o.objects[t.mesh])return[e.mesh(o,o.objects[t.mesh])];throw Error("Invalid TopoJSON object: "+t.mesh)}throw Error("Missing TopoJSON feature or mesh parameter.")};G.topojson=W;var X={json:j,topojson:G,treejson:function(n,t){return function(n,t){var e=t&&t.children||"children",r=t&&t.parent||"parent",o=[];function i(n,t){n[r]=t,o.push(n);var a=n[e];if(a)for(var s=0;s<a.length;++s)i(a[s],n)}return i(n,null),o.root=n,o}(j(n,t),t)},dsv:z,csv:z.delimiter(","),tsv:z.delimiter("\t")},J=b((function(n,t){!function(n){var t=new Date,e=new Date;function r(n,o,i,a){function s(t){return n(t=new Date(+t)),t}return s.floor=s,s.round=function(t){var e=new Date(+t),r=new Date(t-1);return n(e),n(r),o(r,1),t-e<r-t?e:r},s.ceil=function(t){return n(t=new Date(t-1)),o(t,1),t},s.offset=function(n,t){return o(n=new Date(+n),null==t?1:Math.floor(t)),n},s.range=function(t,e,r){var i=[];if(t=new Date(t-1),e=new Date(+e),r=null==r?1:Math.floor(r),!(t<e&&r>0))return i;for(o(t,1),n(t),t<e&&i.push(new Date(+t));o(t,r),n(t),t<e;)i.push(new Date(+t));return i},s.filter=function(t){return r((function(e){for(;n(e),!t(e);)e.setTime(e-1)}),(function(n,e){for(;--e>=0;)for(;o(n,1),!t(n););}))},i&&(s.count=function(r,o){return t.setTime(+r),e.setTime(+o),n(t),n(e),Math.floor(i(t,e))},s.every=function(n){return n=Math.floor(n),isFinite(n)&&n>0?n>1?s.filter(a?function(t){return a(t)%n==0}:function(t){return s.count(0,t)%n==0}):s:null}),s}var o=r((function(){}),(function(n,t){n.setTime(+n+t)}),(function(n,t){return t-n}));o.every=function(n){return n=Math.floor(n),isFinite(n)&&n>0?n>1?r((function(t){t.setTime(Math.floor(t/n)*n)}),(function(t,e){t.setTime(+t+e*n)}),(function(t,e){return(e-t)/n})):o:null};var i=r((function(n){n.setMilliseconds(0)}),(function(n,t){n.setTime(+n+1e3*t)}),(function(n,t){return(t-n)/1e3}),(function(n){return n.getSeconds()})),a=r((function(n){n.setSeconds(0,0)}),(function(n,t){n.setTime(+n+6e4*t)}),(function(n,t){return(t-n)/6e4}),(function(n){return n.getMinutes()})),s=r((function(n){n.setMinutes(0,0,0)}),(function(n,t){n.setTime(+n+36e5*t)}),(function(n,t){return(t-n)/36e5}),(function(n){return n.getHours()})),c=r((function(n){n.setHours(0,0,0,0)}),(function(n,t){n.setDate(n.getDate()+t)}),(function(n,t){return(t-n-6e4*(t.getTimezoneOffset()-n.getTimezoneOffset()))/864e5}),(function(n){return n.getDate()-1}));function u(n){return r((function(t){t.setHours(0,0,0,0),t.setDate(t.getDate()-(t.getDay()+7-n)%7)}),(function(n,t){n.setDate(n.getDate()+7*t)}),(function(n,t){return(t-n-6e4*(t.getTimezoneOffset()-n.getTimezoneOffset()))/6048e5}))}var l=u(0),f=u(1),d=u(2),_=u(3),h=u(4),m=u(5),g=u(6),p=r((function(n){n.setHours(0,0,0,0),n.setDate(1)}),(function(n,t){n.setMonth(n.getMonth()+t)}),(function(n,t){return t.getMonth()-n.getMonth()+12*(t.getFullYear()-n.getFullYear())}),(function(n){return n.getMonth()})),y=r((function(n){n.setHours(0,0,0,0),n.setMonth(0,1)}),(function(n,t){n.setFullYear(n.getFullYear()+t)}),(function(n,t){return t.getFullYear()-n.getFullYear()}),(function(n){return n.getFullYear()})),w=r((function(n){n.setUTCMilliseconds(0)}),(function(n,t){n.setTime(+n+1e3*t)}),(function(n,t){return(t-n)/1e3}),(function(n){return n.getUTCSeconds()})),v=r((function(n){n.setUTCSeconds(0,0)}),(function(n,t){n.setTime(+n+6e4*t)}),(function(n,t){return(t-n)/6e4}),(function(n){return n.getUTCMinutes()})),E=r((function(n){n.setUTCMinutes(0,0,0)}),(function(n,t){n.setTime(+n+36e5*t)}),(function(n,t){return(t-n)/36e5}),(function(n){return n.getUTCHours()})),b=r((function(n){n.setUTCHours(0,0,0,0)}),(function(n,t){n.setUTCDate(n.getUTCDate()+t)}),(function(n,t){return(t-n)/864e5}),(function(n){return n.getUTCDate()-1}));function k(n){return r((function(t){t.setUTCHours(0,0,0,0),t.setUTCDate(t.getUTCDate()-(t.getUTCDay()+7-n)%7)}),(function(n,t){n.setUTCDate(n.getUTCDate()+7*t)}),(function(n,t){return(t-n)/6048e5}))}var x=k(0),M=k(1),S=k(2),D=k(3),T=k(4),C=k(5),A=k(6),N=r((function(n){n.setUTCHours(0,0,0,0),n.setUTCDate(1)}),(function(n,t){n.setUTCMonth(n.getUTCMonth()+t)}),(function(n,t){return t.getUTCMonth()-n.getUTCMonth()+12*(t.getUTCFullYear()-n.getUTCFullYear())}),(function(n){return n.getUTCMonth()})),O=r((function(n){n.setUTCHours(0,0,0,0),n.setUTCMonth(0,1)}),(function(n,t){n.setUTCFullYear(n.getUTCFullYear()+t)}),(function(n,t){return t.getUTCFullYear()-n.getUTCFullYear()}),(function(n){return n.getUTCFullYear()})),F=o.range,z=i.range,j=a.range,P=s.range,I=c.range,L=l.range,R=f.range,B=d.range,Y=_.range,U=h.range,q=m.range,$=g.range,H=l.range,V=p.range,W=y.range,G=o,X=F,J=w.range,K=v.range,Z=E.range,Q=b.range,nn=x.range,tn=M.range,en=S.range,rn=D.range,on=T.range,an=C.range,sn=A.range,cn=x.range,un=N.range,ln=O.range,fn="0.1.1";n.version=fn,n.milliseconds=F,n.seconds=z,n.minutes=j,n.hours=P,n.days=I,n.sundays=L,n.mondays=R,n.tuesdays=B,n.wednesdays=Y,n.thursdays=U,n.fridays=q,n.saturdays=$,n.weeks=H,n.months=V,n.years=W,n.utcMillisecond=G,n.utcMilliseconds=X,n.utcSeconds=J,n.utcMinutes=K,n.utcHours=Z,n.utcDays=Q,n.utcSundays=nn,n.utcMondays=tn,n.utcTuesdays=en,n.utcWednesdays=rn,n.utcThursdays=on,n.utcFridays=an,n.utcSaturdays=sn,n.utcWeeks=cn,n.utcMonths=un,n.utcYears=ln,n.millisecond=o,n.second=i,n.minute=a,n.hour=s,n.day=c,n.sunday=l,n.monday=f,n.tuesday=d,n.wednesday=_,n.thursday=h,n.friday=m,n.saturday=g,n.week=l,n.month=p,n.year=y,n.utcSecond=w,n.utcMinute=v,n.utcHour=E,n.utcDay=b,n.utcSunday=x,n.utcMonday=M,n.utcTuesday=S,n.utcWednesday=D,n.utcThursday=T,n.utcFriday=C,n.utcSaturday=A,n.utcWeek=x,n.utcMonth=N,n.utcYear=O,n.interval=r}(t)})),K=b((function(n,t){!function(n,t){function e(n){if(0<=n.y&&n.y<100){var t=new Date(-1,n.m,n.d,n.H,n.M,n.S,n.L);return t.setFullYear(n.y),t}return new Date(n.y,n.m,n.d,n.H,n.M,n.S,n.L)}function r(n){if(0<=n.y&&n.y<100){var t=new Date(Date.UTC(-1,n.m,n.d,n.H,n.M,n.S,n.L));return t.setUTCFullYear(n.y),t}return new Date(Date.UTC(n.y,n.m,n.d,n.H,n.M,n.S,n.L))}function o(n){return{y:n,m:0,d:1,H:0,M:0,S:0,L:0}}function i(n){var t=n.dateTime,i=n.date,s=n.time,c=n.periods,u=n.days,l=n.shortDays,f=n.months,rn=n.shortMonths,on=d(c),an=_(c),sn=d(u),cn=_(u),un=d(l),ln=_(l),fn=d(f),dn=_(f),_n=d(rn),hn=_(rn),mn={a:Cn,A:An,b:Nn,B:On,c:null,d:T,e:T,H:C,I:A,j:N,L:O,m:F,M:z,p:Fn,S:j,U:P,w:I,W:L,x:null,X:null,y:R,Y:B,Z:Y,"%":en},gn={a:zn,A:jn,b:Pn,B:In,c:null,d:U,e:U,H:q,I:$,j:H,L:V,m:W,M:G,p:Ln,S:X,U:J,w:K,W:Z,x:null,X:null,y:Q,Y:nn,Z:tn,"%":en},pn={a:bn,A:kn,b:xn,B:Mn,c:Sn,d:E,e:E,H:k,I:k,j:b,L:S,m:v,M:x,p:En,S:M,U:m,w:h,W:g,x:Dn,X:Tn,y,Y:p,Z:w,"%":D};function yn(n,t){return function(e){var r,o,i,s=[],c=-1,u=0,l=n.length;for(e instanceof Date||(e=new Date(+e));++c<l;)37===n.charCodeAt(c)&&(s.push(n.slice(u,c)),null!=(o=a[r=n.charAt(++c)])?r=n.charAt(++c):o="e"===r?" ":"0",(i=t[r])&&(r=i(e,o)),s.push(r),u=c+1);return s.push(n.slice(u,c)),s.join("")}}function wn(n,t){return function(e){var i=o(1900);if(vn(i,n,e+="",0)!=e.length)return null;if("p"in i&&(i.H=i.H%12+12*i.p),"W"in i||"U"in i){"w"in i||(i.w="W"in i?1:0);var a="Z"in i?r(o(i.y)).getUTCDay():t(o(i.y)).getDay();i.m=0,i.d="W"in i?(i.w+6)%7+7*i.W-(a+5)%7:i.w+7*i.U-(a+6)%7}return"Z"in i?(i.H+=i.Z/100|0,i.M+=i.Z%100,r(i)):t(i)}}function vn(n,t,e,r){for(var o,i,s=0,c=t.length,u=e.length;s<c;){if(r>=u)return-1;if(37===(o=t.charCodeAt(s++))){if(o=t.charAt(s++),!(i=pn[o in a?t.charAt(s++):o])||(r=i(n,e,r))<0)return-1}else if(o!=e.charCodeAt(r++))return-1}return r}function En(n,t,e){var r=on.exec(t.slice(e));return r?(n.p=an[r[0].toLowerCase()],e+r[0].length):-1}function bn(n,t,e){var r=un.exec(t.slice(e));return r?(n.w=ln[r[0].toLowerCase()],e+r[0].length):-1}function kn(n,t,e){var r=sn.exec(t.slice(e));return r?(n.w=cn[r[0].toLowerCase()],e+r[0].length):-1}function xn(n,t,e){var r=_n.exec(t.slice(e));return r?(n.m=hn[r[0].toLowerCase()],e+r[0].length):-1}function Mn(n,t,e){var r=fn.exec(t.slice(e));return r?(n.m=dn[r[0].toLowerCase()],e+r[0].length):-1}function Sn(n,e,r){return vn(n,t,e,r)}function Dn(n,t,e){return vn(n,i,t,e)}function Tn(n,t,e){return vn(n,s,t,e)}function Cn(n){return l[n.getDay()]}function An(n){return u[n.getDay()]}function Nn(n){return rn[n.getMonth()]}function On(n){return f[n.getMonth()]}function Fn(n){return c[+(n.getHours()>=12)]}function zn(n){return l[n.getUTCDay()]}function jn(n){return u[n.getUTCDay()]}function Pn(n){return rn[n.getUTCMonth()]}function In(n){return f[n.getUTCMonth()]}function Ln(n){return c[+(n.getUTCHours()>=12)]}return mn.x=yn(i,mn),mn.X=yn(s,mn),mn.c=yn(t,mn),gn.x=yn(i,gn),gn.X=yn(s,gn),gn.c=yn(t,gn),{format:function(n){var t=yn(n+="",mn);return t.parse=wn(n,e),t.toString=function(){return n},t},utcFormat:function(n){var t=yn(n+="",gn);return t.parse=wn(n,r),t.toString=function(){return n},t}}}var a={"-":"",_:" ",0:"0"},s=/^\s*\d+/,c=/^%/,u=/[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;function l(n,t,e){var r=n<0?"-":"",o=(r?-n:n)+"",i=o.length;return r+(i<e?new Array(e-i+1).join(t)+o:o)}function f(n){return n.replace(u,"\\$&")}function d(n){return new RegExp("^(?:"+n.map(f).join("|")+")","i")}function _(n){for(var t={},e=-1,r=n.length;++e<r;)t[n[e].toLowerCase()]=e;return t}function h(n,t,e){var r=s.exec(t.slice(e,e+1));return r?(n.w=+r[0],e+r[0].length):-1}function m(n,t,e){var r=s.exec(t.slice(e));return r?(n.U=+r[0],e+r[0].length):-1}function g(n,t,e){var r=s.exec(t.slice(e));return r?(n.W=+r[0],e+r[0].length):-1}function p(n,t,e){var r=s.exec(t.slice(e,e+4));return r?(n.y=+r[0],e+r[0].length):-1}function y(n,t,e){var r=s.exec(t.slice(e,e+2));return r?(n.y=+r[0]+(+r[0]>68?1900:2e3),e+r[0].length):-1}function w(n,t,e){var r=/^(Z)|([+-]\d\d)(?:\:?(\d\d))?/.exec(t.slice(e,e+6));return r?(n.Z=r[1]?0:-(r[2]+(r[3]||"00")),e+r[0].length):-1}function v(n,t,e){var r=s.exec(t.slice(e,e+2));return r?(n.m=r[0]-1,e+r[0].length):-1}function E(n,t,e){var r=s.exec(t.slice(e,e+2));return r?(n.d=+r[0],e+r[0].length):-1}function b(n,t,e){var r=s.exec(t.slice(e,e+3));return r?(n.m=0,n.d=+r[0],e+r[0].length):-1}function k(n,t,e){var r=s.exec(t.slice(e,e+2));return r?(n.H=+r[0],e+r[0].length):-1}function x(n,t,e){var r=s.exec(t.slice(e,e+2));return r?(n.M=+r[0],e+r[0].length):-1}function M(n,t,e){var r=s.exec(t.slice(e,e+2));return r?(n.S=+r[0],e+r[0].length):-1}function S(n,t,e){var r=s.exec(t.slice(e,e+3));return r?(n.L=+r[0],e+r[0].length):-1}function D(n,t,e){var r=c.exec(t.slice(e,e+1));return r?e+r[0].length:-1}function T(n,t){return l(n.getDate(),t,2)}function C(n,t){return l(n.getHours(),t,2)}function A(n,t){return l(n.getHours()%12||12,t,2)}function N(n,e){return l(1+t.day.count(t.year(n),n),e,3)}function O(n,t){return l(n.getMilliseconds(),t,3)}function F(n,t){return l(n.getMonth()+1,t,2)}function z(n,t){return l(n.getMinutes(),t,2)}function j(n,t){return l(n.getSeconds(),t,2)}function P(n,e){return l(t.sunday.count(t.year(n),n),e,2)}function I(n){return n.getDay()}function L(n,e){return l(t.monday.count(t.year(n),n),e,2)}function R(n,t){return l(n.getFullYear()%100,t,2)}function B(n,t){return l(n.getFullYear()%1e4,t,4)}function Y(n){var t=n.getTimezoneOffset();return(t>0?"-":(t*=-1,"+"))+l(t/60|0,"0",2)+l(t%60,"0",2)}function U(n,t){return l(n.getUTCDate(),t,2)}function q(n,t){return l(n.getUTCHours(),t,2)}function $(n,t){return l(n.getUTCHours()%12||12,t,2)}function H(n,e){return l(1+t.utcDay.count(t.utcYear(n),n),e,3)}function V(n,t){return l(n.getUTCMilliseconds(),t,3)}function W(n,t){return l(n.getUTCMonth()+1,t,2)}function G(n,t){return l(n.getUTCMinutes(),t,2)}function X(n,t){return l(n.getUTCSeconds(),t,2)}function J(n,e){return l(t.utcSunday.count(t.utcYear(n),n),e,2)}function K(n){return n.getUTCDay()}function Z(n,e){return l(t.utcMonday.count(t.utcYear(n),n),e,2)}function Q(n,t){return l(n.getUTCFullYear()%100,t,2)}function nn(n,t){return l(n.getUTCFullYear()%1e4,t,4)}function tn(){return"+0000"}function en(){return"%"}var rn=i({dateTime:"%a %b %e %X %Y",date:"%m/%d/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}),on=i({dateTime:"%A, %e de %B de %Y, %X",date:"%d/%m/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["diumenge","dilluns","dimarts","dimecres","dijous","divendres","dissabte"],shortDays:["dg.","dl.","dt.","dc.","dj.","dv.","ds."],months:["gener","febrer","març","abril","maig","juny","juliol","agost","setembre","octubre","novembre","desembre"],shortMonths:["gen.","febr.","març","abr.","maig","juny","jul.","ag.","set.","oct.","nov.","des."]}),an=i({dateTime:"%A, der %e. %B %Y, %X",date:"%d.%m.%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"],shortDays:["So","Mo","Di","Mi","Do","Fr","Sa"],months:["Januar","Februar","März","April","Mai","Juni","Juli","August","September","Oktober","November","Dezember"],shortMonths:["Jan","Feb","Mrz","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"]}),sn=i({dateTime:"%A, der %e. %B %Y, %X",date:"%d.%m.%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"],shortDays:["So","Mo","Di","Mi","Do","Fr","Sa"],months:["Januar","Februar","März","April","Mai","Juni","Juli","August","September","Oktober","November","Dezember"],shortMonths:["Jan","Feb","Mrz","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"]}),cn=i({dateTime:"%a %b %e %X %Y",date:"%Y-%m-%d",time:"%H:%M:%S",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}),un=i({dateTime:"%a %e %b %X %Y",date:"%d/%m/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}),ln=i({dateTime:"%A, %e de %B de %Y, %X",date:"%d/%m/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["domingo","lunes","martes","miércoles","jueves","viernes","sábado"],shortDays:["dom","lun","mar","mié","jue","vie","sáb"],months:["enero","febrero","marzo","abril","mayo","junio","julio","agosto","septiembre","octubre","noviembre","diciembre"],shortMonths:["ene","feb","mar","abr","may","jun","jul","ago","sep","oct","nov","dic"]}),fn=i({dateTime:"%A, %-d. %Bta %Y klo %X",date:"%-d.%-m.%Y",time:"%H:%M:%S",periods:["a.m.","p.m."],days:["sunnuntai","maanantai","tiistai","keskiviikko","torstai","perjantai","lauantai"],shortDays:["Su","Ma","Ti","Ke","To","Pe","La"],months:["tammikuu","helmikuu","maaliskuu","huhtikuu","toukokuu","kesäkuu","heinäkuu","elokuu","syyskuu","lokakuu","marraskuu","joulukuu"],shortMonths:["Tammi","Helmi","Maalis","Huhti","Touko","Kesä","Heinä","Elo","Syys","Loka","Marras","Joulu"]}),dn=i({dateTime:"%a %e %b %Y %X",date:"%Y-%m-%d",time:"%H:%M:%S",periods:["",""],days:["dimanche","lundi","mardi","mercredi","jeudi","vendredi","samedi"],shortDays:["dim","lun","mar","mer","jeu","ven","sam"],months:["janvier","février","mars","avril","mai","juin","juillet","août","septembre","octobre","novembre","décembre"],shortMonths:["jan","fév","mar","avr","mai","jui","jul","aoû","sep","oct","nov","déc"]}),_n=i({dateTime:"%A, le %e %B %Y, %X",date:"%d/%m/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["dimanche","lundi","mardi","mercredi","jeudi","vendredi","samedi"],shortDays:["dim.","lun.","mar.","mer.","jeu.","ven.","sam."],months:["janvier","février","mars","avril","mai","juin","juillet","août","septembre","octobre","novembre","décembre"],shortMonths:["janv.","févr.","mars","avr.","mai","juin","juil.","août","sept.","oct.","nov.","déc."]}),hn=i({dateTime:"%A, %e ב%B %Y %X",date:"%d.%m.%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["ראשון","שני","שלישי","רביעי","חמישי","שישי","שבת"],shortDays:["א׳","ב׳","ג׳","ד׳","ה׳","ו׳","ש׳"],months:["ינואר","פברואר","מרץ","אפריל","מאי","יוני","יולי","אוגוסט","ספטמבר","אוקטובר","נובמבר","דצמבר"],shortMonths:["ינו׳","פבר׳","מרץ","אפר׳","מאי","יוני","יולי","אוג׳","ספט׳","אוק׳","נוב׳","דצמ׳"]}),mn=i({dateTime:"%Y. %B %-e., %A %X",date:"%Y. %m. %d.",time:"%H:%M:%S",periods:["de.","du."],days:["vasárnap","hétfő","kedd","szerda","csütörtök","péntek","szombat"],shortDays:["V","H","K","Sze","Cs","P","Szo"],months:["január","február","március","április","május","június","július","augusztus","szeptember","október","november","december"],shortMonths:["jan.","feb.","már.","ápr.","máj.","jún.","júl.","aug.","szept.","okt.","nov.","dec."]}),gn=i({dateTime:"%A %e %B %Y, %X",date:"%d/%m/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Domenica","Lunedì","Martedì","Mercoledì","Giovedì","Venerdì","Sabato"],shortDays:["Dom","Lun","Mar","Mer","Gio","Ven","Sab"],months:["Gennaio","Febbraio","Marzo","Aprile","Maggio","Giugno","Luglio","Agosto","Settembre","Ottobre","Novembre","Dicembre"],shortMonths:["Gen","Feb","Mar","Apr","Mag","Giu","Lug","Ago","Set","Ott","Nov","Dic"]}),pn=i({dateTime:"%Y %b %e %a %X",date:"%Y/%m/%d",time:"%H:%M:%S",periods:["AM","PM"],days:["日曜日","月曜日","火曜日","水曜日","木曜日","金曜日","土曜日"],shortDays:["日","月","火","水","木","金","土"],months:["睦月","如月","弥生","卯月","皐月","水無月","文月","葉月","長月","神無月","霜月","師走"],shortMonths:["1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"]}),yn=i({dateTime:"%Y/%m/%d %a %X",date:"%Y/%m/%d",time:"%H:%M:%S",periods:["오전","오후"],days:["일요일","월요일","화요일","수요일","목요일","금요일","토요일"],shortDays:["일","월","화","수","목","금","토"],months:["1월","2월","3월","4월","5월","6월","7월","8월","9월","10월","11월","12월"],shortMonths:["1월","2월","3월","4월","5월","6월","7월","8월","9월","10월","11월","12월"]}),wn=i({dateTime:"%A, %e %B %Y г. %X",date:"%d.%m.%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["недела","понеделник","вторник","среда","четврток","петок","сабота"],shortDays:["нед","пон","вто","сре","чет","пет","саб"],months:["јануари","февруари","март","април","мај","јуни","јули","август","септември","октомври","ноември","декември"],shortMonths:["јан","фев","мар","апр","мај","јун","јул","авг","сеп","окт","ное","дек"]}),vn=i({dateTime:"%a %e %B %Y %T",date:"%d-%m-%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["zondag","maandag","dinsdag","woensdag","donderdag","vrijdag","zaterdag"],shortDays:["zo","ma","di","wo","do","vr","za"],months:["januari","februari","maart","april","mei","juni","juli","augustus","september","oktober","november","december"],shortMonths:["jan","feb","mrt","apr","mei","jun","jul","aug","sep","okt","nov","dec"]}),En=i({dateTime:"%A, %e %B %Y, %X",date:"%d/%m/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Niedziela","Poniedziałek","Wtorek","Środa","Czwartek","Piątek","Sobota"],shortDays:["Niedz.","Pon.","Wt.","Śr.","Czw.","Pt.","Sob."],months:["Styczeń","Luty","Marzec","Kwiecień","Maj","Czerwiec","Lipiec","Sierpień","Wrzesień","Październik","Listopad","Grudzień"],shortMonths:["Stycz.","Luty","Marz.","Kwie.","Maj","Czerw.","Lipc.","Sierp.","Wrz.","Paźdz.","Listop.","Grudz."]}),bn=i({dateTime:"%A, %e de %B de %Y. %X",date:"%d/%m/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Domingo","Segunda","Terça","Quarta","Quinta","Sexta","Sábado"],shortDays:["Dom","Seg","Ter","Qua","Qui","Sex","Sáb"],months:["Janeiro","Fevereiro","Março","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],shortMonths:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"]}),kn=i({dateTime:"%A, %e %B %Y г. %X",date:"%d.%m.%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["воскресенье","понедельник","вторник","среда","четверг","пятница","суббота"],shortDays:["вс","пн","вт","ср","чт","пт","сб"],months:["января","февраля","марта","апреля","мая","июня","июля","августа","сентября","октября","ноября","декабря"],shortMonths:["янв","фев","мар","апр","май","июн","июл","авг","сен","окт","ноя","дек"]}),xn=i({dateTime:"%A den %d %B %Y %X",date:"%Y-%m-%d",time:"%H:%M:%S",periods:["fm","em"],days:["Söndag","Måndag","Tisdag","Onsdag","Torsdag","Fredag","Lördag"],shortDays:["Sön","Mån","Tis","Ons","Tor","Fre","Lör"],months:["Januari","Februari","Mars","April","Maj","Juni","Juli","Augusti","September","Oktober","November","December"],shortMonths:["Jan","Feb","Mar","Apr","Maj","Jun","Jul","Aug","Sep","Okt","Nov","Dec"]}),Mn=i({dateTime:"%a %b %e %X %Y",date:"%Y/%-m/%-d",time:"%H:%M:%S",periods:["上午","下午"],days:["星期日","星期一","星期二","星期三","星期四","星期五","星期六"],shortDays:["星期日","星期一","星期二","星期三","星期四","星期五","星期六"],months:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],shortMonths:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"]}),Sn="%Y-%m-%dT%H:%M:%S.%LZ";function Dn(n){return n.toISOString()}Dn.parse=function(n){var t=new Date(n);return isNaN(t)?null:t},Dn.toString=function(){return Sn};var Tn=Date.prototype.toISOString&&+new Date("2000-01-01T00:00:00.000Z")?Dn:rn.utcFormat(Sn),Cn=rn.format,An=rn.utcFormat,Nn="0.2.1";n.version=Nn,n.format=Cn,n.utcFormat=An,n.locale=i,n.localeCaEs=on,n.localeDeCh=an,n.localeDeDe=sn,n.localeEnCa=cn,n.localeEnGb=un,n.localeEnUs=rn,n.localeEsEs=ln,n.localeFiFi=fn,n.localeFrCa=dn,n.localeFrFr=_n,n.localeHeIl=hn,n.localeHuHu=mn,n.localeItIt=gn,n.localeJaJp=pn,n.localeKoKr=yn,n.localeMkMk=wn,n.localeNlNl=vn,n.localePlPl=En,n.localePtBr=bn,n.localeRuRu=kn,n.localeSvSe=xn,n.localeZhCn=Mn,n.isoFormat=Tn}(t,J)})),Z=(b((function(n,t){!function(n){function t(n,t){if((e=(n=t?n.toExponential(t-1):n.toExponential()).indexOf("e"))<0)return null;var e,r=n.slice(0,e);return[r.length>1?r[0]+r.slice(2):r,+n.slice(e+1)]}function e(n){return(n=t(Math.abs(n)))?n[1]:NaN}function r(n,t){return function(e,r){for(var o=e.length,i=[],a=0,s=n[0],c=0;o>0&&s>0&&(c+s+1>r&&(s=Math.max(1,r-c)),i.push(e.substring(o-=s,o+s)),!((c+=s+1)>r));)s=n[a=(a+1)%n.length];return i.reverse().join(t)}}var o;function i(n,e){var r=t(n,e);if(!r)return n+"";var i=r[0],a=r[1],s=a-(o=3*Math.max(-8,Math.min(8,Math.floor(a/3))))+1,c=i.length;return s===c?i:s>c?i+new Array(s-c+1).join("0"):s>0?i.slice(0,s)+"."+i.slice(s):"0."+new Array(1-s).join("0")+t(n,Math.max(0,e+s-1))[0]}function a(n,e){var r=t(n,e);if(!r)return n+"";var o=r[0],i=r[1];return i<0?"0."+new Array(-i).join("0")+o:o.length>i+1?o.slice(0,i+1)+"."+o.slice(i+1):o+new Array(i-o.length+2).join("0")}function s(n,t){n:for(var e,r=(n=n.toPrecision(t)).length,o=1,i=-1;o<r;++o)switch(n[o]){case".":i=e=o;break;case"0":0===i&&(i=o),e=o;break;case"e":break n;default:i>0&&(i=0)}return i>0?n.slice(0,i)+n.slice(e+1):n}var c={"":s,"%":function(n,t){return(100*n).toFixed(t)},b:function(n){return Math.round(n).toString(2)},c:function(n){return n+""},d:function(n){return Math.round(n).toString(10)},e:function(n,t){return n.toExponential(t)},f:function(n,t){return n.toFixed(t)},g:function(n,t){return n.toPrecision(t)},o:function(n){return Math.round(n).toString(8)},p:function(n,t){return a(100*n,t)},r:a,s:i,X:function(n){return Math.round(n).toString(16).toUpperCase()},x:function(n){return Math.round(n).toString(16)}},u=/^(?:(.)?([<>=^]))?([+\-\( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?([a-z%])?$/i;function l(n){return new f(n)}function f(n){if(!(t=u.exec(n)))throw new Error("invalid format: "+n);var t,e=t[1]||" ",r=t[2]||">",o=t[3]||"-",i=t[4]||"",a=!!t[5],s=t[6]&&+t[6],l=!!t[7],f=t[8]&&+t[8].slice(1),d=t[9]||"";"n"===d?(l=!0,d="g"):c[d]||(d=""),(a||"0"===e&&"="===r)&&(a=!0,e="0",r="="),this.fill=e,this.align=r,this.sign=o,this.symbol=i,this.zero=a,this.width=s,this.comma=l,this.precision=f,this.type=d}f.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(null==this.width?"":Math.max(1,0|this.width))+(this.comma?",":"")+(null==this.precision?"":"."+Math.max(0,0|this.precision))+this.type};var d=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function _(n){return n}function h(n){var t=n.grouping&&n.thousands?r(n.grouping,n.thousands):_,i=n.currency,a=n.decimal;function s(n){var e=(n=l(n)).fill,r=n.align,s=n.sign,u=n.symbol,f=n.zero,_=n.width,h=n.comma,m=n.precision,g=n.type,p="$"===u?i[0]:"#"===u&&/[boxX]/.test(g)?"0"+g.toLowerCase():"",y="$"===u?i[1]:/[%p]/.test(g)?"%":"",w=c[g],v=!g||/[defgprs%]/.test(g);return m=null==m?g?6:12:/[gprs]/.test(g)?Math.max(1,Math.min(21,m)):Math.max(0,Math.min(20,m)),function(n){var i=p,c=y;if("c"===g)c=w(n)+c,n="";else{var u,l=((n=+n)<0||1/n<0)&&(n*=-1,!0);if(n=w(n,m),l){var E=-1,b=n.length;for(l=!1;++E<b;)if(48<(u=n.charCodeAt(E))&&u<58||"x"===g&&96<u&&u<103||"X"===g&&64<u&&u<71){l=!0;break}}if(i=(l?"("===s?s:"-":"-"===s||"("===s?"":s)+i,c=c+("s"===g?d[8+o/3]:"")+(l&&"("===s?")":""),v)for(E=-1,b=n.length;++E<b;)if(48>(u=n.charCodeAt(E))||u>57){c=(46===u?a+n.slice(E+1):n.slice(E))+c,n=n.slice(0,E);break}}h&&!f&&(n=t(n,1/0));var k=i.length+n.length+c.length,x=k<_?new Array(_-k+1).join(e):"";switch(h&&f&&(n=t(x+n,x.length?_-c.length:1/0),x=""),r){case"<":return i+n+c+x;case"=":return i+x+n+c;case"^":return x.slice(0,k=x.length>>1)+i+n+c+x.slice(k)}return x+i+n+c}}function u(n,t){var r=s(((n=l(n)).type="f",n)),o=3*Math.max(-8,Math.min(8,Math.floor(e(t)/3))),i=Math.pow(10,-o),a=d[8+o/3];return function(n){return r(i*n)+a}}return{format:s,formatPrefix:u}}var m=h({decimal:".",thousands:",",grouping:[3],currency:["$",""]}),g=h({decimal:",",thousands:".",grouping:[3],currency:[""," €"]}),p=h({decimal:",",thousands:" ",grouping:[3],currency:[""," Kč"]}),y=h({decimal:",",thousands:"'",grouping:[3],currency:[""," CHF"]}),w=h({decimal:",",thousands:".",grouping:[3],currency:[""," €"]}),v=h({decimal:".",thousands:",",grouping:[3],currency:["$",""]}),E=h({decimal:".",thousands:",",grouping:[3],currency:["£",""]}),b=h({decimal:",",thousands:".",grouping:[3],currency:[""," €"]}),k=h({decimal:",",thousands:" ",grouping:[3],currency:[""," €"]}),x=h({decimal:",",thousands:" ",grouping:[3],currency:["","$"]}),M=h({decimal:",",thousands:".",grouping:[3],currency:[""," €"]}),S=h({decimal:".",thousands:",",grouping:[3],currency:["₪",""]}),D=h({decimal:",",thousands:" ",grouping:[3],currency:[""," Ft"]}),T=h({decimal:",",thousands:".",grouping:[3],currency:["€",""]}),C=h({decimal:".",thousands:",",grouping:[3],currency:["","円"]}),A=h({decimal:".",thousands:",",grouping:[3],currency:["₩",""]}),N=h({decimal:",",thousands:".",grouping:[3],currency:[""," ден."]}),O=h({decimal:",",thousands:".",grouping:[3],currency:["€ ",""]}),F=h({decimal:",",thousands:".",grouping:[3],currency:["","zł"]}),z=h({decimal:",",thousands:".",grouping:[3],currency:["R$",""]}),j=h({decimal:",",thousands:" ",grouping:[3],currency:[""," руб."]}),P=h({decimal:",",thousands:" ",grouping:[3],currency:["","SEK"]}),I=h({decimal:".",thousands:",",grouping:[3],currency:["¥",""]});function L(n){return Math.max(0,-e(Math.abs(n)))}function R(n,t){return Math.max(0,3*Math.max(-8,Math.min(8,Math.floor(e(t)/3)))-e(Math.abs(n)))}function B(n,t){return n=Math.abs(n),t=Math.abs(t)-n,Math.max(0,e(t)-e(n))+1}var Y=m.format,U=m.formatPrefix,q="0.4.2";n.version=q,n.format=Y,n.formatPrefix=U,n.locale=h,n.localeCaEs=g,n.localeCsCz=p,n.localeDeCh=y,n.localeDeDe=w,n.localeEnCa=v,n.localeEnGb=E,n.localeEnUs=m,n.localeEsEs=b,n.localeFiFi=k,n.localeFrCa=x,n.localeFrFr=M,n.localeHeIl=S,n.localeHuHu=D,n.localeItIt=T,n.localeJaJp=C,n.localeKoKr=A,n.localeMkMk=N,n.localeNlNl=O,n.localePlPl=F,n.localePtBr=z,n.localeRuRu=j,n.localeSvSe=P,n.localeZhCn=I,n.formatSpecifier=l,n.precisionFixed=L,n.precisionPrefix=R,n.precisionRound=B}(t)})),K),Q=(new Date(2e3,0,1),function(n){return Z.format(n)});Math.sqrt(50),Math.sqrt(10),Math.sqrt(2);var nn=Q;function tn(n,t){var e=t&&t.type||"json";return n=X[e](n,t),t&&t.parse&&function(n,t){var e,r,o,i,a,s,c=n.length;for(t="auto"===t?N.inferAll(n):k.duplicate(t),r=(e=k.keys(t)).map((function(n){var e=t[n];if(e&&0===e.indexOf("date:")){var r=e.split(/:(.+)?/,2)[1];if(!("'"===r[0]&&"'"===r[r.length-1]||'"'===r[0]&&'"'===r[r.length-1]))throw Error("Format pattern must be quoted: "+r);return r=r.slice(1,-1),r=nn(r),function(n){return r.parse(n)}}if(!N.parsers[e])throw Error("Illegal format pattern: "+n+":"+e);return N.parsers[e]})),i=0,s=e.length;i<c;++i)for(o=n[i],a=0;a<s;++a)o[e[a]]=r[a](o[e[a]]);N.annotation(n,t)}(n,t.parse),n}tn.formats=X;var en=tn,rn=b((function(n){var t=n.exports;t.repeat=function(n,t){var e,r=Array(t);for(e=0;e<t;++e)r[e]=n;return r},t.zeros=function(n){return t.repeat(0,n)},t.range=function(n,t,e){if(arguments.length<3&&(e=1,arguments.length<2&&(t=n,n=0)),(t-n)/e==1/0)throw new Error("Infinite range");var r,o=[],i=-1;if(e<0)for(;(r=n+e*++i)>t;)o.push(r);else for(;(r=n+e*++i)<t;)o.push(r);return o},t.random={},t.random.uniform=function(n,e){void 0===e&&(e=void 0===n?1:n,n=0);var r=e-n,o=function(){return n+r*Math.random()};return o.samples=function(n){return t.zeros(n).map(o)},o.pdf=function(t){return t>=n&&t<=e?1/r:0},o.cdf=function(t){return t<n?0:t>e?1:(t-n)/r},o.icdf=function(t){return t>=0&&t<=1?n+t*r:NaN},o},t.random.integer=function(n,e){void 0===e&&(e=n,n=0);var r=e-n,o=function(){return n+Math.floor(r*Math.random())};return o.samples=function(n){return t.zeros(n).map(o)},o.pdf=function(t){return t===Math.floor(t)&&t>=n&&t<e?1/r:0},o.cdf=function(t){var o=Math.floor(t);return o<n?0:o>=e?1:(o-n+1)/r},o.icdf=function(t){return t>=0&&t<=1?n-1+Math.floor(t*r):NaN},o},t.random.normal=function(n,e){var r;n=n||0,e=e||1;var o=function(){var t,o,i=0,a=0;if(void 0!==r)return i=r,r=void 0,i;do{t=(i=2*Math.random()-1)*i+(a=2*Math.random()-1)*a}while(0===t||t>1);return o=Math.sqrt(-2*Math.log(t)/t),r=n+a*o*e,n+i*o*e};return o.samples=function(n){return t.zeros(n).map(o)},o.pdf=function(t){var r=Math.exp(Math.pow(t-n,2)/(-2*Math.pow(e,2)));return 1/(e*Math.sqrt(2*Math.PI))*r},o.cdf=function(t){var r,o=(t-n)/e,i=Math.abs(o);if(i>37)r=0;else{var a=Math.exp(-i*i/2);i<7.07106781186547?(r=a*((((((.0352624965998911*i+.700383064443688)*i+6.37396220353165)*i+33.912866078383)*i+112.079291497871)*i+221.213596169931)*i+220.206867912376),r/=((((((.0883883476483184*i+1.75566716318264)*i+16.064177579207)*i+86.7807322029461)*i+296.564248779674)*i+637.333633378831)*i+793.826512519948)*i+440.413735824752):r=a/(i+1/(i+2/(i+3/(i+4/(i+.65)))))/2.506628274631}return o>0?1-r:r},o.icdf=function(t){if(t<=0||t>=1)return NaN;var r=2*t-1,o=8*(Math.PI-3)/(3*Math.PI*(4-Math.PI)),i=2/(Math.PI*o)+Math.log(1-Math.pow(r,2))/2,a=Math.log(1-r*r)/o,s=(r>0?1:-1)*Math.sqrt(Math.sqrt(i*i-a)-i);return n+e*Math.SQRT2*s},o},t.random.bootstrap=function(n,e){var r=n.filter(k.isValid),o=r.length,i=e?t.random.normal(0,e):null,a=function(){return r[~~(Math.random()*o)]+(i?i():0)};return a.samples=function(n){return t.zeros(n).map(a)},a}})),on=b((function(n){var t=n.exports;function e(n,e,r){var o=n&&n.nullh||0,i=rn.random.normal(0,1),a=t.mean(e,r),s=t.stdev(e,r)/Math.sqrt(t.count.valid(e,r));if(0===s)return a-o==0?1:0;var c=(a-o)/s;return 2*i.cdf(-Math.abs(c))}function r(n,e,r,o){var i,a=o?e.map(k.$(r)):e,s=o?e.map(k.$(o)):r,c=t.count(a),u=t.count(s),l=Array();if(c!==u)throw Error("Array lengths must match.");for(i=0;i<c;++i)k.isValid(a[i])&&k.isValid(s[i])&&l.push(a[i]-s[i]);return t.z.test(l,n&&n.nullh||0)}function o(n,e,r,o){var i=o?e.map(k.$(r)):e,a=o?e.map(k.$(o)):r,s=t.count.valid(i),c=t.count.valid(a),u=rn.random.normal(0,1),l=t.mean(i)-t.mean(a)-(n&&n.nullh||0),f=Math.sqrt(t.variance(i)/s+t.variance(a)/c);if(0===f)return 0===l?1:0;var d=l/f;return 2*u.cdf(-Math.abs(d))}t.unique=function(n,t,e){t=k.$(t),e=e||[];var r,o,i,a={};for(o=0,i=n.length;o<i;++o)(r=t?t(n[o]):n[o])in a||(a[r]=1,e.push(r));return e},t.count=function(n){return n&&n.length||0},t.count.valid=function(n,t){t=k.$(t);var e,r,o,i=0;for(r=0,o=n.length;r<o;++r)e=t?t(n[r]):n[r],k.isValid(e)&&(i+=1);return i},t.count.missing=function(n,t){t=k.$(t);var e,r,o=0;for(e=0,r=n.length;e<r;++e)null==(t?t(n[e]):n[e])&&(o+=1);return o},t.count.distinct=function(n,t){t=k.$(t);var e,r,o,i={},a=0;for(r=0,o=n.length;r<o;++r)(e=t?t(n[r]):n[r])in i||(i[e]=1,a+=1);return a},t.count.map=function(n,t){t=k.$(t);var e,r,o,i={};for(r=0,o=n.length;r<o;++r)i[e=t?t(n[r]):n[r]]=e in i?i[e]+1:1;return i},t.median=function(n,e){return e&&(n=n.map(k.$(e))),n=n.filter(k.isValid).sort(k.cmp),t.quantile(n,.5)},t.quartile=function(n,e){e&&(n=n.map(k.$(e))),n=n.filter(k.isValid).sort(k.cmp);var r=t.quantile;return[r(n,.25),r(n,.5),r(n,.75)]},t.quantile=function(n,t,e){void 0===e&&(e=t,t=k.identity),t=k.$(t);var r=(n.length-1)*e+1,o=Math.floor(r),i=+t(n[o-1]),a=r-o;return a?i+a*(t(n[o])-i):i},t.sum=function(n,t){t=k.$(t);for(var e,r=0,o=0,i=n.length;o<i;++o)e=t?t(n[o]):n[o],k.isValid(e)&&(r+=e);return r},t.mean=function(n,t){t=k.$(t);var e,r,o,i,a=0;for(e=0,o=0,r=n.length;e<r;++e)i=t?t(n[e]):n[e],k.isValid(i)&&(a+=(i-a)/++o);return a},t.mean.geometric=function(n,t){t=k.$(t);var e,r,o,i,a=1;for(i=0,e=0,r=n.length;i<r;++i)if(o=t?t(n[i]):n[i],k.isValid(o)){if(o<=0)throw Error("Geometric mean only defined for positive values.");a*=o,++e}return e>0?Math.pow(a,1/e):0},t.mean.harmonic=function(n,t){t=k.$(t);var e,r,o,i,a=0;for(i=0,e=0,r=n.length;i<r;++i)o=t?t(n[i]):n[i],k.isValid(o)&&(a+=1/o,++e);return e/a},t.variance=function(n,t){if(t=k.$(t),!k.isArray(n)||n.length<2)return 0;var e,r,o,i,a=0,s=0;for(r=0,o=0;r<n.length;++r)i=t?t(n[r]):n[r],k.isValid(i)&&(s+=(e=i-a)*(i-(a+=e/++o)));return s/(o-1)},t.stdev=function(n,e){return Math.sqrt(t.variance(n,e))},t.modeskew=function(n,e){var r=t.mean(n,e),o=t.median(n,e),i=t.stdev(n,e);return 0===i?0:(r-o)/i},t.min=function(n,e){return t.extent(n,e)[0]},t.max=function(n,e){return t.extent(n,e)[1]},t.extent=function(n,t){t=k.$(t);var e,r,o,i,a=n.length;for(i=0;i<a;++i)if(o=t?t(n[i]):n[i],k.isValid(o)){e=r=o;break}for(;i<a;++i)o=t?t(n[i]):n[i],k.isValid(o)&&(o<e&&(e=o),o>r&&(r=o));return[e,r]},t.extent.index=function(n,t){t=k.$(t);var e,r,o,i,a=-1,s=-1,c=n.length;for(i=0;i<c;++i)if(o=t?t(n[i]):n[i],k.isValid(o)){e=r=o,a=s=i;break}for(;i<c;++i)o=t?t(n[i]):n[i],k.isValid(o)&&(o<e&&(e=o,a=i),o>r&&(r=o,s=i));return[a,s]},t.dot=function(n,t,e){var r,o,i=0;if(e)for(t=k.$(t),e=k.$(e),r=0;r<n.length;++r)(o=t(n[r])*e(n[r]))==o&&(i+=o);else{if(n.length!==t.length)throw Error("Array lengths must match.");for(r=0;r<n.length;++r)(o=n[r]*t[r])==o&&(i+=o)}return i},t.dist=function(n,t,e,r){var o,i,a=k.isFunction(e)||k.isString(e),s=n,c=a?n:t,u=a?r:e,l=2===u||null==u,f=n.length,d=0;for(a&&(t=k.$(t),e=k.$(e)),i=0;i<f;++i)o=a?t(s[i])-e(c[i]):s[i]-c[i],d+=l?o*o:Math.pow(Math.abs(o),u);return l?Math.sqrt(d):Math.pow(d,1/u)},t.cohensd=function(n,e,r){var o=r?n.map(k.$(e)):n,i=r?n.map(k.$(r)):e,a=t.mean(o),s=t.mean(i),c=t.count.valid(o),u=t.count.valid(i);if(c+u-2<=0)return 0;var l=t.variance(o),f=t.variance(i),d=Math.sqrt(((c-1)*l+(u-1)*f)/(c+u-2));return 0===d?0:(a-s)/d},t.covariance=function(n,e,r){var o,i,a,s,c,u=r?n.map(k.$(e)):n,l=r?n.map(k.$(r)):e,f=u.length,d=t.mean(u),_=t.mean(l),h=0,m=0;if(f!==l.length)throw Error("Input lengths must match.");for(o=0;o<f;++o)if(i=u[o],s=k.isValid(i),a=l[o],c=k.isValid(a),s&&c)h+=(i-d)*(a-_),++m;else if(s||c)throw Error("Valid values must align.");return h/(m-1)},t.rank=function(n,t){t=k.$(t)||k.identity;var e,r,o,i=n.map((function(n,e){return{idx:e,val:t(n)}})).sort(k.comparator("val")),a=n.length,s=Array(a),c=-1,u={};for(e=0;e<a;++e){if(r=i[e].val,c<0&&u===r)c=e-1;else if(c>-1&&u!==r){for(o=1+(e-1+c)/2;c<e;++c)s[i[c].idx]=o;c=-1}s[i[e].idx]=e+1,u=r}if(c>-1)for(o=1+(a-1+c)/2;c<a;++c)s[i[c].idx]=o;return s},t.cor=function(n,e,r){var o=r;r=o?n.map(k.$(r)):e,e=o?n.map(k.$(e)):n;var i=t.dot(e,r),a=t.mean(e),s=t.mean(r),c=t.stdev(e),u=t.stdev(r),l=n.length;return(i-l*a*s)/((l-1)*c*u)},t.cor.rank=function(n,e,r){var o,i,a,s=r?t.rank(n,e):t.rank(n),c=r?t.rank(n,r):t.rank(e),u=n.length;for(o=0,i=0;o<u;++o)i+=(a=s[o]-c[o])*a;return 1-6*i/(u*(u*u-1))},t.cor.dist=function(n,e,r){var o,i,a,s,c=r?n.map(k.$(e)):n,u=r?n.map(k.$(r)):e,l=t.dist.mat(c),f=t.dist.mat(u),d=l.length;for(o=0,i=0,a=0,s=0;o<d;++o)i+=l[o]*l[o],a+=f[o]*f[o],s+=l[o]*f[o];return Math.sqrt(s/Math.sqrt(i*a))},t.linearRegression=function(n,e,r){var o,i,a=r?n.map(k.$(e)):n,s=r?n.map(k.$(r)):e,c=a.length,u=t.covariance(a,s),l=t.stdev(a),f=t.stdev(s),d=u/(l*l),_=t.mean(s)-d*t.mean(a),h={slope:d,intercept:_,R:u/(l*f),rss:0};for(i=0;i<c;++i)k.isValid(a[i])&&k.isValid(s[i])&&(o=d*a[i]+_-s[i],h.rss+=o*o);return h},t.bootstrap={},t.bootstrap.ci=function(n,e,r,o,i){var a,s,c,u,l,f,d;for(k.isFunction(e)||k.isString(e)?(a=n.map(k.$(e)),s=r,c=o,u=i):(a=n,s=e,c=r,u=o),s=s?+s:1e3,c=c||.05,l=rn.random.bootstrap(a,u),d=0,f=Array(s);d<s;++d)f[d]=t.mean(l.samples(a.length));return f.sort(k.numcmp),[t.quantile(f,c/2),t.quantile(f,1-c/2)]},t.z={},t.z.ci=function(n,e,r){var o=n,i=e;(k.isFunction(e)||k.isString(e))&&(o=n.map(k.$(e)),i=r);var a=.05===(i=i||.05)?1.96:rn.random.normal(0,1).icdf(1-i/2),s=t.mean(o),c=t.stdev(o)/Math.sqrt(t.count.valid(o));return[s-a*c,s+a*c]},t.z.test=function(n,t,i,a){return k.isFunction(i)||k.isString(i)?(a&&a.paired?r:o)(a,n,t,i):k.isArray(t)?(i&&i.paired?r:o)(i,n,t):k.isFunction(t)||k.isString(t)?e(i,n,t):e(t,n)},t.dist.mat=function(n){var t,e,r,o=n.length,i=o*o,a=Array(i),s=rn.zeros(o),c=0;for(e=0;e<o;++e)for(a[e*o+e]=0,r=e+1;r<o;++r)a[e*o+r]=t=Math.abs(n[e]-n[r]),a[r*o+e]=t,s[e]+=t,s[r]+=t;for(e=0;e<o;++e)c+=s[e],s[e]/=o;for(c/=i,e=0;e<o;++e)for(r=e;r<o;++r)a[e*o+r]+=c-s[e]-s[r],a[r*o+e]=a[e*o+r];return a},t.entropy=function(n,t){t=k.$(t);var e,r,o=0,i=0,a=n.length;for(e=0;e<a;++e)o+=t?t(n[e]):n[e];if(0===o)return 0;for(e=0;e<a;++e)(r=(t?t(n[e]):n[e])/o)&&(i+=r*Math.log(r));return-i/Math.LN2},t.mutual=function(n,t,e,r){var o,i,a,s=r?n.map(k.$(t)):n,c=r?n.map(k.$(e)):t,u=r?n.map(k.$(r)):e,l={},f={},d=u.length,_=0,h=0,m=0;for(a=0;a<d;++a)l[s[a]]=0,f[c[a]]=0;for(a=0;a<d;++a)l[s[a]]+=u[a],f[c[a]]+=u[a],_+=u[a];for(i=1/(_*Math.LN2),a=0;a<d;++a)0!==u[a]&&(o=_*u[a]/(l[s[a]]*f[c[a]]),h+=u[a]*i*Math.log(o),m+=u[a]*i*Math.log(u[a]/_));return[h,1+h/m]},t.mutual.info=function(n,e,r,o){return t.mutual(n,e,r,o)[0]},t.mutual.dist=function(n,e,r,o){return t.mutual(n,e,r,o)[1]},t.profile=function(n,e){var r,o,i,a,s,c=0,u=0,l=0,f=0,d=null,_=null,h=0,m=[],g={};for(i=0;i<n.length;++i)g[a=e?e(n[i]):n[i]]=a in g?g[a]+1:(f+=1,1),null==a?++l:k.isValid(a)&&(s="string"==typeof a?a.length:a,(null===d||s<d)&&(d=s),(null===_||s>_)&&(_=s),h+=(r=s-c)*(s-(c+=r/++u)),m.push(s));return h/=u-1,o=Math.sqrt(h),m.sort(k.cmp),{type:N(n,e),unique:g,count:n.length,valid:u,missing:l,distinct:f,min:d,max:_,mean:c,stdev:o,median:a=t.quantile(m,.5),q1:t.quantile(m,.25),q3:t.quantile(m,.75),modeskew:0===o?0:(c-a)/o}},t.summary=function(n,e){var r=(e=e||k.keys(n[0])).map((function(e){var r=t.profile(n,k.$(e));return r.field=e,r}));return r.__summary__=!0,r}}));function an(n){const t=en(n),e=on.summary(t),r={};return e.forEach((n=>{const t=n.field;delete n.field,r[t]=n})),{stats:r,size:n.length}}function sn(n){const t=n[0].type;n.forEach((n=>{if(n.type!==t)throw new Error(`constraints not all of type ${t}`)}));let e,r,o="";"soft"===t&&(e="",r="");for(const i of n)o+=`% @constraint ${i.description}\n${i.asp}`,o+="\n\n","soft"===t&&(e+=`#const ${i.name}_weight = ${i.weight}.`,e+="\n",r+=`soft_weight(${i.name}, ${i.name}_weight).`,r+="\n");return"hard"===t?{definitions:o}:{definitions:o,weights:e,assigns:r}}function cn(n){if(!n)throw Error("No data has been prepared");const t=n.stats,e=[`num_rows(${n.size}).\n`];return Object.keys(t).forEach(((n,r)=>{const o=`"${n}"`,i=t[n],a=`fieldtype(${o},${i.type}).`,s=`cardinality(${o}, ${i.distinct}).`;e.push(`${a}\n${s}`)})),e}var un={},ln=Object.freeze({default:un});function fn(n,t){for(var e=0,r=n.length-1;r>=0;r--){var o=n[r];"."===o?n.splice(r,1):".."===o?(n.splice(r,1),e++):e&&(n.splice(r,1),e--)}if(t)for(;e--;e)n.unshift("..");return n}var dn=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,_n=function(n){return dn.exec(n).slice(1)};function hn(){for(var n="",t=!1,e=arguments.length-1;e>=-1&&!t;e--){var r=e>=0?arguments[e]:"/";if("string"!=typeof r)throw new TypeError("Arguments to path.resolve must be strings");r&&(n=r+"/"+n,t="/"===r.charAt(0))}return(t?"/":"")+(n=fn(kn(n.split("/"),(function(n){return!!n})),!t).join("/"))||"."}function mn(n){var t=gn(n),e="/"===xn(n,-1);return(n=fn(kn(n.split("/"),(function(n){return!!n})),!t).join("/"))||t||(n="."),n&&e&&(n+="/"),(t?"/":"")+n}function gn(n){return"/"===n.charAt(0)}function pn(){return mn(kn(Array.prototype.slice.call(arguments,0),(function(n,t){if("string"!=typeof n)throw new TypeError("Arguments to path.join must be strings");return n})).join("/"))}function yn(n,t){function e(n){for(var t=0;t<n.length&&""===n[t];t++);for(var e=n.length-1;e>=0&&""===n[e];e--);return t>e?[]:n.slice(t,e-t+1)}n=hn(n).substr(1),t=hn(t).substr(1);for(var r=e(n.split("/")),o=e(t.split("/")),i=Math.min(r.length,o.length),a=i,s=0;s<i;s++)if(r[s]!==o[s]){a=s;break}var c=[];for(s=a;s<r.length;s++)c.push("..");return(c=c.concat(o.slice(a))).join("/")}function wn(n){var t=_n(n),e=t[0],r=t[1];return e||r?(r&&(r=r.substr(0,r.length-1)),e+r):"."}function vn(n,t){var e=_n(n)[2];return t&&e.substr(-1*t.length)===t&&(e=e.substr(0,e.length-t.length)),e}function En(n){return _n(n)[3]}var bn={extname:En,basename:vn,dirname:wn,sep:"/",delimiter:":",relative:yn,join:pn,isAbsolute:gn,normalize:mn,resolve:hn};function kn(n,t){if(n.filter)return n.filter(t);for(var e=[],r=0;r<n.length;r++)t(n[r],r,n)&&e.push(n[r]);return e}var xn=function(n,t,e){return n.substr(t,e)},Mn=Object.freeze({resolve:hn,normalize:mn,isAbsolute:gn,join:pn,relative:yn,sep:"/",delimiter:":",dirname:wn,basename:vn,extname:En,default:bn}),Sn=ln&&un||ln,Dn=Mn&&bn||Mn,Tn=b((function(n,t){var e,o=(e="undefined"!=typeof document&&document.currentScript?document.currentScript.src:void 0,function(n){n=void 0!==(n=n||{})?n:{};var t,o={};for(t in n)n.hasOwnProperty(t)&&(o[t]=n[t]);n.arguments=[],n.thisProgram="./this.program",n.quit=function(n,t){throw t},n.preRun=[],n.postRun=[];var i=!1,a=!1,s=!1,c=!1;i="object"==typeof window,a="function"==typeof importScripts,s="object"==typeof r&&!i&&!a,c=!i&&!s&&!a;var u,l,f="";function d(t){return n.locateFile?n.locateFile(t,f):f+t}s?(f="//",n.read=function(n,t){var e;return u||(u=Sn),l||(l=Dn),n=l.normalize(n),e=u.readFileSync(n),t?e:e.toString()},n.readBinary=function(t){var e=n.read(t,!0);return e.buffer||(e=new Uint8Array(e)),k(e.buffer),e},r.argv.length>1&&(n.thisProgram=r.argv[1].replace(/\\/g,"/")),n.arguments=r.argv.slice(2),r.on("uncaughtException",(function(n){if(!(n instanceof go))throw n})),r.on("unhandledRejection",(function(n,t){r.exit(1)})),n.quit=function(n){r.exit(n)},n.inspect=function(){return"[Emscripten Module object]"}):c?("undefined"!=typeof read&&(n.read=function(n){return read(n)}),n.readBinary=function(n){var t;return"function"==typeof readbuffer?new Uint8Array(readbuffer(n)):(k("object"==typeof(t=read(n,"binary"))),t)},"undefined"!=typeof scriptArgs?n.arguments=scriptArgs:void 0!==arguments&&(n.arguments=arguments),"function"==typeof quit&&(n.quit=function(n){quit(n)})):(i||a)&&(i?document.currentScript&&(f=document.currentScript.src):f=self.location.href,e&&(f=e),f=0!==f.indexOf("blob:")?f.substr(0,f.lastIndexOf("/")+1):"",n.read=function(n){var t=new XMLHttpRequest;return t.open("GET",n,!1),t.send(null),t.responseText},a&&(n.readBinary=function(n){var t=new XMLHttpRequest;return t.open("GET",n,!1),t.responseType="arraybuffer",t.send(null),new Uint8Array(t.response)}),n.readAsync=function(n,t,e){var r=new XMLHttpRequest;r.open("GET",n,!0),r.responseType="arraybuffer",r.onload=function(){200==r.status||0==r.status&&r.response?t(r.response):e()},r.onerror=e,r.send(null)},n.setWindowTitle=function(n){document.title=n});var _=n.print||("undefined"!=typeof console?console.log.bind(console):"undefined"!=typeof print?print:null),h=n.printErr||("undefined"!=typeof printErr?printErr:"undefined"!=typeof console&&console.warn.bind(console)||_);for(t in o)o.hasOwnProperty(t)&&(n[t]=o[t]);o=void 0;var m=16;function g(n){var t=Q;return Q=Q+n+15&-16,t}function p(n){var t=X[an>>2],e=t+n+15&-16;return X[an>>2]=e,e>=gn&&!hn()?(X[an>>2]=t,0):t}function y(n,t){return t||(t=m),Math.ceil(n/t)*t}function w(n){switch(n){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:if("*"===n[n.length-1])return 4;if("i"===n[0]){var t=parseInt(n.substr(1));return k(t%8==0),t/8}return 0}}var v={"f64-rem":function(n,t){return n%t},debugger:function(){}},E=1024,b=!1;function k(n,t){n||wo("Assertion failed: "+t)}function x(t){var e=n["_"+t];return k(e,"Cannot call unknown function "+t+", make sure it is exported"),e}var M={stackSave:function(){mo()},stackRestore:function(){ho()},arrayToC:function(n){var t=_o(n.length);return zn(n,t),t},stringToC:function(n){var t=0;if(null!=n&&0!==n){var e=1+(n.length<<2);R(n,t=_o(e),e)}return t}},S={string:M.stringToC,array:M.arrayToC};function D(n,t,e,r,o){var i=x(n),a=[],s=0;if(r)for(var c=0;c<r.length;c++){var u=S[e[c]];u?(0===s&&(s=mo()),a[c]=u(r[c])):a[c]=r[c]}var l=i.apply(null,a);return l=function(n){return"string"===t?z(n):"boolean"===t?Boolean(n):n}(l),0!==s&&ho(s),l}function T(n,t,e,r){switch("*"===(e=e||"i8").charAt(e.length-1)&&(e="i32"),e){case"i1":case"i8":V[n>>0]=t;break;case"i16":G[n>>1]=t;break;case"i32":X[n>>2]=t;break;case"i64":tempI64=[t>>>0,(tempDouble=t,+Pn(tempDouble)>=1?tempDouble>0?(0|Rn(+Ln(tempDouble/4294967296),4294967295))>>>0:~~+In((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],X[n>>2]=tempI64[0],X[n+4>>2]=tempI64[1];break;case"float":J[n>>2]=t;break;case"double":K[n>>3]=t;break;default:wo("invalid type for setValue: "+e)}}var C=0,A=2,N=4;function O(n,t,e,r){var o,i;"number"==typeof n?(o=!0,i=n):(o=!1,i=n.length);var a,s="string"==typeof t?t:null;if(a=e==N?r:["function"==typeof uo?uo:g,_o,g,p][void 0===e?A:e](Math.max(i,s?1:t.length)),o){var c;for(r=a,k(0==(3&a)),c=a+(-4&i);r<c;r+=4)X[r>>2]=0;for(c=a+i;r<c;)V[r++>>0]=0;return a}if("i8"===s)return n.subarray||n.slice?W.set(n,a):W.set(new Uint8Array(n),a),a;for(var u,l,f,d=0;d<i;){var _=n[d];0!==(u=s||t[d])?("i64"==u&&(u="i32"),T(a+d,_,u),f!==u&&(l=w(u),f=u),d+=l):d++}return a}function F(n){return nn?xn?uo(n):p(n):g(n)}function z(n,t){if(0===t||!n)return"";for(var e,r=0,o=0;r|=e=W[n+o>>0],(0!=e||t)&&(o++,!t||o!=t););t||(t=o);var i="";if(r<128){for(var a,s=1024;t>0;)a=String.fromCharCode.apply(String,W.subarray(n,n+Math.min(t,s))),i=i?i+a:a,n+=s,t-=s;return i}return I(n)}var j="undefined"!=typeof TextDecoder?new TextDecoder("utf8"):void 0;function P(n,t){for(var e=t;n[e];)++e;if(e-t>16&&n.subarray&&j)return j.decode(n.subarray(t,e));for(var r,o,i,a,s,c="";;){if(!(r=n[t++]))return c;if(128&r)if(o=63&n[t++],192!=(224&r))if(i=63&n[t++],224==(240&r)?r=(15&r)<<12|o<<6|i:(a=63&n[t++],240==(248&r)?r=(7&r)<<18|o<<12|i<<6|a:(s=63&n[t++],r=248==(252&r)?(3&r)<<24|o<<18|i<<12|a<<6|s:(1&r)<<30|o<<24|i<<18|a<<12|s<<6|63&n[t++])),r<65536)c+=String.fromCharCode(r);else{var u=r-65536;c+=String.fromCharCode(55296|u>>10,56320|1023&u)}else c+=String.fromCharCode((31&r)<<6|o);else c+=String.fromCharCode(r)}}function I(n){return P(W,n)}function L(n,t,e,r){if(!(r>0))return 0;for(var o=e,i=e+r-1,a=0;a<n.length;++a){var s=n.charCodeAt(a);if(s>=55296&&s<=57343&&(s=65536+((1023&s)<<10)|1023&n.charCodeAt(++a)),s<=127){if(e>=i)break;t[e++]=s}else if(s<=2047){if(e+1>=i)break;t[e++]=192|s>>6,t[e++]=128|63&s}else if(s<=65535){if(e+2>=i)break;t[e++]=224|s>>12,t[e++]=128|s>>6&63,t[e++]=128|63&s}else if(s<=2097151){if(e+3>=i)break;t[e++]=240|s>>18,t[e++]=128|s>>12&63,t[e++]=128|s>>6&63,t[e++]=128|63&s}else if(s<=67108863){if(e+4>=i)break;t[e++]=248|s>>24,t[e++]=128|s>>18&63,t[e++]=128|s>>12&63,t[e++]=128|s>>6&63,t[e++]=128|63&s}else{if(e+5>=i)break;t[e++]=252|s>>30,t[e++]=128|s>>24&63,t[e++]=128|s>>18&63,t[e++]=128|s>>12&63,t[e++]=128|s>>6&63,t[e++]=128|63&s}}return t[e]=0,e-o}function R(n,t,e){return L(n,W,t,e)}function B(n){for(var t=0,e=0;e<n.length;++e){var r=n.charCodeAt(e);r>=55296&&r<=57343&&(r=65536+((1023&r)<<10)|1023&n.charCodeAt(++e)),r<=127?++t:t+=r<=2047?2:r<=65535?3:r<=2097151?4:r<=67108863?5:6}return t}function Y(n){var t=B(n)+1,e=uo(t);return e&&L(n,V,e,t),e}function U(n){return n.replace(/__Z[\w\d_]+/g,(function(n){return n===n?n:n+" ["+n+"]"}))}function q(){var n=new Error;if(!n.stack){try{throw new Error(0)}catch(t){n=t}if(!n.stack)return"(no stack trace available)"}return n.stack.toString()}function $(){var t=q();return n.extraStackTrace&&(t+="\n"+n.extraStackTrace()),U(t)}"undefined"!=typeof TextDecoder&&new TextDecoder("utf-16le");var H,V,W,G,X,J,K,Z,Q,nn,tn,en,rn,on,an,sn=65536,cn=16777216,un=16777216;function ln(n,t){return n%t>0&&(n+=t-n%t),n}function fn(t){n.buffer=H=t}function dn(){n.HEAP8=V=new Int8Array(H),n.HEAP16=G=new Int16Array(H),n.HEAP32=X=new Int32Array(H),n.HEAPU8=W=new Uint8Array(H),n.HEAPU16=new Uint16Array(H),n.HEAPU32=new Uint32Array(H),n.HEAPF32=J=new Float32Array(H),n.HEAPF64=K=new Float64Array(H)}function _n(){wo("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+gn+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime, or (3) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function hn(){var t=n.usingWasm?sn:cn,e=2147483648-t;if(X[an>>2]>e)return!1;var r=gn;for(gn=Math.max(gn,un);gn<X[an>>2];)gn=gn<=536870912?ln(2*gn,t):Math.min(ln((3*gn+2147483648)/4,t),e);var o=n.reallocBuffer(gn);return o&&o.byteLength==gn?(fn(o),dn(),!0):(gn=r,!1)}Z=Q=tn=en=rn=on=an=0,nn=!1,n.reallocBuffer||(n.reallocBuffer=function(n){var t;try{var e=V;t=new ArrayBuffer(n),new Int8Array(t).set(e)}catch(n){return!1}return!!so(t)&&t});try{Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype,"byteLength").get)(new ArrayBuffer(4))}catch(n){}var mn=n.TOTAL_STACK||5242880,gn=n.TOTAL_MEMORY||16777216;function pn(){return gn}function yn(t){for(;t.length>0;){var e=t.shift();if("function"!=typeof e){var r=e.func;"number"==typeof r?void 0===e.arg?n.dynCall_v(r):n.dynCall_vi(r,e.arg):r(void 0===e.arg?null:e.arg)}else e()}}gn<mn&&h("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+gn+"! (TOTAL_STACK="+mn+")"),n.buffer?H=n.buffer:("object"==typeof WebAssembly&&"function"==typeof WebAssembly.Memory?(n.wasmMemory=new WebAssembly.Memory({initial:gn/sn}),H=n.wasmMemory.buffer):H=new ArrayBuffer(gn),n.buffer=H),dn();var wn=[],vn=[],En=[],bn=[],kn=[],xn=!1;function Mn(){if(n.preRun)for("function"==typeof n.preRun&&(n.preRun=[n.preRun]);n.preRun.length;)On(n.preRun.shift());yn(wn)}function Tn(){xn||(xn=!0,yn(vn))}function Cn(){yn(En)}function An(){yn(bn)}function Nn(){if(n.postRun)for("function"==typeof n.postRun&&(n.postRun=[n.postRun]);n.postRun.length;)Fn(n.postRun.shift());yn(kn)}function On(n){wn.unshift(n)}function Fn(n){kn.unshift(n)}function zn(n,t){V.set(n,t)}function jn(n,t,e){for(var r=0;r<n.length;++r)V[t++>>0]=n.charCodeAt(r);e||(V[t>>0]=0)}var Pn=Math.abs,In=Math.ceil,Ln=Math.floor,Rn=Math.min,Bn=0,Yn=null,Un=null;function qn(t){Bn++,n.monitorRunDependencies&&n.monitorRunDependencies(Bn)}function $n(t){if(Bn--,n.monitorRunDependencies&&n.monitorRunDependencies(Bn),0==Bn&&(null!==Yn&&(clearInterval(Yn),Yn=null),Un)){var e=Un;Un=null,e()}}n.preloadedImages={},n.preloadedAudios={};var Hn="data:application/octet-stream;base64,";function Vn(n){return String.prototype.startsWith?n.startsWith(Hn):0===n.indexOf(Hn)}function Wn(){var t="clingo.wast",e="clingo.wasm",r="clingo.temp.asm.js";Vn(t)||(t=d(t)),Vn(e)||(e=d(e)),Vn(r)||(r=d(r));var o={global:null,env:null,asm2wasm:v,parent:n},s=null;function c(){try{if(n.wasmBinary)return new Uint8Array(n.wasmBinary);if(n.readBinary)return n.readBinary(e);throw"both async and sync fetching of the wasm failed"}catch(n){wo(n)}}function u(t,r,u){if("object"!=typeof WebAssembly)return h("no native wasm support detected"),!1;if(!(n.wasmMemory instanceof WebAssembly.Memory))return h("no native wasm Memory in use"),!1;function l(t,e){(s=t.exports).memory&&function(t){var e=n.buffer;t.byteLength<e.byteLength&&h("the new buffer in mergeMemory is smaller than the previous one. in native wasm, we should grow memory here");var r=new Int8Array(e);new Int8Array(t).set(r),fn(t),dn()}(s.memory),n.asm=s,n.usingWasm=!0,$n()}if(r.memory=n.wasmMemory,o.global={NaN:NaN,Infinity:1/0},o["global.Math"]=Math,o.env=r,qn(),n.instantiateWasm)try{return n.instantiateWasm(o,l)}catch(n){return h("Module.instantiateWasm callback failed with error: "+n),!1}function f(n){l(n.instance,n.module)}function d(t){(n.wasmBinary||!i&&!a||"function"!=typeof fetch?new Promise((function(n,t){n(c())})):fetch(e,{credentials:"same-origin"}).then((function(n){if(!n.ok)throw"failed to load wasm binary file at '"+e+"'";return n.arrayBuffer()})).catch((function(){return c()}))).then((function(n){return WebAssembly.instantiate(n,o)})).then(t).catch((function(n){h("failed to asynchronously prepare wasm: "+n),wo(n)}))}return n.wasmBinary||"function"!=typeof WebAssembly.instantiateStreaming||Vn(e)||"function"!=typeof fetch?d(f):WebAssembly.instantiateStreaming(fetch(e,{credentials:"same-origin"}),o).then(f).catch((function(n){h("wasm streaming compile failed: "+n),h("falling back to ArrayBuffer instantiation"),d(f)})),{}}n.asmPreload=n.asm,n.reallocBuffer;n.reallocBuffer=function(t){return function(t){t=ln(t,n.usingWasm?sn:cn);var e=n.buffer.byteLength;if(n.usingWasm)try{return-1!==n.wasmMemory.grow((t-e)/65536)?n.buffer=n.wasmMemory.buffer:null}catch(n){return null}}(t)},n.asm=function(t,e,r){if(!(e=e).table){var o=n.wasmTableSize;void 0===o&&(o=1024);var i=n.wasmMaxTableSize;"object"==typeof WebAssembly&&"function"==typeof WebAssembly.Table?e.table=void 0!==i?new WebAssembly.Table({initial:o,maximum:i,element:"anyfunc"}):new WebAssembly.Table({initial:o,element:"anyfunc"}):e.table=new Array(o),n.wasmTable=e.table}var a;return e.memoryBase||(e.memoryBase=n.STATIC_BASE),e.tableBase||(e.tableBase=0),k(a=u(0,e),"no binaryen method succeeded."),a}}Wn(),Q=(Z=E)+204768,vn.push({func:function(){zr()}},{func:function(){Xr()}},{func:function(){Zr()}},{func:function(){Qr()}},{func:function(){no()}},{func:function(){to()}},{func:function(){Ir()}},{func:function(){jr()}},{func:function(){Pr()}},{func:function(){$r()}},{func:function(){Kr()}},{func:function(){Rr()}},{func:function(){Br()}},{func:function(){Yr()}},{func:function(){Jr()}},{func:function(){eo()}},{func:function(){Hr()}},{func:function(){Vr()}},{func:function(){Wr()}},{func:function(){Gr()}},{func:function(){Ur()}},{func:function(){ro()}},{func:function(){Lr()}});var Gn=204768;n.STATIC_BASE=Z,n.STATIC_BUMP=Gn;var Xn=Q;function Jn(n){yo(n)}function Kn(n){Jn(n)}function Zn(n){Jn(n)}Q+=16;var Qn={};function nt(t){var e,r;nt.called?(r=X[t>>2],e=X[r>>2]):(nt.called=!0,Qn.USER=Qn.LOGNAME="web_user",Qn.PATH="/",Qn.PWD="/",Qn.HOME="/home/web_user",Qn.LANG="C.UTF-8",Qn._=n.thisProgram,e=F(1024),r=F(256),X[r>>2]=e,X[t>>2]=r);var o=[],i=0;for(var a in Qn)if("string"==typeof Qn[a]){var s=a+"="+Qn[a];o.push(s),i+=s.length}if(i>1024)throw new Error("Environment size exceeded TOTAL_ENV_SIZE!");for(var c=0;c<o.length;c++)jn(s=o[c],e),X[r+4*c>>2]=e,e+=s.length+1;X[r+4*o.length>>2]=0}function tt(){wo()}function et(){return s||"undefined"!=typeof dateNow||(i||a)&&self.performance&&self.performance.now}var rt={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function ot(t){return n.___errno_location&&(X[n.___errno_location()>>2]=t),t}function it(n,t){var e;if(0===n)e=Date.now();else{if(1!==n||!et())return ot(rt.EINVAL),-1;e=tt()}return X[t>>2]=e/1e3|0,X[t+4>>2]=e%1e3*1e3*1e3|0,0}function at(){return it.apply(null,arguments)}function st(n){return uo(n)}var ct={last:0,caught:[],infos:{},deAdjust:function(n){if(!n||ct.infos[n])return n;for(var t in ct.infos){var e=+t;if(ct.infos[e].adjusted===n)return e}return n},addRef:function(n){n&&ct.infos[n].refcount++},decRef:function(t){if(t){var e=ct.infos[t];k(e.refcount>0),e.refcount--,0!==e.refcount||e.rethrown||(e.destructor&&n.dynCall_vi(e.destructor,t),delete ct.infos[t],ht(t))}},clearRef:function(n){n&&(ct.infos[n].refcount=0)}};function ut(n){var t=ct.infos[n];return t&&!t.caught&&(t.caught=!0,qr.uncaught_exception--),t&&(t.rethrown=!1),ct.caught.push(n),ct.addRef(ct.deAdjust(n)),n}function lt(){var n=ct.caught[ct.caught.length-1]||0;return n&&ct.addRef(ct.deAdjust(n)),n}function ft(n){ct.decRef(ct.deAdjust(n))}function dt(n){ct.addRef(ct.deAdjust(n))}function _t(){throw b=!0,"Pure virtual function called!"}function ht(n){try{return co(n)}catch(n){}}function mt(){n.setThrew(0);var t=ct.caught.pop();t&&(ct.decRef(ct.deAdjust(t)),ct.last=0)}function gt(){var n=ct.caught.pop();throw n=ct.deAdjust(n),ct.infos[n].rethrown||(ct.caught.push(n),ct.infos[n].rethrown=!0),ct.last=n,n+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function pt(n){n&&(ct.caught.push(n),ct.infos[n].rethrown=!0,gt())}function yt(n){throw ct.last||(ct.last=n),n+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function wt(){var t=ct.last;if(!t)return 0|(fo(0),0);var e=ct.infos[t],r=e.type;if(!r)return 0|(fo(0),t);var o=Array.prototype.slice.call(arguments);n.___cxa_is_pointer_type(r),wt.buffer||(wt.buffer=uo(4)),X[wt.buffer>>2]=t,t=wt.buffer;for(var i=0;i<o.length;i++)if(o[i]&&n.___cxa_can_catch(o[i],r,t))return t=X[t>>2],e.adjusted=t,0|(fo(o[i]),t);return t=X[t>>2],0|(fo(r),t)}function vt(n,t,e){throw ct.infos[n]={ptr:n,adjusted:n,type:t,destructor:e,refcount:0,caught:!1,rethrown:!1},ct.last=n,"uncaught_exception"in qr?qr.uncaught_exception++:qr.uncaught_exception=1,n+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function Et(){return!!qr.uncaught_exception}function bt(){}function kt(){}function xt(n,t){return ot(rt.EPERM),-1}var Mt={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"},St={splitPath:function(n){return/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/.exec(n).slice(1)},normalizeArray:function(n,t){for(var e=0,r=n.length-1;r>=0;r--){var o=n[r];"."===o?n.splice(r,1):".."===o?(n.splice(r,1),e++):e&&(n.splice(r,1),e--)}if(t)for(;e;e--)n.unshift("..");return n},normalize:function(n){var t="/"===n.charAt(0),e="/"===n.substr(-1);return(n=St.normalizeArray(n.split("/").filter((function(n){return!!n})),!t).join("/"))||t||(n="."),n&&e&&(n+="/"),(t?"/":"")+n},dirname:function(n){var t=St.splitPath(n),e=t[0],r=t[1];return e||r?(r&&(r=r.substr(0,r.length-1)),e+r):"."},basename:function(n){if("/"===n)return"/";var t=n.lastIndexOf("/");return-1===t?n:n.substr(t+1)},extname:function(n){return St.splitPath(n)[3]},join:function(){var n=Array.prototype.slice.call(arguments,0);return St.normalize(n.join("/"))},join2:function(n,t){return St.normalize(n+"/"+t)},resolve:function(){for(var n="",t=!1,e=arguments.length-1;e>=-1&&!t;e--){var r=e>=0?arguments[e]:Ot.cwd();if("string"!=typeof r)throw new TypeError("Arguments to path.resolve must be strings");if(!r)return"";n=r+"/"+n,t="/"===r.charAt(0)}return(t?"/":"")+(n=St.normalizeArray(n.split("/").filter((function(n){return!!n})),!t).join("/"))||"."},relative:function(n,t){function e(n){for(var t=0;t<n.length&&""===n[t];t++);for(var e=n.length-1;e>=0&&""===n[e];e--);return t>e?[]:n.slice(t,e-t+1)}n=St.resolve(n).substr(1),t=St.resolve(t).substr(1);for(var r=e(n.split("/")),o=e(t.split("/")),i=Math.min(r.length,o.length),a=i,s=0;s<i;s++)if(r[s]!==o[s]){a=s;break}var c=[];for(s=a;s<r.length;s++)c.push("..");return(c=c.concat(o.slice(a))).join("/")}},Dt={ttys:[],init:function(){},shutdown:function(){},register:function(n,t){Dt.ttys[n]={input:[],output:[],ops:t},Ot.registerDevice(n,Dt.stream_ops)},stream_ops:{open:function(n){var t=Dt.ttys[n.node.rdev];if(!t)throw new Ot.ErrnoError(rt.ENODEV);n.tty=t,n.seekable=!1},close:function(n){n.tty.ops.flush(n.tty)},flush:function(n){n.tty.ops.flush(n.tty)},read:function(n,t,e,r,o){if(!n.tty||!n.tty.ops.get_char)throw new Ot.ErrnoError(rt.ENXIO);for(var i=0,a=0;a<r;a++){var s;try{s=n.tty.ops.get_char(n.tty)}catch(n){throw new Ot.ErrnoError(rt.EIO)}if(void 0===s&&0===i)throw new Ot.ErrnoError(rt.EAGAIN);if(null==s)break;i++,t[e+a]=s}return i&&(n.node.timestamp=Date.now()),i},write:function(n,t,e,r,o){if(!n.tty||!n.tty.ops.put_char)throw new Ot.ErrnoError(rt.ENXIO);for(var i=0;i<r;i++)try{n.tty.ops.put_char(n.tty,t[e+i])}catch(n){throw new Ot.ErrnoError(rt.EIO)}return r&&(n.node.timestamp=Date.now()),i}},default_tty_ops:{get_char:function(n){if(!n.input.length){var t=null;if(s){var e=new Buffer(256),o=0,i="win32"!=r.platform,a=r.stdin.fd;if(i){var c=!1;try{a=qe.openSync("/dev/stdin","r"),c=!0}catch(n){}}try{o=qe.readSync(a,e,0,256,null)}catch(n){if(-1==n.toString().indexOf("EOF"))throw n;o=0}c&&qe.closeSync(a),t=o>0?e.slice(0,o).toString("utf-8"):null}else"undefined"!=typeof window&&"function"==typeof window.prompt?null!==(t=window.prompt("Input: "))&&(t+="\n"):"function"==typeof readline&&null!==(t=readline())&&(t+="\n");if(!t)return null;n.input=He(t,!0)}return n.input.shift()},put_char:function(n,t){null===t||10===t?(_(P(n.output,0)),n.output=[]):0!=t&&n.output.push(t)},flush:function(n){n.output&&n.output.length>0&&(_(P(n.output,0)),n.output=[])}},default_tty1_ops:{put_char:function(n,t){null===t||10===t?(h(P(n.output,0)),n.output=[]):0!=t&&n.output.push(t)},flush:function(n){n.output&&n.output.length>0&&(h(P(n.output,0)),n.output=[])}}},Tt={ops_table:null,mount:function(n){return Tt.createNode(null,"/",16895,0)},createNode:function(n,t,e,r){if(Ot.isBlkdev(e)||Ot.isFIFO(e))throw new Ot.ErrnoError(rt.EPERM);Tt.ops_table||(Tt.ops_table={dir:{node:{getattr:Tt.node_ops.getattr,setattr:Tt.node_ops.setattr,lookup:Tt.node_ops.lookup,mknod:Tt.node_ops.mknod,rename:Tt.node_ops.rename,unlink:Tt.node_ops.unlink,rmdir:Tt.node_ops.rmdir,readdir:Tt.node_ops.readdir,symlink:Tt.node_ops.symlink},stream:{llseek:Tt.stream_ops.llseek}},file:{node:{getattr:Tt.node_ops.getattr,setattr:Tt.node_ops.setattr},stream:{llseek:Tt.stream_ops.llseek,read:Tt.stream_ops.read,write:Tt.stream_ops.write,allocate:Tt.stream_ops.allocate,mmap:Tt.stream_ops.mmap,msync:Tt.stream_ops.msync}},link:{node:{getattr:Tt.node_ops.getattr,setattr:Tt.node_ops.setattr,readlink:Tt.node_ops.readlink},stream:{}},chrdev:{node:{getattr:Tt.node_ops.getattr,setattr:Tt.node_ops.setattr},stream:Ot.chrdev_stream_ops}});var o=Ot.createNode(n,t,e,r);return Ot.isDir(o.mode)?(o.node_ops=Tt.ops_table.dir.node,o.stream_ops=Tt.ops_table.dir.stream,o.contents={}):Ot.isFile(o.mode)?(o.node_ops=Tt.ops_table.file.node,o.stream_ops=Tt.ops_table.file.stream,o.usedBytes=0,o.contents=null):Ot.isLink(o.mode)?(o.node_ops=Tt.ops_table.link.node,o.stream_ops=Tt.ops_table.link.stream):Ot.isChrdev(o.mode)&&(o.node_ops=Tt.ops_table.chrdev.node,o.stream_ops=Tt.ops_table.chrdev.stream),o.timestamp=Date.now(),n&&(n.contents[t]=o),o},getFileDataAsRegularArray:function(n){if(n.contents&&n.contents.subarray){for(var t=[],e=0;e<n.usedBytes;++e)t.push(n.contents[e]);return t}return n.contents},getFileDataAsTypedArray:function(n){return n.contents?n.contents.subarray?n.contents.subarray(0,n.usedBytes):new Uint8Array(n.contents):new Uint8Array},expandFileStorage:function(n,t){if(n.contents&&n.contents.subarray&&t>n.contents.length&&(n.contents=Tt.getFileDataAsRegularArray(n),n.usedBytes=n.contents.length),!n.contents||n.contents.subarray){var e=n.contents?n.contents.length:0;if(e>=t)return;t=Math.max(t,e*(e<1048576?2:1.125)|0),0!=e&&(t=Math.max(t,256));var r=n.contents;return n.contents=new Uint8Array(t),void(n.usedBytes>0&&n.contents.set(r.subarray(0,n.usedBytes),0))}for(!n.contents&&t>0&&(n.contents=[]);n.contents.length<t;)n.contents.push(0)},resizeFileStorage:function(n,t){if(n.usedBytes!=t){if(0==t)return n.contents=null,void(n.usedBytes=0);if(!n.contents||n.contents.subarray){var e=n.contents;return n.contents=new Uint8Array(new ArrayBuffer(t)),e&&n.contents.set(e.subarray(0,Math.min(t,n.usedBytes))),void(n.usedBytes=t)}if(n.contents||(n.contents=[]),n.contents.length>t)n.contents.length=t;else for(;n.contents.length<t;)n.contents.push(0);n.usedBytes=t}},node_ops:{getattr:function(n){var t={};return t.dev=Ot.isChrdev(n.mode)?n.id:1,t.ino=n.id,t.mode=n.mode,t.nlink=1,t.uid=0,t.gid=0,t.rdev=n.rdev,Ot.isDir(n.mode)?t.size=4096:Ot.isFile(n.mode)?t.size=n.usedBytes:Ot.isLink(n.mode)?t.size=n.link.length:t.size=0,t.atime=new Date(n.timestamp),t.mtime=new Date(n.timestamp),t.ctime=new Date(n.timestamp),t.blksize=4096,t.blocks=Math.ceil(t.size/t.blksize),t},setattr:function(n,t){void 0!==t.mode&&(n.mode=t.mode),void 0!==t.timestamp&&(n.timestamp=t.timestamp),void 0!==t.size&&Tt.resizeFileStorage(n,t.size)},lookup:function(n,t){throw Ot.genericErrors[rt.ENOENT]},mknod:function(n,t,e,r){return Tt.createNode(n,t,e,r)},rename:function(n,t,e){if(Ot.isDir(n.mode)){var r;try{r=Ot.lookupNode(t,e)}catch(n){}if(r)for(var o in r.contents)throw new Ot.ErrnoError(rt.ENOTEMPTY)}delete n.parent.contents[n.name],n.name=e,t.contents[e]=n,n.parent=t},unlink:function(n,t){delete n.contents[t]},rmdir:function(n,t){var e=Ot.lookupNode(n,t);for(var r in e.contents)throw new Ot.ErrnoError(rt.ENOTEMPTY);delete n.contents[t]},readdir:function(n){var t=[".",".."];for(var e in n.contents)n.contents.hasOwnProperty(e)&&t.push(e);return t},symlink:function(n,t,e){var r=Tt.createNode(n,t,41471,0);return r.link=e,r},readlink:function(n){if(!Ot.isLink(n.mode))throw new Ot.ErrnoError(rt.EINVAL);return n.link}},stream_ops:{read:function(n,t,e,r,o){var i=n.node.contents;if(o>=n.node.usedBytes)return 0;var a=Math.min(n.node.usedBytes-o,r);if(k(a>=0),a>8&&i.subarray)t.set(i.subarray(o,o+a),e);else for(var s=0;s<a;s++)t[e+s]=i[o+s];return a},write:function(n,t,e,r,o,i){if(!r)return 0;var a=n.node;if(a.timestamp=Date.now(),t.subarray&&(!a.contents||a.contents.subarray)){if(i)return a.contents=t.subarray(e,e+r),a.usedBytes=r,r;if(0===a.usedBytes&&0===o)return a.contents=new Uint8Array(t.subarray(e,e+r)),a.usedBytes=r,r;if(o+r<=a.usedBytes)return a.contents.set(t.subarray(e,e+r),o),r}if(Tt.expandFileStorage(a,o+r),a.contents.subarray&&t.subarray)a.contents.set(t.subarray(e,e+r),o);else for(var s=0;s<r;s++)a.contents[o+s]=t[e+s];return a.usedBytes=Math.max(a.usedBytes,o+r),r},llseek:function(n,t,e){var r=t;if(1===e?r+=n.position:2===e&&Ot.isFile(n.node.mode)&&(r+=n.node.usedBytes),r<0)throw new Ot.ErrnoError(rt.EINVAL);return r},allocate:function(n,t,e){Tt.expandFileStorage(n.node,t+e),n.node.usedBytes=Math.max(n.node.usedBytes,t+e)},mmap:function(n,t,e,r,o,i,a){if(!Ot.isFile(n.node.mode))throw new Ot.ErrnoError(rt.ENODEV);var s,c,u=n.node.contents;if(2&a||u.buffer!==t&&u.buffer!==t.buffer){if((o>0||o+r<n.node.usedBytes)&&(u=u.subarray?u.subarray(o,o+r):Array.prototype.slice.call(u,o,o+r)),c=!0,!(s=uo(r)))throw new Ot.ErrnoError(rt.ENOMEM);t.set(u,s)}else c=!1,s=u.byteOffset;return{ptr:s,allocated:c}},msync:function(n,t,e,r,o){if(!Ot.isFile(n.node.mode))throw new Ot.ErrnoError(rt.ENODEV);return 2&o||Tt.stream_ops.write(n,t,0,r,e,!1),0}}},Ct={dbs:{},indexedDB:function(){if("undefined"!=typeof indexedDB)return indexedDB;var n=null;return"object"==typeof window&&(n=window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB),k(n,"IDBFS used, but indexedDB not supported"),n},DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:function(n){return Tt.mount.apply(null,arguments)},syncfs:function(n,t,e){Ct.getLocalSet(n,(function(r,o){if(r)return e(r);Ct.getRemoteSet(n,(function(n,r){if(n)return e(n);var i=t?r:o,a=t?o:r;Ct.reconcile(i,a,e)}))}))},getDB:function(n,t){var e,r=Ct.dbs[n];if(r)return t(null,r);try{e=Ct.indexedDB().open(n,Ct.DB_VERSION)}catch(n){return t(n)}if(!e)return t("Unable to connect to IndexedDB");e.onupgradeneeded=function(n){var t,e=n.target.result,r=n.target.transaction;(t=e.objectStoreNames.contains(Ct.DB_STORE_NAME)?r.objectStore(Ct.DB_STORE_NAME):e.createObjectStore(Ct.DB_STORE_NAME)).indexNames.contains("timestamp")||t.createIndex("timestamp","timestamp",{unique:!1})},e.onsuccess=function(){r=e.result,Ct.dbs[n]=r,t(null,r)},e.onerror=function(n){t(this.error),n.preventDefault()}},getLocalSet:function(n,t){var e={};function r(n){return"."!==n&&".."!==n}function o(n){return function(t){return St.join2(n,t)}}for(var i=Ot.readdir(n.mountpoint).filter(r).map(o(n.mountpoint));i.length;){var a,s=i.pop();try{a=Ot.stat(s)}catch(n){return t(n)}Ot.isDir(a.mode)&&i.push.apply(i,Ot.readdir(s).filter(r).map(o(s))),e[s]={timestamp:a.mtime}}return t(null,{type:"local",entries:e})},getRemoteSet:function(n,t){var e={};Ct.getDB(n.mountpoint,(function(n,r){if(n)return t(n);try{var o=r.transaction([Ct.DB_STORE_NAME],"readonly");o.onerror=function(n){t(this.error),n.preventDefault()},o.objectStore(Ct.DB_STORE_NAME).index("timestamp").openKeyCursor().onsuccess=function(n){var o=n.target.result;if(!o)return t(null,{type:"remote",db:r,entries:e});e[o.primaryKey]={timestamp:o.key},o.continue()}}catch(n){return t(n)}}))},loadLocalEntry:function(n,t){var e,r;try{r=Ot.lookupPath(n).node,e=Ot.stat(n)}catch(n){return t(n)}return Ot.isDir(e.mode)?t(null,{timestamp:e.mtime,mode:e.mode}):Ot.isFile(e.mode)?(r.contents=Tt.getFileDataAsTypedArray(r),t(null,{timestamp:e.mtime,mode:e.mode,contents:r.contents})):t(new Error("node type not supported"))},storeLocalEntry:function(n,t,e){try{if(Ot.isDir(t.mode))Ot.mkdir(n,t.mode);else{if(!Ot.isFile(t.mode))return e(new Error("node type not supported"));Ot.writeFile(n,t.contents,{canOwn:!0})}Ot.chmod(n,t.mode),Ot.utime(n,t.timestamp,t.timestamp)}catch(n){return e(n)}e(null)},removeLocalEntry:function(n,t){try{Ot.lookupPath(n);var e=Ot.stat(n);Ot.isDir(e.mode)?Ot.rmdir(n):Ot.isFile(e.mode)&&Ot.unlink(n)}catch(n){return t(n)}t(null)},loadRemoteEntry:function(n,t,e){var r=n.get(t);r.onsuccess=function(n){e(null,n.target.result)},r.onerror=function(n){e(this.error),n.preventDefault()}},storeRemoteEntry:function(n,t,e,r){var o=n.put(e,t);o.onsuccess=function(){r(null)},o.onerror=function(n){r(this.error),n.preventDefault()}},removeRemoteEntry:function(n,t,e){var r=n.delete(t);r.onsuccess=function(){e(null)},r.onerror=function(n){e(this.error),n.preventDefault()}},reconcile:function(n,t,e){var r=0,o=[];Object.keys(n.entries).forEach((function(e){var i=n.entries[e],a=t.entries[e];(!a||i.timestamp>a.timestamp)&&(o.push(e),r++)}));var i=[];if(Object.keys(t.entries).forEach((function(e){t.entries[e],n.entries[e]||(i.push(e),r++)})),!r)return e(null);var a=0,s=("remote"===n.type?n.db:t.db).transaction([Ct.DB_STORE_NAME],"readwrite"),c=s.objectStore(Ct.DB_STORE_NAME);function u(n){return n?u.errored?void 0:(u.errored=!0,e(n)):++a>=r?e(null):void 0}s.onerror=function(n){u(this.error),n.preventDefault()},o.sort().forEach((function(n){"local"===t.type?Ct.loadRemoteEntry(c,n,(function(t,e){if(t)return u(t);Ct.storeLocalEntry(n,e,u)})):Ct.loadLocalEntry(n,(function(t,e){if(t)return u(t);Ct.storeRemoteEntry(c,n,e,u)}))})),i.sort().reverse().forEach((function(n){"local"===t.type?Ct.removeLocalEntry(n,u):Ct.removeRemoteEntry(c,n,u)}))}},At={isWindows:!1,staticInit:function(){At.isWindows=!!r.platform.match(/^win/);var n=r.binding("constants");n.fs&&(n=n.fs),At.flagsForNodeMap={1024:n.O_APPEND,64:n.O_CREAT,128:n.O_EXCL,0:n.O_RDONLY,2:n.O_RDWR,4096:n.O_SYNC,512:n.O_TRUNC,1:n.O_WRONLY}},bufferFrom:function(n){return Buffer.alloc?Buffer.from(n):new Buffer(n)},mount:function(n){return k(s),At.createNode(null,"/",At.getMode(n.opts.root),0)},createNode:function(n,t,e,r){if(!Ot.isDir(e)&&!Ot.isFile(e)&&!Ot.isLink(e))throw new Ot.ErrnoError(rt.EINVAL);var o=Ot.createNode(n,t,e);return o.node_ops=At.node_ops,o.stream_ops=At.stream_ops,o},getMode:function(n){var t;try{t=qe.lstatSync(n),At.isWindows&&(t.mode=t.mode|(292&t.mode)>>2)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}return t.mode},realPath:function(n){for(var t=[];n.parent!==n;)t.push(n.name),n=n.parent;return t.push(n.mount.opts.root),t.reverse(),St.join.apply(null,t)},flagsForNode:function(n){n&=-2097153,n&=-2049,n&=-32769,n&=-524289;var t=0;for(var e in At.flagsForNodeMap)n&e&&(t|=At.flagsForNodeMap[e],n^=e);if(n)throw new Ot.ErrnoError(rt.EINVAL);return t},node_ops:{getattr:function(n){var t,e=At.realPath(n);try{t=qe.lstatSync(e)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}return At.isWindows&&!t.blksize&&(t.blksize=4096),At.isWindows&&!t.blocks&&(t.blocks=(t.size+t.blksize-1)/t.blksize|0),{dev:t.dev,ino:t.ino,mode:t.mode,nlink:t.nlink,uid:t.uid,gid:t.gid,rdev:t.rdev,size:t.size,atime:t.atime,mtime:t.mtime,ctime:t.ctime,blksize:t.blksize,blocks:t.blocks}},setattr:function(n,t){var e=At.realPath(n);try{if(void 0!==t.mode&&(qe.chmodSync(e,t.mode),n.mode=t.mode),void 0!==t.timestamp){var r=new Date(t.timestamp);qe.utimesSync(e,r,r)}void 0!==t.size&&qe.truncateSync(e,t.size)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}},lookup:function(n,t){var e=St.join2(At.realPath(n),t),r=At.getMode(e);return At.createNode(n,t,r)},mknod:function(n,t,e,r){var o=At.createNode(n,t,e,r),i=At.realPath(o);try{Ot.isDir(o.mode)?qe.mkdirSync(i,o.mode):qe.writeFileSync(i,"",{mode:o.mode})}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}return o},rename:function(n,t,e){var r=At.realPath(n),o=St.join2(At.realPath(t),e);try{qe.renameSync(r,o)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}},unlink:function(n,t){var e=St.join2(At.realPath(n),t);try{qe.unlinkSync(e)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}},rmdir:function(n,t){var e=St.join2(At.realPath(n),t);try{qe.rmdirSync(e)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}},readdir:function(n){var t=At.realPath(n);try{return qe.readdirSync(t)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}},symlink:function(n,t,e){var r=St.join2(At.realPath(n),t);try{qe.symlinkSync(e,r)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}},readlink:function(n){var t=At.realPath(n);try{return t=qe.readlinkSync(t),t=$e.relative($e.resolve(n.mount.opts.root),t)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}}},stream_ops:{open:function(n){var t=At.realPath(n.node);try{Ot.isFile(n.node.mode)&&(n.nfd=qe.openSync(t,At.flagsForNode(n.flags)))}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}},close:function(n){try{Ot.isFile(n.node.mode)&&n.nfd&&qe.closeSync(n.nfd)}catch(n){if(!n.code)throw n;throw new Ot.ErrnoError(rt[n.code])}},read:function(n,t,e,r,o){if(0===r)return 0;try{return qe.readSync(n.nfd,At.bufferFrom(t.buffer),e,r,o)}catch(n){throw new Ot.ErrnoError(rt[n.code])}},write:function(n,t,e,r,o){try{return qe.writeSync(n.nfd,At.bufferFrom(t.buffer),e,r,o)}catch(n){throw new Ot.ErrnoError(rt[n.code])}},llseek:function(n,t,e){var r=t;if(1===e)r+=n.position;else if(2===e&&Ot.isFile(n.node.mode))try{r+=qe.fstatSync(n.nfd).size}catch(n){throw new Ot.ErrnoError(rt[n.code])}if(r<0)throw new Ot.ErrnoError(rt.EINVAL);return r}}},Nt={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:function(n){k(a),Nt.reader||(Nt.reader=new FileReaderSync);var t=Nt.createNode(null,"/",Nt.DIR_MODE,0),e={};function r(n){for(var r=n.split("/"),o=t,i=0;i<r.length-1;i++){var a=r.slice(0,i+1).join("/");e[a]||(e[a]=Nt.createNode(o,r[i],Nt.DIR_MODE,0)),o=e[a]}return o}function o(n){var t=n.split("/");return t[t.length-1]}return Array.prototype.forEach.call(n.opts.files||[],(function(n){Nt.createNode(r(n.name),o(n.name),Nt.FILE_MODE,0,n,n.lastModifiedDate)})),(n.opts.blobs||[]).forEach((function(n){Nt.createNode(r(n.name),o(n.name),Nt.FILE_MODE,0,n.data)})),(n.opts.packages||[]).forEach((function(n){n.metadata.files.forEach((function(t){var e=t.filename.substr(1);Nt.createNode(r(e),o(e),Nt.FILE_MODE,0,n.blob.slice(t.start,t.end))}))})),t},createNode:function(n,t,e,r,o,i){var a=Ot.createNode(n,t,e);return a.mode=e,a.node_ops=Nt.node_ops,a.stream_ops=Nt.stream_ops,a.timestamp=(i||new Date).getTime(),k(Nt.FILE_MODE!==Nt.DIR_MODE),e===Nt.FILE_MODE?(a.size=o.size,a.contents=o):(a.size=4096,a.contents={}),n&&(n.contents[t]=a),a},node_ops:{getattr:function(n){return{dev:1,ino:void 0,mode:n.mode,nlink:1,uid:0,gid:0,rdev:void 0,size:n.size,atime:new Date(n.timestamp),mtime:new Date(n.timestamp),ctime:new Date(n.timestamp),blksize:4096,blocks:Math.ceil(n.size/4096)}},setattr:function(n,t){void 0!==t.mode&&(n.mode=t.mode),void 0!==t.timestamp&&(n.timestamp=t.timestamp)},lookup:function(n,t){throw new Ot.ErrnoError(rt.ENOENT)},mknod:function(n,t,e,r){throw new Ot.ErrnoError(rt.EPERM)},rename:function(n,t,e){throw new Ot.ErrnoError(rt.EPERM)},unlink:function(n,t){throw new Ot.ErrnoError(rt.EPERM)},rmdir:function(n,t){throw new Ot.ErrnoError(rt.EPERM)},readdir:function(n){var t=[".",".."];for(var e in n.contents)n.contents.hasOwnProperty(e)&&t.push(e);return t},symlink:function(n,t,e){throw new Ot.ErrnoError(rt.EPERM)},readlink:function(n){throw new Ot.ErrnoError(rt.EPERM)}},stream_ops:{read:function(n,t,e,r,o){if(o>=n.node.size)return 0;var i=n.node.contents.slice(o,o+r),a=Nt.reader.readAsArrayBuffer(i);return t.set(new Uint8Array(a),e),i.size},write:function(n,t,e,r,o){throw new Ot.ErrnoError(rt.EIO)},llseek:function(n,t,e){var r=t;if(1===e?r+=n.position:2===e&&Ot.isFile(n.node.mode)&&(r+=n.node.size),r<0)throw new Ot.ErrnoError(rt.EINVAL);return r}}};Q+=16,Q+=16;var Ot={root:null,mounts:[],devices:{},streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:!1,ignorePermissions:!0,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,syncFSRequests:0,handleFSError:function(n){if(!(n instanceof Ot.ErrnoError))throw n+" : "+$();return ot(n.errno)},lookupPath:function(n,t){if(t=t||{},!(n=St.resolve(Ot.cwd(),n)))return{path:"",node:null};var e={follow_mount:!0,recurse_count:0};for(var r in e)void 0===t[r]&&(t[r]=e[r]);if(t.recurse_count>8)throw new Ot.ErrnoError(rt.ELOOP);for(var o=St.normalizeArray(n.split("/").filter((function(n){return!!n})),!1),i=Ot.root,a="/",s=0;s<o.length;s++){var c=s===o.length-1;if(c&&t.parent)break;if(i=Ot.lookupNode(i,o[s]),a=St.join2(a,o[s]),Ot.isMountpoint(i)&&(!c||c&&t.follow_mount)&&(i=i.mounted.root),!c||t.follow)for(var u=0;Ot.isLink(i.mode);){var l=Ot.readlink(a);if(a=St.resolve(St.dirname(a),l),i=Ot.lookupPath(a,{recurse_count:t.recurse_count}).node,u++>40)throw new Ot.ErrnoError(rt.ELOOP)}}return{path:a,node:i}},getPath:function(n){for(var t;;){if(Ot.isRoot(n)){var e=n.mount.mountpoint;return t?"/"!==e[e.length-1]?e+"/"+t:e+t:e}t=t?n.name+"/"+t:n.name,n=n.parent}},hashName:function(n,t){for(var e=0,r=0;r<t.length;r++)e=(e<<5)-e+t.charCodeAt(r)|0;return(n+e>>>0)%Ot.nameTable.length},hashAddNode:function(n){var t=Ot.hashName(n.parent.id,n.name);n.name_next=Ot.nameTable[t],Ot.nameTable[t]=n},hashRemoveNode:function(n){var t=Ot.hashName(n.parent.id,n.name);if(Ot.nameTable[t]===n)Ot.nameTable[t]=n.name_next;else for(var e=Ot.nameTable[t];e;){if(e.name_next===n){e.name_next=n.name_next;break}e=e.name_next}},lookupNode:function(n,t){var e=Ot.mayLookup(n);if(e)throw new Ot.ErrnoError(e,n);for(var r=Ot.hashName(n.id,t),o=Ot.nameTable[r];o;o=o.name_next){var i=o.name;if(o.parent.id===n.id&&i===t)return o}return Ot.lookup(n,t)},createNode:function(n,t,e,r){if(!Ot.FSNode){Ot.FSNode=function(n,t,e,r){n||(n=this),this.parent=n,this.mount=n.mount,this.mounted=null,this.id=Ot.nextInode++,this.name=t,this.mode=e,this.node_ops={},this.stream_ops={},this.rdev=r},Ot.FSNode.prototype={};var o=365,i=146;Object.defineProperties(Ot.FSNode.prototype,{read:{get:function(){return(this.mode&o)===o},set:function(n){n?this.mode|=o:this.mode&=-366}},write:{get:function(){return(this.mode&i)===i},set:function(n){n?this.mode|=i:this.mode&=-147}},isFolder:{get:function(){return Ot.isDir(this.mode)}},isDevice:{get:function(){return Ot.isChrdev(this.mode)}}})}var a=new Ot.FSNode(n,t,e,r);return Ot.hashAddNode(a),a},destroyNode:function(n){Ot.hashRemoveNode(n)},isRoot:function(n){return n===n.parent},isMountpoint:function(n){return!!n.mounted},isFile:function(n){return 32768==(61440&n)},isDir:function(n){return 16384==(61440&n)},isLink:function(n){return 40960==(61440&n)},isChrdev:function(n){return 8192==(61440&n)},isBlkdev:function(n){return 24576==(61440&n)},isFIFO:function(n){return 4096==(61440&n)},isSocket:function(n){return 49152==(49152&n)},flagModes:{r:0,rs:1052672,"r+":2,w:577,wx:705,xw:705,"w+":578,"wx+":706,"xw+":706,a:1089,ax:1217,xa:1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function(n){var t=Ot.flagModes[n];if(void 0===t)throw new Error("Unknown file open mode: "+n);return t},flagsToPermissionString:function(n){var t=["r","w","rw"][3&n];return 512&n&&(t+="w"),t},nodePermissions:function(n,t){return Ot.ignorePermissions||(-1===t.indexOf("r")||292&n.mode)&&(-1===t.indexOf("w")||146&n.mode)&&(-1===t.indexOf("x")||73&n.mode)?0:rt.EACCES},mayLookup:function(n){return Ot.nodePermissions(n,"x")||(n.node_ops.lookup?0:rt.EACCES)},mayCreate:function(n,t){try{return Ot.lookupNode(n,t),rt.EEXIST}catch(n){}return Ot.nodePermissions(n,"wx")},mayDelete:function(n,t,e){var r;try{r=Ot.lookupNode(n,t)}catch(n){return n.errno}var o=Ot.nodePermissions(n,"wx");if(o)return o;if(e){if(!Ot.isDir(r.mode))return rt.ENOTDIR;if(Ot.isRoot(r)||Ot.getPath(r)===Ot.cwd())return rt.EBUSY}else if(Ot.isDir(r.mode))return rt.EISDIR;return 0},mayOpen:function(n,t){return n?Ot.isLink(n.mode)?rt.ELOOP:Ot.isDir(n.mode)&&("r"!==Ot.flagsToPermissionString(t)||512&t)?rt.EISDIR:Ot.nodePermissions(n,Ot.flagsToPermissionString(t)):rt.ENOENT},MAX_OPEN_FDS:4096,nextfd:function(n,t){n=n||0,t=t||Ot.MAX_OPEN_FDS;for(var e=n;e<=t;e++)if(!Ot.streams[e])return e;throw new Ot.ErrnoError(rt.EMFILE)},getStream:function(n){return Ot.streams[n]},createStream:function(n,t,e){Ot.FSStream||(Ot.FSStream=function(){},Ot.FSStream.prototype={},Object.defineProperties(Ot.FSStream.prototype,{object:{get:function(){return this.node},set:function(n){this.node=n}},isRead:{get:function(){return 1!=(2097155&this.flags)}},isWrite:{get:function(){return 0!=(2097155&this.flags)}},isAppend:{get:function(){return 1024&this.flags}}}));var r=new Ot.FSStream;for(var o in n)r[o]=n[o];n=r;var i=Ot.nextfd(t,e);return n.fd=i,Ot.streams[i]=n,n},closeStream:function(n){Ot.streams[n]=null},chrdev_stream_ops:{open:function(n){var t=Ot.getDevice(n.node.rdev);n.stream_ops=t.stream_ops,n.stream_ops.open&&n.stream_ops.open(n)},llseek:function(){throw new Ot.ErrnoError(rt.ESPIPE)}},major:function(n){return n>>8},minor:function(n){return 255&n},makedev:function(n,t){return n<<8|t},registerDevice:function(n,t){Ot.devices[n]={stream_ops:t}},getDevice:function(n){return Ot.devices[n]},getMounts:function(n){for(var t=[],e=[n];e.length;){var r=e.pop();t.push(r),e.push.apply(e,r.mounts)}return t},syncfs:function(n,t){"function"==typeof n&&(t=n,n=!1),Ot.syncFSRequests++,Ot.syncFSRequests>1&&console.log("warning: "+Ot.syncFSRequests+" FS.syncfs operations in flight at once, probably just doing extra work");var e=Ot.getMounts(Ot.root.mount),r=0;function o(n){return k(Ot.syncFSRequests>0),Ot.syncFSRequests--,t(n)}function i(n){if(n)return i.errored?void 0:(i.errored=!0,o(n));++r>=e.length&&o(null)}e.forEach((function(t){if(!t.type.syncfs)return i(null);t.type.syncfs(t,n,i)}))},mount:function(n,t,e){var r,o="/"===e,i=!e;if(o&&Ot.root)throw new Ot.ErrnoError(rt.EBUSY);if(!o&&!i){var a=Ot.lookupPath(e,{follow_mount:!1});if(e=a.path,r=a.node,Ot.isMountpoint(r))throw new Ot.ErrnoError(rt.EBUSY);if(!Ot.isDir(r.mode))throw new Ot.ErrnoError(rt.ENOTDIR)}var s={type:n,opts:t,mountpoint:e,mounts:[]},c=n.mount(s);return c.mount=s,s.root=c,o?Ot.root=c:r&&(r.mounted=s,r.mount&&r.mount.mounts.push(s)),c},unmount:function(n){var t=Ot.lookupPath(n,{follow_mount:!1});if(!Ot.isMountpoint(t.node))throw new Ot.ErrnoError(rt.EINVAL);var e=t.node,r=e.mounted,o=Ot.getMounts(r);Object.keys(Ot.nameTable).forEach((function(n){for(var t=Ot.nameTable[n];t;){var e=t.name_next;-1!==o.indexOf(t.mount)&&Ot.destroyNode(t),t=e}})),e.mounted=null;var i=e.mount.mounts.indexOf(r);k(-1!==i),e.mount.mounts.splice(i,1)},lookup:function(n,t){return n.node_ops.lookup(n,t)},mknod:function(n,t,e){var r=Ot.lookupPath(n,{parent:!0}).node,o=St.basename(n);if(!o||"."===o||".."===o)throw new Ot.ErrnoError(rt.EINVAL);var i=Ot.mayCreate(r,o);if(i)throw new Ot.ErrnoError(i);if(!r.node_ops.mknod)throw new Ot.ErrnoError(rt.EPERM);return r.node_ops.mknod(r,o,t,e)},create:function(n,t){return t=void 0!==t?t:438,t&=4095,t|=32768,Ot.mknod(n,t,0)},mkdir:function(n,t){return t=void 0!==t?t:511,t&=1023,t|=16384,Ot.mknod(n,t,0)},mkdirTree:function(n,t){for(var e=n.split("/"),r="",o=0;o<e.length;++o)if(e[o]){r+="/"+e[o];try{Ot.mkdir(r,t)}catch(n){if(n.errno!=rt.EEXIST)throw n}}},mkdev:function(n,t,e){return void 0===e&&(e=t,t=438),t|=8192,Ot.mknod(n,t,e)},symlink:function(n,t){if(!St.resolve(n))throw new Ot.ErrnoError(rt.ENOENT);var e=Ot.lookupPath(t,{parent:!0}).node;if(!e)throw new Ot.ErrnoError(rt.ENOENT);var r=St.basename(t),o=Ot.mayCreate(e,r);if(o)throw new Ot.ErrnoError(o);if(!e.node_ops.symlink)throw new Ot.ErrnoError(rt.EPERM);return e.node_ops.symlink(e,r,n)},rename:function(n,t){var e,r,o=St.dirname(n),i=St.dirname(t),a=St.basename(n),s=St.basename(t);try{e=Ot.lookupPath(n,{parent:!0}).node,r=Ot.lookupPath(t,{parent:!0}).node}catch(n){throw new Ot.ErrnoError(rt.EBUSY)}if(!e||!r)throw new Ot.ErrnoError(rt.ENOENT);if(e.mount!==r.mount)throw new Ot.ErrnoError(rt.EXDEV);var c,u=Ot.lookupNode(e,a),l=St.relative(n,i);if("."!==l.charAt(0))throw new Ot.ErrnoError(rt.EINVAL);if("."!==(l=St.relative(t,o)).charAt(0))throw new Ot.ErrnoError(rt.ENOTEMPTY);try{c=Ot.lookupNode(r,s)}catch(n){}if(u!==c){var f=Ot.isDir(u.mode),d=Ot.mayDelete(e,a,f);if(d)throw new Ot.ErrnoError(d);if(d=c?Ot.mayDelete(r,s,f):Ot.mayCreate(r,s))throw new Ot.ErrnoError(d);if(!e.node_ops.rename)throw new Ot.ErrnoError(rt.EPERM);if(Ot.isMountpoint(u)||c&&Ot.isMountpoint(c))throw new Ot.ErrnoError(rt.EBUSY);if(r!==e&&(d=Ot.nodePermissions(e,"w")))throw new Ot.ErrnoError(d);Ot.hashRemoveNode(u);try{e.node_ops.rename(u,r,s)}catch(n){throw n}finally{Ot.hashAddNode(u)}}},rmdir:function(n){var t=Ot.lookupPath(n,{parent:!0}).node,e=St.basename(n),r=Ot.lookupNode(t,e),o=Ot.mayDelete(t,e,!0);if(o)throw new Ot.ErrnoError(o);if(!t.node_ops.rmdir)throw new Ot.ErrnoError(rt.EPERM);if(Ot.isMountpoint(r))throw new Ot.ErrnoError(rt.EBUSY);t.node_ops.rmdir(t,e),Ot.destroyNode(r)},readdir:function(n){var t=Ot.lookupPath(n,{follow:!0}).node;if(!t.node_ops.readdir)throw new Ot.ErrnoError(rt.ENOTDIR);return t.node_ops.readdir(t)},unlink:function(n){var t=Ot.lookupPath(n,{parent:!0}).node,e=St.basename(n),r=Ot.lookupNode(t,e),o=Ot.mayDelete(t,e,!1);if(o)throw new Ot.ErrnoError(o);if(!t.node_ops.unlink)throw new Ot.ErrnoError(rt.EPERM);if(Ot.isMountpoint(r))throw new Ot.ErrnoError(rt.EBUSY);t.node_ops.unlink(t,e),Ot.destroyNode(r)},readlink:function(n){var t=Ot.lookupPath(n).node;if(!t)throw new Ot.ErrnoError(rt.ENOENT);if(!t.node_ops.readlink)throw new Ot.ErrnoError(rt.EINVAL);return St.resolve(Ot.getPath(t.parent),t.node_ops.readlink(t))},stat:function(n,t){var e=Ot.lookupPath(n,{follow:!t}).node;if(!e)throw new Ot.ErrnoError(rt.ENOENT);if(!e.node_ops.getattr)throw new Ot.ErrnoError(rt.EPERM);return e.node_ops.getattr(e)},lstat:function(n){return Ot.stat(n,!0)},chmod:function(n,t,e){var r;if(!(r="string"==typeof n?Ot.lookupPath(n,{follow:!e}).node:n).node_ops.setattr)throw new Ot.ErrnoError(rt.EPERM);r.node_ops.setattr(r,{mode:4095&t|-4096&r.mode,timestamp:Date.now()})},lchmod:function(n,t){Ot.chmod(n,t,!0)},fchmod:function(n,t){var e=Ot.getStream(n);if(!e)throw new Ot.ErrnoError(rt.EBADF);Ot.chmod(e.node,t)},chown:function(n,t,e,r){var o;if(!(o="string"==typeof n?Ot.lookupPath(n,{follow:!r}).node:n).node_ops.setattr)throw new Ot.ErrnoError(rt.EPERM);o.node_ops.setattr(o,{timestamp:Date.now()})},lchown:function(n,t,e){Ot.chown(n,t,e,!0)},fchown:function(n,t,e){var r=Ot.getStream(n);if(!r)throw new Ot.ErrnoError(rt.EBADF);Ot.chown(r.node,t,e)},truncate:function(n,t){if(t<0)throw new Ot.ErrnoError(rt.EINVAL);var e;if(!(e="string"==typeof n?Ot.lookupPath(n,{follow:!0}).node:n).node_ops.setattr)throw new Ot.ErrnoError(rt.EPERM);if(Ot.isDir(e.mode))throw new Ot.ErrnoError(rt.EISDIR);if(!Ot.isFile(e.mode))throw new Ot.ErrnoError(rt.EINVAL);var r=Ot.nodePermissions(e,"w");if(r)throw new Ot.ErrnoError(r);e.node_ops.setattr(e,{size:t,timestamp:Date.now()})},ftruncate:function(n,t){var e=Ot.getStream(n);if(!e)throw new Ot.ErrnoError(rt.EBADF);if(0==(2097155&e.flags))throw new Ot.ErrnoError(rt.EINVAL);Ot.truncate(e.node,t)},utime:function(n,t,e){var r=Ot.lookupPath(n,{follow:!0}).node;r.node_ops.setattr(r,{timestamp:Math.max(t,e)})},open:function(t,e,r,o,i){if(""===t)throw new Ot.ErrnoError(rt.ENOENT);var a;if(r=void 0===r?438:r,r=64&(e="string"==typeof e?Ot.modeStringToFlags(e):e)?4095&r|32768:0,"object"==typeof t)a=t;else{t=St.normalize(t);try{a=Ot.lookupPath(t,{follow:!(131072&e)}).node}catch(n){}}var s=!1;if(64&e)if(a){if(128&e)throw new Ot.ErrnoError(rt.EEXIST)}else a=Ot.mknod(t,r,0),s=!0;if(!a)throw new Ot.ErrnoError(rt.ENOENT);if(Ot.isChrdev(a.mode)&&(e&=-513),65536&e&&!Ot.isDir(a.mode))throw new Ot.ErrnoError(rt.ENOTDIR);if(!s){var c=Ot.mayOpen(a,e);if(c)throw new Ot.ErrnoError(c)}512&e&&Ot.truncate(a,0),e&=-641;var u=Ot.createStream({node:a,path:Ot.getPath(a),flags:e,seekable:!0,position:0,stream_ops:a.stream_ops,ungotten:[],error:!1},o,i);return u.stream_ops.open&&u.stream_ops.open(u),!n.logReadFiles||1&e||(Ot.readFiles||(Ot.readFiles={}),t in Ot.readFiles||(Ot.readFiles[t]=1,c("read file: "+t))),u},close:function(n){if(Ot.isClosed(n))throw new Ot.ErrnoError(rt.EBADF);n.getdents&&(n.getdents=null);try{n.stream_ops.close&&n.stream_ops.close(n)}catch(n){throw n}finally{Ot.closeStream(n.fd)}n.fd=null},isClosed:function(n){return null===n.fd},llseek:function(n,t,e){if(Ot.isClosed(n))throw new Ot.ErrnoError(rt.EBADF);if(!n.seekable||!n.stream_ops.llseek)throw new Ot.ErrnoError(rt.ESPIPE);return n.position=n.stream_ops.llseek(n,t,e),n.ungotten=[],n.position},read:function(n,t,e,r,o){if(r<0||o<0)throw new Ot.ErrnoError(rt.EINVAL);if(Ot.isClosed(n))throw new Ot.ErrnoError(rt.EBADF);if(1==(2097155&n.flags))throw new Ot.ErrnoError(rt.EBADF);if(Ot.isDir(n.node.mode))throw new Ot.ErrnoError(rt.EISDIR);if(!n.stream_ops.read)throw new Ot.ErrnoError(rt.EINVAL);var i=void 0!==o;if(i){if(!n.seekable)throw new Ot.ErrnoError(rt.ESPIPE)}else o=n.position;var a=n.stream_ops.read(n,t,e,r,o);return i||(n.position+=a),a},write:function(n,t,e,r,o,i){if(r<0||o<0)throw new Ot.ErrnoError(rt.EINVAL);if(Ot.isClosed(n))throw new Ot.ErrnoError(rt.EBADF);if(0==(2097155&n.flags))throw new Ot.ErrnoError(rt.EBADF);if(Ot.isDir(n.node.mode))throw new Ot.ErrnoError(rt.EISDIR);if(!n.stream_ops.write)throw new Ot.ErrnoError(rt.EINVAL);1024&n.flags&&Ot.llseek(n,0,2);var a=void 0!==o;if(a){if(!n.seekable)throw new Ot.ErrnoError(rt.ESPIPE)}else o=n.position;var s=n.stream_ops.write(n,t,e,r,o,i);a||(n.position+=s);try{n.path&&Ot.trackingDelegate.onWriteToFile&&Ot.trackingDelegate.onWriteToFile(n.path)}catch(n){console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: "+n.message)}return s},allocate:function(n,t,e){if(Ot.isClosed(n))throw new Ot.ErrnoError(rt.EBADF);if(t<0||e<=0)throw new Ot.ErrnoError(rt.EINVAL);if(0==(2097155&n.flags))throw new Ot.ErrnoError(rt.EBADF);if(!Ot.isFile(n.node.mode)&&!Ot.isDir(n.node.mode))throw new Ot.ErrnoError(rt.ENODEV);if(!n.stream_ops.allocate)throw new Ot.ErrnoError(rt.EOPNOTSUPP);n.stream_ops.allocate(n,t,e)},mmap:function(n,t,e,r,o,i,a){if(1==(2097155&n.flags))throw new Ot.ErrnoError(rt.EACCES);if(!n.stream_ops.mmap)throw new Ot.ErrnoError(rt.ENODEV);return n.stream_ops.mmap(n,t,e,r,o,i,a)},msync:function(n,t,e,r,o){return n&&n.stream_ops.msync?n.stream_ops.msync(n,t,e,r,o):0},munmap:function(n){return 0},ioctl:function(n,t,e){if(!n.stream_ops.ioctl)throw new Ot.ErrnoError(rt.ENOTTY);return n.stream_ops.ioctl(n,t,e)},readFile:function(n,t){if((t=t||{}).flags=t.flags||"r",t.encoding=t.encoding||"binary","utf8"!==t.encoding&&"binary"!==t.encoding)throw new Error('Invalid encoding type "'+t.encoding+'"');var e,r=Ot.open(n,t.flags),o=Ot.stat(n).size,i=new Uint8Array(o);return Ot.read(r,i,0,o,0),"utf8"===t.encoding?e=P(i,0):"binary"===t.encoding&&(e=i),Ot.close(r),e},writeFile:function(n,t,e){(e=e||{}).flags=e.flags||"w";var r=Ot.open(n,e.flags,e.mode);if("string"==typeof t){var o=new Uint8Array(B(t)+1),i=L(t,o,0,o.length);Ot.write(r,o,0,i,void 0,e.canOwn)}else{if(!ArrayBuffer.isView(t))throw new Error("Unsupported data type");Ot.write(r,t,0,t.byteLength,void 0,e.canOwn)}Ot.close(r)},cwd:function(){return Ot.currentPath},chdir:function(n){var t=Ot.lookupPath(n,{follow:!0});if(null===t.node)throw new Ot.ErrnoError(rt.ENOENT);if(!Ot.isDir(t.node.mode))throw new Ot.ErrnoError(rt.ENOTDIR);var e=Ot.nodePermissions(t.node,"x");if(e)throw new Ot.ErrnoError(e);Ot.currentPath=t.path},createDefaultDirectories:function(){Ot.mkdir("/tmp"),Ot.mkdir("/home"),Ot.mkdir("/home/web_user")},createDefaultDevices:function(){var n;if(Ot.mkdir("/dev"),Ot.registerDevice(Ot.makedev(1,3),{read:function(){return 0},write:function(n,t,e,r,o){return r}}),Ot.mkdev("/dev/null",Ot.makedev(1,3)),Dt.register(Ot.makedev(5,0),Dt.default_tty_ops),Dt.register(Ot.makedev(6,0),Dt.default_tty1_ops),Ot.mkdev("/dev/tty",Ot.makedev(5,0)),Ot.mkdev("/dev/tty1",Ot.makedev(6,0)),"undefined"!=typeof crypto){var t=new Uint8Array(1);n=function(){return crypto.getRandomValues(t),t[0]}}else n=s?function(){return Sn.randomBytes(1)[0]}:function(){return 256*Math.random()|0};Ot.createDevice("/dev","random",n),Ot.createDevice("/dev","urandom",n),Ot.mkdir("/dev/shm"),Ot.mkdir("/dev/shm/tmp")},createSpecialDirectories:function(){Ot.mkdir("/proc"),Ot.mkdir("/proc/self"),Ot.mkdir("/proc/self/fd"),Ot.mount({mount:function(){var n=Ot.createNode("/proc/self","fd",16895,73);return n.node_ops={lookup:function(n,t){var e=+t,r=Ot.getStream(e);if(!r)throw new Ot.ErrnoError(rt.EBADF);var o={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:function(){return r.path}}};return o.parent=o,o}},n}},{},"/proc/self/fd")},createStandardStreams:function(){n.stdin?Ot.createDevice("/dev","stdin",n.stdin):Ot.symlink("/dev/tty","/dev/stdin"),n.stdout?Ot.createDevice("/dev","stdout",null,n.stdout):Ot.symlink("/dev/tty","/dev/stdout"),n.stderr?Ot.createDevice("/dev","stderr",null,n.stderr):Ot.symlink("/dev/tty1","/dev/stderr");var t=Ot.open("/dev/stdin","r");k(0===t.fd,"invalid handle for stdin ("+t.fd+")");var e=Ot.open("/dev/stdout","w");k(1===e.fd,"invalid handle for stdout ("+e.fd+")");var r=Ot.open("/dev/stderr","w");k(2===r.fd,"invalid handle for stderr ("+r.fd+")")},ensureErrnoError:function(){Ot.ErrnoError||(Ot.ErrnoError=function(n,t){this.node=t,this.setErrno=function(n){for(var t in this.errno=n,rt)if(rt[t]===n){this.code=t;break}},this.setErrno(n),this.message=Mt[n],this.stack&&Object.defineProperty(this,"stack",{value:(new Error).stack,writable:!0})},Ot.ErrnoError.prototype=new Error,Ot.ErrnoError.prototype.constructor=Ot.ErrnoError,[rt.ENOENT].forEach((function(n){Ot.genericErrors[n]=new Ot.ErrnoError(n),Ot.genericErrors[n].stack="<generic error, no stack>"})))},staticInit:function(){Ot.ensureErrnoError(),Ot.nameTable=new Array(4096),Ot.mount(Tt,{},"/"),Ot.createDefaultDirectories(),Ot.createDefaultDevices(),Ot.createSpecialDirectories(),Ot.filesystems={MEMFS:Tt,IDBFS:Ct,NODEFS:At,WORKERFS:Nt}},init:function(t,e,r){k(!Ot.init.initialized,"FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)"),Ot.init.initialized=!0,Ot.ensureErrnoError(),n.stdin=t||n.stdin,n.stdout=e||n.stdout,n.stderr=r||n.stderr,Ot.createStandardStreams()},quit:function(){Ot.init.initialized=!1;var t=n._fflush;t&&t(0);for(var e=0;e<Ot.streams.length;e++){var r=Ot.streams[e];r&&Ot.close(r)}},getMode:function(n,t){var e=0;return n&&(e|=365),t&&(e|=146),e},joinPath:function(n,t){var e=St.join.apply(null,n);return t&&"/"==e[0]&&(e=e.substr(1)),e},absolutePath:function(n,t){return St.resolve(t,n)},standardizePath:function(n){return St.normalize(n)},findObject:function(n,t){var e=Ot.analyzePath(n,t);return e.exists?e.object:(ot(e.error),null)},analyzePath:function(n,t){try{n=(r=Ot.lookupPath(n,{follow:!t})).path}catch(n){}var e={isRoot:!1,exists:!1,error:0,name:null,path:null,object:null,parentExists:!1,parentPath:null,parentObject:null};try{var r=Ot.lookupPath(n,{parent:!0});e.parentExists=!0,e.parentPath=r.path,e.parentObject=r.node,e.name=St.basename(n),r=Ot.lookupPath(n,{follow:!t}),e.exists=!0,e.path=r.path,e.object=r.node,e.name=r.node.name,e.isRoot="/"===r.path}catch(n){e.error=n.errno}return e},createFolder:function(n,t,e,r){var o=St.join2("string"==typeof n?n:Ot.getPath(n),t),i=Ot.getMode(e,r);return Ot.mkdir(o,i)},createPath:function(n,t,e,r){n="string"==typeof n?n:Ot.getPath(n);for(var o=t.split("/").reverse();o.length;){var i=o.pop();if(i){var a=St.join2(n,i);try{Ot.mkdir(a)}catch(n){}n=a}}return a},createFile:function(n,t,e,r,o){var i=St.join2("string"==typeof n?n:Ot.getPath(n),t),a=Ot.getMode(r,o);return Ot.create(i,a)},createDataFile:function(n,t,e,r,o,i){var a=t?St.join2("string"==typeof n?n:Ot.getPath(n),t):n,s=Ot.getMode(r,o),c=Ot.create(a,s);if(e){if("string"==typeof e){for(var u=new Array(e.length),l=0,f=e.length;l<f;++l)u[l]=e.charCodeAt(l);e=u}Ot.chmod(c,146|s);var d=Ot.open(c,"w");Ot.write(d,e,0,e.length,0,i),Ot.close(d),Ot.chmod(c,s)}return c},createDevice:function(n,t,e,r){var o=St.join2("string"==typeof n?n:Ot.getPath(n),t),i=Ot.getMode(!!e,!!r);Ot.createDevice.major||(Ot.createDevice.major=64);var a=Ot.makedev(Ot.createDevice.major++,0);return Ot.registerDevice(a,{open:function(n){n.seekable=!1},close:function(n){r&&r.buffer&&r.buffer.length&&r(10)},read:function(n,t,r,o,i){for(var a=0,s=0;s<o;s++){var c;try{c=e()}catch(n){throw new Ot.ErrnoError(rt.EIO)}if(void 0===c&&0===a)throw new Ot.ErrnoError(rt.EAGAIN);if(null==c)break;a++,t[r+s]=c}return a&&(n.node.timestamp=Date.now()),a},write:function(n,t,e,o,i){for(var a=0;a<o;a++)try{r(t[e+a])}catch(n){throw new Ot.ErrnoError(rt.EIO)}return o&&(n.node.timestamp=Date.now()),a}}),Ot.mkdev(o,i,a)},createLink:function(n,t,e,r,o){var i=St.join2("string"==typeof n?n:Ot.getPath(n),t);return Ot.symlink(e,i)},forceLoadFile:function(t){if(t.isDevice||t.isFolder||t.link||t.contents)return!0;var e=!0;if("undefined"!=typeof XMLHttpRequest)throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");if(!n.read)throw new Error("Cannot load without read() or XMLHttpRequest.");try{t.contents=He(n.read(t.url),!0),t.usedBytes=t.contents.length}catch(n){e=!1}return e||ot(rt.EIO),e},createLazyFile:function(n,t,e,r,o){function i(){this.lengthKnown=!1,this.chunks=[]}if(i.prototype.get=function(n){if(!(n>this.length-1||n<0)){var t=n%this.chunkSize,e=n/this.chunkSize|0;return this.getter(e)[t]}},i.prototype.setDataGetter=function(n){this.getter=n},i.prototype.cacheLength=function(){var n=new XMLHttpRequest;if(n.open("HEAD",e,!1),n.send(null),!(n.status>=200&&n.status<300||304===n.status))throw new Error("Couldn't load "+e+". Status: "+n.status);var t,r=Number(n.getResponseHeader("Content-length")),o=(t=n.getResponseHeader("Accept-Ranges"))&&"bytes"===t,i=(t=n.getResponseHeader("Content-Encoding"))&&"gzip"===t,a=1048576;o||(a=r);var s=this;s.setDataGetter((function(n){var t=n*a,o=(n+1)*a-1;if(o=Math.min(o,r-1),void 0===s.chunks[n]&&(s.chunks[n]=function(n,t){if(n>t)throw new Error("invalid range ("+n+", "+t+") or no bytes requested!");if(t>r-1)throw new Error("only "+r+" bytes available! programmer error!");var o=new XMLHttpRequest;if(o.open("GET",e,!1),r!==a&&o.setRequestHeader("Range","bytes="+n+"-"+t),"undefined"!=typeof Uint8Array&&(o.responseType="arraybuffer"),o.overrideMimeType&&o.overrideMimeType("text/plain; charset=x-user-defined"),o.send(null),!(o.status>=200&&o.status<300||304===o.status))throw new Error("Couldn't load "+e+". Status: "+o.status);return void 0!==o.response?new Uint8Array(o.response||[]):He(o.responseText||"",!0)}(t,o)),void 0===s.chunks[n])throw new Error("doXHR failed!");return s.chunks[n]})),!i&&r||(a=r=1,r=this.getter(0).length,a=r,console.log("LazyFiles on gzip forces download of the whole file when length is accessed")),this._length=r,this._chunkSize=a,this.lengthKnown=!0},"undefined"!=typeof XMLHttpRequest){if(!a)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var s=new i;Object.defineProperties(s,{length:{get:function(){return this.lengthKnown||this.cacheLength(),this._length}},chunkSize:{get:function(){return this.lengthKnown||this.cacheLength(),this._chunkSize}}});var c={isDevice:!1,contents:s}}else c={isDevice:!1,url:e};var u=Ot.createFile(n,t,c,r,o);c.contents?u.contents=c.contents:c.url&&(u.contents=null,u.url=c.url),Object.defineProperties(u,{usedBytes:{get:function(){return this.contents.length}}});var l={};return Object.keys(u.stream_ops).forEach((function(n){var t=u.stream_ops[n];l[n]=function(){if(!Ot.forceLoadFile(u))throw new Ot.ErrnoError(rt.EIO);return t.apply(null,arguments)}})),l.read=function(n,t,e,r,o){if(!Ot.forceLoadFile(u))throw new Ot.ErrnoError(rt.EIO);var i=n.node.contents;if(o>=i.length)return 0;var a=Math.min(i.length-o,r);if(k(a>=0),i.slice)for(var s=0;s<a;s++)t[e+s]=i[o+s];else for(s=0;s<a;s++)t[e+s]=i.get(o+s);return a},u.stream_ops=l,u},createPreloadedFile:function(t,e,r,o,i,a,s,c,u,l){Browser.init();var f=e?St.resolve(St.join2(t,e)):t;function d(r){function d(n){l&&l(),c||Ot.createDataFile(t,e,n,o,i,u),a&&a(),$n()}var _=!1;n.preloadPlugins.forEach((function(n){_||n.canHandle(f)&&(n.handle(r,f,d,(function(){s&&s(),$n()})),_=!0)})),_||d(r)}qn(),"string"==typeof r?Browser.asyncLoad(r,(function(n){d(n)}),s):d(r)},indexedDB:function(){return window.indexedDB||window.mozIndexedDB||window.webkitIndexedDB||window.msIndexedDB},DB_NAME:function(){return"EM_FS_"+window.location.pathname},DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function(n,t,e){t=t||function(){},e=e||function(){};var r=Ot.indexedDB();try{var o=r.open(Ot.DB_NAME(),Ot.DB_VERSION)}catch(n){return e(n)}o.onupgradeneeded=function(){console.log("creating db"),o.result.createObjectStore(Ot.DB_STORE_NAME)},o.onsuccess=function(){var r=o.result.transaction([Ot.DB_STORE_NAME],"readwrite"),i=r.objectStore(Ot.DB_STORE_NAME),a=0,s=0,c=n.length;function u(){0==s?t():e()}n.forEach((function(n){var t=i.put(Ot.analyzePath(n).object.contents,n);t.onsuccess=function(){++a+s==c&&u()},t.onerror=function(){s++,a+s==c&&u()}})),r.onerror=e},o.onerror=e},loadFilesFromDB:function(n,t,e){t=t||function(){},e=e||function(){};var r=Ot.indexedDB();try{var o=r.open(Ot.DB_NAME(),Ot.DB_VERSION)}catch(n){return e(n)}o.onupgradeneeded=e,o.onsuccess=function(){var r=o.result;try{var i=r.transaction([Ot.DB_STORE_NAME],"readonly")}catch(n){return void e(n)}var a=i.objectStore(Ot.DB_STORE_NAME),s=0,c=0,u=n.length;function l(){0==c?t():e()}n.forEach((function(n){var t=a.get(n);t.onsuccess=function(){Ot.analyzePath(n).exists&&Ot.unlink(n),Ot.createDataFile(St.dirname(n),St.basename(n),t.result,!0,!0,!0),++s+c==u&&l()},t.onerror=function(){c++,s+c==u&&l()}})),i.onerror=e},o.onerror=e}},Ft={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:function(n,t){if("/"!==t[0]){var e;if(-100===n)e=Ot.cwd();else{var r=Ot.getStream(n);if(!r)throw new Ot.ErrnoError(rt.EBADF);e=r.path}t=St.join2(e,t)}return t},doStat:function(n,t,e){try{var r=n(t)}catch(n){if(n&&n.node&&St.normalize(t)!==St.normalize(Ot.getPath(n.node)))return-rt.ENOTDIR;throw n}return X[e>>2]=r.dev,X[e+4>>2]=0,X[e+8>>2]=r.ino,X[e+12>>2]=r.mode,X[e+16>>2]=r.nlink,X[e+20>>2]=r.uid,X[e+24>>2]=r.gid,X[e+28>>2]=r.rdev,X[e+32>>2]=0,X[e+36>>2]=r.size,X[e+40>>2]=4096,X[e+44>>2]=r.blocks,X[e+48>>2]=r.atime.getTime()/1e3|0,X[e+52>>2]=0,X[e+56>>2]=r.mtime.getTime()/1e3|0,X[e+60>>2]=0,X[e+64>>2]=r.ctime.getTime()/1e3|0,X[e+68>>2]=0,X[e+72>>2]=r.ino,0},doMsync:function(n,t,e,r){var o=new Uint8Array(W.subarray(n,n+e));Ot.msync(t,o,0,e,r)},doMkdir:function(n,t){return"/"===(n=St.normalize(n))[n.length-1]&&(n=n.substr(0,n.length-1)),Ot.mkdir(n,t,0),0},doMknod:function(n,t,e){switch(61440&t){case 32768:case 8192:case 24576:case 4096:case 49152:break;default:return-rt.EINVAL}return Ot.mknod(n,t,e),0},doReadlink:function(n,t,e){if(e<=0)return-rt.EINVAL;var r=Ot.readlink(n),o=Math.min(e,B(r)),i=V[t+o];return R(r,t,e+1),V[t+o]=i,o},doAccess:function(n,t){if(-8&t)return-rt.EINVAL;var e;e=Ot.lookupPath(n,{follow:!0}).node;var r="";return 4&t&&(r+="r"),2&t&&(r+="w"),1&t&&(r+="x"),r&&Ot.nodePermissions(e,r)?-rt.EACCES:0},doDup:function(n,t,e){var r=Ot.getStream(e);return r&&Ot.close(r),Ot.open(n,t,0,e,e).fd},doReadv:function(n,t,e,r){for(var o=0,i=0;i<e;i++){var a=X[t+8*i>>2],s=X[t+(8*i+4)>>2],c=Ot.read(n,V,a,s,r);if(c<0)return-1;if(o+=c,c<s)break}return o},doWritev:function(n,t,e,r){for(var o=0,i=0;i<e;i++){var a=X[t+8*i>>2],s=X[t+(8*i+4)>>2],c=Ot.write(n,V,a,s,r);if(c<0)return-1;o+=c}return o},varargs:0,get:function(n){return Ft.varargs+=4,X[Ft.varargs-4>>2]},getStr:function(){return z(Ft.get())},getStreamFromFD:function(){var n=Ot.getStream(Ft.get());if(!n)throw new Ot.ErrnoError(rt.EBADF);return n},getSocketFromFD:function(){var n=SOCKFS.getSocket(Ft.get());if(!n)throw new Ot.ErrnoError(rt.EBADF);return n},getSocketAddress:function(n){var t=Ft.get(),e=Ft.get();if(n&&0===t)return null;var r=__read_sockaddr(t,e);if(r.errno)throw new Ot.ErrnoError(r.errno);return r.addr=DNS.lookup_addr(r.addr)||r.addr,r},get64:function(){var n=Ft.get(),t=Ft.get();return k(n>=0?0===t:-1===t),n},getZero:function(){k(0===Ft.get())}};function zt(n,t){Ft.varargs=t;try{var e=Ft.getStr();return Ot.unlink(e),0}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function jt(n,t){Ft.varargs=t;try{var e=Ft.getStreamFromFD(),r=(Ft.get(),Ft.get()),o=Ft.get(),i=Ft.get(),a=r;return Ot.llseek(e,a,i),X[o>>2]=e.position,e.getdents&&0===a&&0===i&&(e.getdents=null),0}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Pt(n,t){Ft.varargs=t;try{var e=Ft.getStreamFromFD(),r=Ft.get(),o=Ft.get();return Ft.doReadv(e,r,o)}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function It(n,t){Ft.varargs=t;try{var e=Ft.getStreamFromFD(),r=Ft.get(),o=Ft.get();return Ft.doWritev(e,r,o)}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Lt(n,t){Ft.varargs=t;try{var e=Ft.getStr(),r=Ft.get();return Ft.doStat(Ot.lstat,e,r)}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Rt(n,t){Ft.varargs=t;try{var e=Ft.getStreamFromFD();switch(Ft.get()){case 0:return(r=Ft.get())<0?-rt.EINVAL:Ot.open(e.path,e.flags,0,r).fd;case 1:case 2:return 0;case 3:return e.flags;case 4:var r=Ft.get();return e.flags|=r,0;case 12:case 12:return r=Ft.get(),G[r+0>>1]=2,0;case 13:case 14:case 13:case 14:return 0;case 16:case 8:return-rt.EINVAL;case 9:return ot(rt.EINVAL),-1;default:return-rt.EINVAL}}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Bt(n,t){Ft.varargs=t;try{var e=Ft.getStreamFromFD(),r=Ft.get();return k(!Ft.get()),e.fd===r?-rt.EINVAL:Ft.doDup(e.path,e.flags,r)}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Yt(n,t){Ft.varargs=t;try{var e=Ft.getStr(),r=Ft.getStr();return Ot.rename(e,r),0}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Ut(n,t){Ft.varargs=t;try{var e=Ft.getStr();return Ot.rmdir(e),0}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function qt(n,t){Ft.varargs=t;try{var e=Ft.getStr(),r=Ft.get(),o=Ft.get();return Ot.open(e,r,o).fd}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function $t(n,t){Ft.varargs=t;try{var e=Ft.getStreamFromFD(),r=Ft.get();switch(r){case 21509:case 21505:return e.tty?0:-rt.ENOTTY;case 21510:case 21511:case 21512:case 21506:case 21507:case 21508:return e.tty?0:-rt.ENOTTY;case 21519:if(!e.tty)return-rt.ENOTTY;var o=Ft.get();return X[o>>2]=0,0;case 21520:return e.tty?-rt.EINVAL:-rt.ENOTTY;case 21531:return o=Ft.get(),Ot.ioctl(e,r,o);case 21523:case 21524:return e.tty?0:-rt.ENOTTY;default:wo("bad ioctl syscall "+r)}}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Ht(n,t){Ft.varargs=t;try{var e=Ft.getStreamFromFD();return Ot.close(e),0}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Vt(n,t){Ft.varargs=t;try{var e=Ft.getStreamFromFD(),r=Ft.get();return e.fd===r?r:Ft.doDup(e.path,e.flags,r)}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Wt(n,t){Ft.varargs=t;try{Ft.get();var e=Ft.get();return lo(e,0,136),X[e>>2]=1,X[e+4>>2]=2,X[e+8>>2]=3,X[e+12>>2]=4,0}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Gt(n,t){Ft.varargs=t;try{var e=Ft.get(),r=Ft.get(),o=Ft.mappings[e];if(!o)return 0;if(r===o.len){var i=Ot.getStream(o.fd);Ft.doMsync(e,i,r,o.flags),Ft.mappings[e]=null,o.allocated&&co(o.malloc)}return 0}catch(n){return void 0!==Ot&&n instanceof Ot.ErrnoError||wo(n),-n.errno}}function Xt(){}function Jt(){}function Kt(){n.abort()}var Zt=0;function Qt(t){setTimeout((function(){Zt&&n.dynCall_vi(Zt,0)}),1e3*t)}function ne(){return void 0===ne.start&&(ne.start=Date.now()),1e3*(Date.now()-ne.start)|0}function te(n,t){return n-t}function ee(n){return 0===n?0:(n=z(n),Qn.hasOwnProperty(n)?(ee.ret&&co(ee.ret),ee.ret=Y(Qn[n]),ee.ret):0)}function re(n){var t=Date.now();return X[n>>2]=t/1e3|0,X[n+4>>2]=t%1e3*1e3|0,0}var oe=Q+=16;Q+=48;var ie=O(He("GMT"),"i8",A);function ae(n,t){var e=new Date(1e3*X[n>>2]);X[t>>2]=e.getUTCSeconds(),X[t+4>>2]=e.getUTCMinutes(),X[t+8>>2]=e.getUTCHours(),X[t+12>>2]=e.getUTCDate(),X[t+16>>2]=e.getUTCMonth(),X[t+20>>2]=e.getUTCFullYear()-1900,X[t+24>>2]=e.getUTCDay(),X[t+36>>2]=0,X[t+32>>2]=0;var r=Date.UTC(e.getUTCFullYear(),0,1,0,0,0,0),o=(e.getTime()-r)/864e5|0;return X[t+28>>2]=o,X[t+40>>2]=ie,t}function se(n){return ae(n,oe)}var ce=In,ue=In;function le(n){return Math.pow(2,n)}function fe(){return le.apply(null,arguments)}var de=Pn,_e=Ln;function he(n){return Math.log(n)/Math.LN10}function me(){return he.apply(null,arguments)}function ge(n){var t=pe,e=t.LLVM_SAVEDSTACKS[n];t.LLVM_SAVEDSTACKS.splice(n,1),ho(e)}function pe(){var n=pe;return n.LLVM_SAVEDSTACKS||(n.LLVM_SAVEDSTACKS=[]),n.LLVM_SAVEDSTACKS.push(mo()),n.LLVM_SAVEDSTACKS.length-1}function ye(){wo("trap!")}function we(){if(!we.called){we.called=!0,X[io()>>2]=60*(new Date).getTimezoneOffset();var n=new Date(2e3,0,1),t=new Date(2e3,6,1);X[oo()>>2]=Number(n.getTimezoneOffset()!=t.getTimezoneOffset());var e=a(n),r=a(t),o=O(He(e),"i8",C),i=O(He(r),"i8",C);t.getTimezoneOffset()<n.getTimezoneOffset()?(X[ao()>>2]=o,X[ao()+4>>2]=i):(X[ao()>>2]=i,X[ao()+4>>2]=o)}function a(n){var t=n.toTimeString().match(/\(([A-Za-z ]+)\)$/);return t?t[1]:"GMT"}}function ve(n,t){we();var e=new Date(1e3*X[n>>2]);X[t>>2]=e.getSeconds(),X[t+4>>2]=e.getMinutes(),X[t+8>>2]=e.getHours(),X[t+12>>2]=e.getDate(),X[t+16>>2]=e.getMonth(),X[t+20>>2]=e.getFullYear()-1900,X[t+24>>2]=e.getDay();var r=new Date(e.getFullYear(),0,1),o=(e.getTime()-r.getTime())/864e5|0;X[t+28>>2]=o,X[t+36>>2]=-60*e.getTimezoneOffset();var i=new Date(2e3,6,1).getTimezoneOffset(),a=r.getTimezoneOffset(),s=0|(i!=a&&e.getTimezoneOffset()==Math.min(a,i));X[t+32>>2]=s;var c=X[ao()+(s?4:0)>>2];return X[t+40>>2]=c,t}function Ee(n){return ve(n,oe)}function be(t,e){throw n.setThrew(t,e||1),"longjmp"}function ke(n,t,e){return W.set(W.subarray(t,t+e),n),n}function xe(n){we();var t=new Date(X[n+20>>2]+1900,X[n+16>>2],X[n+12>>2],X[n+8>>2],X[n+4>>2],X[n>>2],0),e=X[n+32>>2],r=t.getTimezoneOffset(),o=new Date(t.getFullYear(),0,1),i=new Date(2e3,6,1).getTimezoneOffset(),a=o.getTimezoneOffset(),s=Math.min(a,i);if(e<0)X[n+32>>2]=Number(i!=a&&s==r);else if(e>0!=(s==r)){var c=Math.max(a,i),u=e>0?s:c;t.setTime(t.getTime()+6e4*(u-r))}X[n+24>>2]=t.getDay();var l=(t.getTime()-o.getTime())/864e5|0;return X[n+28>>2]=l,t.getTime()/1e3|0}function Me(){return 0}var Se={};function De(n){return Se[n]||0}var Te=1;function Ce(n,t){return 0==n?rt.EINVAL:(X[n>>2]=Te,Se[Te]=0,Te++,0)}function Ae(){}function Ne(t,e){Ne.seen||(Ne.seen={}),t in Ne.seen||(n.dynCall_v(e),Ne.seen[t]=1)}function Oe(n,t){return n in Se?(Se[n]=t,0):rt.EINVAL}function Fe(n,t){return 14==n&&(Zt=t),0}function ze(n){return n%4==0&&(n%100!=0||n%400==0)}function je(n,t){for(var e=0,r=0;r<=t;e+=n[r++]);return e}var Pe=[31,29,31,30,31,30,31,31,30,31,30,31],Ie=[31,28,31,30,31,30,31,31,30,31,30,31];function Le(n,t){for(var e=new Date(n.getTime());t>0;){var r=ze(e.getFullYear()),o=e.getMonth(),i=(r?Pe:Ie)[o];if(!(t>i-e.getDate()))return e.setDate(e.getDate()+t),e;t-=i-e.getDate()+1,e.setDate(1),o<11?e.setMonth(o+1):(e.setMonth(0),e.setFullYear(e.getFullYear()+1))}return e}function Re(n,t,e,r){var o=X[r+40>>2],i={tm_sec:X[r>>2],tm_min:X[r+4>>2],tm_hour:X[r+8>>2],tm_mday:X[r+12>>2],tm_mon:X[r+16>>2],tm_year:X[r+20>>2],tm_wday:X[r+24>>2],tm_yday:X[r+28>>2],tm_isdst:X[r+32>>2],tm_gmtoff:X[r+36>>2],tm_zone:o?z(o):""},a=z(e),s={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S"};for(var c in s)a=a.replace(new RegExp(c,"g"),s[c]);var u=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],l=["January","February","March","April","May","June","July","August","September","October","November","December"];function f(n,t,e){for(var r="number"==typeof n?n.toString():n||"";r.length<t;)r=e[0]+r;return r}function d(n,t){return f(n,t,"0")}function _(n,t){function e(n){return n<0?-1:n>0?1:0}var r;return 0===(r=e(n.getFullYear()-t.getFullYear()))&&0===(r=e(n.getMonth()-t.getMonth()))&&(r=e(n.getDate()-t.getDate())),r}function h(n){switch(n.getDay()){case 0:return new Date(n.getFullYear()-1,11,29);case 1:return n;case 2:return new Date(n.getFullYear(),0,3);case 3:return new Date(n.getFullYear(),0,2);case 4:return new Date(n.getFullYear(),0,1);case 5:return new Date(n.getFullYear()-1,11,31);case 6:return new Date(n.getFullYear()-1,11,30)}}function m(n){var t=Le(new Date(n.tm_year+1900,0,1),n.tm_yday),e=new Date(t.getFullYear(),0,4),r=new Date(t.getFullYear()+1,0,4),o=h(e),i=h(r);return _(o,t)<=0?_(i,t)<=0?t.getFullYear()+1:t.getFullYear():t.getFullYear()-1}var g={"%a":function(n){return u[n.tm_wday].substring(0,3)},"%A":function(n){return u[n.tm_wday]},"%b":function(n){return l[n.tm_mon].substring(0,3)},"%B":function(n){return l[n.tm_mon]},"%C":function(n){return d((n.tm_year+1900)/100|0,2)},"%d":function(n){return d(n.tm_mday,2)},"%e":function(n){return f(n.tm_mday,2," ")},"%g":function(n){return m(n).toString().substring(2)},"%G":function(n){return m(n)},"%H":function(n){return d(n.tm_hour,2)},"%I":function(n){var t=n.tm_hour;return 0==t?t=12:t>12&&(t-=12),d(t,2)},"%j":function(n){return d(n.tm_mday+je(ze(n.tm_year+1900)?Pe:Ie,n.tm_mon-1),3)},"%m":function(n){return d(n.tm_mon+1,2)},"%M":function(n){return d(n.tm_min,2)},"%n":function(){return"\n"},"%p":function(n){return n.tm_hour>=0&&n.tm_hour<12?"AM":"PM"},"%S":function(n){return d(n.tm_sec,2)},"%t":function(){return"\t"},"%u":function(n){return new Date(n.tm_year+1900,n.tm_mon+1,n.tm_mday,0,0,0,0).getDay()||7},"%U":function(n){var t=new Date(n.tm_year+1900,0,1),e=0===t.getDay()?t:Le(t,7-t.getDay()),r=new Date(n.tm_year+1900,n.tm_mon,n.tm_mday);if(_(e,r)<0){var o=je(ze(r.getFullYear())?Pe:Ie,r.getMonth()-1)-31,i=31-e.getDate()+o+r.getDate();return d(Math.ceil(i/7),2)}return 0===_(e,t)?"01":"00"},"%V":function(n){var t,e=new Date(n.tm_year+1900,0,4),r=new Date(n.tm_year+1901,0,4),o=h(e),i=h(r),a=Le(new Date(n.tm_year+1900,0,1),n.tm_yday);return _(a,o)<0?"53":_(i,a)<=0?"01":(t=o.getFullYear()<n.tm_year+1900?n.tm_yday+32-o.getDate():n.tm_yday+1-o.getDate(),d(Math.ceil(t/7),2))},"%w":function(n){return new Date(n.tm_year+1900,n.tm_mon+1,n.tm_mday,0,0,0,0).getDay()},"%W":function(n){var t=new Date(n.tm_year,0,1),e=1===t.getDay()?t:Le(t,0===t.getDay()?1:7-t.getDay()+1),r=new Date(n.tm_year+1900,n.tm_mon,n.tm_mday);if(_(e,r)<0){var o=je(ze(r.getFullYear())?Pe:Ie,r.getMonth()-1)-31,i=31-e.getDate()+o+r.getDate();return d(Math.ceil(i/7),2)}return 0===_(e,t)?"01":"00"},"%y":function(n){return(n.tm_year+1900).toString().substring(2)},"%Y":function(n){return n.tm_year+1900},"%z":function(n){var t=n.tm_gmtoff,e=t>=0;return t=(t=Math.abs(t)/60)/60*100+t%60,(e?"+":"-")+String("0000"+t).slice(-4)},"%Z":function(n){return n.tm_zone},"%%":function(){return"%"}};for(var c in g)a.indexOf(c)>=0&&(a=a.replace(new RegExp(c,"g"),g[c](i)));var p=He(a,!1);return p.length>t?0:(zn(p,n),p.length-1)}function Be(n,t,e,r){return Re(n,t,e,r)}function Ye(n){return ot(rt.EAGAIN),-1}function Ue(n){var t=Date.now()/1e3|0;return n&&(X[n>>2]=t),t}if(tt=s?function(){var n=r.hrtime();return 1e3*n[0]+n[1]/1e6}:"undefined"!=typeof dateNow?dateNow:"object"==typeof self&&self.performance&&"function"==typeof self.performance.now?function(){return self.performance.now()}:"object"==typeof performance&&"function"==typeof performance.now?function(){return performance.now()}:Date.now,Ot.staticInit(),vn.unshift((function(){n.noFSInit||Ot.init.initialized||Ot.init()})),En.push((function(){Ot.ignorePermissions=!1})),bn.push((function(){Ot.quit()})),vn.unshift((function(){})),bn.push((function(){})),s){var qe=Sn,$e=Dn;At.staticInit()}function He(n,t,e){var r=e>0?e:B(n)+1,o=new Array(r),i=L(n,o,0,o.length);return t&&(o.length=i),o}function Ve(t,e){var r=mo();try{return n.dynCall_di(t,e)}catch(t){if(ho(r),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function We(t,e,r,o){var i=mo();try{return n.dynCall_didi(t,e,r,o)}catch(t){if(ho(i),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Ge(t,e,r,o){var i=mo();try{return n.dynCall_diii(t,e,r,o)}catch(t){if(ho(i),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Xe(t,e,r,o){var i=mo();try{return n.dynCall_dij(t,e,r,o)}catch(t){if(ho(i),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Je(t,e){var r=mo();try{return n.dynCall_ii(t,e)}catch(t){if(ho(r),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Ke(t,e,r){var o=mo();try{return n.dynCall_iid(t,e,r)}catch(t){if(ho(o),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Ze(t,e,r){var o=mo();try{return n.dynCall_iii(t,e,r)}catch(t){if(ho(o),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Qe(t,e,r,o){var i=mo();try{return n.dynCall_iiii(t,e,r,o)}catch(t){if(ho(i),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function nr(t,e,r,o,i){var a=mo();try{return n.dynCall_iiiid(t,e,r,o,i)}catch(t){if(ho(a),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function tr(t,e,r,o,i){var a=mo();try{return n.dynCall_iiiii(t,e,r,o,i)}catch(t){if(ho(a),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function er(t,e,r,o,i,a){var s=mo();try{return n.dynCall_iiiiid(t,e,r,o,i,a)}catch(t){if(ho(s),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function rr(t,e,r,o,i,a){var s=mo();try{return n.dynCall_iiiiii(t,e,r,o,i,a)}catch(t){if(ho(s),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function or(t,e,r,o,i,a,s){var c=mo();try{return n.dynCall_iiiiiid(t,e,r,o,i,a,s)}catch(t){if(ho(c),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function ir(t,e,r,o,i,a,s){var c=mo();try{return n.dynCall_iiiiiii(t,e,r,o,i,a,s)}catch(t){if(ho(c),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function ar(t,e,r,o,i,a,s,c){var u=mo();try{return n.dynCall_iiiiiiii(t,e,r,o,i,a,s,c)}catch(t){if(ho(u),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function sr(t,e,r,o,i,a,s,c,u){var l=mo();try{return n.dynCall_iiiiiiiii(t,e,r,o,i,a,s,c,u)}catch(t){if(ho(l),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function cr(t,e,r,o,i,a,s){var c=mo();try{return n.dynCall_iiiiij(t,e,r,o,i,a,s)}catch(t){if(ho(c),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function ur(t,e,r,o){var i=mo();try{return n.dynCall_iij(t,e,r,o)}catch(t){if(ho(i),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function lr(t,e,r,o,i){var a=mo();try{return n.dynCall_iiji(t,e,r,o,i)}catch(t){if(ho(a),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function fr(t,e,r,o,i,a){var s=mo();try{return n.dynCall_iijii(t,e,r,o,i,a)}catch(t){if(ho(s),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function dr(t,e,r,o,i,a){var s=mo();try{return n.dynCall_iijj(t,e,r,o,i,a)}catch(t){if(ho(s),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function _r(t,e,r,o,i){var a=mo();try{return n.dynCall_ijii(t,e,r,o,i)}catch(t){if(ho(a),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function hr(t,e,r,o,i,a){var s=mo();try{return n.dynCall_ijiii(t,e,r,o,i,a)}catch(t){if(ho(s),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function mr(t,e,r,o,i,a,s){var c=mo();try{return n.dynCall_ijiiii(t,e,r,o,i,a,s)}catch(t){if(ho(c),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function gr(t,e){var r=mo();try{return n.dynCall_ji(t,e)}catch(t){if(ho(r),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function pr(t,e,r){var o=mo();try{return n.dynCall_jii(t,e,r)}catch(t){if(ho(o),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function yr(t,e,r,o){var i=mo();try{return n.dynCall_jiii(t,e,r,o)}catch(t){if(ho(i),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function wr(t,e,r,o){var i=mo();try{return n.dynCall_jij(t,e,r,o)}catch(t){if(ho(i),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function vr(t,e,r,o,i){var a=mo();try{return n.dynCall_jiji(t,e,r,o,i)}catch(t){if(ho(a),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Er(t,e,r,o,i,a){var s=mo();try{return n.dynCall_jijii(t,e,r,o,i,a)}catch(t){if(ho(s),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function br(t){var e=mo();try{n.dynCall_v(t)}catch(t){if(ho(e),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function kr(t,e){var r=mo();try{n.dynCall_vi(t,e)}catch(t){if(ho(r),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function xr(t,e,r){var o=mo();try{n.dynCall_vii(t,e,r)}catch(t){if(ho(o),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Mr(t,e,r,o){var i=mo();try{n.dynCall_viii(t,e,r,o)}catch(t){if(ho(i),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Sr(t,e,r,o,i){var a=mo();try{n.dynCall_viiii(t,e,r,o,i)}catch(t){if(ho(a),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Dr(t,e,r,o,i,a){var s=mo();try{n.dynCall_viiiii(t,e,r,o,i,a)}catch(t){if(ho(s),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Tr(t,e,r,o,i,a,s){var c=mo();try{n.dynCall_viiiiii(t,e,r,o,i,a,s)}catch(t){if(ho(c),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Cr(t,e,r,o,i,a,s,c){var u=mo();try{n.dynCall_viiiiiii(t,e,r,o,i,a,s,c)}catch(t){if(ho(u),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Ar(t,e,r,o,i,a,s){var c=mo();try{n.dynCall_viijii(t,e,r,o,i,a,s)}catch(t){if(ho(c),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}function Nr(t,e,r,o,i){var a=mo();try{n.dynCall_vijd(t,e,r,o,i)}catch(t){if(ho(a),"number"!=typeof t&&"longjmp"!==t)throw t;n.setThrew(1,0)}}an=g(4),tn=en=y(Q),on=y(rn=tn+mn),X[an>>2]=on,nn=!0,n.wasmTableSize=7612,n.wasmMaxTableSize=7612,n.asmGlobalArg={},n.asmLibraryArg={abort:wo,assert:k,enlargeMemory:hn,getTotalMemory:pn,abortOnCannotGrowMemory:_n,invoke_di:Ve,invoke_didi:We,invoke_diii:Ge,invoke_dij:Xe,invoke_ii:Je,invoke_iid:Ke,invoke_iii:Ze,invoke_iiii:Qe,invoke_iiiid:nr,invoke_iiiii:tr,invoke_iiiiid:er,invoke_iiiiii:rr,invoke_iiiiiid:or,invoke_iiiiiii:ir,invoke_iiiiiiii:ar,invoke_iiiiiiiii:sr,invoke_iiiiij:cr,invoke_iij:ur,invoke_iiji:lr,invoke_iijii:fr,invoke_iijj:dr,invoke_ijii:_r,invoke_ijiii:hr,invoke_ijiiii:mr,invoke_ji:gr,invoke_jii:pr,invoke_jiii:yr,invoke_jij:wr,invoke_jiji:vr,invoke_jijii:Er,invoke_v:br,invoke_vi:kr,invoke_vii:xr,invoke_viii:Mr,invoke_viiii:Sr,invoke_viiiii:Dr,invoke_viiiiii:Tr,invoke_viiiiiii:Cr,invoke_viijii:Ar,invoke_vijd:Nr,__Exit:Zn,___buildEnvironment:nt,___clock_gettime:at,___cxa_allocate_exception:st,___cxa_begin_catch:ut,___cxa_current_primary_exception:lt,___cxa_decrement_exception_refcount:ft,___cxa_end_catch:mt,___cxa_find_matching_catch:wt,___cxa_free_exception:ht,___cxa_increment_exception_refcount:dt,___cxa_pure_virtual:_t,___cxa_rethrow:gt,___cxa_rethrow_primary_exception:pt,___cxa_throw:vt,___cxa_uncaught_exception:Et,___gxx_personality_v0:bt,___lock:kt,___map_file:xt,___resumeException:yt,___setErrNo:ot,___syscall10:zt,___syscall140:jt,___syscall145:Pt,___syscall146:It,___syscall196:Lt,___syscall221:Rt,___syscall330:Bt,___syscall38:Yt,___syscall40:Ut,___syscall5:qt,___syscall54:$t,___syscall6:Ht,___syscall63:Vt,___syscall77:Wt,___syscall91:Gt,___unlock:Xt,___wait:Jt,__addDays:Le,__arraySum:je,__exit:Jn,__isLeapYear:ze,_abort:Kt,_alarm:Qt,_clock:ne,_clock_gettime:it,_difftime:te,_emscripten_get_now:tt,_emscripten_get_now_is_monotonic:et,_emscripten_memcpy_big:ke,_exit:Kn,_getenv:ee,_gettimeofday:re,_gmtime:se,_gmtime_r:ae,_llvm_ceil_f32:ce,_llvm_ceil_f64:ue,_llvm_exp2_f32:le,_llvm_exp2_f64:fe,_llvm_fabs_f64:de,_llvm_floor_f64:_e,_llvm_log10_f32:he,_llvm_log10_f64:me,_llvm_stackrestore:ge,_llvm_stacksave:pe,_llvm_trap:ye,_localtime:Ee,_localtime_r:ve,_longjmp:be,_mktime:xe,_pthread_cond_wait:Me,_pthread_getspecific:De,_pthread_key_create:Ce,_pthread_mutex_destroy:Ae,_pthread_once:Ne,_pthread_setspecific:Oe,_signal:Fe,_strftime:Re,_strftime_l:Be,_system:Ye,_time:Ue,_tzset:we,DYNAMICTOP_PTR:an,tempDoublePtr:Xn,STACKTOP:en,STACK_MAX:rn};var Or=n.asm(n.asmGlobalArg,n.asmLibraryArg,H);n.asm=Or;var Fr,zr=n.__GLOBAL__I_000101=function(){return n.asm.__GLOBAL__I_000101.apply(null,arguments)},jr=n.__GLOBAL__sub_I_clasp_app_cpp=function(){return n.asm.__GLOBAL__sub_I_clasp_app_cpp.apply(null,arguments)},Pr=n.__GLOBAL__sub_I_clasp_options_cpp=function(){return n.asm.__GLOBAL__sub_I_clasp_options_cpp.apply(null,arguments)},Ir=n.__GLOBAL__sub_I_control_cc=function(){return n.asm.__GLOBAL__sub_I_control_cc.apply(null,arguments)},Lr=n.__GLOBAL__sub_I_iostream_cpp=function(){return n.asm.__GLOBAL__sub_I_iostream_cpp.apply(null,arguments)},Rr=n.__GLOBAL__sub_I_logic_program_cpp=function(){return n.asm.__GLOBAL__sub_I_logic_program_cpp.apply(null,arguments)},Br=n.__GLOBAL__sub_I_shared_context_cpp=function(){return n.asm.__GLOBAL__sub_I_shared_context_cpp.apply(null,arguments)},Yr=n.__GLOBAL__sub_I_statistics_cpp=function(){return n.asm.__GLOBAL__sub_I_statistics_cpp.apply(null,arguments)},Ur=n.__GLOBAL__sub_I_string_convert_cpp=function(){return n.asm.__GLOBAL__sub_I_string_convert_cpp.apply(null,arguments)},qr=n.__ZSt18uncaught_exceptionv=function(){return n.asm.__ZSt18uncaught_exceptionv.apply(null,arguments)},$r=(n.___cxa_can_catch=function(){return n.asm.___cxa_can_catch.apply(null,arguments)},n.___cxa_is_pointer_type=function(){return n.asm.___cxa_is_pointer_type.apply(null,arguments)},n.___cxx_global_var_init=function(){return n.asm.___cxx_global_var_init.apply(null,arguments)}),Hr=n.___cxx_global_var_init_10=function(){return n.asm.___cxx_global_var_init_10.apply(null,arguments)},Vr=n.___cxx_global_var_init_11=function(){return n.asm.___cxx_global_var_init_11.apply(null,arguments)},Wr=n.___cxx_global_var_init_12=function(){return n.asm.___cxx_global_var_init_12.apply(null,arguments)},Gr=n.___cxx_global_var_init_13=function(){return n.asm.___cxx_global_var_init_13.apply(null,arguments)},Xr=n.___cxx_global_var_init_2=function(){return n.asm.___cxx_global_var_init_2.apply(null,arguments)},Jr=n.___cxx_global_var_init_2409=function(){return n.asm.___cxx_global_var_init_2409.apply(null,arguments)},Kr=n.___cxx_global_var_init_265=function(){return n.asm.___cxx_global_var_init_265.apply(null,arguments)},Zr=n.___cxx_global_var_init_3=function(){return n.asm.___cxx_global_var_init_3.apply(null,arguments)},Qr=n.___cxx_global_var_init_4=function(){return n.asm.___cxx_global_var_init_4.apply(null,arguments)},no=n.___cxx_global_var_init_5=function(){return n.asm.___cxx_global_var_init_5.apply(null,arguments)},to=n.___cxx_global_var_init_6=function(){return n.asm.___cxx_global_var_init_6.apply(null,arguments)},eo=n.___cxx_global_var_init_9=function(){return n.asm.___cxx_global_var_init_9.apply(null,arguments)},ro=n.___emscripten_environ_constructor=function(){return n.asm.___emscripten_environ_constructor.apply(null,arguments)},oo=(n.___errno_location=function(){return n.asm.___errno_location.apply(null,arguments)},n.__get_daylight=function(){return n.asm.__get_daylight.apply(null,arguments)}),io=(n.__get_environ=function(){return n.asm.__get_environ.apply(null,arguments)},n.__get_timezone=function(){return n.asm.__get_timezone.apply(null,arguments)}),ao=n.__get_tzname=function(){return n.asm.__get_tzname.apply(null,arguments)},so=n._emscripten_replace_memory=function(){return n.asm._emscripten_replace_memory.apply(null,arguments)},co=n._free=function(){return n.asm._free.apply(null,arguments)},uo=(n._llvm_bswap_i32=function(){return n.asm._llvm_bswap_i32.apply(null,arguments)},n._malloc=function(){return n.asm._malloc.apply(null,arguments)}),lo=(n._memcpy=function(){return n.asm._memcpy.apply(null,arguments)},n._memmove=function(){return n.asm._memmove.apply(null,arguments)},n._memset=function(){return n.asm._memset.apply(null,arguments)}),fo=(n._pthread_cond_broadcast=function(){return n.asm._pthread_cond_broadcast.apply(null,arguments)},n._pthread_mutex_lock=function(){return n.asm._pthread_mutex_lock.apply(null,arguments)},n._pthread_mutex_unlock=function(){return n.asm._pthread_mutex_unlock.apply(null,arguments)},n._realloc=function(){return n.asm._realloc.apply(null,arguments)},n._run=function(){return n.asm._run.apply(null,arguments)},n._saveSetjmp=function(){return n.asm._saveSetjmp.apply(null,arguments)},n._sbrk=function(){return n.asm._sbrk.apply(null,arguments)},n._testSetjmp=function(){return n.asm._testSetjmp.apply(null,arguments)},n.establishStackSpace=function(){return n.asm.establishStackSpace.apply(null,arguments)},n.getTempRet0=function(){return n.asm.getTempRet0.apply(null,arguments)},n.runPostSets=function(){return n.asm.runPostSets.apply(null,arguments)},n.setTempRet0=function(){return n.asm.setTempRet0.apply(null,arguments)}),_o=(n.setThrew=function(){return n.asm.setThrew.apply(null,arguments)},n.stackAlloc=function(){return n.asm.stackAlloc.apply(null,arguments)}),ho=n.stackRestore=function(){return n.asm.stackRestore.apply(null,arguments)},mo=n.stackSave=function(){return n.asm.stackSave.apply(null,arguments)};function go(n){this.name="ExitStatus",this.message="Program terminated with exit("+n+")",this.status=n}function po(t){function e(){n.calledRun||(n.calledRun=!0,b||(Tn(),Cn(),n.onRuntimeInitialized&&n.onRuntimeInitialized(),Nn()))}t=t||n.arguments,Bn>0||(Mn(),Bn>0||n.calledRun||(n.setStatus?(n.setStatus("Running..."),setTimeout((function(){setTimeout((function(){n.setStatus("")}),1),e()}),1)):e()))}function yo(t,e){e&&n.noExitRuntime&&0===t||(n.noExitRuntime||(b=!0,en=Fr,An(),n.onExit&&n.onExit(t)),n.quit(t,new go(t)))}function wo(t){throw n.onAbort&&n.onAbort(t),void 0!==t?(_(t),h(t),t=JSON.stringify(t)):t="",b=!0,"abort("+t+"). Build with -s ASSERTIONS=1 for more info."}if(n.dynCall_di=function(){return n.asm.dynCall_di.apply(null,arguments)},n.dynCall_didi=function(){return n.asm.dynCall_didi.apply(null,arguments)},n.dynCall_diii=function(){return n.asm.dynCall_diii.apply(null,arguments)},n.dynCall_dij=function(){return n.asm.dynCall_dij.apply(null,arguments)},n.dynCall_ii=function(){return n.asm.dynCall_ii.apply(null,arguments)},n.dynCall_iid=function(){return n.asm.dynCall_iid.apply(null,arguments)},n.dynCall_iii=function(){return n.asm.dynCall_iii.apply(null,arguments)},n.dynCall_iiii=function(){return n.asm.dynCall_iiii.apply(null,arguments)},n.dynCall_iiiid=function(){return n.asm.dynCall_iiiid.apply(null,arguments)},n.dynCall_iiiii=function(){return n.asm.dynCall_iiiii.apply(null,arguments)},n.dynCall_iiiiid=function(){return n.asm.dynCall_iiiiid.apply(null,arguments)},n.dynCall_iiiiii=function(){return n.asm.dynCall_iiiiii.apply(null,arguments)},n.dynCall_iiiiiid=function(){return n.asm.dynCall_iiiiiid.apply(null,arguments)},n.dynCall_iiiiiii=function(){return n.asm.dynCall_iiiiiii.apply(null,arguments)},n.dynCall_iiiiiiii=function(){return n.asm.dynCall_iiiiiiii.apply(null,arguments)},n.dynCall_iiiiiiiii=function(){return n.asm.dynCall_iiiiiiiii.apply(null,arguments)},n.dynCall_iiiiij=function(){return n.asm.dynCall_iiiiij.apply(null,arguments)},n.dynCall_iij=function(){return n.asm.dynCall_iij.apply(null,arguments)},n.dynCall_iiji=function(){return n.asm.dynCall_iiji.apply(null,arguments)},n.dynCall_iijii=function(){return n.asm.dynCall_iijii.apply(null,arguments)},n.dynCall_iijj=function(){return n.asm.dynCall_iijj.apply(null,arguments)},n.dynCall_ijii=function(){return n.asm.dynCall_ijii.apply(null,arguments)},n.dynCall_ijiii=function(){return n.asm.dynCall_ijiii.apply(null,arguments)},n.dynCall_ijiiii=function(){return n.asm.dynCall_ijiiii.apply(null,arguments)},n.dynCall_ji=function(){return n.asm.dynCall_ji.apply(null,arguments)},n.dynCall_jii=function(){return n.asm.dynCall_jii.apply(null,arguments)},n.dynCall_jiii=function(){return n.asm.dynCall_jiii.apply(null,arguments)},n.dynCall_jij=function(){return n.asm.dynCall_jij.apply(null,arguments)},n.dynCall_jiji=function(){return n.asm.dynCall_jiji.apply(null,arguments)},n.dynCall_jijii=function(){return n.asm.dynCall_jijii.apply(null,arguments)},n.dynCall_v=function(){return n.asm.dynCall_v.apply(null,arguments)},n.dynCall_vi=function(){return n.asm.dynCall_vi.apply(null,arguments)},n.dynCall_vii=function(){return n.asm.dynCall_vii.apply(null,arguments)},n.dynCall_viii=function(){return n.asm.dynCall_viii.apply(null,arguments)},n.dynCall_viiii=function(){return n.asm.dynCall_viiii.apply(null,arguments)},n.dynCall_viiiii=function(){return n.asm.dynCall_viiiii.apply(null,arguments)},n.dynCall_viiiiii=function(){return n.asm.dynCall_viiiiii.apply(null,arguments)},n.dynCall_viiiiiii=function(){return n.asm.dynCall_viiiiiii.apply(null,arguments)},n.dynCall_viijii=function(){return n.asm.dynCall_viijii.apply(null,arguments)},n.dynCall_vijd=function(){return n.asm.dynCall_vijd.apply(null,arguments)},n.asm=Or,n.ccall=D,n.then=function(t){if(n.calledRun)t(n);else{var e=n.onRuntimeInitialized;n.onRuntimeInitialized=function(){e&&e(),t(n)}}return n},go.prototype=new Error,go.prototype.constructor=go,Un=function t(){n.calledRun||po(),n.calledRun||(Un=t)},n.run=po,n.abort=wo,n.preInit)for("function"==typeof n.preInit&&(n.preInit=[n.preInit]);n.preInit.length>0;)n.preInit.pop()();return n.noExitRuntime=!0,po(),n});n.exports=o}));const Cn=/(soft\(\w+).*?\)/;function An(n,t){return(n.Call||[]).reduce(((n,e)=>(e.Witnesses.forEach((e=>{const r=e.Value,o=e.Costs,i=r.filter((n=>n.startsWith("soft("))).map((n=>{const e=Cn.exec(n);if(!e)throw Error(`invalid violation: ${n}`);const r=e[1],o=t.find((n=>n.asp.startsWith(r)));if(!o)throw Error(`${r} not found!`);return Object.assign({},o,{witness:n})}));n.push({costs:o,facts:r,violations:i})})),n)),[])}function Nn(n){return n.map((n=>o(n.facts)))}n.default=class{constructor(n="https://unpkg.com/wasm-clingo@0.2.2",t=console.log){this.initialized=!1,this.stdout="","/"!==n.substr(n.length-1)&&(n+="/");const e=this,r={locateFile:t=>`${n}${t}`,setStatus:t,print(n){e.stdout+=n},totalDependencies:0,monitorRunDependencies(n){r.totalDependencies=Math.max(r.totalDependencies,n),r.setStatus(n?"Preparing... ("+(r.totalDependencies-n)+"/"+r.totalDependencies+")":"All downloads complete.")},printErr(n){n&&(r.setStatus("Received output on stderr."),console.warn(n))}};this.Module=r,this.schema=null,this.hard=u(i),this.soft=u(a,s),this.constraints=c}init(){return new Promise(((n,t)=>{this.Module.setStatus("Downloading..."),this.Module.onRuntimeInitialized=()=>{this.initialized=!0,n(this)},Tn(this.Module)}))}solve(n,t={}){if(!this.initialized)throw Error("Draco is not initialized. Call `init() first.`");this.Module.setStatus("Running Draco Query..."),n+=this.getDataDeclaration();const e=t.constraints||Object.keys(this.constraints).filter((n=>!("SOFT"===n||"HARD"===n||"WEIGHTS"===n)));t.relaxHard&&-1!==e.indexOf("HARD_INTEGRITY")&&e.splice(e.indexOf("HARD_INTEGRITY"),1),n+=e.map((n=>this.constraints[n])).join("\n\n");const r=sn(this.soft);n+=sn(this.hard).definitions+"\n\n",n+=r.definitions+"\n\n"+r.weights+"\n\n"+r.assigns;const o=["--outf=2","--opt-mode=OptN","--quiet=1","--project",void 0===t.models?1:t.models].concat((t.weights||[]).map((n=>`-c ${n.name}=${n.value}`))).join(" ");this.stdout="",this.Module.ccall("run","number",["string","string"],[n,o]);const i=JSON.parse(this.stdout);if("UNSATISFIABLE"===i.Result)return console.debug("UNSATISFIABLE"),console.debug(i),null;const a=An(i,this.soft.concat(this.hard));if(a.length>(t.models||1))throw new Error("Too many models.");const s=Nn(a);return this.Module.setStatus(""),{models:a,programs:e,specs:s,result:i}}getSchema(){return this.schema}prepareData(n){this.schema=an(n)}updateAsp(n){this.constraints=Object.assign({},this.constraints,n)}getConstraintSet(){return{soft:this.soft,hard:this.hard}}setConstraintSet(n){this.hard=n.hard,this.soft=n.soft}getDataDeclaration(){return this.schema?cn(this.schema).join("\n"):""}},n.getModels=An,n.models2vl=Nn,n.vl2asp=function(n){const t=[`mark(${n.mark}).`];"data"in n&&"url"in n.data&&t.push(`data("${n.data.url}").`);const e=n.encoding||{};let r=0;for(const n of Object.keys(e)){const o="e"+r++;t.push(`encoding(${o}).`),t.push(`channel(${o},${n}).`);let i=null,a=null,s=null;for(const r of Object.keys(e[n])){const c=e[n][r];"type"===r&&(i=c),"bin"===r&&(s=c),"scale"===r?("zero"in c&&(a=c.zero,c.zero?t.push(`zero(${o}).`):t.push(`:- zero(${o}).`)),"log"in c&&(c.log?t.push(`log(${o}).`):t.push(`:-log(${o}).`))):"bin"===r?c.maxbins?t.push(`${r}(${o},${c.maxbins}).`):t.push(`${r}(${o},10).`):"field"===r?t.push(`${r}(${o},"${c}").`):"bin"!==r&&t.push(`${r}(${o},${c}).`)}"quantitative"===i&&null===a&&null===s&&t.push(`zero(${o}).`)}return t},n.asp2vl=o,n.cql2asp=function(n){const t=[];E(n.mark)&&t.push(`mark(${n.mark}).`),"data"in n&&"url"in n.data&&t.push(`data("${n.data.url}").`);for(let r=0;r<n.encodings.length;r++){const o=n.encodings[r],i=`e${r}`;t.push(`encoding(${i}).`);let a=null,s=null,c=null;for(const n of Object.keys(o)){const r=E(o[n]);r&&("*"!==(e=r)&&e)&&("type"===n&&(a=r),"bin"===n&&(c=r),"scale"===n?("zero"in r&&(s=r.zero,r.zero?t.push(`zero(${i}).`):t.push(`:- zero(${i}).`)),"log"in r&&(r.log?t.push(`log(${i}).`):t.push(`:-log(${i}).`))):"bin"===n?r.maxbins?t.push(`${n}(${i},${r.maxbins}).`):r?t.push(`:- not bin(${i},_).`):t.push(`:- bin(${i},_).`):"field"===n?t.push(`${n}(${i},"${r}").`):"bin"!==n&&t.push(`${n}(${i},${r}).`))}"quantitative"===a&&null===s&&null===c&&t.push(`zero(${i}).`)}var e;return t},n.data2schema=an,n.schema2asp=cn,n.constraints=c,n.constraints2json=u,n.json2constraints=sn,Object.defineProperty(n,"__esModule",{value:!0})}(t)},2223:(n,t,e)=>{"use strict";e.r(t),e.d(t,{getModels:()=>a.h,models2vl:()=>a.P,default:()=>c});var r=e(2791),o=e.n(r),i={};for(const n in r)"default"!==n&&(i[n]=()=>r[n]);e.d(t,i);var a=e(4881),s=e(4934);i={};for(const n in s)["default","getModels","models2vl"].indexOf(n)<0&&(i[n]=()=>s[n]);e.d(t,i);const c=o()},4881:(n,t,e)=>{"use strict";e.d(t,{h:()=>i,P:()=>a});var r=e(4934);const o=/(soft\(\w+).*?\)/;function i(n,t){return(n.Call||[]).reduce(((n,e)=>(e.Witnesses.forEach((e=>{const r=e.Value,i=e.Costs,a=r.filter((n=>n.startsWith("soft("))).map((n=>{const e=o.exec(n);if(!e)throw Error(`invalid violation: ${n}`);const r=e[1],i=t.find((n=>n.asp.startsWith(r)));if(!i)throw Error(`${r} not found!`);return Object.assign({},i,{witness:n})}));n.push({costs:i,facts:r,violations:a})})),n)),[])}function a(n){return n.map((n=>(0,r.asp2vl)(n.facts)))}},4155:n=>{var t,e,r=n.exports={};function o(){throw new Error("setTimeout has not been defined")}function i(){throw new Error("clearTimeout has not been defined")}function a(n){if(t===setTimeout)return setTimeout(n,0);if((t===o||!t)&&setTimeout)return t=setTimeout,setTimeout(n,0);try{return t(n,0)}catch(e){try{return t.call(null,n,0)}catch(e){return t.call(this,n,0)}}}!function(){try{t="function"==typeof setTimeout?setTimeout:o}catch(n){t=o}try{e="function"==typeof clearTimeout?clearTimeout:i}catch(n){e=i}}();var s,c=[],u=!1,l=-1;function f(){u&&s&&(u=!1,s.length?c=s.concat(c):l=-1,c.length&&d())}function d(){if(!u){var n=a(f);u=!0;for(var t=c.length;t;){for(s=c,c=[];++l<t;)s&&s[l].run();l=-1,t=c.length}s=null,u=!1,function(n){if(e===clearTimeout)return clearTimeout(n);if((e===i||!e)&&clearTimeout)return e=clearTimeout,clearTimeout(n);try{e(n)}catch(t){try{return e.call(null,n)}catch(t){return e.call(this,n)}}}(n)}}function _(n,t){this.fun=n,this.array=t}function h(){}r.nextTick=function(n){var t=new Array(arguments.length-1);if(arguments.length>1)for(var e=1;e<arguments.length;e++)t[e-1]=arguments[e];c.push(new _(n,t)),1!==c.length||u||a(d)},_.prototype.run=function(){this.fun.apply(null,this.array)},r.title="browser",r.browser=!0,r.env={},r.argv=[],r.version="",r.versions={},r.on=h,r.addListener=h,r.once=h,r.off=h,r.removeListener=h,r.removeAllListeners=h,r.emit=h,r.prependListener=h,r.prependOnceListener=h,r.listeners=function(n){return[]},r.binding=function(n){throw new Error("process.binding is not supported")},r.cwd=function(){return"/"},r.chdir=function(n){throw new Error("process.chdir is not supported")},r.umask=function(){return 0}}}]);