# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: mergetb/tech/reconcile/taskstatus.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import List

import betterproto


class ReconcilerOp(betterproto.Enum):
    """
    ReconcilerOp is so we tell the reconciler's main function what we're doing,
    for synchronization.
    """

    Undefined = 0
    Idle = 1
    Init = 2
    Create = 3
    Update = 4
    Delete = 5
    Ensure = 6
    Health = 7
    Pollcheck = 8


class TaskRecordExistenceTypes(betterproto.Enum):
    """
    What the task record's existence should be Using multiple of these on the
    same Task/ReconcilerManager/ReconcilerName works for
    Exists/Optional/Deleted, although your TaskForest will be funny. Ignore
    overrides everything else.
    """

    Exists = 0
    Optional = 1
    Deleted = 2
    Ignore = 3


class TaskRecordKeyTypes(betterproto.Enum):
    """Options for how to interpret the key"""

    SingleKey = 0
    PrefixSpace = 1


class TaskGoalGoalType(betterproto.Enum):
    """
    This determines the type of keys in Subkeys, but as subkeys was deprecated,
    the meanings are much simpler now
    """

    Undefined = 0
    Supergoal = 1
    Supertask = 2


class TaskStatusStatusType(betterproto.Enum):
    Undefined = 0
    Success = 1
    Deleted = 2
    Pending = 3
    Unresponsive = 4
    Processing = 5
    Error = 6


class TaskMessageType(betterproto.Enum):
    Undefined = 0
    Error = 1
    Warning = 2
    Info = 3
    Debug = 4
    Trace = 5


class DeprStatusDeprResultType(betterproto.Enum):
    ResultUndefined = 0
    Working = 1
    Error = 2
    Success = 3
    Stale = 4


@dataclass(eq=False, repr=False)
class TaskRecord(betterproto.Message):
    """
    small tuple representing indicating a task handled by a specific reconciler
    if Manager or Name is "", then it is considered to be a generic task
    record, meaning that any reconciler can fulfill this record
    """

    task: str = betterproto.string_field(1)
    reconciler_manager: str = betterproto.string_field(2)
    reconciler_name: str = betterproto.string_field(3)
    existence: "TaskRecordExistenceTypes" = betterproto.enum_field(4)
    key_type: "TaskRecordKeyTypes" = betterproto.enum_field(5)


@dataclass(eq=False, repr=False)
class TaskGoal(betterproto.Message):
    """
    TaskGoal Goals are created at the highest level, usually by an apiserver
    handler Reconcilers should never create goals, they should only create
    subtasks
    """

    self_key: str = betterproto.string_field(1)
    """The etcd key used (without the taskgoal prefix)"""

    name: str = betterproto.string_field(2)
    """The goal's name, used for display"""

    desc: str = betterproto.string_field(3)
    """A description of the goal, used for display"""

    type: "TaskGoalGoalType" = betterproto.enum_field(4)
    """The type of goal this is"""

    self_version: int = betterproto.int64_field(5)
    """Version of the etcd key, used for the storage interface."""

    creation: datetime = betterproto.message_field(6)
    """When the goal was first created."""

    when: datetime = betterproto.message_field(7)
    """The last time the goal was written."""

    subkeys: List[str] = betterproto.string_field(8)
    """
    The etcd subkeys of the goal. Prefixes to these subkeys are determined by
    the GoalType. deprecated, as we just use Subgoals, Subtasks, and Subrecs
    instead
    """

    subgoals: List[str] = betterproto.string_field(9)
    """Keys of subgoals"""

    subtasks: List["TaskRecord"] = betterproto.message_field(10)
    """Keys of subtasks (without the reconciler attached)"""


@dataclass(eq=False, repr=False)
class TaskStatus(betterproto.Message):
    """
    A TaskStatus is an individual step that changes the state of something to
    accomplish a goal.
    """

    reconciler_manager: str = betterproto.string_field(1)
    reconciler_name: str = betterproto.string_field(2)
    desc: str = betterproto.string_field(3)
    last_status: "TaskStatusStatusType" = betterproto.enum_field(4)
    self_version: int = betterproto.int64_field(5)
    """
    This is the value to set if you want to manually specify the status of a
    Task.
    """

    task_version: int = betterproto.int64_field(6)
    prev_value: bytes = betterproto.bytes_field(7)
    duration: timedelta = betterproto.message_field(8)
    """
    Used to determine if the status is actually up to date   and when a key is
    deleted while the reconciler is offline   so we know what exactly to
    teardown. When a TaskStatus is used inside of a TaskTree, this is set to
    nil   to save data and to not expose these to users.
    """

    when: datetime = betterproto.message_field(9)
    task_key: str = betterproto.string_field(10)
    subtask_keys: List[str] = betterproto.string_field(11)
    """as opposed to a key under which keys are put, i.e. /users/"""

    messages: List["TaskMessage"] = betterproto.message_field(12)
    current_status: "TaskStatusStatusType" = betterproto.enum_field(13)
    """Meant for human consumption. "Couldn't create /home/murphy"."""

    task_revision: int = betterproto.int64_field(14)
    """
    Because the value of this depends on when the TaskStatus is read,   this
    value will be overwritten when the TaskStatus is read. So, if you want to
    manually set the Status of a TaskStatus for use in etcd,   DO NOT SET THIS
    VALUE, set LastStatus instead. The value of this depends on:  - the version
    and value of the currently written task key    - if they don't match, the
    status is "Pending"  - if the reconciler doesn't seem to be alive, the
    status is "Unresponsive."  - otherwise, this is identical to LastStatus
    """

    creation: datetime = betterproto.message_field(15)


@dataclass(eq=False, repr=False)
class TaskMessage(betterproto.Message):
    """A container for messages with a severity level"""

    level: "TaskMessageType" = betterproto.enum_field(1)
    message: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class TaskTree(betterproto.Message):
    """
    TaskTree is the tree of tasks spawned by an etcd key entry. It's a
    collection of task instances and task instances created by those, etc. This
    is ephermeral, i.e. not stored in minio or etcd and sent when requested.
    """

    task: "TaskStatus" = betterproto.message_field(1)
    highest_status: "TaskStatusStatusType" = betterproto.enum_field(2)
    last_updated: datetime = betterproto.message_field(3)
    num_child_tasks: int = betterproto.int64_field(4)
    subtasks: List["TaskTree"] = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class TaskForest(betterproto.Message):
    """
    Depending on the Goal Type, Task Forest either:  - Wraps up all goals
    underneath if it is a supergoal    - For example, all subgoals across a
    materialization  - Wraps up all tasks underneath if it is a supertask    -
    For example, all keys across all reconcilers when /users/murphy is created
    This is ephermeral, i.e. not stored in minio or etcd, and sent when
    requested.
    """

    goal: "TaskGoal" = betterproto.message_field(1)
    highest_status: "TaskStatusStatusType" = betterproto.enum_field(2)
    last_updated: datetime = betterproto.message_field(3)
    num_child_tasks: int = betterproto.int64_field(4)
    subgoals: List["TaskForest"] = betterproto.message_field(5)
    subtasks: List["TaskTree"] = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class TaskSummary(betterproto.Message):
    """
    This is a summary of a TaskForest Used when we want a status of something,
    but we don't care about the details Usually sent in addition to something,
    like a materialization This is ephermeral, i.e. not stored in minio or
    etcd, and sent when requested.
    """

    highest_status: "TaskStatusStatusType" = betterproto.enum_field(1)
    first_updated: datetime = betterproto.message_field(2)
    last_updated: datetime = betterproto.message_field(3)
    messages: List["TaskMessage"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class DeprStatus(betterproto.Message):
    """
    TODO: Depreciate this. This is currently here for backwards compatibility,
    so we can convert old statuses to new ones.
    """

    result: "DeprStatusDeprResultType" = betterproto.enum_field(1)
    """Status result"""

    worker: str = betterproto.string_field(2)
    """The identity of the worker responsible for reporting on this status."""

    info: str = betterproto.string_field(3)
    """Typically used for error or warning reporting form the worker."""

    version: int = betterproto.int64_field(4)
    """Version of the state key this status is associated with."""

    reconciler: str = betterproto.string_field(5)
    """The reconciler who owns this status."""

    event: str = betterproto.string_field(6)
    """The event/type of status this is."""

    when: datetime = betterproto.message_field(7)
    """When the status was recorded"""


@dataclass(eq=False, repr=False)
class ReconcilerHealth(betterproto.Message):
    """
    ReconcilerHealth is something that a reconciler periodically checks in on
    and writes values to. This is used to see if a reconciler has gone rogue,
    but also for some basic performance metrics.
    """

    manager: str = betterproto.string_field(1)
    name: str = betterproto.string_field(2)
    self_version: int = betterproto.int64_field(3)
    start_time: datetime = betterproto.message_field(4)
    check_in_time: datetime = betterproto.message_field(5)
    duration: timedelta = betterproto.message_field(6)
    unresponsive: bool = betterproto.bool_field(7)
    keys_handled: int = betterproto.int64_field(8)
    last_key: str = betterproto.string_field(9)
    when_last_key: datetime = betterproto.message_field(10)


@dataclass(eq=False, repr=False)
class ServerHeartbeat(betterproto.Message):
    """
    For reconcilers watching for server heartbeats, the ServerHeartbeat message
    indicates the expected interval between heartbeats
    """

    interval: int = betterproto.uint64_field(1)
    when: datetime = betterproto.message_field(2)
