# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: portal/v1/alloc_types.proto, portal/v1/commission_types.proto, portal/v1/cred_types.proto, portal/v1/identity_types.proto, portal/v1/internal.proto, portal/v1/materialize_types.proto, portal/v1/model_types.proto, portal/v1/patch_types.proto, portal/v1/realize_types.proto, portal/v1/status_types.proto, portal/v1/wg_types.proto, portal/v1/workspace_types.proto, portal/v1/xdc_types.proto, proto/portal/v1/portal.proto
# plugin: python-betterproto
# This file has been @generated
import warnings
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ... import (
    reconcile as __reconcile__,
    xir as __xir__,
)


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class PatchStrategyStrategy(betterproto.Enum):
    replace = 0
    remove = 1
    expand = 2
    subtract = 3


class TaskMessageType(betterproto.Enum):
    Undefined = 0
    Error = 1
    Warning = 2
    Info = 3
    Debug = 4
    Trace = 5


class TaskStatusStatusType(betterproto.Enum):
    Undefined = 0
    Success = 1
    Deleted = 2
    Pending = 3
    Unresponsive = 4
    Processing = 5
    Error = 6


class AccessMode(betterproto.Enum):
    Public = 0
    Protected = 1
    Private = 2


class FilterMode(betterproto.Enum):
    """NOTE: FilterMode supports bitwise ORing options together."""

    ByUser = 0
    ByAll = 1


class MembershipType(betterproto.Enum):
    UserMember = 0
    ProjectMember = 1


class UserState(betterproto.Enum):
    """A users state broadly determines what they are authorized to do."""

    NotSet = 0
    """
    We need a NotSet state for updates, which may not include state and we need
    to distinguish between 0 = Pending and 0 = not included in messages which
    use this enum.
    """

    Pending = 1
    """
    User has not been activated yet. Most API calls are not available to users
    in this state.
    """

    Frozen = 2
    """
    User has been frozen by a organization maintainer or portal admin. All API
    calls are forbidden to users in this state.
    """

    Active = 3
    """
    User is active. API calls are governed by the portal's policy definitions.
    """


class MemberRole(betterproto.Enum):
    Member = 0
    Maintainer = 1
    Creator = 2


class MemberState(betterproto.Enum):
    Pending = 0
    Active = 1
    MemberRequested = 2
    EntityRequested = 3


class GetRevisionRequestEncoding(betterproto.Enum):
    NONE = 0
    XIRB64 = 1
    DOT = 2


class DiagnosticLevel(betterproto.Enum):
    DiagUnspec = 0
    Error = 1
    Warning = 2
    Info = 3
    Debug = 4
    Trace = 5


class NodeRealizationKind(betterproto.Enum):
    Undefined = 0
    BareMetal = 1
    VirtualMachine = 2


class ReservationDurationCode(betterproto.Enum):
    given = 0
    never = 1


class RealizeResponseCode(betterproto.Enum):
    Ok = 0
    BadXir = 1
    Unrealizable = 2
    InternalError = 3


class RebootMaterializationMode(betterproto.Enum):
    Reboot = 0
    Cycle = 1
    Reimage = 2


class XdcType(betterproto.Enum):
    shared = 0
    personal = 1


@dataclass(eq=False, repr=False)
class PatchStrategy(betterproto.Message):
    strategy: "PatchStrategyStrategy" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class ResourceAllocationList(betterproto.Message):
    value: List["__xir__.ResourceAllocation"] = betterproto.message_field(1)
    revision: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class CableAllocationList(betterproto.Message):
    value: List["__xir__.CableAllocation"] = betterproto.message_field(1)
    revision: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class AllocationTable(betterproto.Message):
    resource: Dict[str, "ResourceAllocationList"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    cable: Dict[str, "CableAllocationList"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )


@dataclass(eq=False, repr=False)
class AllocationRequest(betterproto.Message):
    table: "AllocationTable" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AllocationResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class FreeRequest(betterproto.Message):
    rzid: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class FreeResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class FetchAllocationTableRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class FetchAllocationTableResponse(betterproto.Message):
    table: "AllocationTable" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Pool(betterproto.Message):
    name: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    projects: List[str] = betterproto.string_field(3)
    facilities: Dict[str, "PoolResources"] = betterproto.map_field(
        4, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """Per facility list of resources (as strings)"""

    creator: str = betterproto.string_field(5)
    ver: int = betterproto.int64_field(6)
    organizations: List[str] = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class PoolResources(betterproto.Message):
    resources: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetPoolsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetPoolsResponse(betterproto.Message):
    pools: List["Pool"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetPoolRequest(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetPoolResponse(betterproto.Message):
    pool: "Pool" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreatePoolRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    projects: List[str] = betterproto.string_field(3)
    facilities: List[str] = betterproto.string_field(4)
    organizations: List[str] = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class CreatePoolResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeletePoolRequest(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class DeletePoolResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class AddProjectToPoolRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    project: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class AddProjectToPoolResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RemoveProjectFromPoolRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    project: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RemoveProjectFromPoolResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class AddOrganizationToPoolRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    organization: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class AddOrganizationToPoolResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RemoveOrganizationFromPoolRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    organization: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RemoveOrganizationFromPoolResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class AddFacilityToPoolRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    facility: str = betterproto.string_field(2)
    resources: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class AddFacilityToPoolResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RemoveFacilityFromPoolRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    facility: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RemoveFacilityFromPoolResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UpdatePoolResourcesRequest(betterproto.Message):
    pool: str = betterproto.string_field(1)
    facility: str = betterproto.string_field(2)
    resources: List[str] = betterproto.string_field(3)
    patchstrategy: "PatchStrategy" = betterproto.message_field(4)
    """
    how to merge the given resources into the existing pool replace, remove,
    expand, or subtract.
    """


@dataclass(eq=False, repr=False)
class UpdatePoolResourcesResponse(betterproto.Message):
    """
    UpdatePoolResourcesResponse contains the updates list of resources for the
    facility in the pool.
    """

    pool: str = betterproto.string_field(1)
    facility: str = betterproto.string_field(2)
    resources: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class TaskMessage(betterproto.Message):
    """A container for messages with a severity level"""

    level: "TaskMessageType" = betterproto.enum_field(1)
    message: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class TaskStatus(betterproto.Message):
    id: str = betterproto.string_field(1)
    name: str = betterproto.string_field(2)
    message: "TaskMessage" = betterproto.message_field(3)
    status_value: "TaskStatusStatusType" = betterproto.enum_field(4)
    first_updated: datetime = betterproto.message_field(5)
    last_updated: datetime = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class TaskTree(betterproto.Message):
    highest_status: "TaskStatusStatusType" = betterproto.enum_field(1)
    last_updated: datetime = betterproto.message_field(2)
    num_child_tasks: int = betterproto.int64_field(3)
    task: "TaskStatus" = betterproto.message_field(4)
    subtasks: List["TaskTree"] = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class TaskSummary(betterproto.Message):
    highest_status: "TaskStatusStatusType" = betterproto.enum_field(1)
    first_updated: datetime = betterproto.message_field(2)
    last_updated: datetime = betterproto.message_field(3)
    messages: List["TaskMessage"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class AccessModeUpdate(betterproto.Message):
    value: "AccessMode" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class UserStateUpdate(betterproto.Message):
    value: "UserState" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class Member(betterproto.Message):
    role: "MemberRole" = betterproto.enum_field(2)
    state: "MemberState" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class MembershipUpdate(betterproto.Message):
    remove: List[str] = betterproto.string_field(1)
    """A list of entities to remove a member from."""

    set: Dict[str, "Member"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """
    A set of entities to add a member to. If the member is already present
    within the entity, their membership status is overwritten with the provided
    value.
    """


@dataclass(eq=False, repr=False)
class User(betterproto.Message):
    """
    This is the definition of a user in MergeTB that is used for storage of
    record and messaging between applications.
    """

    username: str = betterproto.string_field(1)
    """The users unique identifier."""

    name: str = betterproto.string_field(2)
    """Full name of the user."""

    state: "UserState" = betterproto.enum_field(3)
    """What state the user account is in."""

    access_mode: "AccessMode" = betterproto.enum_field(4)
    """The visibility of the user account."""

    uid: int = betterproto.uint32_field(5)
    """MergeFS user id."""

    gid: int = betterproto.uint32_field(6)
    """MergeFS group id."""

    projects: Dict[str, "Member"] = betterproto.map_field(
        7, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """Projects the user is a member of."""

    experiments: List[str] = betterproto.string_field(8)
    """Experiments the user is a creator or maintainer of."""

    organizations: Dict[str, "Member"] = betterproto.map_field(
        9, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """Organizations the user is a member of."""

    facilities: Dict[str, "Member"] = betterproto.map_field(
        10, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """Facilities this user is a member of."""

    admin: bool = betterproto.bool_field(11)
    ver: int = betterproto.int64_field(12)
    """Revision counter for this object."""

    institution: str = betterproto.string_field(13)
    """User Traits."""

    category: str = betterproto.string_field(14)
    email: str = betterproto.string_field(15)
    country: str = betterproto.string_field(16)
    usstate: str = betterproto.string_field(17)


@dataclass(eq=False, repr=False)
class InitUserRequest(betterproto.Message):
    username: str = betterproto.string_field(1)
    """The user to initialize."""


@dataclass(eq=False, repr=False)
class InitUserResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ActivateUserRequest(betterproto.Message):
    username: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ActivateUserResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class FreezeUserRequest(betterproto.Message):
    username: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class FreezeUserResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetUsersRequest(betterproto.Message):
    filter: "FilterMode" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class GetUsersResponse(betterproto.Message):
    users: List["User"] = betterproto.message_field(1)
    """A list of users."""


@dataclass(eq=False, repr=False)
class GetUserRequest(betterproto.Message):
    username: str = betterproto.string_field(1)
    """The identity of the user."""

    status_ms: int = betterproto.int32_field(2)


@dataclass(eq=False, repr=False)
class GetUserResponse(betterproto.Message):
    user: "User" = betterproto.message_field(1)
    """The requested user."""

    status: "TaskTree" = betterproto.message_field(2)
    """The status, if requested"""


@dataclass(eq=False, repr=False)
class UpdateUserRequest(betterproto.Message):
    username: str = betterproto.string_field(1)
    """The id of the user to update."""

    name: str = betterproto.string_field(2)
    """The colloquial name of the user."""

    state: "UserStateUpdate" = betterproto.message_field(3)
    """Optional state update"""

    access_mode: "AccessModeUpdate" = betterproto.message_field(4)
    """Optional access mode update."""

    organizations: "MembershipUpdate" = betterproto.message_field(5)
    """Optional organization membership update."""

    projects: "MembershipUpdate" = betterproto.message_field(6)
    """Optional project membership update."""

    facilities: "MembershipUpdate" = betterproto.message_field(7)
    """Optional facility membership update."""

    experiments: List[str] = betterproto.string_field(8)
    """Optional experiment membership update."""

    toggle_admin: bool = betterproto.bool_field(9)
    """If true, toggle the user's admin state."""


@dataclass(eq=False, repr=False)
class UpdateUserResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteUserRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    """The identity of the user."""


@dataclass(eq=False, repr=False)
class DeleteUserResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UserStatus(betterproto.Message):
    """
    UserStatus - keeps track of active user status on the portal (currently
    just if they are logged in or not)
    """

    username: str = betterproto.string_field(1)
    loggedin: bool = betterproto.bool_field(2)
    ver: int = betterproto.int64_field(3)


@dataclass(eq=False, repr=False)
class PublicKey(betterproto.Message):
    fingerprint: str = betterproto.string_field(1)
    """SHA256 fingerprint of the SSH key."""

    key: str = betterproto.string_field(2)
    """The ssh-rsa key."""


@dataclass(eq=False, repr=False)
class GetUserPublicKeysRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    """The user to fetch keys for."""


@dataclass(eq=False, repr=False)
class GetUserPublicKeysResponse(betterproto.Message):
    keys: List["PublicKey"] = betterproto.message_field(1)
    """The public keys for the specified user."""


@dataclass(eq=False, repr=False)
class AddUserPublicKeyRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    """The user to add a new public key for."""

    key: str = betterproto.string_field(2)
    """An ssh-rsa public key."""


@dataclass(eq=False, repr=False)
class AddUserPublicKeyResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteUserPublicKeyRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    """The user to remove the public key from."""

    fingerprint: str = betterproto.string_field(2)
    """The SHA256 fingerprint of the key to remove."""


@dataclass(eq=False, repr=False)
class DeleteUserPublicKeyResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteUserPublicKeysRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    """User to delete to remove public keys for."""


@dataclass(eq=False, repr=False)
class DeleteUserPublicKeysResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class Project(betterproto.Message):
    name: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    members: Dict[str, "Member"] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    experiments: List[str] = betterproto.string_field(4)
    access_mode: "AccessMode" = betterproto.enum_field(5)
    gid: int = betterproto.uint32_field(6)
    deprecated: List[str] = betterproto.string_field(7)
    """here for backwards compatibility"""

    ver: int = betterproto.int64_field(8)
    organization: str = betterproto.string_field(9)
    org_membership: "Member" = betterproto.message_field(10)
    category: str = betterproto.string_field(11)
    subcategory: str = betterproto.string_field(12)


@dataclass(eq=False, repr=False)
class GetProjectsRequest(betterproto.Message):
    filter: "FilterMode" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class GetProjectsResponse(betterproto.Message):
    projects: List["Project"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetProjectRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    status_ms: int = betterproto.int32_field(2)


@dataclass(eq=False, repr=False)
class GetProjectResponse(betterproto.Message):
    project: "Project" = betterproto.message_field(1)
    status: "TaskTree" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class DeleteProjectRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    name: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteProjectResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class CreateProjectRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    project: "Project" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CreateProjectResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DescriptionUpdate(betterproto.Message):
    value: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class UpdateProjectRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Name of the project to update."""

    description: "DescriptionUpdate" = betterproto.message_field(2)
    """Optional description update."""

    access_mode: "AccessModeUpdate" = betterproto.message_field(3)
    """Optional access mode update."""

    members: "MembershipUpdate" = betterproto.message_field(4)
    """Optional project membership update."""

    organization: "MembershipUpdate" = betterproto.message_field(5)
    """Optional organization membership update."""


@dataclass(eq=False, repr=False)
class UpdateProjectResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetProjectMembersRequest(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetProjectMembersResponse(betterproto.Message):
    members: List["Member"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetProjectMemberRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    member: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetProjectMemberResponse(betterproto.Message):
    member: "Member" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AddProjectMemberRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    username: str = betterproto.string_field(2)
    member: "Member" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class AddProjectMemberResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UpdateProjectMemberRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    username: str = betterproto.string_field(2)
    member: "Member" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class UpdateProjectMemberResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteProjectMemberRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    member: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteProjectMemberResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ExperimentModel(betterproto.Message):
    compiled: bool = betterproto.bool_field(1)
    msg: str = betterproto.string_field(2)
    realizations: List[str] = betterproto.string_field(3)
    compile_time: datetime = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class Experiment(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Name of the experiment."""

    project: str = betterproto.string_field(2)
    """Project this experiment belongs to."""

    description: str = betterproto.string_field(3)
    """A short description."""

    models: Dict[str, "ExperimentModel"] = betterproto.map_field(
        4, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """A map of source revisions to their model and realization status"""

    access_mode: "AccessMode" = betterproto.enum_field(5)
    """Visibility of this experiment."""

    repository: str = betterproto.string_field(6)
    """Git repository where this experiments source is held."""

    creator: str = betterproto.string_field(7)
    maintainers: List[str] = betterproto.string_field(8)
    ver: int = betterproto.int64_field(9)
    """
    Experiment version, increments each time experiment metadata is updated.
    """


@dataclass(eq=False, repr=False)
class GetExperimentsRequest(betterproto.Message):
    filter: "FilterMode" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class GetExperimentsResponse(betterproto.Message):
    experiments: List["Experiment"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetProjectExperimentsRequest(betterproto.Message):
    project: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetProjectExperimentsResponse(betterproto.Message):
    experiments: List["Experiment"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetExperimentRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    with_models: bool = betterproto.bool_field(3)
    status_ms: int = betterproto.int32_field(4)


@dataclass(eq=False, repr=False)
class XpNetModel(betterproto.Message):
    compiled: bool = betterproto.bool_field(1)
    model: "__xir__.Network" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetExperimentResponse(betterproto.Message):
    experiment: "Experiment" = betterproto.message_field(1)
    models: Dict[str, "XpNetModel"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    status: "TaskTree" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class UpdateExperimentRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Name of the experiment to update"""

    project: str = betterproto.string_field(2)
    """Name of the project the experiment is in"""

    description: "DescriptionUpdate" = betterproto.message_field(3)
    """Optional description update."""

    access_mode: "AccessModeUpdate" = betterproto.message_field(4)
    """Optional access mode update."""

    creator: str = betterproto.string_field(5)
    """set experiment creator"""

    maintainers: List[str] = betterproto.string_field(6)
    """
    experiment maintainers have some privledges depending on the active policy
    """


@dataclass(eq=False, repr=False)
class UpdateExperimentResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class CreateExperimentRequest(betterproto.Message):
    experiment: "Experiment" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CreateExperimentResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteExperimentRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteExperimentResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetRevisionRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    revision: str = betterproto.string_field(3)
    encoding: "GetRevisionRequestEncoding" = betterproto.enum_field(4)


@dataclass(eq=False, repr=False)
class GetRevisionResponse(betterproto.Message):
    model: "XpNetModel" = betterproto.message_field(1)
    encoding: str = betterproto.string_field(2)
    model_file: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class Organization(betterproto.Message):
    name: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    oid: int = betterproto.uint32_field(3)
    members: Dict[str, "Member"] = betterproto.map_field(
        4, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    projects: Dict[str, "Member"] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    state: "UserState" = betterproto.enum_field(6)
    access_mode: "AccessMode" = betterproto.enum_field(7)
    ver: int = betterproto.int64_field(8)
    """Revision counter for this object."""

    category: str = betterproto.string_field(9)
    subcategory: str = betterproto.string_field(10)


@dataclass(eq=False, repr=False)
class ActivateOrganizationRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ActivateOrganizationResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class FreezeOrganizationRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class FreezeOrganizationResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetOrganizationsRequest(betterproto.Message):
    filter: "FilterMode" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class GetOrganizationsResponse(betterproto.Message):
    organizations: List["Organization"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetOrganizationRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    status_ms: int = betterproto.int32_field(2)


@dataclass(eq=False, repr=False)
class GetOrganizationResponse(betterproto.Message):
    organization: "Organization" = betterproto.message_field(1)
    status: "TaskTree" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class DeleteOrganizationRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    name: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteOrganizationResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class CreateOrganizationRequest(betterproto.Message):
    user: str = betterproto.string_field(1)
    organization: "Organization" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CreateOrganizationResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UpdateOrganizationRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Name of the organization to update."""

    description: "DescriptionUpdate" = betterproto.message_field(2)
    """Optional description update."""

    state: "UserStateUpdate" = betterproto.message_field(3)
    """Optional state update"""

    access_mode: "AccessModeUpdate" = betterproto.message_field(4)
    """Optional access mode update."""

    members: "MembershipUpdate" = betterproto.message_field(5)
    """Optional user membership update."""

    projects: "MembershipUpdate" = betterproto.message_field(6)
    """Optional project membership update."""


@dataclass(eq=False, repr=False)
class UpdateOrganizationResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetOrganizationMembersRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetOrganizationMembersResponse(betterproto.Message):
    members: List["Member"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetOrganizationMemberRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)
    username: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetOrganizationMemberResponse(betterproto.Message):
    member: "Member" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RequestOrganizationMembershipRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)
    kind: "MembershipType" = betterproto.enum_field(3)
    member: "Member" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class RequestOrganizationMembershipResponse(betterproto.Message):
    member: "Member" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ConfirmOrganizationMembershipRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)
    id: str = betterproto.string_field(2)
    kind: "MembershipType" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class ConfirmOrganizationMembershipResponse(betterproto.Message):
    member: "Member" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateOrganizationMemberRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)
    username: str = betterproto.string_field(2)
    member: "Member" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class UpdateOrganizationMemberResponse(betterproto.Message):
    member: "Member" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DeleteOrganizationMemberRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)
    username: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteOrganizationMemberResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetOrganizationProjectsRequest(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetOrganizationProjectsResponse(betterproto.Message):
    projects: List["Member"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetOrganizationProjectRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)
    project: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetOrganizationProjectResponse(betterproto.Message):
    member: "Member" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class AddOrganizationProjectRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)
    project: str = betterproto.string_field(2)
    member: "Member" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class AddOrganizationProjectResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UpdateOrganizationProjectRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)
    project: str = betterproto.string_field(2)
    member: "Member" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class UpdateOrganizationProjectResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteOrganizationProjectRequest(betterproto.Message):
    organization: str = betterproto.string_field(1)
    project: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteOrganizationProjectResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetUserConfigurationsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetUserConfigurationsResponse(betterproto.Message):
    institutions: List[str] = betterproto.string_field(1)
    countries: List["GetUserConfigurationsResponseCountry"] = betterproto.message_field(
        2
    )
    usstates: List["GetUserConfigurationsResponseUsState"] = betterproto.message_field(
        3
    )
    categories: List[str] = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class GetUserConfigurationsResponseCountry(betterproto.Message):
    name: str = betterproto.string_field(1)
    iso2: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetUserConfigurationsResponseUsState(betterproto.Message):
    name: str = betterproto.string_field(1)
    usps2: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class UpdateUserConfigurationsRequest(betterproto.Message):
    institutions: List[str] = betterproto.string_field(1)
    categories: List[str] = betterproto.string_field(2)
    patchstrategy: "PatchStrategy" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class UpdateUserConfigurationsResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetEntityTypeConfigurationsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class EntityType(betterproto.Message):
    etype: str = betterproto.string_field(1)
    subtypes: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetEntityTypeConfigurationsResponse(betterproto.Message):
    types: List["EntityType"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateEntityTypeConfigurationsRequest(betterproto.Message):
    types: List["EntityType"] = betterproto.message_field(1)
    patchstrategy: "PatchStrategy" = betterproto.message_field(2)
    """How to update types"""


@dataclass(eq=False, repr=False)
class UpdateEntityTypeConfigurationsResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetPolicyRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetPolicyResponse(betterproto.Message):
    policy: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class HealthRequest(betterproto.Message):
    """
    Health
    =====================================================================
    """

    pass


@dataclass(eq=False, repr=False)
class HealthResponse(betterproto.Message):
    status: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class Facility(betterproto.Message):
    name: str = betterproto.string_field(1)
    address: str = betterproto.string_field(2)
    description: str = betterproto.string_field(3)
    access_mode: "AccessMode" = betterproto.enum_field(4)
    members: Dict[str, "Member"] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    certificate: str = betterproto.string_field(6)
    cacertificate: str = betterproto.string_field(7)
    ver: int = betterproto.int64_field(8)


@dataclass(eq=False, repr=False)
class BlockPool(betterproto.Message):
    blocks: List[str] = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class RegisterFacilityRequest(betterproto.Message):
    facility: "Facility" = betterproto.message_field(1)
    model: "__xir__.Facility" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class RegisterFacilityResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    message: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetFacilitiesRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetFacilitiesResponse(betterproto.Message):
    facilities: List["Facility"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetFacilityRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    with_model: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class GetFacilityResponse(betterproto.Message):
    facility: "Facility" = betterproto.message_field(1)
    model: "__xir__.Facility" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class UpdateFacilityRequest(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Name of the facility to update"""

    address: str = betterproto.string_field(2)
    """Optional facility address update. Empty string indicates no update."""

    description: "DescriptionUpdate" = betterproto.message_field(3)
    """Optional description update."""

    access_mode: "AccessModeUpdate" = betterproto.message_field(4)
    """Optional access mode update."""

    members: "MembershipUpdate" = betterproto.message_field(5)
    """Optional experiment membership update."""

    certificate: str = betterproto.string_field(6)
    """Optional cert update. Empty string indicates no update."""

    cacertificate: str = betterproto.string_field(7)
    model: "__xir__.Facility" = betterproto.message_field(8)
    """Optional model update"""

    model_patch_strategy: "PatchStrategy" = betterproto.message_field(9)
    """If a model is given, how to merge the model into the existing one."""


@dataclass(eq=False, repr=False)
class UpdateFacilityResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteFacilityRequest(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class DeleteFacilityResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeactivateResourcesRequest(betterproto.Message):
    facility: str = betterproto.string_field(1)
    resources: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeactivateResourcesResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ActivateResourcesRequest(betterproto.Message):
    facility: str = betterproto.string_field(1)
    resources: List[str] = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ActivateResourcesResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListBlockPoolsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListBlockPoolsResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class InitHarborRequest(betterproto.Message):
    facility: str = betterproto.string_field(1)
    ver: int = betterproto.int64_field(2)
    rid: str = betterproto.string_field(3)
    eid: str = betterproto.string_field(4)
    pid: str = betterproto.string_field(5)
    status_ms: int = betterproto.int32_field(6)


@dataclass(eq=False, repr=False)
class InitHarborResponse(betterproto.Message):
    status: "TaskTree" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DeinitHarborRequest(betterproto.Message):
    facility: str = betterproto.string_field(1)
    ver: int = betterproto.int64_field(2)
    rid: str = betterproto.string_field(3)
    eid: str = betterproto.string_field(4)
    pid: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class DeinitHarborResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class SshKeyPair(betterproto.Message):
    public: str = betterproto.string_field(1)
    private: str = betterproto.string_field(2)
    ver: int = betterproto.int64_field(3)


@dataclass(eq=False, repr=False)
class GetUserSshKeysRequest(betterproto.Message):
    username: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetUserSshKeysResponse(betterproto.Message):
    keys: "SshKeyPair" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SshCert(betterproto.Message):
    cert: str = betterproto.string_field(1)
    ca_host_pub_key: str = betterproto.string_field(2)
    ver: int = betterproto.int64_field(3)


@dataclass(eq=False, repr=False)
class GetUserSshCertRequest(betterproto.Message):
    username: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetUserSshCertResponse(betterproto.Message):
    cert: "SshCert" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class IdentityInfo(betterproto.Message):
    username: str = betterproto.string_field(1)
    """The identity of the user."""

    email: str = betterproto.string_field(2)
    """The user's email."""

    admin: bool = betterproto.bool_field(3)
    """
    This is an administrator account. Can only be set by existing admins.
    """

    traits: Dict[str, str] = betterproto.map_field(
        4, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("admin"):
            warnings.warn("IdentityInfo.admin is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class ListIdentityRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListIdentityResponse(betterproto.Message):
    identities: List["IdentityInfo"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetIdentityRequest(betterproto.Message):
    username: str = betterproto.string_field(1)
    """The identity of the user."""


@dataclass(eq=False, repr=False)
class GetIdentityResponse(betterproto.Message):
    identity: "IdentityInfo" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class RegisterRequest(betterproto.Message):
    username: str = betterproto.string_field(1)
    """The identity of the user."""

    email: str = betterproto.string_field(2)
    """The user's email."""

    password: str = betterproto.string_field(3)
    """The user's password."""

    admin: bool = betterproto.bool_field(4)
    """
    This is an administrator account. Can only be set by existing admins.
    """

    traits: Dict[str, str] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """Traits not explicity specified by this API. Depreciated."""

    institution: str = betterproto.string_field(6)
    """User data"""

    category: str = betterproto.string_field(7)
    country: str = betterproto.string_field(8)
    usstate: str = betterproto.string_field(9)
    name: str = betterproto.string_field(10)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("traits"):
            warnings.warn("RegisterRequest.traits is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class RegisterResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class LoginRequest(betterproto.Message):
    username: str = betterproto.string_field(1)
    """The identity of the user."""

    password: str = betterproto.string_field(3)
    """The user's password."""


@dataclass(eq=False, repr=False)
class LoginResponse(betterproto.Message):
    token: str = betterproto.string_field(1)
    """An OAuth2 access token."""


@dataclass(eq=False, repr=False)
class LogoutRequest(betterproto.Message):
    username: str = betterproto.string_field(1)
    """The identity of the user."""


@dataclass(eq=False, repr=False)
class LogoutResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class UnregisterRequest(betterproto.Message):
    username: str = betterproto.string_field(1)
    """The identity of the user."""


@dataclass(eq=False, repr=False)
class UnregisterResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class CountSet(betterproto.Message):
    name: str = betterproto.string_field(1)
    size: int = betterproto.uint64_field(2)
    values: List[int] = betterproto.uint64_field(3)
    offset: int = betterproto.uint64_field(4)
    ver: int = betterproto.int64_field(5)


@dataclass(eq=False, repr=False)
class Vlist(betterproto.Message):
    values: List[int] = betterproto.uint32_field(1)


@dataclass(eq=False, repr=False)
class Realization(betterproto.Message):
    complete: bool = betterproto.bool_field(1)
    id: str = betterproto.string_field(2)
    eid: str = betterproto.string_field(3)
    pid: str = betterproto.string_field(4)
    xhash: str = betterproto.string_field(5)
    nodes: Dict[str, "NodeRealization"] = betterproto.map_field(
        6, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    links: Dict[str, "LinkRealization"] = betterproto.map_field(
        7, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    phyos: Dict[str, "PhyoRealization"] = betterproto.map_field(
        8, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    sensors: Dict[str, "SensorRealization"] = betterproto.map_field(
        9, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    actuators: Dict[str, "ActuatorRealization"] = betterproto.map_field(
        10, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    bonds: Dict[str, "BondRealization"] = betterproto.map_field(
        11, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    infranet: "InfranetEmbedding" = betterproto.message_field(12)
    creator: str = betterproto.string_field(13)
    ver: int = betterproto.int64_field(14)
    link_emulation: "LinkEmulationParams" = betterproto.message_field(15)
    created: datetime = betterproto.message_field(16)
    expires: datetime = betterproto.message_field(17)


@dataclass(eq=False, repr=False)
class RealizationSummary(betterproto.Message):
    """
    ephemeral -- not meant to be stored at all, and just constructed for
    requests when needed from a realization
    """

    complete: bool = betterproto.bool_field(1)
    id: str = betterproto.string_field(2)
    eid: str = betterproto.string_field(3)
    pid: str = betterproto.string_field(4)
    xhash: str = betterproto.string_field(5)
    creator: str = betterproto.string_field(6)
    ver: int = betterproto.int64_field(7)
    created: datetime = betterproto.message_field(8)
    expires: datetime = betterproto.message_field(9)
    num_nodes: int = betterproto.int32_field(10)
    num_links: int = betterproto.int32_field(11)


@dataclass(eq=False, repr=False)
class InfrapodConfig(betterproto.Message):
    phy: str = betterproto.string_field(1)
    addr: str = betterproto.string_field(2)
    subnet: str = betterproto.string_field(3)
    gw: str = betterproto.string_field(4)
    vid: int = betterproto.uint32_field(5)
    mgmt_phy: str = betterproto.string_field(6)
    vni: int = betterproto.uint32_field(7)


@dataclass(eq=False, repr=False)
class InfranetEmbedding(betterproto.Message):
    infrapod_server: str = betterproto.string_field(1)
    """hostname of infrapod server"""

    infrapod_site: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class BlockPoolAllocations(betterproto.Message):
    id: str = betterproto.string_field(1)
    allocations: "CountSet" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Neighbor(betterproto.Message):
    prefix_v4: str = betterproto.string_field(1)
    prefix_v6: str = betterproto.string_field(2)
    nexthop: str = betterproto.string_field(3)
    mac: str = betterproto.string_field(4)
    name: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class NodeRealization(betterproto.Message):
    node: "__xir__.Node" = betterproto.message_field(1)
    resource: "__xir__.Resource" = betterproto.message_field(2)
    vm_alloc: "__xir__.ResourceAllocation" = betterproto.message_field(3)
    facility: str = betterproto.string_field(4)
    kind: "NodeRealizationKind" = betterproto.enum_field(5)
    infranet_addr: str = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class LinkRealization(betterproto.Message):
    link: "__xir__.Link" = betterproto.message_field(1)
    segments: Dict[int, "LinkSegment"] = betterproto.map_field(
        2, betterproto.TYPE_UINT64, betterproto.TYPE_MESSAGE
    )


@dataclass(eq=False, repr=False)
class PhyoRealization(betterproto.Message):
    simulator: str = betterproto.string_field(1)
    facility: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class BondRealization(betterproto.Message):
    simulator: str = betterproto.string_field(1)
    facility: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SensorRealization(betterproto.Message):
    simulator: str = betterproto.string_field(1)
    facility: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ActuatorRealization(betterproto.Message):
    simulator: str = betterproto.string_field(1)
    facility: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class LinkSegment(betterproto.Message):
    endpoints: List["Endpoint"] = betterproto.message_field(1)
    waypoints: List["Waypoint"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Endpoint(betterproto.Message):
    facility: str = betterproto.string_field(1)
    host: str = betterproto.string_field(2)
    node: str = betterproto.string_field(3)
    bridge: "BridgeMember" = betterproto.message_field(4)
    mac: str = betterproto.string_field(5)
    phy: "PhysicalInterface" = betterproto.message_field(6, group="interface")
    vlan: "VlanInterface" = betterproto.message_field(7, group="interface")
    vtep: "Vtep" = betterproto.message_field(8, group="interface")
    vf: "VfInterface" = betterproto.message_field(12, group="interface")
    trunk: "VlanTrunkPort" = betterproto.message_field(13, group="interface")
    evpn: "Evpn" = betterproto.message_field(9)
    mtu: int = betterproto.uint32_field(10)
    virtual: bool = betterproto.bool_field(11)


@dataclass(eq=False, repr=False)
class Waypoint(betterproto.Message):
    facility: str = betterproto.string_field(1)
    host: str = betterproto.string_field(2)
    bridge: "BridgeMember" = betterproto.message_field(3)
    access: "VlanAccessPort" = betterproto.message_field(4, group="interface")
    trunk: "VlanTrunkPort" = betterproto.message_field(5, group="interface")
    tap: "VlanTapPort" = betterproto.message_field(6, group="interface")
    vtep: "Vtep" = betterproto.message_field(7, group="interface")
    bgp_peer: "BgpPeer" = betterproto.message_field(8, group="interface")
    mtu: int = betterproto.uint32_field(9)


@dataclass(eq=False, repr=False)
class BridgeMember(betterproto.Message):
    bridge: str = betterproto.string_field(1)
    untagged: List[int] = betterproto.uint32_field(2)
    tagged: List[int] = betterproto.uint32_field(3)
    pvid: int = betterproto.uint32_field(4)


@dataclass(eq=False, repr=False)
class Evpn(betterproto.Message):
    mac: "EvpnMacAdv" = betterproto.message_field(1)
    multicast: "EvpnMulticastAdv" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EvpnMacAdv(betterproto.Message):
    mac: str = betterproto.string_field(1)
    tunnel_ip: str = betterproto.string_field(2)
    vni: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class EvpnMulticastAdv(betterproto.Message):
    tunnel_ip: str = betterproto.string_field(1)
    vni: int = betterproto.uint32_field(2)


@dataclass(eq=False, repr=False)
class PhysicalInterface(betterproto.Message):
    name: str = betterproto.string_field(1)
    mac: str = betterproto.string_field(2)
    port_index: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class VirtualFunction(betterproto.Message):
    name: str = betterproto.string_field(1)
    pf: "PhysicalInterface" = betterproto.message_field(2)
    vf_index: int = betterproto.uint32_field(3)
    mac: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class VlanInterface(betterproto.Message):
    name: str = betterproto.string_field(1)
    vid: int = betterproto.uint32_field(2)
    parent: "PhysicalInterface" = betterproto.message_field(3)
    addrs: List[str] = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class VfInterface(betterproto.Message):
    """SRIOV: VF (Virtual Function interface)"""

    virtif: "PhysicalInterface" = betterproto.message_field(1)
    parent: "VirtualFunction" = betterproto.message_field(2)
    vid: int = betterproto.uint32_field(3)
    addrs: List[str] = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class Vtep(betterproto.Message):
    name: str = betterproto.string_field(1)
    vni: int = betterproto.uint32_field(2)
    parent: "PhysicalInterface" = betterproto.message_field(3)
    tunnel_ip: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class BgpPeer(betterproto.Message):
    interface: "PhysicalInterface" = betterproto.message_field(1)
    local_asn: int = betterproto.uint32_field(2)
    remote_asn: int = betterproto.uint32_field(3)
    network: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class VlanAccessPort(betterproto.Message):
    port: "PhysicalInterface" = betterproto.message_field(1)
    vid: int = betterproto.uint32_field(2)


@dataclass(eq=False, repr=False)
class VlanTrunkPort(betterproto.Message):
    port: "PhysicalInterface" = betterproto.message_field(1)
    vids: List[int] = betterproto.uint32_field(2)


@dataclass(eq=False, repr=False)
class VlanTapPort(betterproto.Message):
    """A VLAN access port in the form of a TAP device"""

    node: str = betterproto.string_field(1)
    frontend: "PhysicalInterface" = betterproto.message_field(2)
    vid: int = betterproto.uint32_field(3)
    vni: int = betterproto.uint32_field(4)


@dataclass(eq=False, repr=False)
class VlanVfPort(betterproto.Message):
    """SRIOV: VLANVfPort is a tagged VF seen by the VM as `frontend`"""

    vf: "VirtualFunction" = betterproto.message_field(1)
    frontend: "PhysicalInterface" = betterproto.message_field(2)
    vid: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class Diagnostic(betterproto.Message):
    message: str = betterproto.string_field(1)
    level: "DiagnosticLevel" = betterproto.enum_field(2)
    data: Dict[str, str] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    guest: str = betterproto.string_field(4)
    host: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class DiagnosticList(betterproto.Message):
    value: List["Diagnostic"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class LinkEmulation(betterproto.Message):
    loss: float = betterproto.float_field(1)
    capacity: int = betterproto.uint64_field(2)
    latency: int = betterproto.uint64_field(3)
    tags: List[str] = betterproto.string_field(4)
    interfaces: List[str] = betterproto.string_field(5)
    nodes: List[str] = betterproto.string_field(6)
    server: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class LinkEmulationParams(betterproto.Message):
    server: str = betterproto.string_field(1)
    links: List["LinkEmulation"] = betterproto.message_field(2)
    backend: "__xir__.Emulation" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class RealizationResult(betterproto.Message):
    realization: "Realization" = betterproto.message_field(1)
    diagnostics: "DiagnosticList" = betterproto.message_field(2)
    summary: "RealizationSummary" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class GetRealizationsRequest(betterproto.Message):
    filter: "FilterMode" = betterproto.enum_field(1)
    """from workspace_types"""

    summary: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class GetRealizationsResponse(betterproto.Message):
    results: List["RealizationResult"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetRealizationRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)
    status_ms: int = betterproto.int32_field(4)


@dataclass(eq=False, repr=False)
class GetRealizationResponse(betterproto.Message):
    result: "RealizationResult" = betterproto.message_field(1)
    status: "TaskTree" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class RealizeRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    """The project this realization's experiment belongs to."""

    experiment: str = betterproto.string_field(2)
    """The name of the experiment this realization belongs to."""

    realization: str = betterproto.string_field(3)
    """The name of the realization."""

    revision: str = betterproto.string_field(4)
    """
    Experiment revision to realize. Only one of revision, tag, or branch is
    allowed.
    """

    creator: str = betterproto.string_field(5)
    """The user who created this realization."""

    time: str = betterproto.string_field(6)
    """The time this realization was submitted."""

    ver: int = betterproto.int64_field(7)
    """The version of this realization request object."""

    tag: str = betterproto.string_field(8)
    """
    The git tag to use for this realization. Only one of revision, tag, or
    branch is allowed.
    """

    branch: str = betterproto.string_field(9)
    """
    The branch to use for this realization. HEAD revision will e realized. Only
    one of revision, tag, or branch is allowed.
    """

    duration: "ReservationDuration" = betterproto.message_field(10)


@dataclass(eq=False, repr=False)
class ReservationDuration(betterproto.Message):
    when: "ReservationDurationCode" = betterproto.enum_field(1)
    duration: str = betterproto.string_field(2)
    """
    How long to reserve the resources of the realization. After the duration
    ends the realization is available to be forcibly relinquished to free
    reserved resources. The format of the duration follows the golang
    time.ParseDuration with extra fields for weeks and days prepending the
    golang duration. Example: 2 weeks, 3 days, 4 hours, 5 seconds is
    "2w3d4h5s". Any field may be absent. "2w4h" is 2 weeks for hours. A day is
    24 hours. A week is 7 days. Only used if "when" is "given".
    """


@dataclass(eq=False, repr=False)
class RealizeResponse(betterproto.Message):
    code: "RealizeResponseCode" = betterproto.enum_field(1)
    diagnostics: List["Diagnostic"] = betterproto.message_field(2)
    realization: "Realization" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class RelinquishRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class RelinquishResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class Allocation(betterproto.Message):
    """End user view of realization resources"""

    rid: str = betterproto.string_field(1)
    eid: str = betterproto.string_field(2)
    pid: str = betterproto.string_field(3)
    uid: str = betterproto.string_field(4)
    fid: str = betterproto.string_field(5)
    oid: str = betterproto.string_field(6)
    node: str = betterproto.string_field(7)
    virt: bool = betterproto.bool_field(8)
    cores_used: int = betterproto.uint32_field(9)
    memory_used: int = betterproto.uint64_field(10)


@dataclass(eq=False, repr=False)
class Resource(betterproto.Message):
    resource: "__xir__.Resource" = betterproto.message_field(1)
    allocated: List["Allocation"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetResourcesRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetResourcesResponse(betterproto.Message):
    resources: List["Resource"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateRealizationRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)
    duration: "ReservationDuration" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class UpdateRealizationResponse(betterproto.Message):
    expires: datetime = betterproto.message_field(1)
    """The new expiration time, if updated."""


@dataclass(eq=False, repr=False)
class MzParameters(betterproto.Message):
    infrapod_server: str = betterproto.string_field(1)
    infrapod_phy: str = betterproto.string_field(2)
    infranet_addr: str = betterproto.string_field(3)
    infranet_subnet: str = betterproto.string_field(4)
    infranet_gw: str = betterproto.string_field(5)
    infranet_vni: int = betterproto.uint32_field(6)
    resolve_expnet: bool = betterproto.bool_field(7)


@dataclass(eq=False, repr=False)
class Materialization(betterproto.Message):
    rid: str = betterproto.string_field(1)
    eid: str = betterproto.string_field(2)
    pid: str = betterproto.string_field(3)
    params: "MzParameters" = betterproto.message_field(4)
    metal: List["BareMetal"] = betterproto.message_field(5)
    """Cyber"""

    vms: List["VirtualMachine"] = betterproto.message_field(6)
    links: List["Link"] = betterproto.message_field(7)
    phyos: List["Phyo"] = betterproto.message_field(8)
    """Physical"""

    bonds: List["Bond"] = betterproto.message_field(9)
    sensors: List["Sensor"] = betterproto.message_field(10)
    actuators: List["Actuator"] = betterproto.message_field(11)
    link_emulation: "LinkEmulationParams" = betterproto.message_field(12)
    """Moa"""


@dataclass(eq=False, repr=False)
class MaterializationSummary(betterproto.Message):
    rid: str = betterproto.string_field(1)
    eid: str = betterproto.string_field(2)
    pid: str = betterproto.string_field(3)
    num_metal: int = betterproto.int32_field(4)
    num_virtual: int = betterproto.int32_field(5)
    num_links: int = betterproto.int32_field(6)


@dataclass(eq=False, repr=False)
class UserInfo(betterproto.Message):
    name: str = betterproto.string_field(1)
    groups: List[str] = betterproto.string_field(2)
    pubkeys: List[str] = betterproto.string_field(3)
    privkeys: List[str] = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class BareMetal(betterproto.Message):
    facility: str = betterproto.string_field(1)
    resource: str = betterproto.string_field(2)
    model: "__xir__.Node" = betterproto.message_field(3)
    users: List["UserInfo"] = betterproto.message_field(4)
    inframac: str = betterproto.string_field(5)
    infravid: int = betterproto.uint32_field(6)
    infraport: str = betterproto.string_field(7)
    infranet_addr: str = betterproto.string_field(8)
    rootdev: str = betterproto.string_field(9)


@dataclass(eq=False, repr=False)
class VirtualMachine(betterproto.Message):
    vm_alloc: "__xir__.ResourceAllocation" = betterproto.message_field(1)
    users: List["UserInfo"] = betterproto.message_field(2)
    inframac: str = betterproto.string_field(3)
    infranet_addr: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class Link(betterproto.Message):
    realization: "LinkRealization" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Phyo(betterproto.Message):
    realization: "PhyoRealization" = betterproto.message_field(1)
    model: "__xir__.Phyo" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Sensor(betterproto.Message):
    realization: "SensorRealization" = betterproto.message_field(1)
    model: "__xir__.Sensor" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Bond(betterproto.Message):
    realization: "BondRealization" = betterproto.message_field(1)
    model: "__xir__.Bond" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Actuator(betterproto.Message):
    realization: "ActuatorRealization" = betterproto.message_field(1)
    model: "__xir__.Actuator" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class RebootMaterializationRequest(betterproto.Message):
    mode: "RebootMaterializationMode" = betterproto.enum_field(1)
    project: str = betterproto.string_field(2)
    experiment: str = betterproto.string_field(3)
    realization: str = betterproto.string_field(4)
    hostnames: List[str] = betterproto.string_field(5)
    all_nodes: bool = betterproto.bool_field(6)
    ver: int = betterproto.int64_field(7)


@dataclass(eq=False, repr=False)
class RebootMaterializationResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class Ingress(betterproto.Message):
    """
    We translate the facility verison of this into something more user
    friendly.
    """

    mzid: str = betterproto.string_field(1)
    protocol: str = betterproto.string_field(2)
    hostname: str = betterproto.string_field(3)
    hostport: int = betterproto.uint32_field(4)
    hostaddr: str = betterproto.string_field(5)
    gateway: str = betterproto.string_field(6)
    gatewayport: int = betterproto.uint32_field(7)
    ingress: str = betterproto.string_field(8)


@dataclass(eq=False, repr=False)
class Ingresses(betterproto.Message):
    ingresses: List["Ingress"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetMaterializationsRequest(betterproto.Message):
    """deprecated, use GetMaterializationsResponseV2 instead"""

    project: str = betterproto.string_field(1)
    """
    NOTE: project and experiment are currently not used. API callers will get
    all mtzs.
    """

    experiment: str = betterproto.string_field(2)
    filter: "FilterMode" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class GetMaterializationsResponse(betterproto.Message):
    materializations: List["Materialization"] = betterproto.message_field(1)
    statuses: List["__reconcile__.TaskSummary"] = betterproto.message_field(2)
    ingresses: List["Ingresses"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class GetMaterializationsResponseV2(betterproto.Message):
    materializations: List["MaterializationSummary"] = betterproto.message_field(1)
    ingresses: List["Ingresses"] = betterproto.message_field(2)
    statuses: List["TaskSummary"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class GetMaterializationsRequestV2(betterproto.Message):
    project: str = betterproto.string_field(1)
    """
    NOTE: project and experiment are currently not used. API callers will get
    all mtzs.
    """

    experiment: str = betterproto.string_field(2)
    filter: "FilterMode" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class GetMaterializationRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class GetMaterializationResponse(betterproto.Message):
    materialization: "Materialization" = betterproto.message_field(1)
    status: "__reconcile__.TaskSummary" = betterproto.message_field(2)
    ingresses: "Ingresses" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class GetMaterializationRequestV2(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)
    status_ms: int = betterproto.int32_field(4)


@dataclass(eq=False, repr=False)
class GetMaterializationResponseV2(betterproto.Message):
    materialization: "Materialization" = betterproto.message_field(1)
    ingresses: "Ingresses" = betterproto.message_field(2)
    summary: "TaskSummary" = betterproto.message_field(3)
    status: "TaskTree" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class GetMaterializationStatusRequest(betterproto.Message):
    """deprecated, use GetMaterializationRequestV2 instead"""

    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class GetMaterializationStatusResponse(betterproto.Message):
    """deprecated, use GetMaterializationRequestV2 instead"""

    status: "__reconcile__.TaskForest" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MaterializeRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)
    ver: int = betterproto.int64_field(4)


@dataclass(eq=False, repr=False)
class MaterializeResponse(betterproto.Message):
    materialization: "Materialization" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class DematerializeRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class DematerializeResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class NewIngressRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)
    protocol: "__xir__.Protocol" = betterproto.enum_field(4)
    host: str = betterproto.string_field(5)
    port: int = betterproto.uint32_field(6)


@dataclass(eq=False, repr=False)
class NewIngressResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteIngressRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    experiment: str = betterproto.string_field(2)
    realization: str = betterproto.string_field(3)
    protocol: "__xir__.Protocol" = betterproto.enum_field(4)
    host: str = betterproto.string_field(5)
    port: int = betterproto.uint32_field(6)


@dataclass(eq=False, repr=False)
class DeleteIngressResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class CompileRequest(betterproto.Message):
    model: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class CompileResponse(betterproto.Message):
    success: bool = betterproto.bool_field(1)
    errors: List[str] = betterproto.string_field(2)
    network: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class PushRequest(betterproto.Message):
    model: str = betterproto.string_field(1)
    branch: str = betterproto.string_field(2)
    experiment: str = betterproto.string_field(3)
    project: str = betterproto.string_field(4)
    tag: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class PushResponse(betterproto.Message):
    revision: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class XdcStorage(betterproto.Message):
    name: str = betterproto.string_field(1)
    """identify an XDC"""

    project: str = betterproto.string_field(2)
    creator: str = betterproto.string_field(3)
    mem_limit: int = betterproto.int32_field(4)
    """xdc configuration"""

    cpu_limit: int = betterproto.int32_field(5)
    image: str = betterproto.string_field(6)
    ver: int = betterproto.int64_field(8)
    """Housekeeping"""

    materialization: str = betterproto.string_field(9)
    realization_project: str = betterproto.string_field(10)
    """
    Project XDC is getting attached to (may not be saved in storage) might as
    well be called materialization_project but follows AttachXDCRequest naming
    """

    type: "XdcType" = betterproto.enum_field(11)


@dataclass(eq=False, repr=False)
class XdcInfo(betterproto.Message):
    name: str = betterproto.string_field(1)
    url: str = betterproto.string_field(2)
    fqdn: str = betterproto.string_field(3)
    creator: str = betterproto.string_field(4)
    memlimit: int = betterproto.int32_field(5)
    cpulimit: int = betterproto.int32_field(6)
    image: str = betterproto.string_field(7)
    materialization: str = betterproto.string_field(8)
    type: "XdcType" = betterproto.enum_field(9)


@dataclass(eq=False, repr=False)
class ListXdCsRequest(betterproto.Message):
    project: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ListXdCsResponse(betterproto.Message):
    xd_cs: List["XdcInfo"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetXdcRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    xdc: str = betterproto.string_field(2)
    status_ms: int = betterproto.int32_field(3)


@dataclass(eq=False, repr=False)
class GetXdcResponse(betterproto.Message):
    xdc: "XdcInfo" = betterproto.message_field(1)
    status: "TaskTree" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CreateXdcRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    xdc: str = betterproto.string_field(2)
    image: str = betterproto.string_field(3)
    memlimit: int = betterproto.int32_field(4)
    cpulimit: int = betterproto.int32_field(5)
    type: "XdcType" = betterproto.enum_field(6)


@dataclass(eq=False, repr=False)
class CreateXdcResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DeleteXdcRequest(betterproto.Message):
    project: str = betterproto.string_field(1)
    xdc: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DeleteXdcResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class AttachXdcRequest(betterproto.Message):
    xdc: str = betterproto.string_field(1)
    project: str = betterproto.string_field(2)
    """part of the xdc name <xdc>.<project>"""

    experiment: str = betterproto.string_field(3)
    realization: str = betterproto.string_field(4)
    realization_project: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class AttachXdcResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DetachXdcRequest(betterproto.Message):
    xdc: str = betterproto.string_field(1)
    project: str = betterproto.string_field(2)
    experiment: str = betterproto.string_field(3)
    realization: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class DetachXdcResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class XdcTunnelGatewayRequest(betterproto.Message):
    site: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class XdcTunnelGateway(betterproto.Message):
    key: str = betterproto.string_field(1)
    endpoint: str = betterproto.string_field(2)
    allowedips: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class XdcTunnelGatewayResponse(betterproto.Message):
    gateways: List["XdcTunnelGateway"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GetXdcJumpHostsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetXdcJumpHostsResponse(betterproto.Message):
    jump_hosts: List["SshJump"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SshJump(betterproto.Message):
    name: str = betterproto.string_field(1)
    port: int = betterproto.uint32_field(2)
    fqdn: str = betterproto.string_field(3)
    ver: int = betterproto.int64_field(4)


@dataclass(eq=False, repr=False)
class JupyterCfg(betterproto.Message):
    token: str = betterproto.string_field(1)
    url: str = betterproto.string_field(2)
    host: str = betterproto.string_field(3)
    domain: str = betterproto.string_field(4)
    ver: int = betterproto.int64_field(5)


@dataclass(eq=False, repr=False)
class WgEnclave(betterproto.Message):
    enclaveid: str = betterproto.string_field(1)
    gateways: Dict[str, "WgIfConfig"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    clients: Dict[str, "WgIfConfig"] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    ver: int = betterproto.int64_field(4)
    gateway_ips: Dict[str, str] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    client_ips: Dict[str, str] = betterproto.map_field(
        6, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )


@dataclass(eq=False, repr=False)
class WgIfConfig(betterproto.Message):
    endpoint: str = betterproto.string_field(1)
    key: str = betterproto.string_field(2)
    allowedips: List[str] = betterproto.string_field(3)
    accessaddr: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class AddWgIfConfigRequest(betterproto.Message):
    enclaveid: str = betterproto.string_field(1)
    config: "WgIfConfig" = betterproto.message_field(2)
    gateway: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class AddWgIfConfigResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class DelWgIfConfigRequest(betterproto.Message):
    enclaveid: str = betterproto.string_field(1)
    key: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class DelWgIfConfigResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetWgIfConfigRequest(betterproto.Message):
    enclaveid: str = betterproto.string_field(1)
    key: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetWgIfConfigResponse(betterproto.Message):
    enclaveid: str = betterproto.string_field(1)
    endpoint: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class GetWgEnclaveRequest(betterproto.Message):
    enclaveid: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetWgEnclaveResponse(betterproto.Message):
    enclave: "WgEnclave" = betterproto.message_field(1)


class WorkspaceStub(betterproto.ServiceStub):
    async def activate_user(
        self,
        activate_user_request: "ActivateUserRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ActivateUserResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/ActivateUser",
            activate_user_request,
            ActivateUserResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def freeze_user(
        self,
        freeze_user_request: "FreezeUserRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "FreezeUserResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/FreezeUser",
            freeze_user_request,
            FreezeUserResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def init_user(
        self,
        init_user_request: "InitUserRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "InitUserResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/InitUser",
            init_user_request,
            InitUserResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_users(
        self,
        get_users_request: "GetUsersRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetUsersResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetUsers",
            get_users_request,
            GetUsersResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_user(
        self,
        get_user_request: "GetUserRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetUserResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetUser",
            get_user_request,
            GetUserResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_user(
        self,
        update_user_request: "UpdateUserRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateUserResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/UpdateUser",
            update_user_request,
            UpdateUserResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_user(
        self,
        delete_user_request: "DeleteUserRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteUserResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/DeleteUser",
            delete_user_request,
            DeleteUserResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_user_public_keys(
        self,
        get_user_public_keys_request: "GetUserPublicKeysRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetUserPublicKeysResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetUserPublicKeys",
            get_user_public_keys_request,
            GetUserPublicKeysResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def add_user_public_key(
        self,
        add_user_public_key_request: "AddUserPublicKeyRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AddUserPublicKeyResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/AddUserPublicKey",
            add_user_public_key_request,
            AddUserPublicKeyResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_user_public_key(
        self,
        delete_user_public_key_request: "DeleteUserPublicKeyRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteUserPublicKeyResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/DeleteUserPublicKey",
            delete_user_public_key_request,
            DeleteUserPublicKeyResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_user_public_keys(
        self,
        delete_user_public_keys_request: "DeleteUserPublicKeysRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteUserPublicKeysResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/DeleteUserPublicKeys",
            delete_user_public_keys_request,
            DeleteUserPublicKeysResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_projects(
        self,
        get_projects_request: "GetProjectsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetProjectsResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetProjects",
            get_projects_request,
            GetProjectsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_project(
        self,
        get_project_request: "GetProjectRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetProjectResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetProject",
            get_project_request,
            GetProjectResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_project(
        self,
        create_project_request: "CreateProjectRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CreateProjectResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/CreateProject",
            create_project_request,
            CreateProjectResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_project(
        self,
        update_project_request: "UpdateProjectRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateProjectResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/UpdateProject",
            update_project_request,
            UpdateProjectResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_project(
        self,
        delete_project_request: "DeleteProjectRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteProjectResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/DeleteProject",
            delete_project_request,
            DeleteProjectResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_project_members(
        self,
        get_project_members_request: "GetProjectMembersRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetProjectMembersResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetProjectMembers",
            get_project_members_request,
            GetProjectMembersResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_project_member(
        self,
        get_project_member_request: "GetProjectMemberRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetProjectMemberResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetProjectMember",
            get_project_member_request,
            GetProjectMemberResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def add_project_member(
        self,
        add_project_member_request: "AddProjectMemberRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AddProjectMemberResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/AddProjectMember",
            add_project_member_request,
            AddProjectMemberResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_project_member(
        self,
        update_project_member_request: "UpdateProjectMemberRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateProjectMemberResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/UpdateProjectMember",
            update_project_member_request,
            UpdateProjectMemberResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_project_member(
        self,
        delete_project_member_request: "DeleteProjectMemberRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteProjectMemberResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/DeleteProjectMember",
            delete_project_member_request,
            DeleteProjectMemberResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def activate_organization(
        self,
        activate_organization_request: "ActivateOrganizationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ActivateOrganizationResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/ActivateOrganization",
            activate_organization_request,
            ActivateOrganizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def freeze_organization(
        self,
        freeze_organization_request: "FreezeOrganizationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "FreezeOrganizationResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/FreezeOrganization",
            freeze_organization_request,
            FreezeOrganizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_organizations(
        self,
        get_organizations_request: "GetOrganizationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetOrganizationsResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetOrganizations",
            get_organizations_request,
            GetOrganizationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_organization(
        self,
        get_organization_request: "GetOrganizationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetOrganizationResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetOrganization",
            get_organization_request,
            GetOrganizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_organization(
        self,
        create_organization_request: "CreateOrganizationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CreateOrganizationResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/CreateOrganization",
            create_organization_request,
            CreateOrganizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_organization(
        self,
        update_organization_request: "UpdateOrganizationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateOrganizationResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/UpdateOrganization",
            update_organization_request,
            UpdateOrganizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_organization(
        self,
        delete_organization_request: "DeleteOrganizationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteOrganizationResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/DeleteOrganization",
            delete_organization_request,
            DeleteOrganizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_organization_members(
        self,
        get_organization_members_request: "GetOrganizationMembersRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetOrganizationMembersResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetOrganizationMembers",
            get_organization_members_request,
            GetOrganizationMembersResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_organization_member(
        self,
        get_organization_member_request: "GetOrganizationMemberRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetOrganizationMemberResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetOrganizationMember",
            get_organization_member_request,
            GetOrganizationMemberResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def request_organization_membership(
        self,
        request_organization_membership_request: "RequestOrganizationMembershipRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RequestOrganizationMembershipResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/RequestOrganizationMembership",
            request_organization_membership_request,
            RequestOrganizationMembershipResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def confirm_organization_membership(
        self,
        confirm_organization_membership_request: "ConfirmOrganizationMembershipRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ConfirmOrganizationMembershipResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/ConfirmOrganizationMembership",
            confirm_organization_membership_request,
            ConfirmOrganizationMembershipResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_organization_member(
        self,
        update_organization_member_request: "UpdateOrganizationMemberRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateOrganizationMemberResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/UpdateOrganizationMember",
            update_organization_member_request,
            UpdateOrganizationMemberResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_organization_member(
        self,
        delete_organization_member_request: "DeleteOrganizationMemberRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteOrganizationMemberResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/DeleteOrganizationMember",
            delete_organization_member_request,
            DeleteOrganizationMemberResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_organization_projects(
        self,
        get_organization_projects_request: "GetOrganizationProjectsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetOrganizationProjectsResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetOrganizationProjects",
            get_organization_projects_request,
            GetOrganizationProjectsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_organization_project(
        self,
        get_organization_project_request: "GetOrganizationProjectRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetOrganizationProjectResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetOrganizationProject",
            get_organization_project_request,
            GetOrganizationProjectResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def add_organization_project(
        self,
        add_organization_project_request: "AddOrganizationProjectRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AddOrganizationProjectResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/AddOrganizationProject",
            add_organization_project_request,
            AddOrganizationProjectResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_organization_project(
        self,
        update_organization_project_request: "UpdateOrganizationProjectRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateOrganizationProjectResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/UpdateOrganizationProject",
            update_organization_project_request,
            UpdateOrganizationProjectResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_organization_project(
        self,
        delete_organization_project_request: "DeleteOrganizationProjectRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteOrganizationProjectResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/DeleteOrganizationProject",
            delete_organization_project_request,
            DeleteOrganizationProjectResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_experiments(
        self,
        get_experiments_request: "GetExperimentsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetExperimentsResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetExperiments",
            get_experiments_request,
            GetExperimentsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_project_experiments(
        self,
        get_project_experiments_request: "GetProjectExperimentsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetProjectExperimentsResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetProjectExperiments",
            get_project_experiments_request,
            GetProjectExperimentsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_experiment(
        self,
        get_experiment_request: "GetExperimentRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetExperimentResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetExperiment",
            get_experiment_request,
            GetExperimentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_experiment(
        self,
        create_experiment_request: "CreateExperimentRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CreateExperimentResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/CreateExperiment",
            create_experiment_request,
            CreateExperimentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_experiment(
        self,
        update_experiment_request: "UpdateExperimentRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateExperimentResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/UpdateExperiment",
            update_experiment_request,
            UpdateExperimentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_experiment(
        self,
        delete_experiment_request: "DeleteExperimentRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteExperimentResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/DeleteExperiment",
            delete_experiment_request,
            DeleteExperimentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_revision(
        self,
        get_revision_request: "GetRevisionRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetRevisionResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetRevision",
            get_revision_request,
            GetRevisionResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_policy(
        self,
        get_policy_request: "GetPolicyRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetPolicyResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetPolicy",
            get_policy_request,
            GetPolicyResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_user_configurations(
        self,
        get_user_configurations_request: "GetUserConfigurationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetUserConfigurationsResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetUserConfigurations",
            get_user_configurations_request,
            GetUserConfigurationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_user_configurations(
        self,
        update_user_configurations_request: "UpdateUserConfigurationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateUserConfigurationsResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/UpdateUserConfigurations",
            update_user_configurations_request,
            UpdateUserConfigurationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_entity_type_configurations(
        self,
        get_entity_type_configurations_request: "GetEntityTypeConfigurationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetEntityTypeConfigurationsResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/GetEntityTypeConfigurations",
            get_entity_type_configurations_request,
            GetEntityTypeConfigurationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_entity_type_configurations(
        self,
        update_entity_type_configurations_request: "UpdateEntityTypeConfigurationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateEntityTypeConfigurationsResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/UpdateEntityTypeConfigurations",
            update_entity_type_configurations_request,
            UpdateEntityTypeConfigurationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def health(
        self,
        health_request: "HealthRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "HealthResponse":
        return await self._unary_unary(
            "/portal.v1.Workspace/Health",
            health_request,
            HealthResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class RealizeStub(betterproto.ServiceStub):
    async def get_realizations(
        self,
        get_realizations_request: "GetRealizationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetRealizationsResponse":
        return await self._unary_unary(
            "/portal.v1.Realize/GetRealizations",
            get_realizations_request,
            GetRealizationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_realization(
        self,
        get_realization_request: "GetRealizationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetRealizationResponse":
        return await self._unary_unary(
            "/portal.v1.Realize/GetRealization",
            get_realization_request,
            GetRealizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def realize(
        self,
        realize_request: "RealizeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RealizeResponse":
        return await self._unary_unary(
            "/portal.v1.Realize/Realize",
            realize_request,
            RealizeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def relinquish(
        self,
        relinquish_request: "RelinquishRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RelinquishResponse":
        return await self._unary_unary(
            "/portal.v1.Realize/Relinquish",
            relinquish_request,
            RelinquishResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_resources(
        self,
        get_resources_request: "GetResourcesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetResourcesResponse":
        return await self._unary_unary(
            "/portal.v1.Realize/GetResources",
            get_resources_request,
            GetResourcesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_realization(
        self,
        update_realization_request: "UpdateRealizationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateRealizationResponse":
        return await self._unary_unary(
            "/portal.v1.Realize/UpdateRealization",
            update_realization_request,
            UpdateRealizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MaterializeStub(betterproto.ServiceStub):
    async def get_materializations(
        self,
        get_materializations_request: "GetMaterializationsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetMaterializationsResponse":
        return await self._unary_unary(
            "/portal.v1.Materialize/GetMaterializations",
            get_materializations_request,
            GetMaterializationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_materializations_v2(
        self,
        get_materializations_request_v2: "GetMaterializationsRequestV2",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetMaterializationsResponseV2":
        return await self._unary_unary(
            "/portal.v1.Materialize/GetMaterializationsV2",
            get_materializations_request_v2,
            GetMaterializationsResponseV2,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_materialization(
        self,
        get_materialization_request: "GetMaterializationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetMaterializationResponse":
        return await self._unary_unary(
            "/portal.v1.Materialize/GetMaterialization",
            get_materialization_request,
            GetMaterializationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_materialization_v2(
        self,
        get_materialization_request_v2: "GetMaterializationRequestV2",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetMaterializationResponseV2":
        return await self._unary_unary(
            "/portal.v1.Materialize/GetMaterializationV2",
            get_materialization_request_v2,
            GetMaterializationResponseV2,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_materialization_status(
        self,
        get_materialization_status_request: "GetMaterializationStatusRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetMaterializationStatusResponse":
        return await self._unary_unary(
            "/portal.v1.Materialize/GetMaterializationStatus",
            get_materialization_status_request,
            GetMaterializationStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def materialize(
        self,
        materialize_request: "MaterializeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MaterializeResponse":
        return await self._unary_unary(
            "/portal.v1.Materialize/Materialize",
            materialize_request,
            MaterializeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def dematerialize(
        self,
        dematerialize_request: "DematerializeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DematerializeResponse":
        return await self._unary_unary(
            "/portal.v1.Materialize/Dematerialize",
            dematerialize_request,
            DematerializeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def reboot_materialization(
        self,
        reboot_materialization_request: "RebootMaterializationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RebootMaterializationResponse":
        return await self._unary_unary(
            "/portal.v1.Materialize/RebootMaterialization",
            reboot_materialization_request,
            RebootMaterializationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def new_ingress(
        self,
        new_ingress_request: "NewIngressRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "NewIngressResponse":
        return await self._unary_unary(
            "/portal.v1.Materialize/NewIngress",
            new_ingress_request,
            NewIngressResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_ingress(
        self,
        delete_ingress_request: "DeleteIngressRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteIngressResponse":
        return await self._unary_unary(
            "/portal.v1.Materialize/DeleteIngress",
            delete_ingress_request,
            DeleteIngressResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class CommissionStub(betterproto.ServiceStub):
    async def register_facility(
        self,
        register_facility_request: "RegisterFacilityRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RegisterFacilityResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/RegisterFacility",
            register_facility_request,
            RegisterFacilityResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_facilities(
        self,
        get_facilities_request: "GetFacilitiesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetFacilitiesResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/GetFacilities",
            get_facilities_request,
            GetFacilitiesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_facility(
        self,
        get_facility_request: "GetFacilityRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetFacilityResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/GetFacility",
            get_facility_request,
            GetFacilityResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_facility(
        self,
        update_facility_request: "UpdateFacilityRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateFacilityResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/UpdateFacility",
            update_facility_request,
            UpdateFacilityResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_facility(
        self,
        delete_facility_request: "DeleteFacilityRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteFacilityResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/DeleteFacility",
            delete_facility_request,
            DeleteFacilityResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def deactivate_resources(
        self,
        deactivate_resources_request: "DeactivateResourcesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeactivateResourcesResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/DeactivateResources",
            deactivate_resources_request,
            DeactivateResourcesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def activate_resources(
        self,
        activate_resources_request: "ActivateResourcesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ActivateResourcesResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/ActivateResources",
            activate_resources_request,
            ActivateResourcesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def list_block_pools(
        self,
        list_block_pools_request: "ListBlockPoolsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ListBlockPoolsResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/ListBlockPools",
            list_block_pools_request,
            ListBlockPoolsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def initialize_harbor(
        self,
        init_harbor_request: "InitHarborRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "InitHarborResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/InitializeHarbor",
            init_harbor_request,
            InitHarborResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def deinitialize_harbor(
        self,
        deinit_harbor_request: "DeinitHarborRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeinitHarborResponse":
        return await self._unary_unary(
            "/portal.v1.Commission/DeinitializeHarbor",
            deinit_harbor_request,
            DeinitHarborResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class AllocStub(betterproto.ServiceStub):
    async def alloc(
        self,
        allocation_request: "AllocationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AllocationResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/Alloc",
            allocation_request,
            AllocationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def free(
        self,
        free_request: "FreeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "FreeResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/Free",
            free_request,
            FreeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def fetch(
        self,
        fetch_allocation_table_request: "FetchAllocationTableRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "FetchAllocationTableResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/Fetch",
            fetch_allocation_table_request,
            FetchAllocationTableResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_pool(
        self,
        get_pool_request: "GetPoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetPoolResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/GetPool",
            get_pool_request,
            GetPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_pools(
        self,
        get_pools_request: "GetPoolsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetPoolsResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/GetPools",
            get_pools_request,
            GetPoolsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_pool(
        self,
        create_pool_request: "CreatePoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CreatePoolResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/CreatePool",
            create_pool_request,
            CreatePoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_pool(
        self,
        delete_pool_request: "DeletePoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeletePoolResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/DeletePool",
            delete_pool_request,
            DeletePoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def add_project(
        self,
        add_project_to_pool_request: "AddProjectToPoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AddProjectToPoolResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/AddProject",
            add_project_to_pool_request,
            AddProjectToPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def remove_project(
        self,
        remove_project_from_pool_request: "RemoveProjectFromPoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RemoveProjectFromPoolResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/RemoveProject",
            remove_project_from_pool_request,
            RemoveProjectFromPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def add_organization(
        self,
        add_organization_to_pool_request: "AddOrganizationToPoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AddOrganizationToPoolResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/AddOrganization",
            add_organization_to_pool_request,
            AddOrganizationToPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def remove_organization(
        self,
        remove_organization_from_pool_request: "RemoveOrganizationFromPoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RemoveOrganizationFromPoolResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/RemoveOrganization",
            remove_organization_from_pool_request,
            RemoveOrganizationFromPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def add_facility(
        self,
        add_facility_to_pool_request: "AddFacilityToPoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AddFacilityToPoolResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/AddFacility",
            add_facility_to_pool_request,
            AddFacilityToPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def remove_facility(
        self,
        remove_facility_from_pool_request: "RemoveFacilityFromPoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RemoveFacilityFromPoolResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/RemoveFacility",
            remove_facility_from_pool_request,
            RemoveFacilityFromPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_pool_resources(
        self,
        update_pool_resources_request: "UpdatePoolResourcesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdatePoolResourcesResponse":
        return await self._unary_unary(
            "/portal.v1.Alloc/UpdatePoolResources",
            update_pool_resources_request,
            UpdatePoolResourcesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class IdentityStub(betterproto.ServiceStub):
    async def list_identities(
        self,
        list_identity_request: "ListIdentityRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ListIdentityResponse":
        return await self._unary_unary(
            "/portal.v1.Identity/ListIdentities",
            list_identity_request,
            ListIdentityResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_identity(
        self,
        get_identity_request: "GetIdentityRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetIdentityResponse":
        return await self._unary_unary(
            "/portal.v1.Identity/GetIdentity",
            get_identity_request,
            GetIdentityResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def register(
        self,
        register_request: "RegisterRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RegisterResponse":
        return await self._unary_unary(
            "/portal.v1.Identity/Register",
            register_request,
            RegisterResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def unregister(
        self,
        unregister_request: "UnregisterRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UnregisterResponse":
        return await self._unary_unary(
            "/portal.v1.Identity/Unregister",
            unregister_request,
            UnregisterResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def login(
        self,
        login_request: "LoginRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "LoginResponse":
        return await self._unary_unary(
            "/portal.v1.Identity/Login",
            login_request,
            LoginResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def logout(
        self,
        logout_request: "LogoutRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "LogoutResponse":
        return await self._unary_unary(
            "/portal.v1.Identity/Logout",
            logout_request,
            LogoutResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class CredStub(betterproto.ServiceStub):
    async def get_user_ssh_keys(
        self,
        get_user_ssh_keys_request: "GetUserSshKeysRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetUserSshKeysResponse":
        return await self._unary_unary(
            "/portal.v1.Cred/GetUserSSHKeys",
            get_user_ssh_keys_request,
            GetUserSshKeysResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_user_ssh_cert(
        self,
        get_user_ssh_cert_request: "GetUserSshCertRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetUserSshCertResponse":
        return await self._unary_unary(
            "/portal.v1.Cred/GetUserSSHCert",
            get_user_ssh_cert_request,
            GetUserSshCertResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class XdcStub(betterproto.ServiceStub):
    async def list_xd_cs(
        self,
        list_xd_cs_request: "ListXdCsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ListXdCsResponse":
        return await self._unary_unary(
            "/portal.v1.XDC/ListXDCs",
            list_xd_cs_request,
            ListXdCsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_xdc(
        self,
        get_xdc_request: "GetXdcRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetXdcResponse":
        return await self._unary_unary(
            "/portal.v1.XDC/GetXDC",
            get_xdc_request,
            GetXdcResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_xdc(
        self,
        create_xdc_request: "CreateXdcRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CreateXdcResponse":
        return await self._unary_unary(
            "/portal.v1.XDC/CreateXDC",
            create_xdc_request,
            CreateXdcResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_xdc(
        self,
        delete_xdc_request: "DeleteXdcRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DeleteXdcResponse":
        return await self._unary_unary(
            "/portal.v1.XDC/DeleteXDC",
            delete_xdc_request,
            DeleteXdcResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def attach_xdc(
        self,
        attach_xdc_request: "AttachXdcRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AttachXdcResponse":
        return await self._unary_unary(
            "/portal.v1.XDC/AttachXDC",
            attach_xdc_request,
            AttachXdcResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def detach_xdc(
        self,
        detach_xdc_request: "DetachXdcRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DetachXdcResponse":
        return await self._unary_unary(
            "/portal.v1.XDC/DetachXDC",
            detach_xdc_request,
            DetachXdcResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_xdc_jump_hosts(
        self,
        get_xdc_jump_hosts_request: "GetXdcJumpHostsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetXdcJumpHostsResponse":
        return await self._unary_unary(
            "/portal.v1.XDC/GetXDCJumpHosts",
            get_xdc_jump_hosts_request,
            GetXdcJumpHostsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class WireguardStub(betterproto.ServiceStub):
    async def add_wg_if_config(
        self,
        add_wg_if_config_request: "AddWgIfConfigRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AddWgIfConfigResponse":
        return await self._unary_unary(
            "/portal.v1.Wireguard/AddWgIfConfig",
            add_wg_if_config_request,
            AddWgIfConfigResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def del_wg_if_config(
        self,
        del_wg_if_config_request: "DelWgIfConfigRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "DelWgIfConfigResponse":
        return await self._unary_unary(
            "/portal.v1.Wireguard/DelWgIfConfig",
            del_wg_if_config_request,
            DelWgIfConfigResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_wg_if_config(
        self,
        get_wg_if_config_request: "GetWgIfConfigRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetWgIfConfigResponse":
        return await self._unary_unary(
            "/portal.v1.Wireguard/GetWgIfConfig",
            get_wg_if_config_request,
            GetWgIfConfigResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_wg_enclave(
        self,
        get_wg_enclave_request: "GetWgEnclaveRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetWgEnclaveResponse":
        return await self._unary_unary(
            "/portal.v1.Wireguard/GetWgEnclave",
            get_wg_enclave_request,
            GetWgEnclaveResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ModelStub(betterproto.ServiceStub):
    async def compile(
        self,
        compile_request: "CompileRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CompileResponse":
        return await self._unary_unary(
            "/portal.v1.Model/Compile",
            compile_request,
            CompileResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def push(
        self,
        push_request: "PushRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "PushResponse":
        return await self._unary_unary(
            "/portal.v1.Model/Push",
            push_request,
            PushResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class WorkspaceBase(ServiceBase):
    async def activate_user(
        self, activate_user_request: "ActivateUserRequest"
    ) -> "ActivateUserResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def freeze_user(
        self, freeze_user_request: "FreezeUserRequest"
    ) -> "FreezeUserResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def init_user(
        self, init_user_request: "InitUserRequest"
    ) -> "InitUserResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_users(
        self, get_users_request: "GetUsersRequest"
    ) -> "GetUsersResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_user(self, get_user_request: "GetUserRequest") -> "GetUserResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_user(
        self, update_user_request: "UpdateUserRequest"
    ) -> "UpdateUserResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_user(
        self, delete_user_request: "DeleteUserRequest"
    ) -> "DeleteUserResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_user_public_keys(
        self, get_user_public_keys_request: "GetUserPublicKeysRequest"
    ) -> "GetUserPublicKeysResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def add_user_public_key(
        self, add_user_public_key_request: "AddUserPublicKeyRequest"
    ) -> "AddUserPublicKeyResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_user_public_key(
        self, delete_user_public_key_request: "DeleteUserPublicKeyRequest"
    ) -> "DeleteUserPublicKeyResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_user_public_keys(
        self, delete_user_public_keys_request: "DeleteUserPublicKeysRequest"
    ) -> "DeleteUserPublicKeysResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_projects(
        self, get_projects_request: "GetProjectsRequest"
    ) -> "GetProjectsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_project(
        self, get_project_request: "GetProjectRequest"
    ) -> "GetProjectResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_project(
        self, create_project_request: "CreateProjectRequest"
    ) -> "CreateProjectResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_project(
        self, update_project_request: "UpdateProjectRequest"
    ) -> "UpdateProjectResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_project(
        self, delete_project_request: "DeleteProjectRequest"
    ) -> "DeleteProjectResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_project_members(
        self, get_project_members_request: "GetProjectMembersRequest"
    ) -> "GetProjectMembersResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_project_member(
        self, get_project_member_request: "GetProjectMemberRequest"
    ) -> "GetProjectMemberResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def add_project_member(
        self, add_project_member_request: "AddProjectMemberRequest"
    ) -> "AddProjectMemberResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_project_member(
        self, update_project_member_request: "UpdateProjectMemberRequest"
    ) -> "UpdateProjectMemberResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_project_member(
        self, delete_project_member_request: "DeleteProjectMemberRequest"
    ) -> "DeleteProjectMemberResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def activate_organization(
        self, activate_organization_request: "ActivateOrganizationRequest"
    ) -> "ActivateOrganizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def freeze_organization(
        self, freeze_organization_request: "FreezeOrganizationRequest"
    ) -> "FreezeOrganizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_organizations(
        self, get_organizations_request: "GetOrganizationsRequest"
    ) -> "GetOrganizationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_organization(
        self, get_organization_request: "GetOrganizationRequest"
    ) -> "GetOrganizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_organization(
        self, create_organization_request: "CreateOrganizationRequest"
    ) -> "CreateOrganizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_organization(
        self, update_organization_request: "UpdateOrganizationRequest"
    ) -> "UpdateOrganizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_organization(
        self, delete_organization_request: "DeleteOrganizationRequest"
    ) -> "DeleteOrganizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_organization_members(
        self, get_organization_members_request: "GetOrganizationMembersRequest"
    ) -> "GetOrganizationMembersResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_organization_member(
        self, get_organization_member_request: "GetOrganizationMemberRequest"
    ) -> "GetOrganizationMemberResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def request_organization_membership(
        self,
        request_organization_membership_request: "RequestOrganizationMembershipRequest",
    ) -> "RequestOrganizationMembershipResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def confirm_organization_membership(
        self,
        confirm_organization_membership_request: "ConfirmOrganizationMembershipRequest",
    ) -> "ConfirmOrganizationMembershipResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_organization_member(
        self, update_organization_member_request: "UpdateOrganizationMemberRequest"
    ) -> "UpdateOrganizationMemberResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_organization_member(
        self, delete_organization_member_request: "DeleteOrganizationMemberRequest"
    ) -> "DeleteOrganizationMemberResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_organization_projects(
        self, get_organization_projects_request: "GetOrganizationProjectsRequest"
    ) -> "GetOrganizationProjectsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_organization_project(
        self, get_organization_project_request: "GetOrganizationProjectRequest"
    ) -> "GetOrganizationProjectResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def add_organization_project(
        self, add_organization_project_request: "AddOrganizationProjectRequest"
    ) -> "AddOrganizationProjectResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_organization_project(
        self, update_organization_project_request: "UpdateOrganizationProjectRequest"
    ) -> "UpdateOrganizationProjectResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_organization_project(
        self, delete_organization_project_request: "DeleteOrganizationProjectRequest"
    ) -> "DeleteOrganizationProjectResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_experiments(
        self, get_experiments_request: "GetExperimentsRequest"
    ) -> "GetExperimentsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_project_experiments(
        self, get_project_experiments_request: "GetProjectExperimentsRequest"
    ) -> "GetProjectExperimentsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_experiment(
        self, get_experiment_request: "GetExperimentRequest"
    ) -> "GetExperimentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_experiment(
        self, create_experiment_request: "CreateExperimentRequest"
    ) -> "CreateExperimentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_experiment(
        self, update_experiment_request: "UpdateExperimentRequest"
    ) -> "UpdateExperimentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_experiment(
        self, delete_experiment_request: "DeleteExperimentRequest"
    ) -> "DeleteExperimentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_revision(
        self, get_revision_request: "GetRevisionRequest"
    ) -> "GetRevisionResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_policy(
        self, get_policy_request: "GetPolicyRequest"
    ) -> "GetPolicyResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_user_configurations(
        self, get_user_configurations_request: "GetUserConfigurationsRequest"
    ) -> "GetUserConfigurationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_user_configurations(
        self, update_user_configurations_request: "UpdateUserConfigurationsRequest"
    ) -> "UpdateUserConfigurationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_entity_type_configurations(
        self,
        get_entity_type_configurations_request: "GetEntityTypeConfigurationsRequest",
    ) -> "GetEntityTypeConfigurationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_entity_type_configurations(
        self,
        update_entity_type_configurations_request: "UpdateEntityTypeConfigurationsRequest",
    ) -> "UpdateEntityTypeConfigurationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def health(self, health_request: "HealthRequest") -> "HealthResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_activate_user(
        self, stream: "grpclib.server.Stream[ActivateUserRequest, ActivateUserResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.activate_user(request)
        await stream.send_message(response)

    async def __rpc_freeze_user(
        self, stream: "grpclib.server.Stream[FreezeUserRequest, FreezeUserResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.freeze_user(request)
        await stream.send_message(response)

    async def __rpc_init_user(
        self, stream: "grpclib.server.Stream[InitUserRequest, InitUserResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.init_user(request)
        await stream.send_message(response)

    async def __rpc_get_users(
        self, stream: "grpclib.server.Stream[GetUsersRequest, GetUsersResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_users(request)
        await stream.send_message(response)

    async def __rpc_get_user(
        self, stream: "grpclib.server.Stream[GetUserRequest, GetUserResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_user(request)
        await stream.send_message(response)

    async def __rpc_update_user(
        self, stream: "grpclib.server.Stream[UpdateUserRequest, UpdateUserResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_user(request)
        await stream.send_message(response)

    async def __rpc_delete_user(
        self, stream: "grpclib.server.Stream[DeleteUserRequest, DeleteUserResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_user(request)
        await stream.send_message(response)

    async def __rpc_get_user_public_keys(
        self,
        stream: "grpclib.server.Stream[GetUserPublicKeysRequest, GetUserPublicKeysResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_user_public_keys(request)
        await stream.send_message(response)

    async def __rpc_add_user_public_key(
        self,
        stream: "grpclib.server.Stream[AddUserPublicKeyRequest, AddUserPublicKeyResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.add_user_public_key(request)
        await stream.send_message(response)

    async def __rpc_delete_user_public_key(
        self,
        stream: "grpclib.server.Stream[DeleteUserPublicKeyRequest, DeleteUserPublicKeyResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_user_public_key(request)
        await stream.send_message(response)

    async def __rpc_delete_user_public_keys(
        self,
        stream: "grpclib.server.Stream[DeleteUserPublicKeysRequest, DeleteUserPublicKeysResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_user_public_keys(request)
        await stream.send_message(response)

    async def __rpc_get_projects(
        self, stream: "grpclib.server.Stream[GetProjectsRequest, GetProjectsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_projects(request)
        await stream.send_message(response)

    async def __rpc_get_project(
        self, stream: "grpclib.server.Stream[GetProjectRequest, GetProjectResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_project(request)
        await stream.send_message(response)

    async def __rpc_create_project(
        self,
        stream: "grpclib.server.Stream[CreateProjectRequest, CreateProjectResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_project(request)
        await stream.send_message(response)

    async def __rpc_update_project(
        self,
        stream: "grpclib.server.Stream[UpdateProjectRequest, UpdateProjectResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_project(request)
        await stream.send_message(response)

    async def __rpc_delete_project(
        self,
        stream: "grpclib.server.Stream[DeleteProjectRequest, DeleteProjectResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_project(request)
        await stream.send_message(response)

    async def __rpc_get_project_members(
        self,
        stream: "grpclib.server.Stream[GetProjectMembersRequest, GetProjectMembersResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_project_members(request)
        await stream.send_message(response)

    async def __rpc_get_project_member(
        self,
        stream: "grpclib.server.Stream[GetProjectMemberRequest, GetProjectMemberResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_project_member(request)
        await stream.send_message(response)

    async def __rpc_add_project_member(
        self,
        stream: "grpclib.server.Stream[AddProjectMemberRequest, AddProjectMemberResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.add_project_member(request)
        await stream.send_message(response)

    async def __rpc_update_project_member(
        self,
        stream: "grpclib.server.Stream[UpdateProjectMemberRequest, UpdateProjectMemberResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_project_member(request)
        await stream.send_message(response)

    async def __rpc_delete_project_member(
        self,
        stream: "grpclib.server.Stream[DeleteProjectMemberRequest, DeleteProjectMemberResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_project_member(request)
        await stream.send_message(response)

    async def __rpc_activate_organization(
        self,
        stream: "grpclib.server.Stream[ActivateOrganizationRequest, ActivateOrganizationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.activate_organization(request)
        await stream.send_message(response)

    async def __rpc_freeze_organization(
        self,
        stream: "grpclib.server.Stream[FreezeOrganizationRequest, FreezeOrganizationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.freeze_organization(request)
        await stream.send_message(response)

    async def __rpc_get_organizations(
        self,
        stream: "grpclib.server.Stream[GetOrganizationsRequest, GetOrganizationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_organizations(request)
        await stream.send_message(response)

    async def __rpc_get_organization(
        self,
        stream: "grpclib.server.Stream[GetOrganizationRequest, GetOrganizationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_organization(request)
        await stream.send_message(response)

    async def __rpc_create_organization(
        self,
        stream: "grpclib.server.Stream[CreateOrganizationRequest, CreateOrganizationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_organization(request)
        await stream.send_message(response)

    async def __rpc_update_organization(
        self,
        stream: "grpclib.server.Stream[UpdateOrganizationRequest, UpdateOrganizationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_organization(request)
        await stream.send_message(response)

    async def __rpc_delete_organization(
        self,
        stream: "grpclib.server.Stream[DeleteOrganizationRequest, DeleteOrganizationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_organization(request)
        await stream.send_message(response)

    async def __rpc_get_organization_members(
        self,
        stream: "grpclib.server.Stream[GetOrganizationMembersRequest, GetOrganizationMembersResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_organization_members(request)
        await stream.send_message(response)

    async def __rpc_get_organization_member(
        self,
        stream: "grpclib.server.Stream[GetOrganizationMemberRequest, GetOrganizationMemberResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_organization_member(request)
        await stream.send_message(response)

    async def __rpc_request_organization_membership(
        self,
        stream: "grpclib.server.Stream[RequestOrganizationMembershipRequest, RequestOrganizationMembershipResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.request_organization_membership(request)
        await stream.send_message(response)

    async def __rpc_confirm_organization_membership(
        self,
        stream: "grpclib.server.Stream[ConfirmOrganizationMembershipRequest, ConfirmOrganizationMembershipResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.confirm_organization_membership(request)
        await stream.send_message(response)

    async def __rpc_update_organization_member(
        self,
        stream: "grpclib.server.Stream[UpdateOrganizationMemberRequest, UpdateOrganizationMemberResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_organization_member(request)
        await stream.send_message(response)

    async def __rpc_delete_organization_member(
        self,
        stream: "grpclib.server.Stream[DeleteOrganizationMemberRequest, DeleteOrganizationMemberResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_organization_member(request)
        await stream.send_message(response)

    async def __rpc_get_organization_projects(
        self,
        stream: "grpclib.server.Stream[GetOrganizationProjectsRequest, GetOrganizationProjectsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_organization_projects(request)
        await stream.send_message(response)

    async def __rpc_get_organization_project(
        self,
        stream: "grpclib.server.Stream[GetOrganizationProjectRequest, GetOrganizationProjectResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_organization_project(request)
        await stream.send_message(response)

    async def __rpc_add_organization_project(
        self,
        stream: "grpclib.server.Stream[AddOrganizationProjectRequest, AddOrganizationProjectResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.add_organization_project(request)
        await stream.send_message(response)

    async def __rpc_update_organization_project(
        self,
        stream: "grpclib.server.Stream[UpdateOrganizationProjectRequest, UpdateOrganizationProjectResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_organization_project(request)
        await stream.send_message(response)

    async def __rpc_delete_organization_project(
        self,
        stream: "grpclib.server.Stream[DeleteOrganizationProjectRequest, DeleteOrganizationProjectResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_organization_project(request)
        await stream.send_message(response)

    async def __rpc_get_experiments(
        self,
        stream: "grpclib.server.Stream[GetExperimentsRequest, GetExperimentsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_experiments(request)
        await stream.send_message(response)

    async def __rpc_get_project_experiments(
        self,
        stream: "grpclib.server.Stream[GetProjectExperimentsRequest, GetProjectExperimentsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_project_experiments(request)
        await stream.send_message(response)

    async def __rpc_get_experiment(
        self,
        stream: "grpclib.server.Stream[GetExperimentRequest, GetExperimentResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_experiment(request)
        await stream.send_message(response)

    async def __rpc_create_experiment(
        self,
        stream: "grpclib.server.Stream[CreateExperimentRequest, CreateExperimentResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_experiment(request)
        await stream.send_message(response)

    async def __rpc_update_experiment(
        self,
        stream: "grpclib.server.Stream[UpdateExperimentRequest, UpdateExperimentResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_experiment(request)
        await stream.send_message(response)

    async def __rpc_delete_experiment(
        self,
        stream: "grpclib.server.Stream[DeleteExperimentRequest, DeleteExperimentResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_experiment(request)
        await stream.send_message(response)

    async def __rpc_get_revision(
        self, stream: "grpclib.server.Stream[GetRevisionRequest, GetRevisionResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_revision(request)
        await stream.send_message(response)

    async def __rpc_get_policy(
        self, stream: "grpclib.server.Stream[GetPolicyRequest, GetPolicyResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_policy(request)
        await stream.send_message(response)

    async def __rpc_get_user_configurations(
        self,
        stream: "grpclib.server.Stream[GetUserConfigurationsRequest, GetUserConfigurationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_user_configurations(request)
        await stream.send_message(response)

    async def __rpc_update_user_configurations(
        self,
        stream: "grpclib.server.Stream[UpdateUserConfigurationsRequest, UpdateUserConfigurationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_user_configurations(request)
        await stream.send_message(response)

    async def __rpc_get_entity_type_configurations(
        self,
        stream: "grpclib.server.Stream[GetEntityTypeConfigurationsRequest, GetEntityTypeConfigurationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_entity_type_configurations(request)
        await stream.send_message(response)

    async def __rpc_update_entity_type_configurations(
        self,
        stream: "grpclib.server.Stream[UpdateEntityTypeConfigurationsRequest, UpdateEntityTypeConfigurationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_entity_type_configurations(request)
        await stream.send_message(response)

    async def __rpc_health(
        self, stream: "grpclib.server.Stream[HealthRequest, HealthResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.health(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.Workspace/ActivateUser": grpclib.const.Handler(
                self.__rpc_activate_user,
                grpclib.const.Cardinality.UNARY_UNARY,
                ActivateUserRequest,
                ActivateUserResponse,
            ),
            "/portal.v1.Workspace/FreezeUser": grpclib.const.Handler(
                self.__rpc_freeze_user,
                grpclib.const.Cardinality.UNARY_UNARY,
                FreezeUserRequest,
                FreezeUserResponse,
            ),
            "/portal.v1.Workspace/InitUser": grpclib.const.Handler(
                self.__rpc_init_user,
                grpclib.const.Cardinality.UNARY_UNARY,
                InitUserRequest,
                InitUserResponse,
            ),
            "/portal.v1.Workspace/GetUsers": grpclib.const.Handler(
                self.__rpc_get_users,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetUsersRequest,
                GetUsersResponse,
            ),
            "/portal.v1.Workspace/GetUser": grpclib.const.Handler(
                self.__rpc_get_user,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetUserRequest,
                GetUserResponse,
            ),
            "/portal.v1.Workspace/UpdateUser": grpclib.const.Handler(
                self.__rpc_update_user,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateUserRequest,
                UpdateUserResponse,
            ),
            "/portal.v1.Workspace/DeleteUser": grpclib.const.Handler(
                self.__rpc_delete_user,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteUserRequest,
                DeleteUserResponse,
            ),
            "/portal.v1.Workspace/GetUserPublicKeys": grpclib.const.Handler(
                self.__rpc_get_user_public_keys,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetUserPublicKeysRequest,
                GetUserPublicKeysResponse,
            ),
            "/portal.v1.Workspace/AddUserPublicKey": grpclib.const.Handler(
                self.__rpc_add_user_public_key,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddUserPublicKeyRequest,
                AddUserPublicKeyResponse,
            ),
            "/portal.v1.Workspace/DeleteUserPublicKey": grpclib.const.Handler(
                self.__rpc_delete_user_public_key,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteUserPublicKeyRequest,
                DeleteUserPublicKeyResponse,
            ),
            "/portal.v1.Workspace/DeleteUserPublicKeys": grpclib.const.Handler(
                self.__rpc_delete_user_public_keys,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteUserPublicKeysRequest,
                DeleteUserPublicKeysResponse,
            ),
            "/portal.v1.Workspace/GetProjects": grpclib.const.Handler(
                self.__rpc_get_projects,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetProjectsRequest,
                GetProjectsResponse,
            ),
            "/portal.v1.Workspace/GetProject": grpclib.const.Handler(
                self.__rpc_get_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetProjectRequest,
                GetProjectResponse,
            ),
            "/portal.v1.Workspace/CreateProject": grpclib.const.Handler(
                self.__rpc_create_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateProjectRequest,
                CreateProjectResponse,
            ),
            "/portal.v1.Workspace/UpdateProject": grpclib.const.Handler(
                self.__rpc_update_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateProjectRequest,
                UpdateProjectResponse,
            ),
            "/portal.v1.Workspace/DeleteProject": grpclib.const.Handler(
                self.__rpc_delete_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteProjectRequest,
                DeleteProjectResponse,
            ),
            "/portal.v1.Workspace/GetProjectMembers": grpclib.const.Handler(
                self.__rpc_get_project_members,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetProjectMembersRequest,
                GetProjectMembersResponse,
            ),
            "/portal.v1.Workspace/GetProjectMember": grpclib.const.Handler(
                self.__rpc_get_project_member,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetProjectMemberRequest,
                GetProjectMemberResponse,
            ),
            "/portal.v1.Workspace/AddProjectMember": grpclib.const.Handler(
                self.__rpc_add_project_member,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddProjectMemberRequest,
                AddProjectMemberResponse,
            ),
            "/portal.v1.Workspace/UpdateProjectMember": grpclib.const.Handler(
                self.__rpc_update_project_member,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateProjectMemberRequest,
                UpdateProjectMemberResponse,
            ),
            "/portal.v1.Workspace/DeleteProjectMember": grpclib.const.Handler(
                self.__rpc_delete_project_member,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteProjectMemberRequest,
                DeleteProjectMemberResponse,
            ),
            "/portal.v1.Workspace/ActivateOrganization": grpclib.const.Handler(
                self.__rpc_activate_organization,
                grpclib.const.Cardinality.UNARY_UNARY,
                ActivateOrganizationRequest,
                ActivateOrganizationResponse,
            ),
            "/portal.v1.Workspace/FreezeOrganization": grpclib.const.Handler(
                self.__rpc_freeze_organization,
                grpclib.const.Cardinality.UNARY_UNARY,
                FreezeOrganizationRequest,
                FreezeOrganizationResponse,
            ),
            "/portal.v1.Workspace/GetOrganizations": grpclib.const.Handler(
                self.__rpc_get_organizations,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetOrganizationsRequest,
                GetOrganizationsResponse,
            ),
            "/portal.v1.Workspace/GetOrganization": grpclib.const.Handler(
                self.__rpc_get_organization,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetOrganizationRequest,
                GetOrganizationResponse,
            ),
            "/portal.v1.Workspace/CreateOrganization": grpclib.const.Handler(
                self.__rpc_create_organization,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateOrganizationRequest,
                CreateOrganizationResponse,
            ),
            "/portal.v1.Workspace/UpdateOrganization": grpclib.const.Handler(
                self.__rpc_update_organization,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateOrganizationRequest,
                UpdateOrganizationResponse,
            ),
            "/portal.v1.Workspace/DeleteOrganization": grpclib.const.Handler(
                self.__rpc_delete_organization,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteOrganizationRequest,
                DeleteOrganizationResponse,
            ),
            "/portal.v1.Workspace/GetOrganizationMembers": grpclib.const.Handler(
                self.__rpc_get_organization_members,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetOrganizationMembersRequest,
                GetOrganizationMembersResponse,
            ),
            "/portal.v1.Workspace/GetOrganizationMember": grpclib.const.Handler(
                self.__rpc_get_organization_member,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetOrganizationMemberRequest,
                GetOrganizationMemberResponse,
            ),
            "/portal.v1.Workspace/RequestOrganizationMembership": grpclib.const.Handler(
                self.__rpc_request_organization_membership,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestOrganizationMembershipRequest,
                RequestOrganizationMembershipResponse,
            ),
            "/portal.v1.Workspace/ConfirmOrganizationMembership": grpclib.const.Handler(
                self.__rpc_confirm_organization_membership,
                grpclib.const.Cardinality.UNARY_UNARY,
                ConfirmOrganizationMembershipRequest,
                ConfirmOrganizationMembershipResponse,
            ),
            "/portal.v1.Workspace/UpdateOrganizationMember": grpclib.const.Handler(
                self.__rpc_update_organization_member,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateOrganizationMemberRequest,
                UpdateOrganizationMemberResponse,
            ),
            "/portal.v1.Workspace/DeleteOrganizationMember": grpclib.const.Handler(
                self.__rpc_delete_organization_member,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteOrganizationMemberRequest,
                DeleteOrganizationMemberResponse,
            ),
            "/portal.v1.Workspace/GetOrganizationProjects": grpclib.const.Handler(
                self.__rpc_get_organization_projects,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetOrganizationProjectsRequest,
                GetOrganizationProjectsResponse,
            ),
            "/portal.v1.Workspace/GetOrganizationProject": grpclib.const.Handler(
                self.__rpc_get_organization_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetOrganizationProjectRequest,
                GetOrganizationProjectResponse,
            ),
            "/portal.v1.Workspace/AddOrganizationProject": grpclib.const.Handler(
                self.__rpc_add_organization_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddOrganizationProjectRequest,
                AddOrganizationProjectResponse,
            ),
            "/portal.v1.Workspace/UpdateOrganizationProject": grpclib.const.Handler(
                self.__rpc_update_organization_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateOrganizationProjectRequest,
                UpdateOrganizationProjectResponse,
            ),
            "/portal.v1.Workspace/DeleteOrganizationProject": grpclib.const.Handler(
                self.__rpc_delete_organization_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteOrganizationProjectRequest,
                DeleteOrganizationProjectResponse,
            ),
            "/portal.v1.Workspace/GetExperiments": grpclib.const.Handler(
                self.__rpc_get_experiments,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetExperimentsRequest,
                GetExperimentsResponse,
            ),
            "/portal.v1.Workspace/GetProjectExperiments": grpclib.const.Handler(
                self.__rpc_get_project_experiments,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetProjectExperimentsRequest,
                GetProjectExperimentsResponse,
            ),
            "/portal.v1.Workspace/GetExperiment": grpclib.const.Handler(
                self.__rpc_get_experiment,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetExperimentRequest,
                GetExperimentResponse,
            ),
            "/portal.v1.Workspace/CreateExperiment": grpclib.const.Handler(
                self.__rpc_create_experiment,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateExperimentRequest,
                CreateExperimentResponse,
            ),
            "/portal.v1.Workspace/UpdateExperiment": grpclib.const.Handler(
                self.__rpc_update_experiment,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateExperimentRequest,
                UpdateExperimentResponse,
            ),
            "/portal.v1.Workspace/DeleteExperiment": grpclib.const.Handler(
                self.__rpc_delete_experiment,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteExperimentRequest,
                DeleteExperimentResponse,
            ),
            "/portal.v1.Workspace/GetRevision": grpclib.const.Handler(
                self.__rpc_get_revision,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetRevisionRequest,
                GetRevisionResponse,
            ),
            "/portal.v1.Workspace/GetPolicy": grpclib.const.Handler(
                self.__rpc_get_policy,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetPolicyRequest,
                GetPolicyResponse,
            ),
            "/portal.v1.Workspace/GetUserConfigurations": grpclib.const.Handler(
                self.__rpc_get_user_configurations,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetUserConfigurationsRequest,
                GetUserConfigurationsResponse,
            ),
            "/portal.v1.Workspace/UpdateUserConfigurations": grpclib.const.Handler(
                self.__rpc_update_user_configurations,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateUserConfigurationsRequest,
                UpdateUserConfigurationsResponse,
            ),
            "/portal.v1.Workspace/GetEntityTypeConfigurations": grpclib.const.Handler(
                self.__rpc_get_entity_type_configurations,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetEntityTypeConfigurationsRequest,
                GetEntityTypeConfigurationsResponse,
            ),
            "/portal.v1.Workspace/UpdateEntityTypeConfigurations": grpclib.const.Handler(
                self.__rpc_update_entity_type_configurations,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateEntityTypeConfigurationsRequest,
                UpdateEntityTypeConfigurationsResponse,
            ),
            "/portal.v1.Workspace/Health": grpclib.const.Handler(
                self.__rpc_health,
                grpclib.const.Cardinality.UNARY_UNARY,
                HealthRequest,
                HealthResponse,
            ),
        }


class RealizeBase(ServiceBase):
    async def get_realizations(
        self, get_realizations_request: "GetRealizationsRequest"
    ) -> "GetRealizationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_realization(
        self, get_realization_request: "GetRealizationRequest"
    ) -> "GetRealizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def realize(self, realize_request: "RealizeRequest") -> "RealizeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def relinquish(
        self, relinquish_request: "RelinquishRequest"
    ) -> "RelinquishResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_resources(
        self, get_resources_request: "GetResourcesRequest"
    ) -> "GetResourcesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_realization(
        self, update_realization_request: "UpdateRealizationRequest"
    ) -> "UpdateRealizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_realizations(
        self,
        stream: "grpclib.server.Stream[GetRealizationsRequest, GetRealizationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_realizations(request)
        await stream.send_message(response)

    async def __rpc_get_realization(
        self,
        stream: "grpclib.server.Stream[GetRealizationRequest, GetRealizationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_realization(request)
        await stream.send_message(response)

    async def __rpc_realize(
        self, stream: "grpclib.server.Stream[RealizeRequest, RealizeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.realize(request)
        await stream.send_message(response)

    async def __rpc_relinquish(
        self, stream: "grpclib.server.Stream[RelinquishRequest, RelinquishResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.relinquish(request)
        await stream.send_message(response)

    async def __rpc_get_resources(
        self, stream: "grpclib.server.Stream[GetResourcesRequest, GetResourcesResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_resources(request)
        await stream.send_message(response)

    async def __rpc_update_realization(
        self,
        stream: "grpclib.server.Stream[UpdateRealizationRequest, UpdateRealizationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_realization(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.Realize/GetRealizations": grpclib.const.Handler(
                self.__rpc_get_realizations,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetRealizationsRequest,
                GetRealizationsResponse,
            ),
            "/portal.v1.Realize/GetRealization": grpclib.const.Handler(
                self.__rpc_get_realization,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetRealizationRequest,
                GetRealizationResponse,
            ),
            "/portal.v1.Realize/Realize": grpclib.const.Handler(
                self.__rpc_realize,
                grpclib.const.Cardinality.UNARY_UNARY,
                RealizeRequest,
                RealizeResponse,
            ),
            "/portal.v1.Realize/Relinquish": grpclib.const.Handler(
                self.__rpc_relinquish,
                grpclib.const.Cardinality.UNARY_UNARY,
                RelinquishRequest,
                RelinquishResponse,
            ),
            "/portal.v1.Realize/GetResources": grpclib.const.Handler(
                self.__rpc_get_resources,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetResourcesRequest,
                GetResourcesResponse,
            ),
            "/portal.v1.Realize/UpdateRealization": grpclib.const.Handler(
                self.__rpc_update_realization,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateRealizationRequest,
                UpdateRealizationResponse,
            ),
        }


class MaterializeBase(ServiceBase):
    async def get_materializations(
        self, get_materializations_request: "GetMaterializationsRequest"
    ) -> "GetMaterializationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_materializations_v2(
        self, get_materializations_request_v2: "GetMaterializationsRequestV2"
    ) -> "GetMaterializationsResponseV2":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_materialization(
        self, get_materialization_request: "GetMaterializationRequest"
    ) -> "GetMaterializationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_materialization_v2(
        self, get_materialization_request_v2: "GetMaterializationRequestV2"
    ) -> "GetMaterializationResponseV2":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_materialization_status(
        self, get_materialization_status_request: "GetMaterializationStatusRequest"
    ) -> "GetMaterializationStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def materialize(
        self, materialize_request: "MaterializeRequest"
    ) -> "MaterializeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def dematerialize(
        self, dematerialize_request: "DematerializeRequest"
    ) -> "DematerializeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def reboot_materialization(
        self, reboot_materialization_request: "RebootMaterializationRequest"
    ) -> "RebootMaterializationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def new_ingress(
        self, new_ingress_request: "NewIngressRequest"
    ) -> "NewIngressResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_ingress(
        self, delete_ingress_request: "DeleteIngressRequest"
    ) -> "DeleteIngressResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_materializations(
        self,
        stream: "grpclib.server.Stream[GetMaterializationsRequest, GetMaterializationsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_materializations(request)
        await stream.send_message(response)

    async def __rpc_get_materializations_v2(
        self,
        stream: "grpclib.server.Stream[GetMaterializationsRequestV2, GetMaterializationsResponseV2]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_materializations_v2(request)
        await stream.send_message(response)

    async def __rpc_get_materialization(
        self,
        stream: "grpclib.server.Stream[GetMaterializationRequest, GetMaterializationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_materialization(request)
        await stream.send_message(response)

    async def __rpc_get_materialization_v2(
        self,
        stream: "grpclib.server.Stream[GetMaterializationRequestV2, GetMaterializationResponseV2]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_materialization_v2(request)
        await stream.send_message(response)

    async def __rpc_get_materialization_status(
        self,
        stream: "grpclib.server.Stream[GetMaterializationStatusRequest, GetMaterializationStatusResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_materialization_status(request)
        await stream.send_message(response)

    async def __rpc_materialize(
        self, stream: "grpclib.server.Stream[MaterializeRequest, MaterializeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.materialize(request)
        await stream.send_message(response)

    async def __rpc_dematerialize(
        self,
        stream: "grpclib.server.Stream[DematerializeRequest, DematerializeResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.dematerialize(request)
        await stream.send_message(response)

    async def __rpc_reboot_materialization(
        self,
        stream: "grpclib.server.Stream[RebootMaterializationRequest, RebootMaterializationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.reboot_materialization(request)
        await stream.send_message(response)

    async def __rpc_new_ingress(
        self, stream: "grpclib.server.Stream[NewIngressRequest, NewIngressResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.new_ingress(request)
        await stream.send_message(response)

    async def __rpc_delete_ingress(
        self,
        stream: "grpclib.server.Stream[DeleteIngressRequest, DeleteIngressResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_ingress(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.Materialize/GetMaterializations": grpclib.const.Handler(
                self.__rpc_get_materializations,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetMaterializationsRequest,
                GetMaterializationsResponse,
            ),
            "/portal.v1.Materialize/GetMaterializationsV2": grpclib.const.Handler(
                self.__rpc_get_materializations_v2,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetMaterializationsRequestV2,
                GetMaterializationsResponseV2,
            ),
            "/portal.v1.Materialize/GetMaterialization": grpclib.const.Handler(
                self.__rpc_get_materialization,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetMaterializationRequest,
                GetMaterializationResponse,
            ),
            "/portal.v1.Materialize/GetMaterializationV2": grpclib.const.Handler(
                self.__rpc_get_materialization_v2,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetMaterializationRequestV2,
                GetMaterializationResponseV2,
            ),
            "/portal.v1.Materialize/GetMaterializationStatus": grpclib.const.Handler(
                self.__rpc_get_materialization_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetMaterializationStatusRequest,
                GetMaterializationStatusResponse,
            ),
            "/portal.v1.Materialize/Materialize": grpclib.const.Handler(
                self.__rpc_materialize,
                grpclib.const.Cardinality.UNARY_UNARY,
                MaterializeRequest,
                MaterializeResponse,
            ),
            "/portal.v1.Materialize/Dematerialize": grpclib.const.Handler(
                self.__rpc_dematerialize,
                grpclib.const.Cardinality.UNARY_UNARY,
                DematerializeRequest,
                DematerializeResponse,
            ),
            "/portal.v1.Materialize/RebootMaterialization": grpclib.const.Handler(
                self.__rpc_reboot_materialization,
                grpclib.const.Cardinality.UNARY_UNARY,
                RebootMaterializationRequest,
                RebootMaterializationResponse,
            ),
            "/portal.v1.Materialize/NewIngress": grpclib.const.Handler(
                self.__rpc_new_ingress,
                grpclib.const.Cardinality.UNARY_UNARY,
                NewIngressRequest,
                NewIngressResponse,
            ),
            "/portal.v1.Materialize/DeleteIngress": grpclib.const.Handler(
                self.__rpc_delete_ingress,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteIngressRequest,
                DeleteIngressResponse,
            ),
        }


class CommissionBase(ServiceBase):
    async def register_facility(
        self, register_facility_request: "RegisterFacilityRequest"
    ) -> "RegisterFacilityResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_facilities(
        self, get_facilities_request: "GetFacilitiesRequest"
    ) -> "GetFacilitiesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_facility(
        self, get_facility_request: "GetFacilityRequest"
    ) -> "GetFacilityResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_facility(
        self, update_facility_request: "UpdateFacilityRequest"
    ) -> "UpdateFacilityResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_facility(
        self, delete_facility_request: "DeleteFacilityRequest"
    ) -> "DeleteFacilityResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def deactivate_resources(
        self, deactivate_resources_request: "DeactivateResourcesRequest"
    ) -> "DeactivateResourcesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def activate_resources(
        self, activate_resources_request: "ActivateResourcesRequest"
    ) -> "ActivateResourcesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_block_pools(
        self, list_block_pools_request: "ListBlockPoolsRequest"
    ) -> "ListBlockPoolsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def initialize_harbor(
        self, init_harbor_request: "InitHarborRequest"
    ) -> "InitHarborResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def deinitialize_harbor(
        self, deinit_harbor_request: "DeinitHarborRequest"
    ) -> "DeinitHarborResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_register_facility(
        self,
        stream: "grpclib.server.Stream[RegisterFacilityRequest, RegisterFacilityResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.register_facility(request)
        await stream.send_message(response)

    async def __rpc_get_facilities(
        self,
        stream: "grpclib.server.Stream[GetFacilitiesRequest, GetFacilitiesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_facilities(request)
        await stream.send_message(response)

    async def __rpc_get_facility(
        self, stream: "grpclib.server.Stream[GetFacilityRequest, GetFacilityResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_facility(request)
        await stream.send_message(response)

    async def __rpc_update_facility(
        self,
        stream: "grpclib.server.Stream[UpdateFacilityRequest, UpdateFacilityResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_facility(request)
        await stream.send_message(response)

    async def __rpc_delete_facility(
        self,
        stream: "grpclib.server.Stream[DeleteFacilityRequest, DeleteFacilityResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_facility(request)
        await stream.send_message(response)

    async def __rpc_deactivate_resources(
        self,
        stream: "grpclib.server.Stream[DeactivateResourcesRequest, DeactivateResourcesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.deactivate_resources(request)
        await stream.send_message(response)

    async def __rpc_activate_resources(
        self,
        stream: "grpclib.server.Stream[ActivateResourcesRequest, ActivateResourcesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.activate_resources(request)
        await stream.send_message(response)

    async def __rpc_list_block_pools(
        self,
        stream: "grpclib.server.Stream[ListBlockPoolsRequest, ListBlockPoolsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.list_block_pools(request)
        await stream.send_message(response)

    async def __rpc_initialize_harbor(
        self, stream: "grpclib.server.Stream[InitHarborRequest, InitHarborResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.initialize_harbor(request)
        await stream.send_message(response)

    async def __rpc_deinitialize_harbor(
        self, stream: "grpclib.server.Stream[DeinitHarborRequest, DeinitHarborResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.deinitialize_harbor(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.Commission/RegisterFacility": grpclib.const.Handler(
                self.__rpc_register_facility,
                grpclib.const.Cardinality.UNARY_UNARY,
                RegisterFacilityRequest,
                RegisterFacilityResponse,
            ),
            "/portal.v1.Commission/GetFacilities": grpclib.const.Handler(
                self.__rpc_get_facilities,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetFacilitiesRequest,
                GetFacilitiesResponse,
            ),
            "/portal.v1.Commission/GetFacility": grpclib.const.Handler(
                self.__rpc_get_facility,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetFacilityRequest,
                GetFacilityResponse,
            ),
            "/portal.v1.Commission/UpdateFacility": grpclib.const.Handler(
                self.__rpc_update_facility,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateFacilityRequest,
                UpdateFacilityResponse,
            ),
            "/portal.v1.Commission/DeleteFacility": grpclib.const.Handler(
                self.__rpc_delete_facility,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteFacilityRequest,
                DeleteFacilityResponse,
            ),
            "/portal.v1.Commission/DeactivateResources": grpclib.const.Handler(
                self.__rpc_deactivate_resources,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeactivateResourcesRequest,
                DeactivateResourcesResponse,
            ),
            "/portal.v1.Commission/ActivateResources": grpclib.const.Handler(
                self.__rpc_activate_resources,
                grpclib.const.Cardinality.UNARY_UNARY,
                ActivateResourcesRequest,
                ActivateResourcesResponse,
            ),
            "/portal.v1.Commission/ListBlockPools": grpclib.const.Handler(
                self.__rpc_list_block_pools,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListBlockPoolsRequest,
                ListBlockPoolsResponse,
            ),
            "/portal.v1.Commission/InitializeHarbor": grpclib.const.Handler(
                self.__rpc_initialize_harbor,
                grpclib.const.Cardinality.UNARY_UNARY,
                InitHarborRequest,
                InitHarborResponse,
            ),
            "/portal.v1.Commission/DeinitializeHarbor": grpclib.const.Handler(
                self.__rpc_deinitialize_harbor,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeinitHarborRequest,
                DeinitHarborResponse,
            ),
        }


class AllocBase(ServiceBase):
    async def alloc(
        self, allocation_request: "AllocationRequest"
    ) -> "AllocationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def free(self, free_request: "FreeRequest") -> "FreeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch(
        self, fetch_allocation_table_request: "FetchAllocationTableRequest"
    ) -> "FetchAllocationTableResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_pool(self, get_pool_request: "GetPoolRequest") -> "GetPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_pools(
        self, get_pools_request: "GetPoolsRequest"
    ) -> "GetPoolsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_pool(
        self, create_pool_request: "CreatePoolRequest"
    ) -> "CreatePoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_pool(
        self, delete_pool_request: "DeletePoolRequest"
    ) -> "DeletePoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def add_project(
        self, add_project_to_pool_request: "AddProjectToPoolRequest"
    ) -> "AddProjectToPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_project(
        self, remove_project_from_pool_request: "RemoveProjectFromPoolRequest"
    ) -> "RemoveProjectFromPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def add_organization(
        self, add_organization_to_pool_request: "AddOrganizationToPoolRequest"
    ) -> "AddOrganizationToPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_organization(
        self, remove_organization_from_pool_request: "RemoveOrganizationFromPoolRequest"
    ) -> "RemoveOrganizationFromPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def add_facility(
        self, add_facility_to_pool_request: "AddFacilityToPoolRequest"
    ) -> "AddFacilityToPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_facility(
        self, remove_facility_from_pool_request: "RemoveFacilityFromPoolRequest"
    ) -> "RemoveFacilityFromPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_pool_resources(
        self, update_pool_resources_request: "UpdatePoolResourcesRequest"
    ) -> "UpdatePoolResourcesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_alloc(
        self, stream: "grpclib.server.Stream[AllocationRequest, AllocationResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.alloc(request)
        await stream.send_message(response)

    async def __rpc_free(
        self, stream: "grpclib.server.Stream[FreeRequest, FreeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.free(request)
        await stream.send_message(response)

    async def __rpc_fetch(
        self,
        stream: "grpclib.server.Stream[FetchAllocationTableRequest, FetchAllocationTableResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch(request)
        await stream.send_message(response)

    async def __rpc_get_pool(
        self, stream: "grpclib.server.Stream[GetPoolRequest, GetPoolResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_pool(request)
        await stream.send_message(response)

    async def __rpc_get_pools(
        self, stream: "grpclib.server.Stream[GetPoolsRequest, GetPoolsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_pools(request)
        await stream.send_message(response)

    async def __rpc_create_pool(
        self, stream: "grpclib.server.Stream[CreatePoolRequest, CreatePoolResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_pool(request)
        await stream.send_message(response)

    async def __rpc_delete_pool(
        self, stream: "grpclib.server.Stream[DeletePoolRequest, DeletePoolResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_pool(request)
        await stream.send_message(response)

    async def __rpc_add_project(
        self,
        stream: "grpclib.server.Stream[AddProjectToPoolRequest, AddProjectToPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.add_project(request)
        await stream.send_message(response)

    async def __rpc_remove_project(
        self,
        stream: "grpclib.server.Stream[RemoveProjectFromPoolRequest, RemoveProjectFromPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.remove_project(request)
        await stream.send_message(response)

    async def __rpc_add_organization(
        self,
        stream: "grpclib.server.Stream[AddOrganizationToPoolRequest, AddOrganizationToPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.add_organization(request)
        await stream.send_message(response)

    async def __rpc_remove_organization(
        self,
        stream: "grpclib.server.Stream[RemoveOrganizationFromPoolRequest, RemoveOrganizationFromPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.remove_organization(request)
        await stream.send_message(response)

    async def __rpc_add_facility(
        self,
        stream: "grpclib.server.Stream[AddFacilityToPoolRequest, AddFacilityToPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.add_facility(request)
        await stream.send_message(response)

    async def __rpc_remove_facility(
        self,
        stream: "grpclib.server.Stream[RemoveFacilityFromPoolRequest, RemoveFacilityFromPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.remove_facility(request)
        await stream.send_message(response)

    async def __rpc_update_pool_resources(
        self,
        stream: "grpclib.server.Stream[UpdatePoolResourcesRequest, UpdatePoolResourcesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_pool_resources(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.Alloc/Alloc": grpclib.const.Handler(
                self.__rpc_alloc,
                grpclib.const.Cardinality.UNARY_UNARY,
                AllocationRequest,
                AllocationResponse,
            ),
            "/portal.v1.Alloc/Free": grpclib.const.Handler(
                self.__rpc_free,
                grpclib.const.Cardinality.UNARY_UNARY,
                FreeRequest,
                FreeResponse,
            ),
            "/portal.v1.Alloc/Fetch": grpclib.const.Handler(
                self.__rpc_fetch,
                grpclib.const.Cardinality.UNARY_UNARY,
                FetchAllocationTableRequest,
                FetchAllocationTableResponse,
            ),
            "/portal.v1.Alloc/GetPool": grpclib.const.Handler(
                self.__rpc_get_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetPoolRequest,
                GetPoolResponse,
            ),
            "/portal.v1.Alloc/GetPools": grpclib.const.Handler(
                self.__rpc_get_pools,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetPoolsRequest,
                GetPoolsResponse,
            ),
            "/portal.v1.Alloc/CreatePool": grpclib.const.Handler(
                self.__rpc_create_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreatePoolRequest,
                CreatePoolResponse,
            ),
            "/portal.v1.Alloc/DeletePool": grpclib.const.Handler(
                self.__rpc_delete_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeletePoolRequest,
                DeletePoolResponse,
            ),
            "/portal.v1.Alloc/AddProject": grpclib.const.Handler(
                self.__rpc_add_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddProjectToPoolRequest,
                AddProjectToPoolResponse,
            ),
            "/portal.v1.Alloc/RemoveProject": grpclib.const.Handler(
                self.__rpc_remove_project,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemoveProjectFromPoolRequest,
                RemoveProjectFromPoolResponse,
            ),
            "/portal.v1.Alloc/AddOrganization": grpclib.const.Handler(
                self.__rpc_add_organization,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddOrganizationToPoolRequest,
                AddOrganizationToPoolResponse,
            ),
            "/portal.v1.Alloc/RemoveOrganization": grpclib.const.Handler(
                self.__rpc_remove_organization,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemoveOrganizationFromPoolRequest,
                RemoveOrganizationFromPoolResponse,
            ),
            "/portal.v1.Alloc/AddFacility": grpclib.const.Handler(
                self.__rpc_add_facility,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddFacilityToPoolRequest,
                AddFacilityToPoolResponse,
            ),
            "/portal.v1.Alloc/RemoveFacility": grpclib.const.Handler(
                self.__rpc_remove_facility,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemoveFacilityFromPoolRequest,
                RemoveFacilityFromPoolResponse,
            ),
            "/portal.v1.Alloc/UpdatePoolResources": grpclib.const.Handler(
                self.__rpc_update_pool_resources,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdatePoolResourcesRequest,
                UpdatePoolResourcesResponse,
            ),
        }


class IdentityBase(ServiceBase):
    async def list_identities(
        self, list_identity_request: "ListIdentityRequest"
    ) -> "ListIdentityResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_identity(
        self, get_identity_request: "GetIdentityRequest"
    ) -> "GetIdentityResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def register(self, register_request: "RegisterRequest") -> "RegisterResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unregister(
        self, unregister_request: "UnregisterRequest"
    ) -> "UnregisterResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def login(self, login_request: "LoginRequest") -> "LoginResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def logout(self, logout_request: "LogoutRequest") -> "LogoutResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_list_identities(
        self, stream: "grpclib.server.Stream[ListIdentityRequest, ListIdentityResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.list_identities(request)
        await stream.send_message(response)

    async def __rpc_get_identity(
        self, stream: "grpclib.server.Stream[GetIdentityRequest, GetIdentityResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_identity(request)
        await stream.send_message(response)

    async def __rpc_register(
        self, stream: "grpclib.server.Stream[RegisterRequest, RegisterResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.register(request)
        await stream.send_message(response)

    async def __rpc_unregister(
        self, stream: "grpclib.server.Stream[UnregisterRequest, UnregisterResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.unregister(request)
        await stream.send_message(response)

    async def __rpc_login(
        self, stream: "grpclib.server.Stream[LoginRequest, LoginResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.login(request)
        await stream.send_message(response)

    async def __rpc_logout(
        self, stream: "grpclib.server.Stream[LogoutRequest, LogoutResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.logout(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.Identity/ListIdentities": grpclib.const.Handler(
                self.__rpc_list_identities,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListIdentityRequest,
                ListIdentityResponse,
            ),
            "/portal.v1.Identity/GetIdentity": grpclib.const.Handler(
                self.__rpc_get_identity,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetIdentityRequest,
                GetIdentityResponse,
            ),
            "/portal.v1.Identity/Register": grpclib.const.Handler(
                self.__rpc_register,
                grpclib.const.Cardinality.UNARY_UNARY,
                RegisterRequest,
                RegisterResponse,
            ),
            "/portal.v1.Identity/Unregister": grpclib.const.Handler(
                self.__rpc_unregister,
                grpclib.const.Cardinality.UNARY_UNARY,
                UnregisterRequest,
                UnregisterResponse,
            ),
            "/portal.v1.Identity/Login": grpclib.const.Handler(
                self.__rpc_login,
                grpclib.const.Cardinality.UNARY_UNARY,
                LoginRequest,
                LoginResponse,
            ),
            "/portal.v1.Identity/Logout": grpclib.const.Handler(
                self.__rpc_logout,
                grpclib.const.Cardinality.UNARY_UNARY,
                LogoutRequest,
                LogoutResponse,
            ),
        }


class CredBase(ServiceBase):
    async def get_user_ssh_keys(
        self, get_user_ssh_keys_request: "GetUserSshKeysRequest"
    ) -> "GetUserSshKeysResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_user_ssh_cert(
        self, get_user_ssh_cert_request: "GetUserSshCertRequest"
    ) -> "GetUserSshCertResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_user_ssh_keys(
        self,
        stream: "grpclib.server.Stream[GetUserSshKeysRequest, GetUserSshKeysResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_user_ssh_keys(request)
        await stream.send_message(response)

    async def __rpc_get_user_ssh_cert(
        self,
        stream: "grpclib.server.Stream[GetUserSshCertRequest, GetUserSshCertResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_user_ssh_cert(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.Cred/GetUserSSHKeys": grpclib.const.Handler(
                self.__rpc_get_user_ssh_keys,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetUserSshKeysRequest,
                GetUserSshKeysResponse,
            ),
            "/portal.v1.Cred/GetUserSSHCert": grpclib.const.Handler(
                self.__rpc_get_user_ssh_cert,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetUserSshCertRequest,
                GetUserSshCertResponse,
            ),
        }


class XdcBase(ServiceBase):
    async def list_xd_cs(
        self, list_xd_cs_request: "ListXdCsRequest"
    ) -> "ListXdCsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_xdc(self, get_xdc_request: "GetXdcRequest") -> "GetXdcResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_xdc(
        self, create_xdc_request: "CreateXdcRequest"
    ) -> "CreateXdcResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_xdc(
        self, delete_xdc_request: "DeleteXdcRequest"
    ) -> "DeleteXdcResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def attach_xdc(
        self, attach_xdc_request: "AttachXdcRequest"
    ) -> "AttachXdcResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def detach_xdc(
        self, detach_xdc_request: "DetachXdcRequest"
    ) -> "DetachXdcResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_xdc_jump_hosts(
        self, get_xdc_jump_hosts_request: "GetXdcJumpHostsRequest"
    ) -> "GetXdcJumpHostsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_list_xd_cs(
        self, stream: "grpclib.server.Stream[ListXdCsRequest, ListXdCsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.list_xd_cs(request)
        await stream.send_message(response)

    async def __rpc_get_xdc(
        self, stream: "grpclib.server.Stream[GetXdcRequest, GetXdcResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_xdc(request)
        await stream.send_message(response)

    async def __rpc_create_xdc(
        self, stream: "grpclib.server.Stream[CreateXdcRequest, CreateXdcResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_xdc(request)
        await stream.send_message(response)

    async def __rpc_delete_xdc(
        self, stream: "grpclib.server.Stream[DeleteXdcRequest, DeleteXdcResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.delete_xdc(request)
        await stream.send_message(response)

    async def __rpc_attach_xdc(
        self, stream: "grpclib.server.Stream[AttachXdcRequest, AttachXdcResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.attach_xdc(request)
        await stream.send_message(response)

    async def __rpc_detach_xdc(
        self, stream: "grpclib.server.Stream[DetachXdcRequest, DetachXdcResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.detach_xdc(request)
        await stream.send_message(response)

    async def __rpc_get_xdc_jump_hosts(
        self,
        stream: "grpclib.server.Stream[GetXdcJumpHostsRequest, GetXdcJumpHostsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_xdc_jump_hosts(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.XDC/ListXDCs": grpclib.const.Handler(
                self.__rpc_list_xd_cs,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListXdCsRequest,
                ListXdCsResponse,
            ),
            "/portal.v1.XDC/GetXDC": grpclib.const.Handler(
                self.__rpc_get_xdc,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetXdcRequest,
                GetXdcResponse,
            ),
            "/portal.v1.XDC/CreateXDC": grpclib.const.Handler(
                self.__rpc_create_xdc,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateXdcRequest,
                CreateXdcResponse,
            ),
            "/portal.v1.XDC/DeleteXDC": grpclib.const.Handler(
                self.__rpc_delete_xdc,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteXdcRequest,
                DeleteXdcResponse,
            ),
            "/portal.v1.XDC/AttachXDC": grpclib.const.Handler(
                self.__rpc_attach_xdc,
                grpclib.const.Cardinality.UNARY_UNARY,
                AttachXdcRequest,
                AttachXdcResponse,
            ),
            "/portal.v1.XDC/DetachXDC": grpclib.const.Handler(
                self.__rpc_detach_xdc,
                grpclib.const.Cardinality.UNARY_UNARY,
                DetachXdcRequest,
                DetachXdcResponse,
            ),
            "/portal.v1.XDC/GetXDCJumpHosts": grpclib.const.Handler(
                self.__rpc_get_xdc_jump_hosts,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetXdcJumpHostsRequest,
                GetXdcJumpHostsResponse,
            ),
        }


class WireguardBase(ServiceBase):
    async def add_wg_if_config(
        self, add_wg_if_config_request: "AddWgIfConfigRequest"
    ) -> "AddWgIfConfigResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def del_wg_if_config(
        self, del_wg_if_config_request: "DelWgIfConfigRequest"
    ) -> "DelWgIfConfigResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_wg_if_config(
        self, get_wg_if_config_request: "GetWgIfConfigRequest"
    ) -> "GetWgIfConfigResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_wg_enclave(
        self, get_wg_enclave_request: "GetWgEnclaveRequest"
    ) -> "GetWgEnclaveResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_add_wg_if_config(
        self,
        stream: "grpclib.server.Stream[AddWgIfConfigRequest, AddWgIfConfigResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.add_wg_if_config(request)
        await stream.send_message(response)

    async def __rpc_del_wg_if_config(
        self,
        stream: "grpclib.server.Stream[DelWgIfConfigRequest, DelWgIfConfigResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.del_wg_if_config(request)
        await stream.send_message(response)

    async def __rpc_get_wg_if_config(
        self,
        stream: "grpclib.server.Stream[GetWgIfConfigRequest, GetWgIfConfigResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_wg_if_config(request)
        await stream.send_message(response)

    async def __rpc_get_wg_enclave(
        self, stream: "grpclib.server.Stream[GetWgEnclaveRequest, GetWgEnclaveResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_wg_enclave(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.Wireguard/AddWgIfConfig": grpclib.const.Handler(
                self.__rpc_add_wg_if_config,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddWgIfConfigRequest,
                AddWgIfConfigResponse,
            ),
            "/portal.v1.Wireguard/DelWgIfConfig": grpclib.const.Handler(
                self.__rpc_del_wg_if_config,
                grpclib.const.Cardinality.UNARY_UNARY,
                DelWgIfConfigRequest,
                DelWgIfConfigResponse,
            ),
            "/portal.v1.Wireguard/GetWgIfConfig": grpclib.const.Handler(
                self.__rpc_get_wg_if_config,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetWgIfConfigRequest,
                GetWgIfConfigResponse,
            ),
            "/portal.v1.Wireguard/GetWgEnclave": grpclib.const.Handler(
                self.__rpc_get_wg_enclave,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetWgEnclaveRequest,
                GetWgEnclaveResponse,
            ),
        }


class ModelBase(ServiceBase):
    async def compile(self, compile_request: "CompileRequest") -> "CompileResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def push(self, push_request: "PushRequest") -> "PushResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_compile(
        self, stream: "grpclib.server.Stream[CompileRequest, CompileResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.compile(request)
        await stream.send_message(response)

    async def __rpc_push(
        self, stream: "grpclib.server.Stream[PushRequest, PushResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.push(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/portal.v1.Model/Compile": grpclib.const.Handler(
                self.__rpc_compile,
                grpclib.const.Cardinality.UNARY_UNARY,
                CompileRequest,
                CompileResponse,
            ),
            "/portal.v1.Model/Push": grpclib.const.Handler(
                self.__rpc_push,
                grpclib.const.Cardinality.UNARY_UNARY,
                PushRequest,
                PushResponse,
            ),
        }
