from pytest import fixture
from math import radians, sqrt


@fixture(
    params=[
        {
            "input": [
                (
                    (
                        0.4000000016853294,
                        -0.39999999880983755,
                        0.3000000025723091,
                    ),
                    (
                        -3.1415926381331523,
                        2.188741009988131e-08,
                        2.6794896299132232e-08,
                    ),
                ),
                (
                    (
                        0.4000000029422969,
                        -0.2999999962803114,
                        0.19999999804274032,
                    ),
                    (
                        1.5707963642922351,
                        3.757424773546488e-15,
                        7.285142337505987e-08,
                    ),
                ),
                (
                    (
                        0.3292893264445241,
                        -0.4707106768261343,
                        0.2000000019309496,
                    ),
                    (
                        -1.5707963309948643,
                        0.7853981633974412,
                        -5.0320115533448106e-08,
                    ),
                ),
                (
                    (
                        0.47071067682613615,
                        -0.32928932644452064,
                        0.19999999806904972,
                    ),
                    (
                        1.570796322594932,
                        -0.7853981633974498,
                        5.363765550429646e-08,
                    ),
                ),
            ],
            "tcp_offset": (0, 0, 0.1),
            "sphere_center": (0.4, -0.4, 0.2),
        },
        {
            "input": [
                (
                    (
                        0.5610981450301386,
                        0.31800863073647684,
                        0.26942849678688663,
                    ),
                    (
                        0.836516865889247,
                        -1.3569763171402913,
                        0.6819871287362032,
                    ),
                ),
                (
                    (
                        0.37091538571441846,
                        0.5148983236031072,
                        0.3233237933301015,
                    ),
                    (
                        1.1566416570203617,
                        1.3252468130469492,
                        2.3129663442508877,
                    ),
                ),
                (
                    (
                        0.35786179065518875,
                        0.4838408100580218,
                        0.23305771045238258,
                    ),
                    (
                        -0.2365540388297892,
                        1.343739868708303,
                        2.9041447933899946,
                    ),
                ),
                (
                    (
                        0.5419185131545186,
                        0.38186201140831383,
                        0.4059339456502231,
                    ),
                    (
                        2.749087694865031,
                        -0.10410790579513919,
                        2.1806997391364216,
                    ),
                ),
            ],
            "tcp_offset": (0, 0.1, 0.1),
            "sphere_center": (0.45, 0.4, 0.3),
        },
        {
            "input": [
                (
                    (
                        -0.6011231030381208,
                        -0.5185209854931511,
                        0.4660692423631188,
                    ),
                    (
                        -2.589645738828296,
                        0.31642476568824607,
                        0.6121585344811777,
                    ),
                ),
                (
                    (
                        -0.514050566835751,
                        -0.47249670316745646,
                        0.5044418759955023,
                    ),
                    (
                        -3.0018677447793785,
                        -0.17492564749341188,
                        0.12422541468587599,
                    ),
                ),
                (
                    (
                        -0.542318742947148,
                        -0.5882653096607863,
                        0.44694158190221334,
                    ),
                    (
                        -2.525737922573022,
                        0.41300061987993353,
                        -2.5476544822851013,
                    ),
                ),
                (
                    (
                        -0.33791729580317204,
                        -0.32889884839065947,
                        0.26045625174181747,
                    ),
                    (
                        1.638743119079991,
                        -1.0161697162847698,
                        1.2646169510464602,
                    ),
                ),
            ],
            "tcp_offset": (0.05, 0, 0.2),
            "sphere_center": (-0.5, -0.45, 0.3),
        },
        {
            "input": [
                (
                    (
                        -0.39159224526193304,
                        -0.4772215874984058,
                        0.24993259806898582,
                    ),
                    (
                        2.351271503384078,
                        -1.4346815455001543,
                        2.121793672034322,
                    ),
                ),
                (
                    (
                        -0.3888874134456802,
                        -0.47724551453580344,
                        0.2562772817479257,
                    ),
                    (
                        -1.4642018869638396,
                        -0.7676159794766343,
                        2.9673678544290065,
                    ),
                ),
                (
                    (
                        -0.433527172682186,
                        -0.38060061187723804,
                        0.3759281815672886,
                    ),
                    (
                        2.833300365546679,
                        -0.10751304579823073,
                        1.7009388859412942,
                    ),
                ),
                (
                    (
                        -0.4448810185796348,
                        -0.3664899006393361,
                        0.3706255041502914,
                    ),
                    (
                        1.8450308293711595,
                        -0.008858105570972018,
                        3.052833544350056,
                    ),
                ),
                (
                    (
                        -0.5985796824793097,
                        -0.5226597741501592,
                        0.3016134168274624,
                    ),
                    (
                        -0.37351757556586546,
                        1.1390697563624113,
                        0.5201946554057293,
                    ),
                ),
                (
                    (
                        -0.38389151696810747,
                        -0.4784797440377333,
                        0.2733969008407851,
                    ),
                    (
                        1.4293899106757775,
                        -1.209953251221259,
                        1.9125506893452016,
                    ),
                ),
                (
                    (
                        -0.42189466333548087,
                        -0.4351067914245066,
                        0.20684556741844956,
                    ),
                    (
                        0.6636929398336955,
                        -0.2626007864158677,
                        1.6543228484123598,
                    ),
                ),
                (
                    (
                        -0.4103245875219697,
                        -0.3716523056341686,
                        0.27136507219929046,
                    ),
                    (
                        0.9337284711640448,
                        -1.430244813528645,
                        -1.1254780875187091,
                    ),
                ),
            ],
            "tcp_offset": (0.05, 0.05, 0.1),
            "sphere_center": (-0.5, -0.45, 0.3),
        },
        # {"input":, "tcp_offset": , "sphere_center": ,}
    ]
)
def valid_data_point(request):
    return request.param
