#!/usr/bin/env python
# -*- coding: utf-8 -*-
from pywkmisc import get_config

class MimeTypeUtils(object):

    # http://www.iana.org/assignments/media-types/media-types.xhtml#text
    def __init__(self):
        self.__mime_types = [
            {'mimetype': 'application/octet-stream', 'ext': '.'},
            {'mimetype': 'video/x-sgi-movie', 'ext': '.movie'},
            {'mimetype': 'video/x-ms-wvx', 'ext': '.wvx'},
            {'mimetype': 'video/x-ms-wmx', 'ext': '.wmx'},
            {'mimetype': 'video/x-ms-wmv', 'ext': '.wmv'},
            {'mimetype': 'video/x-ms-wm', 'ext': '.wm'},
            {'mimetype': 'video/x-ms-asf', 'ext': '.asf'},
            {'mimetype': 'video/x-mpg', 'ext': '.mpa'},
            {'mimetype': 'video/x-mpeg', 'ext': '.m2v'},
            {'mimetype': 'video/x-ivf', 'ext': '.IVF'},
            {'mimetype': 'video/vnd.rn-realvideo', 'ext': '.rv'},
            {'mimetype': 'video/mpg', 'ext': '.mpeg'},
            {'mimetype': 'video/mpeg4', 'ext': '.mp4'},
            {'mimetype': 'video/mpeg', 'ext': '.mp2v'},
            {'mimetype': 'video/avi', 'ext': '.avi'},
            {'mimetype': 'text/x-vcard', 'ext': '.vcf'},
            {'mimetype': 'text/x-ms-odc', 'ext': '.odc'},
            {'mimetype': 'text/xml', 'ext': '.xml'},
            {'mimetype': 'text/x-component', 'ext': '.htc'},
            {'mimetype': 'text/webviewhtml', 'ext': '.htt'},
            {'mimetype': 'text/vnd.wap.wml', 'ext': '.wml'},
            {'mimetype': 'text/vnd.rn-realtext3d', 'ext': '.r3t'},
            {'mimetype': 'text/vnd.rn-realtext', 'ext': '.rt'},
            {'mimetype': 'text/scriptlet', 'ext': '.wsc'},
            {'mimetype': 'text/plain', 'ext': '.txt'},
            {'mimetype': 'text/iuls', 'ext': '.uls'},
            {'mimetype': 'text/html', 'ext': '.htm'},
            {'mimetype': 'text/h323', 'ext': '0.323'},
            {'mimetype': 'text/css', 'ext': '.css'},
            {'mimetype': 'text/asp', 'ext': '.asp'},
            {'mimetype': 'text/asa', 'ext': '.asa'},
            {'mimetype': 'Model/vnd.dwf', 'ext': '.dwf'},
            {'mimetype': 'message/rfc822', 'ext': '.mht'},
            {'mimetype': 'java/*', 'ext': '.java'},
            {'mimetype': 'image/x-icon', 'ext': '.ico'},
            {'mimetype': 'image/vnd.wap.wbmp', 'ext': '.wbmp'},
            {'mimetype': 'image/vnd.rn-realpix', 'ext': '.rp'},
            {'mimetype': 'image/tiff', 'ext': '.tif'},
            {'mimetype': 'image/png', 'ext': '.png'},
            {'mimetype': 'image/pnetvue', 'ext': '.net'},
            {'mimetype': 'image/jpeg', 'ext': '.jpg'},
            {'mimetype': 'image/gif', 'ext': '.gif'},
            {'mimetype': 'image/fax', 'ext': '.fax'},
            {'mimetype': 'drawing/x-top', 'ext': '.top'},
            {'mimetype': 'drawing/x-slk', 'ext': '.slk'},
            {'mimetype': 'drawing/907', 'ext': '0.907'},
            {'mimetype': 'audio/x-pn-realaudio-plugin', 'ext': '.rpm'},
            {'mimetype': 'audio/x-pn-realaudio', 'ext': '.ram'},
            {'mimetype': 'audio/x-musicnet-stream', 'ext': '.mns'},
            {'mimetype': 'audio/x-musicnet-download', 'ext': '.mnd'},
            {'mimetype': 'audio/x-ms-wma', 'ext': '.wma'},
            {'mimetype': 'audio/x-ms-wax', 'ext': '.wax'},
            {'mimetype': 'audio/x-mei-aac', 'ext': '.acp'},
            {'mimetype': 'audio/x-liquid-secure', 'ext': '.lavs'},
            {'mimetype': 'audio/x-liquid-file', 'ext': '.la1'},
            {'mimetype': 'audio/x-la-lms', 'ext': '.lmsff'},
            {'mimetype': 'audio/wav', 'ext': '.wav'},
            {'mimetype': 'audio/vnd.rn-realaudio', 'ext': '.ra'},
            {'mimetype': 'audio/scpls', 'ext': '.xpl'},
            {'mimetype': 'audio/rn-mpeg', 'ext': '.mpga'},
            {'mimetype': 'audio/mpegurl', 'ext': '.m3u'},
            {'mimetype': 'audio/mp3', 'ext': '.mp3'},
            {'mimetype': 'audio/mp2', 'ext': '.mp2'},
            {'mimetype': 'audio/mp1', 'ext': '.mp1'},
            {'mimetype': 'audio/mid', 'ext': '.mid'},
            {'mimetype': 'audio/basic', 'ext': '.au'},
            {'mimetype': 'audio/aiff', 'ext': '.aif'},
            {'mimetype': 'application/x-xwd', 'ext': '.xwd'},
            {'mimetype': 'application/x-xlw', 'ext': '.xlw'},
            {'mimetype': 'application/x-xls', 'ext': '.xls'},
            {'mimetype': 'application/x-x509-ca-cert', 'ext': '.der'},
            {'mimetype': 'application/x-x509-ca-cert', 'ext': '.cer'},
            {'mimetype': 'application/x-x509-ca-cert', 'ext': '.crt'},
            {'mimetype': 'application/x-x_t', 'ext': '.x_t'},
            {'mimetype': 'application/x-x_b', 'ext': '.x_b'},
            {'mimetype': 'application/x-ws', 'ext': '.ws'},
            {'mimetype': 'application/x-wrk', 'ext': '.wrk'},
            {'mimetype': 'application/x-wri', 'ext': '.wri'},
            {'mimetype': 'application/x-wr1', 'ext': '.wr1'},
            {'mimetype': 'application/x-wq1', 'ext': '.wq1'},
            {'mimetype': 'application/x-wpg', 'ext': '.wpg'},
            {'mimetype': 'application/x-wpd', 'ext': '.wpd'},
            {'mimetype': 'application/x-wp6', 'ext': '.wp6'},
            {'mimetype': 'application/x-wmf', 'ext': '.wmf'},
            {'mimetype': 'application/x-wks', 'ext': '.wks'},
            {'mimetype': 'application/x-wkq', 'ext': '.wkq'},
            {'mimetype': 'application/x-wk4', 'ext': '.wk4'},
            {'mimetype': 'application/x-wk3', 'ext': '.wk3'},
            {'mimetype': 'application/x-wb3', 'ext': '.wb3'},
            {'mimetype': 'application/x-wb2', 'ext': '.wb2'},
            {'mimetype': 'application/x-wb1', 'ext': '.wb1'},
            {'mimetype': 'application/x-vst', 'ext': '.vst'},
            {'mimetype': 'application/x-vsd', 'ext': '.vsd'},
            {'mimetype': 'application/x-vpeg005', 'ext': '.vpg'},
            {'mimetype': 'application/x-vda', 'ext': '.vda'},
            {'mimetype': 'application/x-troff-man', 'ext': '.man'},
            {'mimetype': 'application/x-tif', 'ext': '.tif'},
            {'mimetype': 'application/x-tga', 'ext': '.tga'},
            {'mimetype': 'application/x-tg4', 'ext': '.tg4'},
            {'mimetype': 'application/x-tdf', 'ext': '.tdf'},
            {'mimetype': 'application/x-sty', 'ext': '.sty'},
            {'mimetype': 'application/x-stuffit', 'ext': '.sit'},
            {'mimetype': 'application/x-smk', 'ext': '.smk'},
            {'mimetype': 'application/x-sld', 'ext': '.sld'},
            {'mimetype': 'application/x-slb', 'ext': '.slb'},
            {'mimetype': 'application/x-shockwave-flash', 'ext': '.swf'},
            {'mimetype': 'application/x-sdw', 'ext': '.sdw'},
            {'mimetype': 'application/x-sat', 'ext': '.sat'},
            {'mimetype': 'application/x-sam', 'ext': '.sam'},
            {'mimetype': 'application/x-rtf', 'ext': '.rtf'},
            {'mimetype': 'application/x-rle', 'ext': '.rle'},
            {'mimetype': 'application/x-rlc', 'ext': '.rlc'},
            {'mimetype': 'application/x-rgb', 'ext': '.rgb'},
            {'mimetype': 'application/x-red', 'ext': '.red'},
            {'mimetype': 'application/x-ras', 'ext': '.ras'},
            {'mimetype': 'application/x-ptn', 'ext': '.ptn'},
            {'mimetype': 'application/x-ps', 'ext': '.ps'},
            {'mimetype': 'application/x-prt', 'ext': '.prt'},
            {'mimetype': 'application/x-prn', 'ext': '.prn'},
            {'mimetype': 'application/x-pr', 'ext': '.pr'},
            {'mimetype': 'application/x-ppt', 'ext': '.ppt'},
            {'mimetype': 'application/x-ppm', 'ext': '.ppm'},
            {'mimetype': 'application/x-png', 'ext': '.png'},
            {'mimetype': 'application/x-plt', 'ext': '.plt'},
            {'mimetype': 'application/x-pkcs7-certreqresp', 'ext': '.p7r'},
            {'mimetype': 'application/x-pkcs7-certificates', 'ext': '.p7b'},
            {'mimetype': 'application/x-pkcs12', 'ext': '.pfx'},
            {'mimetype': 'application/x-pic', 'ext': '.pic'},
            {'mimetype': 'application/x-pgl', 'ext': '.pgl'},
            {'mimetype': 'application/x-perl', 'ext': '.pl'},
            {'mimetype': 'application/x-pcx', 'ext': '.pcx'},
            {'mimetype': 'application/x-pcl', 'ext': '.pcl'},
            {'mimetype': 'application/x-pci', 'ext': '.pci'},
            {'mimetype': 'application/x-pc5', 'ext': '.pc5'},
            {'mimetype': 'application/json', 'ext': '.json'},
            {'mimetype': 'application/x-out', 'ext': '.out'},
            {'mimetype': 'application/x-nrf', 'ext': '.nrf'},
            {'mimetype': 'application/x-netcdf', 'ext': '.cdf'},
            {'mimetype': 'application/x-ms-wmz', 'ext': '.wmz'},
            {'mimetype': 'application/x-ms-wmd', 'ext': '.wmd'},
            {'mimetype': 'application/x-msdownload', 'ext': '.exe'},
            {'mimetype': 'application/x-mmxp', 'ext': '.mxp'},
            {'mimetype': 'application/x-mil', 'ext': '.mil'},
            {'mimetype': 'application/x-mi', 'ext': '.mi'},
            {'mimetype': 'application/x-mdb', 'ext': '.mdb'},
            {'mimetype': 'application/x-mac', 'ext': '.mac'},
            {'mimetype': 'application/x-ltr', 'ext': '.ltr'},
            {'mimetype': 'application/x-lbm', 'ext': '.lbm'},
            {'mimetype': 'application/x-latex', 'ext': '.latex'},
            {'mimetype': 'application/x-laplayer-reg', 'ext': '.lar'},
            {'mimetype': 'application/x-jpg', 'ext': '.jpg'},
            {'mimetype': 'application/x-jpe', 'ext': '.jpe'},
            {'mimetype': 'application/x-javascript', 'ext': '.js'},
            {'mimetype': 'application/x-iphone', 'ext': '.iii'},
            {'mimetype': 'application/x-internet-signup', 'ext': '.ins'},
            {'mimetype': 'application/x-img', 'ext': '.img'},
            {'mimetype': 'application/x-igs', 'ext': '.igs'},
            {'mimetype': 'application/x-iff', 'ext': '.iff'},
            {'mimetype': 'application/x-icq', 'ext': '.uin'},
            {'mimetype': 'application/x-ico', 'ext': '.ico'},
            {'mimetype': 'application/x-icb', 'ext': '.icb'},
            {'mimetype': 'application/x-hrf', 'ext': '.hrf'},
            {'mimetype': 'application/x-hpl', 'ext': '.hpl'},
            {'mimetype': 'application/x-hpgl', 'ext': '.hpg'},
            {'mimetype': 'application/x-hmr', 'ext': '.hmr'},
            {'mimetype': 'application/x-hgl', 'ext': '.hgl'},
            {'mimetype': 'application/x-gp4', 'ext': '.gp4'},
            {'mimetype': 'application/x-gl2', 'ext': '.gl2'},
            {'mimetype': 'application/x-gbr', 'ext': '.gbr'},
            {'mimetype': 'application/x-g4', 'ext': '.g4'},
            {'mimetype': 'application/x-frm', 'ext': '.frm'},
            {'mimetype': 'application/x-epi', 'ext': '.epi'},
            {'mimetype': 'application/x-emf', 'ext': '.emf'},
            {'mimetype': 'application/x-ebx', 'ext': '.etd'},
            {'mimetype': 'application/x-dxf', 'ext': '.dxf'},
            {'mimetype': 'application/x-dxb', 'ext': '.dxb'},
            {'mimetype': 'application/x-dwg', 'ext': '.dwg'},
            {'mimetype': 'application/x-dwf', 'ext': '.dwf'},
            {'mimetype': 'application/x-drw', 'ext': '.drw'},
            {'mimetype': 'application/x-dib', 'ext': '.dib'},
            {'mimetype': 'application/x-dgn', 'ext': '.dgn'},
            {'mimetype': 'application/x-dcx', 'ext': '.dcx'},
            {'mimetype': 'application/x-dbx', 'ext': '.dbx'},
            {'mimetype': 'application/x-dbm', 'ext': '.dbm'},
            {'mimetype': 'application/x-dbf', 'ext': '.dbf'},
            {'mimetype': 'application/x-cut', 'ext': '.cut'},
            {'mimetype': 'application/x-csi', 'ext': '.csi'},
            {'mimetype': 'application/x-cot', 'ext': '.cot'},
            {'mimetype': 'application/x-cmx', 'ext': '.cmx'},
            {'mimetype': 'application/x-cmp', 'ext': '.cmp'},
            {'mimetype': 'application/x-cit', 'ext': '.cit'},
            {'mimetype': 'application/x-cgm', 'ext': '.cgm'},
            {'mimetype': 'application/x-cel', 'ext': '.cel'},
            {'mimetype': 'application/x-cdr', 'ext': '.cdr'},
            {'mimetype': 'application/x-cals', 'ext': '.cal'},
            {'mimetype': 'application/x-c90', 'ext': '.c90'},
            {'mimetype': 'application/x-c4t', 'ext': '.c4t'},
            {'mimetype': 'application/x-bot', 'ext': '.bot'},
            {'mimetype': 'application/x-bmp', 'ext': '.bmp'},
            {'mimetype': 'application/x-bittorrent', 'ext': '.torrent'},
            {'mimetype': 'application/x-anv', 'ext': '.anv'},
            {'mimetype': 'application/x-a11', 'ext': '.a11'},
            {'mimetype': 'application/x-906', 'ext': '0.906'},
            {'mimetype': 'application/x-301', 'ext': '0.301'},
            {'mimetype': 'application/x-001', 'ext': '0.001'},
            {'mimetype': 'application/x-', 'ext': '.'},
            {'mimetype': 'application/vnd.visio', 'ext': '.vsx'},
            {'mimetype': 'application/vnd.symbian.install', 'ext': '.sis'},
            {'mimetype': 'application/vnd.rn-rsml', 'ext': '.rsml'},
            {'mimetype': 'application/vnd.rn-rn_music_package', 'ext': '.rmp'},
            {'mimetype': 'application/vnd.rn-recording', 'ext': '.rec'},
            {'mimetype': 'application/vnd.rn-realsystem-rmx', 'ext': '.rmx'},
            {'mimetype': 'application/vnd.rn-realsystem-rmj', 'ext': '.rmj'},
            {'mimetype': 'application/vnd.rn-realsystem-rjt', 'ext': '.rjt'},
            {'mimetype': 'application/vnd.rn-realsystem-rjs', 'ext': '.rjs'},
            {'mimetype': 'application/vnd.rn-realplayer', 'ext': '.rnx'},
            {'mimetype': 'application/vnd.rn-realmedia-vbr', 'ext': '.rmvb'},
            {'mimetype': 'application/vnd.rn-realmedia-secure', 'ext': '.rms'},
            {'mimetype': 'application/vnd.rn-realmedia', 'ext': '.rm'},
            {'mimetype': 'application/vnd.ms-wpl', 'ext': '.wpl'},
            {'mimetype': 'application/vnd.ms-project', 'ext': '.mpt'},
            {'mimetype': 'application/vnd.ms-powerpoint', 'ext': '.ppt'},
            {'mimetype': 'application/vnd.ms-pki.stl', 'ext': '.stl'},
            {'mimetype': 'application/vnd.ms-pki.seccat', 'ext': '.cat'},
            {'mimetype': 'application/vnd.ms-pki.pko', 'ext': '.pko'},
            {'mimetype': 'application/vnd.ms-pki.certstore', 'ext': '.sst'},
            {'mimetype': 'application/vnd.ms-excel', 'ext': '.xls'},
            {'mimetype': 'application/vnd.iphone', 'ext': '.ipa'},
            {'mimetype': 'application/vnd.fdf', 'ext': '.fdf'},
            {'mimetype': 'application/vnd.android.package-archive', 'ext': '.apk'},
            {'mimetype': 'application/vnd.adobe.xfdf', 'ext': '.xfdf'},
            {'mimetype': 'application/vnd.adobe.xfd', 'ext': '.xfd'},
            {'mimetype': 'application/vnd.adobe.xdp', 'ext': '.xdp'},
            {'mimetype': 'application/vnd.adobe.workflow', 'ext': '.awf'},
            {'mimetype': 'application/vnd.adobe.rmf', 'ext': '.rmf'},
            {'mimetype': 'application/vnd.adobe.pdx', 'ext': '.pdx'},
            {'mimetype': 'application/vnd.adobe.edn', 'ext': '.edn'},
            {'mimetype': 'application/streamingmedia', 'ext': '.ssm'},
            {'mimetype': 'application/smil', 'ext': '.smi'},
            {'mimetype': 'application/sdp', 'ext': '.sdp'},
            {'mimetype': 'application/rat-file', 'ext': '.rat'},
            {'mimetype': 'application/postscript', 'ext': '.ps'},
            {'mimetype': 'application/pkix-crl', 'ext': '.crl'},
            {'mimetype': 'application/pkcs7-signature', 'ext': '.p7s'},
            {'mimetype': 'application/pkcs7-mime', 'ext': '.p7c'},
            {'mimetype': 'application/pkcs10', 'ext': '.p10'},
            {'mimetype': 'application/pics-rules', 'ext': '.prf'},
            {'mimetype': 'application/pdf', 'ext': '.pdf'},
            {'mimetype': 'application/msword', 'ext': '.doc'},
            {'mimetype': 'application/msaccess', 'ext': '.mdb'},
            {'mimetype': 'application/mac-binhex40', 'ext': '.hqx'},
            {'mimetype': 'application/hta', 'ext': '.hta'},
            {'mimetype': 'application/futuresplash', 'ext': '.spl'},
            {'mimetype': 'application/fractals', 'ext': '.fif'},
            {'mimetype': 'video/x-flv', 'ext': '.flv'},     #Flash
            {'mimetype': 'video/mp4', 'ext': '.mp4'},       #MPEG-4
            {'mimetype': 'video/MP2T', 'ext': '.ts'},        #iPhone Segment
            {'mimetype': 'video/3gpp', 'ext': '.3gp'},
            {'mimetype': 'video/x-ms-wmv', 'ext': '.wmv'},
            {'mimetype': 'video/x-msvideo', 'ext': '.avi'},
            {'mimetype': 'video/quicktime', 'ext': '.mov'},
            {'mimetype': 'application/x-mpegURL', 'ext': '.m3u8'}
        ]
        us_mime = get_config('mimetype')
        if us_mime:
            self.__mime_types = self.__mime_types + us_mime

    def get_content_type_ext(self, conttype):
        for mime in self.__mime_types:
            if conttype and conttype == mime['mimetype']:
                return mime['ext']

    @staticmethod
    def get_content_type(headers):
        if 'Content-Type' in headers and headers['Content-Type']:
            conttype = headers['Content-Type']
            if conttype.find(';') > 0:
                return conttype.split(';')[0]
            return conttype


if __name__ == '__main__':
    pass
