/*
 * Decompiled with CFR 0.152.
 */
package solver;

import constraints.global.Extremum;
import dashboard.Control;
import interfaces.Observers;
import java.util.Random;
import java.util.function.Supplier;
import optimization.ObjectiveVariable;
import org.xcsp.common.Types;
import sets.SetDense;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public class Restarter
implements Observers.ObserverRuns {
    public Solver solver;
    private Control.SettingRestarts setting;
    protected Control.SettingGeneral settingsGeneral;
    public final Supplier<Long> measureSupplier;
    public int numRun = -1;
    public long baseCutoff;
    public long currCutoff;
    public int nRestartsSinceLastReset;
    public boolean forceRootPropagation;
    private long cnt;

    public static Restarter buildFor(Solver solver) {
        boolean lns = solver.head.control.lns.enabled;
        if (lns) {
            return new RestarterLNS(solver);
        }
        return new Restarter(solver);
    }

    private long lubyCutoffFor(long i) {
        int k = (int)Math.floor(Math.log(i) / Math.log(2.0)) + 1;
        long pow = (long)Math.pow(2.0, k - 1);
        return i == pow * 2L - 1L ? pow : this.lubyCutoffFor(i - pow + 1L);
    }

    @Override
    public void beforeRun() {
        ++this.numRun;
        if ((this.solver.restarter.numRun - this.solver.solRecorder.lastSolutionRun) % this.setting.nRestartsResetPeriod == 0) {
            this.nRestartsSinceLastReset = 0;
            this.baseCutoff *= (long)this.setting.nRestartsResetCoefficient;
            System.out.println("    ...resetting restart cutoff to " + this.baseCutoff);
        }
        if (this.forceRootPropagation || this.settingsGeneral.framework == Types.TypeFramework.COP && this.numRun - 1 == this.solver.solRecorder.lastSolutionRun || this.solver.head.control.propagation.strongOnlyAtPreprocessing && this.numRun > 0 && this.numRun % 60 == 0) {
            if (!this.solver.propagation.runInitially()) {
                this.solver.stopping = Enums.EStopping.FULL_EXPLORATION;
            }
            this.forceRootPropagation = false;
            this.nRestartsSinceLastReset = 0;
        }
        if (this.currCutoff != Long.MAX_VALUE) {
            long offset = this.setting.luby ? this.lubyCutoffFor(this.nRestartsSinceLastReset + 1) * 150L : (long)((double)this.baseCutoff * Math.pow(this.setting.factor, this.nRestartsSinceLastReset));
            this.currCutoff = this.measureSupplier.get() + offset;
        }
        ++this.nRestartsSinceLastReset;
    }

    @Override
    public void afterRun() {
        if (this.settingsGeneral.framework == Types.TypeFramework.COP) {
            this.solver.problem.optimizer.afterRun();
        }
    }

    public void reset() {
        this.numRun = -1;
        this.currCutoff = this.baseCutoff = this.setting.cutoff;
        this.nRestartsSinceLastReset = 0;
    }

    private Supplier<Long> measureSupplier() {
        Solver sb = this.solver != null ? this.solver : null;
        switch (this.setting.measure) {
            case FAILED: {
                return () -> sb.stats.nFailedAssignments;
            }
            case WRONG: {
                return () -> sb.stats.nWrongDecisions;
            }
            case BACKTRACK: {
                return () -> sb.stats.nBacktracks;
            }
            case SOLUTION: {
                return () -> this.solver.solRecorder.found;
            }
        }
        throw new AssertionError();
    }

    public Restarter(Solver solver) {
        this.solver = solver;
        this.setting = solver.head.control.restarts;
        this.settingsGeneral = solver.head.control.general;
        this.measureSupplier = this.measureSupplier();
        if (this.settingsGeneral.framework == Types.TypeFramework.COP && this.setting.cutoff < Integer.MAX_VALUE) {
            this.setting.cutoff *= 10L;
        }
        this.reset();
    }

    public boolean currRunFinished() {
        if (this.solver.problem.optimizer != null && this.cnt++ % 5L == 0L) {
            this.solver.problem.optimizer.possiblyUpdateLocalBounds();
        }
        if (this.measureSupplier.get() >= this.currCutoff) {
            return true;
        }
        if (this.settingsGeneral.framework != Types.TypeFramework.COP || this.numRun != this.solver.solRecorder.lastSolutionRun) {
            return false;
        }
        if (this.setting.restartAfterSolution) {
            return true;
        }
        return this.solver.problem.optimizer.ctr instanceof Extremum.ExtremumCst.MaximumCst.MaximumCstLE || this.solver.problem.optimizer.ctr instanceof ObjectiveVariable;
    }

    public boolean allRunsFinished() {
        return this.numRun + 1 >= this.setting.nRunsLimit;
    }

    public boolean runMultipleOf(int v) {
        return this.numRun > 0 && this.numRun % v == 0;
    }

    public static final class RestarterLNS
    extends Restarter {
        private final HeuristicFreezing heuristic = HeuristicFreezing.buildFor(this);

        @Override
        public void beforeRun() {
            super.beforeRun();
            int[] solution = this.solver.solRecorder.lastSolution;
            if (solution != null) {
                this.heuristic.freezeVariables(solution);
                for (int i = this.heuristic.fragment.limit; i >= 0; --i) {
                    Variable x = this.solver.problem.variables[i];
                    int a = solution[x.num];
                    if (!x.dom.present(a)) continue;
                    this.solver.assign(x, solution[x.num]);
                    boolean consistent = this.solver.propagation.runAfterAssignment(x);
                    if (consistent) continue;
                    this.solver.backtrack(x);
                    break;
                }
            }
        }

        @Override
        public void afterRun() {
            if (this.settingsGeneral.framework == Types.TypeFramework.COP) {
                this.solver.problem.optimizer.afterRun();
            }
            this.solver.backtrackToTheRoot();
        }

        public RestarterLNS(Solver solver) {
            super(solver);
        }

        public static abstract class HeuristicFreezing {
            protected final RestarterLNS restarter;
            public final SetDense fragment;

            public static HeuristicFreezing buildFor(RestarterLNS restarter) {
                if (restarter.solver.head.control.lns.heuristic.equals("Impact")) {
                    return new Impact(restarter);
                }
                return new Rand(restarter);
            }

            public HeuristicFreezing(RestarterLNS restarter) {
                this.restarter = restarter;
                int n = restarter.solver.problem.variables.length;
                int nf = restarter.solver.head.control.lns.nFreeze;
                int pf = restarter.solver.head.control.lns.pFreeze;
                this.fragment = new SetDense(n);
                int fragmentSize = 0 < nf && nf < n ? nf : (0 < pf && pf < 100 ? 1 + pf * n / 100 : -1);
                Kit.control(0 < fragmentSize && fragmentSize < n, () -> "You must specify the number or percentage of variables to freeze for LNS");
                this.fragment.limit = fragmentSize - 1;
            }

            protected void shuffle() {
                Random random = this.restarter.solver.head.random;
                int[] dense = this.fragment.dense;
                for (int i = dense.length - 1; i > 0; --i) {
                    int j = random.nextInt(i + 1);
                    int tmp = dense[i];
                    dense[i] = dense[j];
                    dense[j] = tmp;
                }
            }

            public abstract void freezeVariables(int[] var1);

            public static class Rand
            extends HeuristicFreezing {
                public Rand(RestarterLNS restarter) {
                    super(restarter);
                }

                @Override
                public void freezeVariables(int[] solution) {
                    this.shuffle();
                }
            }

            public static class Impact
            extends HeuristicFreezing {
                private final Variable[] variables;
                private int[] before;
                private int[] after;

                public Impact(RestarterLNS restarter) {
                    super(restarter);
                    this.variables = restarter.solver.problem.variables;
                    this.before = new int[this.variables.length];
                    this.after = new int[this.variables.length];
                }

                private void storeDomainSizes(int[] t) {
                    for (int i = 0; i < this.variables.length; ++i) {
                        t[i] = this.variables[i].dom.size();
                    }
                }

                @Override
                public void freezeVariables(int[] solution) {
                    this.shuffle();
                    int[] dense = this.fragment.dense;
                    Integer bestImpacted = null;
                    for (int i = 0; i < this.fragment.size(); ++i) {
                        int x;
                        if (bestImpacted != null) {
                            int tmp = dense[bestImpacted];
                            dense[bestImpacted.intValue()] = dense[i];
                            dense[i] = tmp;
                        }
                        this.restarter.solver.assign(this.variables[dense[i]], solution[dense[i]]);
                        this.storeDomainSizes(this.before);
                        for (x = 0; x < this.variables.length; ++x) {
                            this.before[x] = this.variables[x].dom.size();
                        }
                        this.restarter.solver.propagation.runInitially();
                        for (x = 0; x < this.variables.length; ++x) {
                            this.after[x] = this.variables[x].dom.size();
                        }
                        bestImpacted = null;
                        int bestImpact = 0;
                        for (int j = i + 1; j < dense.length; ++j) {
                            int impact = this.before[dense[j]] - this.after[dense[j]];
                            if (impact <= bestImpact) continue;
                            bestImpacted = j;
                            bestImpact = impact;
                        }
                    }
                    this.restarter.solver.backtrackToTheRoot();
                }
            }
        }
    }
}

