/*
 * Decompiled with CFR 0.152.
 */
package solver;

import interfaces.Observers;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import solver.Solver;
import utility.Kit;
import variables.Variable;

public final class LastConflict
implements Observers.ObserverRuns {
    private Solver solver;
    private int k;
    private Variable[] vars;
    private int nVars;
    private Variable lastAssigned;
    private Variable candidate;
    private Statistics statistics;

    @Override
    public void beforeRun() {
        this.nVars = 0;
        this.candidate = null;
    }

    @Override
    public void afterRun() {
        if (this.k > 0) {
            this.statistics.display();
        }
    }

    public LastConflict(Solver solver, int k) {
        this.solver = solver;
        this.k = k;
        this.vars = new Variable[k];
        this.statistics = new Statistics(k);
    }

    public Variable lastConflictPriorityVar() {
        if (this.k == 0) {
            return null;
        }
        if (this.nVars == 0) {
            if (this.lastAssigned == null || this.lastAssigned.assigned()) {
                return null;
            }
            this.statistics.startLevel = this.solver.depth() + 1;
            this.vars[this.nVars++] = this.lastAssigned;
            return this.lastAssigned;
        }
        for (int i = 0; i < this.nVars; ++i) {
            if (this.vars[i].assigned()) continue;
            return this.vars[i];
        }
        if (this.nVars == this.k || this.candidate == null || this.candidate.assigned()) {
            this.statistics.update(this.nVars);
            this.nVars = 0;
            this.candidate = null;
            return null;
        }
        this.vars[this.nVars++] = this.candidate;
        this.candidate = null;
        return this.vars[this.nVars - 1];
    }

    public final void onAssignment(Variable x) {
        if (this.k > 0 && this.nVars == 0) {
            this.lastAssigned = x;
        }
    }

    public void onRefutation(Variable x, int a) {
        if (this.k == 0) {
            return;
        }
        if (this.nVars == 0) {
            if (x != this.lastAssigned) {
                this.candidate = x;
            }
        } else if (this.nVars < this.k) {
            for (int i = 0; i < this.nVars; ++i) {
                if (this.vars[i] != x) continue;
                return;
            }
            this.candidate = x;
        }
    }

    private class Statistics {
        private int startLevel;
        private int[] cnts;
        private int[] jmps;

        private Statistics(int k) {
            this.cnts = new int[k + 1];
            this.jmps = new int[k + 1];
        }

        private void update(int offset) {
            int n = LastConflict.this.nVars;
            this.cnts[n] = this.cnts[n] + 1;
            int n2 = LastConflict.this.nVars;
            this.jmps[n2] = this.jmps[n2] + (this.startLevel - LastConflict.this.solver.depth() + offset);
        }

        public void display() {
            if (LastConflict.this.nVars > 0) {
                this.update(0);
            }
            String s = IntStream.range(1, this.cnts.length).mapToObj(i -> i + ":(#=" + this.cnts[i] + (this.cnts[i] == 0 ? "" : ",avg=" + Kit.decimalFormat.format((double)this.jmps[i] / (double)this.cnts[i]))).collect(Collectors.joining(")  "));
            Kit.log.info("last-conflicts  " + s + ")\n");
        }
    }
}

