/*
 * Decompiled with CFR 0.152.
 */
package sets;

import java.util.Arrays;
import java.util.stream.IntStream;
import sets.SetDenseReversible;
import utility.Kit;

public class SetSparseReversible
extends SetDenseReversible {
    public int[] sparse;

    public SetSparseReversible(int capacity, boolean initiallyFull, int nLevels) {
        super(capacity, initiallyFull, nLevels);
        this.sparse = IntStream.range(0, capacity).toArray();
        Kit.control(Arrays.equals(this.dense, this.sparse));
    }

    public SetSparseReversible(int capacity, int nLevels) {
        this(capacity, true, nLevels);
    }

    @Override
    public boolean isPresent(int a) {
        return this.sparse[a] <= this.limit;
    }

    @Override
    public boolean add(int a) {
        assert (!this.isPresent(a)) : this.sparse[a] + " " + this.limit;
        int i = this.sparse[a];
        ++this.limit;
        if (i > this.limit) {
            int b;
            this.dense[i] = b = this.dense[this.limit];
            this.dense[this.limit] = a;
            this.sparse[b] = i;
            this.sparse[a] = this.limit;
        }
        return true;
    }

    public void add(int a, int level) {
        assert (!this.isPresent(a)) : this.sparse[a] + " " + this.limit;
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
        }
        int i = this.sparse[a];
        ++this.limit;
        if (i > this.limit) {
            int b;
            this.dense[i] = b = this.dense[this.limit];
            this.dense[this.limit] = a;
            this.sparse[b] = i;
            this.sparse[a] = this.limit;
        }
    }

    public void remove(int a) {
        assert (this.isPresent(a)) : this.sparse[a] + " " + this.limit;
        int i = this.sparse[a];
        if (i != this.limit) {
            int b;
            this.dense[i] = b = this.dense[this.limit];
            this.dense[this.limit] = a;
            this.sparse[b] = i;
            this.sparse[a] = this.limit;
        }
        --this.limit;
    }

    public void removeIfPresent(int a) {
        if (this.sparse[a] <= this.limit) {
            this.remove(a);
        }
    }

    public void remove(int a, int level) {
        int i;
        assert (this.isPresent(a)) : this.sparse[a] + " " + this.limit;
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
        }
        if ((i = this.sparse[a]) != this.limit) {
            int b;
            this.dense[i] = b = this.dense[this.limit];
            this.dense[this.limit] = a;
            this.sparse[b] = i;
            this.sparse[a] = this.limit;
        }
        --this.limit;
    }

    public void reduceTo(int a, int level) {
        int i;
        assert (this.isPresent(a)) : this.sparse[a] + " " + this.limit;
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
        }
        if ((i = this.sparse[a]) != 0) {
            int b;
            this.dense[i] = b = this.dense[0];
            this.dense[0] = a;
            this.sparse[b] = i;
            this.sparse[a] = 0;
        }
        this.limit = 0;
    }

    @Override
    public void removeAtPosition(int i, int level) {
        assert (0 <= i && i <= this.limit);
        if (this.limits[level] == -2) {
            this.limits[level] = this.limit;
        }
        if (i != this.limit) {
            int b;
            int a = this.dense[i];
            this.dense[i] = b = this.dense[this.limit];
            this.dense[this.limit] = a;
            this.sparse[b] = i;
            this.sparse[a] = this.limit;
        }
        --this.limit;
    }

    @Override
    public void swapAtPositions(int i, int j) {
        int b;
        int a = this.dense[i];
        this.dense[i] = b = this.dense[j];
        this.dense[j] = a;
        this.sparse[b] = i;
        this.sparse[a] = j;
    }
}

