/*
 * Decompiled with CFR 0.152.
 */
package sets;

import java.util.function.Consumer;

public interface LinkedSet {
    public void finalizeConstruction(int var1);

    public int initSize();

    public int size();

    default public int nRemoved() {
        return this.initSize() - this.size();
    }

    public boolean present(int var1);

    public int first();

    public int next(int var1);

    public int last();

    public int prev(int var1);

    public int lastRemoved();

    public int prevRemoved(int var1);

    public int lastRemovedLevel();

    public int removedLevelOf(int var1);

    public void remove(int var1, int var2);

    public int reduceTo(int var1, int var2);

    public void restoreBefore(int var1);

    public void setMark();

    public void setMark(int var1);

    public void restoreAtMark();

    public void restoreAtMark(int var1);

    public int getMark();

    default public void execute(Consumer<Integer> consumer, boolean reverse) {
        if (reverse) {
            int a = this.last();
            while (a != -1) {
                consumer.accept(a);
                a = this.prev(a);
            }
        } else {
            int a = this.first();
            while (a != -1) {
                consumer.accept(a);
                a = this.next(a);
            }
        }
    }

    default public void execute(Consumer<Integer> consumer) {
        this.execute(consumer, false);
    }

    public long[] binary();

    public boolean controlStructures();

    default public String stringOfStructures() {
        StringBuilder sb = new StringBuilder().append("Size=" + this.size() + " nRems=" + this.nRemoved() + "\nForward :");
        this.execute(a -> sb.append(' ').append(a));
        sb.append("\nBackward :");
        this.execute(a -> sb.append(' ').append(a), true);
        sb.append("\nDeleted :");
        int a2 = this.lastRemoved();
        while (a2 != -1) {
            sb.append(' ').append(a2);
            a2 = this.prevRemoved(a2);
        }
        return sb.toString();
    }
}

