/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import constraints.Constraint;
import constraints.extension.structures.Bits;
import interfaces.FilteringSpecific;
import java.util.stream.Stream;
import propagation.Reviser;
import utility.Kit;
import variables.Variable;

public abstract class Supporter {
    protected Constraint c;
    protected boolean multidirectionality;
    protected int[] buffer;

    public static Supporter buildFor(Constraint c) {
        if (!(!c.problem.head.control.propagation.residues || c.scp.length <= 1 || c instanceof FilteringSpecific || c.problem.head.control.propagation.reviser.equals(Reviser.Reviser3.class.getSimpleName()) && c.extStructure() instanceof Bits)) {
            return c.scp.length == 2 ? new SupporterHardBary(c) : new SupporterHardNary(c);
        }
        return null;
    }

    public Supporter(Constraint c) {
        this.c = c;
        this.multidirectionality = c.problem.head.control.propagation.multidirectionality;
        this.buffer = c.tupleManager.localTuple;
    }

    public static final class SupporterHardNary
    extends SupporterHard {
        private final int[][][] residues;

        @Override
        public void reset() {
            Stream.of(this.residues).forEach(m -> Kit.fill(m, -1));
        }

        public SupporterHardNary(Constraint c) {
            super(c);
            Kit.control(c.scp.length > 2);
            this.residues = (int[][][])Stream.of(c.scp).map(x -> Kit.repeat(-1, x.dom.initSize(), c.scp.length)).toArray(x$0 -> new int[x$0][][]);
        }

        @Override
        public boolean findArcSupportFor(int x, int a) {
            int[] residue = this.residues[x][a];
            int q = x == 0 ? 1 : 0;
            if (residue[q] != -1 && this.c.isValid(residue)) {
                return true;
            }
            if (this.c.seekFirstSupportWith(x, a, this.buffer)) {
                if (this.multidirectionality) {
                    for (int i = 0; i < this.residues.length; ++i) {
                        Kit.copy(this.buffer, this.residues[i][this.buffer[i]]);
                    }
                } else {
                    Kit.copy(this.buffer, this.residues[x][a]);
                }
                return true;
            }
            return false;
        }
    }

    public static final class SupporterHardBary
    extends SupporterHard {
        public final int[][] residues;

        @Override
        public void reset() {
            Kit.fill(this.residues, -1);
        }

        public SupporterHardBary(Constraint c) {
            super(c);
            Kit.control(c.scp.length == 2);
            this.residues = Variable.litterals(c.scp).intArray(-1);
        }

        @Override
        public boolean findArcSupportFor(int x, int a) {
            int q = x == 0 ? 1 : 0;
            int b = this.residues[x][a];
            if (b != -1 && this.c.doms[q].present(b)) {
                return true;
            }
            if (this.c.seekFirstSupportWith(x, a, this.buffer)) {
                this.residues[x][a] = b = this.buffer[q];
                if (this.multidirectionality) {
                    this.residues[q][b] = a;
                }
                return true;
            }
            return false;
        }
    }

    public static abstract class SupporterHard
    extends Supporter {
        public abstract void reset();

        public SupporterHard(Constraint c) {
            super(c);
        }

        public abstract boolean findArcSupportFor(int var1, int var2);

        public boolean findArcSupportFor(Variable x, int a) {
            return this.findArcSupportFor(this.c.positionOf(x), a);
        }
    }
}

