/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import heuristics.HeuristicRevisions;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import learning.IpsRecorderForDominance;
import learning.NogoodRecorder;
import main.Head;
import propagation.Forward;
import sets.SetSparse;
import utility.Reflector;
import variables.Domain;
import variables.Variable;

public final class Queue
extends SetSparse {
    public final Forward propagation;
    private final HeuristicRevisions heuristic;
    private final Variable[] variables;
    public int nPicks;
    public NogoodRecorder nogoodRecorder;
    private IpsRecorderForDominance ipsRecorder;
    private int[] absentValuesSentinel;
    private long[] sentinelLevel;

    public Queue(Forward propagation) {
        super(propagation.solver.head.problem.variables.length);
        this.propagation = propagation;
        Head head = propagation.solver.head;
        String className = head.problem.features.maxDomSize() <= 4 ? HeuristicRevisions.HeuristicRevisionsDirect.First.class.getSimpleName() : head.control.revh.clazz;
        Set<Class<?>> classes = head.handlerClasses.map.get(HeuristicRevisions.class);
        this.heuristic = (HeuristicRevisions)Reflector.buildObject(className, classes, this, head.control.revh.anti);
        this.variables = head.problem.variables;
    }

    public Variable var(int i) {
        assert (0 <= i && i <= this.limit);
        return this.variables[this.dense[i]];
    }

    public void add(Variable x) {
        x.time = this.propagation.incrementTime();
        this.add(x.num);
        assert (!x.assigned() || x == this.propagation.solver.futVars.lastPast()) : "variable " + x;
    }

    @Override
    public Queue fill() {
        for (Variable x : this.variables) {
            if (x.assigned() && x != this.propagation.solver.futVars.lastPast()) continue;
            this.add(x);
        }
        return this;
    }

    public Variable pickAndDelete(int i) {
        ++this.nPicks;
        int num = this.dense[i];
        this.remove(num);
        return this.variables[num];
    }

    public Variable pickAndDelete() {
        return this.pickAndDelete(this.heuristic.bestPosition());
    }

    public boolean isNogoodConsistent(Variable x) {
        if (this.nogoodRecorder != null && x.dom.size() == 1 && !this.nogoodRecorder.checkWatchesOf(x, x.dom.first(), false)) {
            return false;
        }
        if (this.ipsRecorder != null) {
            if (this.sentinelLevel[x.num] != this.propagation.solver.stats.numberSafe()) {
                this.absentValuesSentinel[x.num] = -1;
            }
            int depth = this.propagation.solver.depth();
            Domain dom = x.dom;
            int last = dom.lastRemoved();
            int a = dom.lastRemoved();
            while (a != this.absentValuesSentinel[x.num] && dom.removedLevelOf(a) == depth) {
                if (!this.ipsRecorder.checkWatchesOf(x.num, a)) {
                    return false;
                }
                a = dom.prevRemoved(a);
            }
            this.sentinelLevel[x.num] = this.propagation.solver.stats.numberSafe();
            this.absentValuesSentinel[x.num] = last;
        }
        return true;
    }

    public void incrementTimestampsOfEnqueuedVariables() {
        for (int i = this.limit; i >= 0; --i) {
            this.variables[this.dense[i]].time = this.propagation.incrementTime();
        }
    }

    @Override
    public String toString() {
        return "There are " + this.size() + " elements : " + IntStream.range(0, this.size()).mapToObj(i -> this.var(i) + " ").collect(Collectors.joining());
    }

    public void setStateDominanceManager(IpsRecorderForDominance recorder) {
        this.ipsRecorder = recorder;
        this.absentValuesSentinel = new int[this.propagation.solver.problem.variables.length];
        this.sentinelLevel = new long[this.absentValuesSentinel.length];
    }
}

