/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import constraints.Constraint;
import dashboard.Control;
import interfaces.Observers;
import java.util.Set;
import java.util.stream.IntStream;
import propagation.Forward;
import propagation.Queue;
import sets.SetSparse;
import solver.Solver;
import utility.Kit;
import utility.Reflector;
import variables.Variable;

public abstract class Propagation {
    public final Solver solver;
    public final Queue queue;
    public final SetSparseMap[] auxiliaryQueues;
    public long time;
    public Constraint currFilteringCtr;
    public Variable lastWipeoutVar;
    public long nSingletonTests;
    public long nEffectiveSingletonTests;
    public boolean performingProperSearch;
    public int nTuplesRemoved;
    protected final Control.SettingPropagation settings;

    public static Propagation buildFor(Solver solver) {
        if (solver.head.control.solving.enablePrepro || solver.head.control.solving.enableSearch) {
            Set<Class<?>> classes = solver.head.handlerClasses.map.get(Propagation.class);
            return (Propagation)Reflector.buildObject(solver.head.control.propagation.clazz, classes, solver);
        }
        return null;
    }

    public final void reset() {
        this.queue.clear();
        for (SetSparseMap auxiliaryQueue : this.auxiliaryQueues) {
            auxiliaryQueue.clear();
        }
        this.nTuplesRemoved = 0;
    }

    public final long incrementTime() {
        return ++this.time;
    }

    public Propagation(Solver solver) {
        this.solver = solver;
        this.settings = solver.head.control.propagation;
        this.queue = this instanceof Forward ? new Queue((Forward)this) : null;
        int nAuxQueues = this.settings.useAuxiliaryQueues ? 2 : 0;
        this.auxiliaryQueues = this instanceof Forward ? SetSparseMap.buildArray(nAuxQueues, solver.problem.constraints.length) : null;
    }

    protected final boolean pickAndFilter() {
        Variable x = this.queue.pickAndDelete();
        if (!this.queue.isNogoodConsistent(x)) {
            return false;
        }
        for (Constraint c : x.ctrs) {
            if (c.ignored || this.solver.isEntailed(c)) continue;
            if (c.filteringComplexity == 0) {
                this.currFilteringCtr = c;
                boolean consistent = c.filterFrom(x);
                this.currFilteringCtr = null;
                if (consistent) continue;
                return false;
            }
            if (c.time > x.time) continue;
            this.auxiliaryQueues[c.filteringComplexity - 1].add(c.num, x.num);
        }
        return true;
    }

    public boolean propagate() {
        while (true) {
            if (this.queue.size() != 0) {
                if (this.pickAndFilter()) continue;
                return false;
            }
            for (SetSparseMap auxiliaryQueue : this.auxiliaryQueues) {
                while (!auxiliaryQueue.isEmpty()) {
                    int cnum = auxiliaryQueue.shift();
                    int xnum = auxiliaryQueue.values[cnum];
                    Constraint c = this.solver.problem.constraints[cnum];
                    Variable x = this.solver.problem.variables[xnum];
                    c.time = x.time;
                    if (c.ignored || this.solver.isEntailed(c)) continue;
                    this.currFilteringCtr = c;
                    boolean consistent = c.filterFrom(x);
                    this.currFilteringCtr = null;
                    if (consistent) continue;
                    return false;
                }
            }
            if (this.queue.size() == 0) break;
        }
        return true;
    }

    public boolean propagate(Constraint.CtrGlobal c) {
        if (c == null || c.ignored || this.solver.isEntailed(c)) {
            return true;
        }
        if (!c.runPropagator(null)) {
            return false;
        }
        return this.propagate();
    }

    public abstract boolean runInitially();

    public abstract boolean runAfterAssignment(Variable var1);

    public abstract boolean runAfterRefutation(Variable var1);

    public final boolean handleReduction(Variable x, int newDomSize) {
        if (newDomSize == 0) {
            this.lastWipeoutVar = x;
            for (Observers.ObserverConflicts obs : this.solver.observersConflicts) {
                obs.whenWipeout(this.currFilteringCtr, x);
            }
            return false;
        }
        this.queue.add(x);
        return true;
    }

    public final boolean handleReduction(Variable x) {
        return this.handleReduction(x, x.dom.size());
    }

    public final boolean handleReductionSafely(Variable x) {
        assert (x.dom.size() > 0);
        this.queue.add(x);
        return true;
    }

    public static class SetSparseMap
    extends SetSparse {
        public final int[] values;

        public static SetSparseMap[] buildArray(int length, int capacity) {
            return (SetSparseMap[])IntStream.range(0, length).mapToObj(i -> new SetSparseMap(capacity)).toArray(SetSparseMap[]::new);
        }

        public SetSparseMap(int capacity, boolean initiallyFull) {
            super(capacity, initiallyFull);
            this.values = Kit.range(capacity);
        }

        public SetSparseMap(int capacity) {
            this(capacity, false);
        }

        public int valueForPosition(int i) {
            return this.values[this.dense[i]];
        }

        @Override
        public final boolean add(int e) {
            throw new RuntimeException("Must not be called without a second argument");
        }

        public boolean add(int e, int value) {
            boolean b = super.add(e);
            this.values[e] = value;
            return b;
        }
    }
}

