/*
 * Decompiled with CFR 0.152.
 */
package propagation;

import constraints.Constraint;
import constraints.extension.STR1;
import constraints.extension.STR3;
import heuristics.HeuristicVariables;
import heuristics.HeuristicVariablesDynamic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import propagation.StrongConsistency;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import variables.Domain;
import variables.Variable;

public class GIC
extends StrongConsistency {
    protected HeuristicVariables heuristic;
    public int[] nInverseTests;
    public int nITests;
    private long baseNbSolutionsLimit;

    public GIC(Solver solver) {
        super(solver);
        this.heuristic = new HeuristicVariablesDynamic.WdegOnDom(solver, false);
        this.nInverseTests = new int[solver.problem.variables.length + 1];
        this.baseNbSolutionsLimit = solver.solRecorder.limit;
        Kit.control(solver.head.control.restarts.cutoff == Long.MAX_VALUE, () -> "With GIC, there is currently no possibility of restarts.");
        Kit.control(!Stream.of(solver.problem.constraints).anyMatch(c -> c.getClass().isAssignableFrom(STR3.class)), () -> "GIC currently not compatible with STR3");
    }

    protected void handleNewSolution(Variable x, int a) {
    }

    protected boolean isInverse(Variable x, int a) {
        int n = this.solver.depth();
        this.nInverseTests[n] = this.nInverseTests[n] + 1;
        ++this.nITests;
        this.solver.resetNoSolutions();
        this.solver.assign(x, a);
        HeuristicVariables h = this.solver.heuristic;
        this.solver.heuristic = this.heuristic;
        this.solver.solRecorder.limit = 1L;
        boolean inverse = this.enforceArcConsistencyAfterAssignment(x) && this.solver.doRun().stopping == Enums.EStopping.REACHED_GOAL;
        this.solver.solRecorder.limit = this.baseNbSolutionsLimit;
        this.solver.heuristic = h;
        if (inverse) {
            this.handleNewSolution(x, a);
        } else {
            Kit.log.info(x + "=" + a + " is not inverse");
        }
        this.solver.backtrack(x);
        return inverse;
    }

    protected void updateSTRStructures() {
        for (Constraint c : this.solver.problem.constraints) {
            if (!(c instanceof STR1)) continue;
            int bef = this.solver.problem.nValuesRemoved;
            ((STR1)c).runPropagator(null);
            Kit.control(this.solver.problem.nValuesRemoved == bef);
        }
    }

    protected final void after(long nSolutionsBefore, int nValuesRemoved) {
        if (this.verbose >= 1) {
            Kit.log.info("nbGICInconsistentValues=" + nValuesRemoved + " at depth=" + this.solver.depth() + " for " + this.nInverseTests[this.solver.depth()] + " tests");
        }
        this.solver.resetNoSolutions();
        this.solver.solRecorder.found = nSolutionsBefore;
        this.updateSTRStructures();
        this.performingProperSearch = false;
    }

    @Override
    public boolean enforceStrongConsistency() {
        this.performingProperSearch = true;
        long nSolutionsBefore = this.solver.solRecorder.found;
        int nValuesRemoved = 0;
        Variable x = this.solver.futVars.first();
        while (x != null) {
            Domain dom = x.dom;
            int a = dom.first();
            while (a != -1) {
                if (!this.isInverse(x, a)) {
                    x.dom.removeElementary(a);
                    ++nValuesRemoved;
                }
                a = dom.next(a);
            }
            Kit.control(dom.size() != 0, () -> "Not possible to reach inconsistency with GIC (or your instance is unsat)");
            x = this.solver.futVars.next(x);
        }
        this.after(nSolutionsBefore, nValuesRemoved);
        return true;
    }

    public static class GIC4
    extends GICAdvanced {
        protected int[][] solutions;
        private int solutionsLimit;
        protected boolean[][] gic;
        private int sValSize;
        private int[] sVal;
        private int[] lastSizes;
        private int nTurns;
        private int origin;
        private int target;
        public int nVals;
        public int nUnks;
        public int nUnksAfterAC;
        public int nTests;
        public long wck;
        public long nItestsRestor;
        private Variable[] decisionVars;
        private int[] decisonsIdxs;
        private Interval[][] allIntervals;
        private List<Interval> unknown;
        private List<Interval> inTransfer;
        private List<Interval>[] known;
        private int algo;

        public GIC4(Solver solver) {
            super(solver);
            Variable[] variables = solver.problem.variables;
            this.solutions = new int[Variable.nInitValuesFor(variables)][];
            this.solutionsLimit = -1;
            this.gic = Variable.litterals(variables).booleanArray();
            this.sVal = new int[variables.length];
            this.lastSizes = Kit.repeat(-2, variables.length);
            this.algo = solver.head.control.experimental.testI3;
        }

        private void handleSolution(int[] solution) {
            for (int j = this.sSupSize - 1; j >= 0; --j) {
                int num = this.sSups[j];
                int a = solution[num];
                if (this.gic[num][a]) continue;
                int n = num;
                this.cnts[n] = this.cnts[n] - 1;
                if (this.cnts[n] == 0) {
                    this.sSups[j] = this.sSups[--this.sSupSize];
                }
                this.gic[num][a] = true;
            }
        }

        @Override
        protected void handleNewSolution(Variable x, int a) {
            ++this.solutionsLimit;
            if (this.solutions[this.solutionsLimit] == null) {
                this.solutions[this.solutionsLimit] = new int[this.solver.problem.variables.length];
            }
            int[] solution = this.solver.solRecorder.lastSolution;
            Kit.copy(solution, this.solutions[this.solutionsLimit]);
            this.handleSolution(solution);
        }

        @Override
        protected void intializationAdvanced() {
            this.sSupSize = 0;
            this.sValSize = 0;
            if (this.solver.futVars.lastPast() != null) {
                this.sVal[this.sValSize++] = this.solver.futVars.lastPast().num;
            }
            for (Variable x : this.solver.futVars) {
                int domSize;
                int num = x.num;
                this.cnts[num] = domSize = x.dom.size();
                if (this.lastSizes[num] != domSize) {
                    this.sVal[this.sValSize++] = num;
                }
                this.sSups[this.sSupSize++] = num;
                Arrays.fill(this.gic[num], false);
            }
            Variable[] variables = this.solver.problem.variables;
            for (int i = this.solutionsLimit; i >= 0; --i) {
                int[] solution = this.solutions[i];
                boolean valid = true;
                for (int j = this.sValSize - 1; j >= 0; --j) {
                    int num = this.sVal[j];
                    if (variables[num].dom.present(solution[num])) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    this.handleSolution(solution);
                    continue;
                }
                Kit.swap(this.solutions, i, this.solutionsLimit--);
            }
        }

        @Override
        protected boolean isInverseAdvanced(Variable x, int a) {
            return this.gic[x.num][a] || this.isInverse(x, a);
        }

        @Override
        public boolean enforceStrongConsistency() {
            boolean consistent = super.enforceStrongConsistency();
            this.restoreAfterDeletingOneDecision();
            this.solver.futVars.execute(x -> {
                this.lastSizes[x.num] = x.dom.size();
            });
            return consistent;
        }

        @Override
        public boolean runAfterAssignment(Variable x) {
            return !this.performingProperSearch && x.dom.lastRemovedLevel() != this.solver.depth() && this.solver.depth() != this.solver.head.control.experimental.testI1 ? true : super.runAfterAssignment(x);
        }

        private void buildIntervalsFor(Variable x, boolean direct) {
            int depth = this.solver.depth();
            boolean firstDecision = depth - 1 == this.target;
            Interval[] intervals = this.allIntervals[x.num];
            Domain dom = x.dom;
            int a = dom.lastRemoved();
            while (a != -1 && dom.removedLevelOf(a) == depth) {
                intervals[a] = firstDecision ? new Interval(x, a, depth, this.origin) : new Interval(x, a, depth - 1, direct ? depth - 1 : this.origin);
                a = dom.prevRemoved(a);
            }
        }

        private void updateMaxFor(Variable x) {
            int depth = this.solver.depth();
            Interval[] intervals = this.allIntervals[x.num];
            Domain dom = x.dom;
            int a = dom.lastRemoved();
            while (a != -1 && dom.removedLevelOf(a) == depth) {
                intervals[a].decreaseMax(depth);
                a = dom.prevRemoved(a);
            }
        }

        private int finalizeIntervals() {
            int nbTests = 0;
            int nbUselessTests = 0;
            while (this.unknown.size() > 0) {
                assert (this.inTransfer.size() == 0);
                if (this.algo == 3) {
                    Collections.sort(this.unknown);
                    int depthBefore = this.solver.depth();
                    for (Interval interval : this.unknown) {
                        if (this.inTransfer.contains(interval)) continue;
                        Kit.control(interval.minDepth <= interval.maxDepth, () -> "" + interval);
                        Variable x = interval.var;
                        int a = interval.idx;
                        int nbDecisionsTaken = this.solver.depth() - depthBefore;
                        int nbDecisions = interval.maxDepth - 1 - depthBefore;
                        assert (nbDecisions > 0);
                        for (int i = nbDecisionsTaken; i < nbDecisions; ++i) {
                            this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                            this.enforceArcConsistencyAfterAssignment(this.decisionVars[i]);
                        }
                        boolean inverse = this.isInverse(x, a);
                        ++nbTests;
                        if (!inverse) {
                            ++nbUselessTests;
                        }
                        if (inverse) {
                            int[] solution = this.solutions[this.solutionsLimit];
                            this.solver.futVars.execute(y -> {
                                if (this.allIntervals[y.num][solution[y.num]] != null) {
                                    this.allIntervals[y.num][solution[y.num]].increaseMin(interval.maxDepth);
                                }
                            });
                            --this.solutionsLimit;
                            continue;
                        }
                        interval.decreaseMax(interval.maxDepth - 1);
                    }
                    int nbDecisions = this.solver.depth() - depthBefore;
                    for (int i = 0; i < nbDecisions; ++i) {
                        this.solver.backtrack();
                    }
                    Kit.control(this.solver.depth() == this.target);
                } else {
                    for (Interval interval : this.unknown) {
                        boolean inverse;
                        int i;
                        int nbDecisions;
                        if (this.inTransfer.contains(interval)) continue;
                        Kit.control(interval.minDepth <= interval.maxDepth, () -> "" + interval);
                        Variable x = interval.var;
                        int a = interval.idx;
                        assert (this.solver.depth() == this.target);
                        if (this.algo == 1) {
                            nbDecisions = interval.maxDepth - 1 - this.solver.depth();
                            assert (nbDecisions > 0);
                            for (i = 0; i < nbDecisions; ++i) {
                                this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                                this.enforceArcConsistencyAfterAssignment(this.decisionVars[i]);
                            }
                            inverse = this.isInverse(x, a);
                            ++nbTests;
                            if (!inverse) {
                                ++nbUselessTests;
                            }
                            for (int i2 = 0; i2 < nbDecisions; ++i2) {
                                this.solver.backtrack();
                            }
                            if (inverse) {
                                int[] solution = this.solutions[this.solutionsLimit];
                                this.solver.futVars.execute(y -> {
                                    if (this.allIntervals[y.num][solution[y.num]] != null) {
                                        this.allIntervals[y.num][solution[y.num]].increaseMin(interval.maxDepth);
                                    }
                                });
                                --this.solutionsLimit;
                                continue;
                            }
                            interval.decreaseMax(interval.maxDepth - 1);
                            continue;
                        }
                        nbDecisions = interval.minDepth - this.solver.depth();
                        assert (nbDecisions > 0);
                        for (i = 0; i < nbDecisions; ++i) {
                            this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                            this.enforceArcConsistencyAfterAssignment(this.decisionVars[i]);
                        }
                        inverse = this.isInverse(x, a);
                        ++nbTests;
                        if (inverse) {
                            ++nbUselessTests;
                        }
                        for (int i3 = 0; i3 < nbDecisions; ++i3) {
                            this.solver.backtrack();
                        }
                        if (inverse) {
                            int[] solution = this.solutions[this.solutionsLimit];
                            interval.increaseMin(interval.minDepth + 1);
                            this.solver.futVars.execute(y -> {
                                if (y != interval.var && this.allIntervals[y.num][solution[y.num]] != null) {
                                    this.allIntervals[y.num][solution[y.num]].increaseMin(interval.minDepth);
                                }
                            });
                            --this.solutionsLimit;
                            continue;
                        }
                        interval.decreaseMax(interval.minDepth);
                    }
                }
                this.unknown.removeAll(this.inTransfer);
                this.inTransfer.clear();
            }
            this.solver.resetNoSolutions();
            Kit.log.info("nbUselessTests=" + nbUselessTests);
            return nbTests;
        }

        private void restoreAfterDeletingOneDecision() {
            this.origin = this.solver.head.control.experimental.testI1;
            this.target = this.solver.head.control.experimental.testI2;
            if (this.nTurns == 0 && this.origin > 0 && this.solver.depth() == this.origin) {
                ++this.nTurns;
                int nbItestsBefore = this.nITests;
                Kit.Stopwatch stopwatch = new Kit.Stopwatch();
                if (this.algo == 0) {
                    int nbDecisionsToReplay = this.origin - this.target - 1;
                    this.decisionVars = new Variable[nbDecisionsToReplay];
                    this.decisonsIdxs = new int[nbDecisionsToReplay];
                    int cnt = 0;
                    while (this.solver.futVars.nDiscarded() > 0) {
                        Variable x = this.solver.futVars.lastPast();
                        int a = x.dom.unique();
                        this.solver.backtrack(x);
                        if (cnt == nbDecisionsToReplay) break;
                        this.decisionVars[nbDecisionsToReplay - 1 - cnt] = x;
                        this.decisonsIdxs[nbDecisionsToReplay - 1 - cnt] = a;
                        ++cnt;
                    }
                    System.out.println("Backtracked to " + this.solver.depth());
                    for (int i = 0; i < this.decisionVars.length; ++i) {
                        this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                        this.runAfterAssignment(this.decisionVars[i]);
                    }
                } else {
                    int i;
                    Variable[] variables = this.solver.problem.variables;
                    this.allIntervals = new Interval[variables.length][];
                    for (int i2 = 0; i2 < this.allIntervals.length; ++i2) {
                        this.allIntervals[i2] = new Interval[variables[i2].dom.initSize()];
                    }
                    int nbDecisionsToReplay = this.origin - this.target - 1;
                    this.decisionVars = new Variable[nbDecisionsToReplay];
                    this.decisonsIdxs = new int[nbDecisionsToReplay];
                    this.unknown = new ArrayList<Interval>();
                    this.inTransfer = new ArrayList<Interval>();
                    this.known = new List[this.solver.problem.variables.length + 1];
                    for (int i3 = this.target; i3 <= this.origin; ++i3) {
                        this.known[i3] = new ArrayList<Interval>();
                    }
                    int cnt = 0;
                    while (this.solver.futVars.nDiscarded() > 0) {
                        Variable x = this.solver.futVars.lastPast();
                        int a = x.dom.unique();
                        this.buildIntervalsFor(x, true);
                        this.solver.futVars.execute(y -> this.buildIntervalsFor((Variable)y, false));
                        this.solver.backtrack(x);
                        if (cnt == nbDecisionsToReplay) break;
                        this.decisionVars[nbDecisionsToReplay - 1 - cnt] = x;
                        this.decisonsIdxs[nbDecisionsToReplay - 1 - cnt] = a;
                        ++cnt;
                    }
                    assert (this.controlIntervals());
                    this.nVals = Variable.nValidValuesFor(variables);
                    this.nUnks = this.unknown.size();
                    this.performingProperSearch = true;
                    for (i = 0; i < this.decisionVars.length; ++i) {
                        this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                        this.enforceArcConsistencyAfterAssignment(this.decisionVars[i]);
                        this.updateMaxFor(this.decisionVars[i]);
                        this.solver.futVars.execute(y -> this.updateMaxFor((Variable)y));
                    }
                    for (i = 0; i < this.decisionVars.length; ++i) {
                        this.solver.backtrack();
                    }
                    this.unknown.removeAll(this.inTransfer);
                    this.inTransfer.clear();
                    assert (this.controlIntervals());
                    System.out.println("After AC, NbUnk = " + this.unknown.size());
                    this.nUnksAfterAC = this.unknown.size();
                    this.nTests = this.finalizeIntervals();
                    System.out.println("After Finalize");
                    assert (this.controlIntervals());
                    for (i = 0; i < this.decisionVars.length; ++i) {
                        this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                        for (Interval interval : this.known[this.solver.depth()]) {
                            if (((Interval)interval).var.dom.present(interval.idx)) {
                                ((Interval)interval).var.dom.removeElementary(interval.idx);
                                continue;
                            }
                            assert (((Interval)interval).var.dom.removedLevelOf(interval.idx) == this.solver.depth());
                        }
                        this.updateSTRStructures();
                    }
                    Kit.log.info("nbVals=" + this.nVals + " nbUnks=" + this.nUnks + " nbUnksAfterAc=" + this.nUnksAfterAC + " nbTests=" + this.nTests);
                    this.performingProperSearch = false;
                }
                this.nItestsRestor = this.nITests - nbItestsBefore;
                this.wck = stopwatch.wckTime();
                System.out.println("Wck=" + this.wck + " nbITestsR=" + this.nItestsRestor);
            }
        }

        private boolean controlIntervals() {
            Kit.control(this.inTransfer.size() == 0, () -> "Control cannot be performed with inTransfer not empty");
            int nIntervals1 = 0;
            for (int i = 0; i < this.allIntervals.length; ++i) {
                for (int j = 0; j < this.allIntervals[i].length; ++j) {
                    if (this.allIntervals[i][j] == null) continue;
                    ++nIntervals1;
                    if (this.allIntervals[i][j].isFixed()) {
                        Kit.control(this.known[this.allIntervals[i][j].maxDepth].contains(this.allIntervals[i][j]));
                        continue;
                    }
                    Kit.control(this.unknown.contains(this.allIntervals[i][j]));
                }
            }
            int nIntervals2 = this.unknown.size();
            for (int i = this.target; i <= this.origin; ++i) {
                nIntervals2 += this.known[i].size();
            }
            Kit.control(nIntervals1 == nIntervals2);
            return true;
        }

        private void display() {
            Kit.log.fine("Unknown : " + Stream.of(this.unknown).map(it -> it.toString()).collect(Collectors.joining(" ")));
            Kit.log.fine("Known : " + IntStream.range(this.target, this.origin + 1).mapToObj(i -> "  level " + i + " : " + Stream.of(this.known[i]).map(it -> it.toString()).collect(Collectors.joining(" "))).collect(Collectors.joining("\n")));
        }

        class Interval
        implements Comparable<Interval> {
            private Variable var;
            private int idx;
            private int minDepth;
            private int maxDepth;

            private Interval(Variable x, int a, int min, int max) {
                this.var = x;
                this.idx = a;
                this.minDepth = min;
                this.maxDepth = max;
                assert (min <= max);
                if (this.minDepth == this.maxDepth) {
                    GIC4.this.known[this.minDepth].add(this);
                } else {
                    GIC4.this.unknown.add(this);
                }
            }

            private void increaseMin(int min) {
                if (this.minDepth < min) {
                    this.minDepth = min;
                    if (this.minDepth == this.maxDepth) {
                        GIC4.this.known[this.minDepth].add(this);
                        GIC4.this.inTransfer.add(this);
                    }
                }
            }

            private void decreaseMax(int max) {
                if (this.maxDepth > max) {
                    this.maxDepth = max;
                    if (this.minDepth == this.maxDepth) {
                        GIC4.this.known[this.minDepth].add(this);
                        GIC4.this.inTransfer.add(this);
                    }
                }
            }

            private boolean isFixed() {
                return this.minDepth == this.maxDepth;
            }

            public String toString() {
                return this.var + "=" + this.idx + " in [" + this.minDepth + ".." + this.maxDepth + "]";
            }

            @Override
            public int compareTo(Interval interval) {
                return Integer.compare(this.maxDepth, interval.maxDepth);
            }
        }
    }

    public static class GIC3
    extends GIC2 {
        private int[][][] residues;

        public GIC3(Solver solver) {
            super(solver);
            this.residues = (int[][][])Stream.of(solver.problem.variables).map(x -> new int[x.dom.initSize()][]).toArray(x$0 -> new int[x$0][][]);
        }

        @Override
        protected void handleNewSolution(Variable x, int a) {
            int[] solution = this.solver.solRecorder.lastSolution;
            this.handleSolution(x, a, solution);
            if (this.residues[x.num][a] == null) {
                this.residues[x.num][a] = new int[this.solver.problem.variables.length];
            }
            Kit.copy(solution, this.residues[x.num][a]);
        }

        @Override
        protected boolean isInverseAdvanced(Variable x, int a) {
            if (this.stamps[x.num][a] == this.timestamp) {
                return true;
            }
            if (this.residues[x.num][a] != null && Variable.isValidTuple(this.solver.problem.variables, this.residues[x.num][a], true)) {
                this.handleSolution(x, a, this.residues[x.num][a]);
                return true;
            }
            return this.isInverse(x, a);
        }
    }

    public static class GIC2
    extends GICAdvanced {
        protected int timestamp;
        protected int[][] stamps;

        public GIC2(Solver solver) {
            super(solver);
            this.stamps = Variable.litterals(solver.problem.variables).intArray();
        }

        protected void handleSolution(Variable x, int a, int[] solution) {
            for (int k = this.cursor - 1; k >= 0; --k) {
                int id = this.sSups[k];
                if (this.stamps[id][solution[id]] == this.timestamp) continue;
                this.stamps[id][solution[id]] = this.timestamp;
                int n = id;
                this.cnts[n] = this.cnts[n] - 1;
            }
        }

        @Override
        protected void handleNewSolution(Variable x, int a) {
            this.handleSolution(x, a, this.solver.solRecorder.lastSolution);
        }

        @Override
        protected void intializationAdvanced() {
            ++this.timestamp;
            this.sSupSize = 0;
            for (Variable x : this.solver.futVars) {
                if (x.dom.size() <= 1) continue;
                this.cnts[x.num] = x.dom.size();
                this.sSups[this.sSupSize++] = x.num;
            }
        }

        @Override
        protected boolean isInverseAdvanced(Variable x, int a) {
            return this.stamps[x.num][a] == this.timestamp || this.isInverse(x, a);
        }
    }

    public static abstract class GICAdvanced
    extends GIC {
        protected int[] cnts;
        protected int sSupSize;
        protected int[] sSups;
        protected int cursor;

        public GICAdvanced(Solver solver) {
            super(solver);
            this.cnts = new int[solver.problem.variables.length];
            this.sSups = new int[solver.problem.variables.length];
        }

        protected abstract void intializationAdvanced();

        protected abstract boolean isInverseAdvanced(Variable var1, int var2);

        @Override
        public boolean enforceStrongConsistency() {
            this.intializationAdvanced();
            this.performingProperSearch = true;
            long nSolutionsBefore = this.solver.solRecorder.found;
            int nValuesRemoved = 0;
            this.cursor = this.sSupSize - 1;
            while (this.cursor >= 0) {
                Variable x = this.solver.problem.variables[this.sSups[this.cursor]];
                if (this.cnts[x.num] != 0) {
                    Domain dom = x.dom;
                    int a = dom.first();
                    while (a != -1) {
                        if (!this.isInverseAdvanced(x, a)) {
                            x.dom.removeElementary(a);
                            ++nValuesRemoved;
                        }
                        a = dom.next(a);
                    }
                    Kit.control(dom.size() != 0, () -> "Not possible to reach inconsistency with GIC (or your instance is unsat)");
                }
                --this.cursor;
            }
            this.after(nSolutionsBefore, nValuesRemoved);
            return true;
        }
    }
}

