/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.ConflictsStructure;
import constraints.Constraint;
import constraints.extension.CMDD;
import constraints.extension.CSmart;
import constraints.extension.Extension;
import constraints.extension.structures.TableSmart;
import constraints.global.AllDifferent;
import constraints.global.AllEqual;
import constraints.global.Among;
import constraints.global.BinPacking;
import constraints.global.Cardinality;
import constraints.global.Circuit;
import constraints.global.Count;
import constraints.global.Cumulative;
import constraints.global.DistinctVectors;
import constraints.global.Element;
import constraints.global.ElementMatrix;
import constraints.global.Extremum;
import constraints.global.Lexicographic;
import constraints.global.NValues;
import constraints.global.NoOverlap;
import constraints.global.Product;
import constraints.global.Sum;
import constraints.global.SumScalarBoolean;
import constraints.intension.Intension;
import constraints.intension.Primitive;
import constraints.intension.PrimitiveBinary;
import constraints.intension.PrimitiveLogic;
import constraints.intension.PrimitiveTernary;
import dashboard.Control;
import heuristics.HeuristicValues;
import heuristics.HeuristicValuesDirect;
import interfaces.Observers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import main.Head;
import optimization.ObjectiveVariable;
import optimization.Optimizable;
import optimization.Optimizer;
import org.xcsp.common.Condition;
import org.xcsp.common.FunctionalInterfaces;
import org.xcsp.common.IVar;
import org.xcsp.common.Range;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.domains.Values;
import org.xcsp.common.predicates.MatcherInterface;
import org.xcsp.common.predicates.TreeEvaluator;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.structures.AbstractTuple;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Table;
import org.xcsp.common.structures.Transition;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.entities.CtrEntities;
import org.xcsp.modeler.entities.ObjEntities;
import org.xcsp.modeler.implementation.ProblemIMP;
import problem.Features;
import problem.Remodeler;
import propagation.Forward;
import solver.Solver;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import variables.Domain;
import variables.Variable;

public class Problem
extends ProblemIMP
implements Observers.ObserverConstruction {
    public static final Boolean DONT_KNOW = null;
    public static final Boolean STARRED = Boolean.TRUE;
    public static final Boolean UNSTARRED = Boolean.FALSE;
    public static final String AUXILIARY_VARIABLE_PREFIX = "_ax_";
    public static final int BASE = 0;
    public static final int INTENSION_DECOMPOSITION = 1;
    public static final int EXTENSION = 2;
    public static final int EXTENSION_STARRED = 22;
    public static final int EXTENSION_SMART = 222;
    public final Head head;
    public Solver solver;
    public Variable[] variables;
    public Constraint[] constraints;
    public Optimizer optimizer;
    public Variable[] priorityVars = new Variable[0];
    public int nStrictPriorityVars;
    public Features features;
    public Symbolic symbolic = new Symbolic();
    public int nValuesRemoved;
    public final List<List<int[]>> symmetryGroupGenerators = new ArrayList<List<int[]>>();
    public final Collection<Observers.ObserverDomainReduction> observersDomainReduction = new ArrayList<Observers.ObserverDomainReduction>();
    public final Control.SettingGeneral settings;
    public List<String> undisplay = new ArrayList<String>();
    public final Map<String, Variable> mapForVars = new HashMap<String, Variable>();
    public int nAuxVariables;
    public int nAuxConstraints;
    private MatcherInterface.Matcher x_relop_k = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, MatcherInterface.val));
    private MatcherInterface.Matcher x_relop_y = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, MatcherInterface.var));
    private MatcherInterface.Matcher x_ariop_y__relop_k = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.var), MatcherInterface.val));
    private MatcherInterface.Matcher k_relop__x_ariop_y = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.val, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.var)));
    private MatcherInterface.Matcher x_relop__y_ariop_k = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.val)));
    private MatcherInterface.Matcher y_ariop_k__relop_x = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.val), MatcherInterface.var));
    private MatcherInterface.Matcher logic_y_relop_k__eq_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, MatcherInterface.val), MatcherInterface.var));
    private MatcherInterface.Matcher logic_y_relop_k__iff_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.IFF, XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, MatcherInterface.val), MatcherInterface.var));
    private MatcherInterface.Matcher logic_k_relop_y__eq_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.val, MatcherInterface.var), MatcherInterface.var));
    private MatcherInterface.Matcher logic_k_relop_y__iff_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.IFF, XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.val, MatcherInterface.var), MatcherInterface.var));
    private MatcherInterface.Matcher unalop_x__eq_y = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(MatcherInterface.AbstractOperation.unalop, MatcherInterface.var), MatcherInterface.var));
    private MatcherInterface.Matcher disjonctive = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.OR, XNode.node(Types.TypeExpr.LE, XNode.node(Types.TypeExpr.ADD, MatcherInterface.var, MatcherInterface.val), MatcherInterface.var), XNode.node(Types.TypeExpr.LE, XNode.node(Types.TypeExpr.ADD, MatcherInterface.var, MatcherInterface.val), MatcherInterface.var)));
    private MatcherInterface.Matcher x_mul_y__eq_k = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(Types.TypeExpr.MUL, MatcherInterface.var, MatcherInterface.var), MatcherInterface.val));
    private MatcherInterface.Matcher x_ariop_y__relop_z = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.var), MatcherInterface.var));
    private MatcherInterface.Matcher z_relop__x_ariop_y = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, XNode.node(MatcherInterface.AbstractOperation.ariop, MatcherInterface.var, MatcherInterface.var)));
    private MatcherInterface.Matcher logic_y_relop_z__eq_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.var, MatcherInterface.var), MatcherInterface.var));
    private MatcherInterface.Matcher logic_X = new MatcherInterface.Matcher(MatcherInterface.logic_vars);
    private MatcherInterface.Matcher logic_X__eq_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.EQ, MatcherInterface.logic_vars, MatcherInterface.var));
    private MatcherInterface.Matcher logic_X__ne_x = new MatcherInterface.Matcher(XNode.node(Types.TypeExpr.NE, MatcherInterface.logic_vars, MatcherInterface.var));
    private MatcherInterface.Matcher min_relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.min_vars, MatcherInterface.varOrVal));
    private MatcherInterface.Matcher max_relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.max_vars, MatcherInterface.varOrVal));
    private MatcherInterface.Matcher add_vars__relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.add_vars, MatcherInterface.varOrVal));
    private MatcherInterface.Matcher add_mul_vals__relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.add_mul_vals, MatcherInterface.varOrVal));
    private MatcherInterface.Matcher add_mul_vars__relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.add_mul_vars, MatcherInterface.varOrVal));
    private MatcherInterface.Matcher mul_vars__relop = new MatcherInterface.Matcher(XNode.node(MatcherInterface.AbstractOperation.relop, MatcherInterface.mul_vars, MatcherInterface.val));
    private ProblemIMP.Converter converter = new ProblemIMP.Converter(){

        @Override
        public StringBuilder signatureFor(IVar.Var[] scp) {
            return Variable.signatureFor((Variable[])scp);
        }

        @Override
        public int[][] domValuesOf(IVar.Var[] scp) {
            return Variable.initDomainValues((Variable[])scp);
        }

        @Override
        public Utilities.ModifiableBoolean mode() {
            Enums.EExportMode exportMode = Enums.EExportMode.EXTENSION;
            return new Utilities.ModifiableBoolean(exportMode != Enums.EExportMode.EXTENSION_SUPPORTS && exportMode != Enums.EExportMode.EXTENSION_CONFLICTS ? null : Boolean.valueOf(exportMode == Enums.EExportMode.EXTENSION_SUPPORTS));
        }
    };
    public static final String vfsComment = "Either you set -f=cop or you set -f=csp together with -vfs=v where v is an integer value forcing the value of the objective.";

    private Variable[] prioritySumVars(Variable[] scp, int[] coeffs) {
        int i2;
        assert (coeffs == null || IntStream.range(0, coeffs.length - 1).allMatch(i -> coeffs[i] <= coeffs[i + 1]));
        int LIM = 3;
        Term[] terms = new Term[Math.min(scp.length, 2 * LIM)];
        if (terms.length == scp.length) {
            for (i2 = 0; i2 < terms.length; ++i2) {
                terms[i2] = new Term((coeffs == null ? 1 : coeffs[i2]) * scp[i2].dom.intervalValue(), scp[i2]);
            }
        } else {
            for (i2 = 0; i2 < LIM; ++i2) {
                terms[i2] = new Term((coeffs == null ? 1 : coeffs[i2]) * scp[i2].dom.intervalValue(), scp[i2]);
            }
            for (i2 = 0; i2 < LIM; ++i2) {
                terms[LIM + i2] = new Term((coeffs == null ? 1 : coeffs[scp.length - 1 - i2]) * scp[scp.length - 1 - i2].dom.intervalValue(), scp[scp.length - 1 - i2]);
            }
        }
        if ((terms = (Term[])Stream.of(terms).filter(t -> t.coeff < -2L || t.coeff > 2L).sorted().toArray(Term[]::new)).length > 0) {
            Variable[] t2 = (Variable[])Stream.of(terms).map(term -> term.obj).toArray(Variable[]::new);
            if (t2.length > LIM) {
                t2 = Arrays.copyOfRange(t2, t2.length - LIM, t2.length);
            }
            Variable[] tt = new Variable[t2.length];
            for (int i3 = 0; i3 < t2.length; ++i3) {
                tt[i3] = t2[t2.length - 1 - i3];
            }
            return tt;
        }
        return null;
    }

    @Override
    public void afterProblemConstruction() {
        Problem.control(Variable.areNumsNormalized(this.variables) && Constraint.areNumsNormalized(this.constraints), "Non normalized nums in the problem");
        Problem.control(Stream.of(this.variables).map(x -> x.id()).distinct().count() == (long)this.variables.length, "Two variables have the same id");
        Problem.control(this.settings.framework == null, new Object[0]);
        if (this.optimizer != null) {
            this.head.control.toCOP();
        } else {
            this.head.control.toCSP();
        }
        Stream.of(this.variables).peek(x -> Problem.control(Stream.of(x.ctrs).noneMatch(c -> c.num == -1), new Object[0])).forEach(x -> x.dom.finalizeConstruction(this.variables.length + 1));
        ConflictsStructure.buildFor(this);
        Variable[] variableArray = this.priorityVars = this.priorityVars.length == 0 && this.annotations.decision != null ? (Variable[])this.annotations.decision : this.priorityVars;
        if (this.settings.framework == Types.TypeFramework.COP && (this.optimizer.ctr instanceof ObjectiveVariable || this.optimizer.ctr instanceof Extremum.ExtremumCst.MaximumCst.MaximumCstLE || this.optimizer.ctr instanceof Extremum.ExtremumCst.MinimumCst.MinimumCstGE)) {
            this.head.control.restarts.restartAfterSolution = true;
        }
        boolean strong = false;
        if (this.settings.framework == Types.TypeFramework.COP && this.head.control.valh.optValHeuristic) {
            int[] coeffs;
            Variable[] vars;
            Constraint c = (Constraint)((Object)this.optimizer.ctr);
            if (c instanceof ObjectiveVariable) {
                Variable x2 = c.scp[0];
                x2.heuristic = this.optimizer.minimization ? new HeuristicValuesDirect.First(x2, false) : new HeuristicValuesDirect.Last(x2, false);
                this.priorityVars = new Variable[]{x2};
            } else if (c instanceof Extremum.ExtremumCst) {
                if (strong) {
                    for (Variable x3 : c.scp) {
                        x3.heuristic = this.optimizer.minimization ? new HeuristicValuesDirect.First(x3, false) : new HeuristicValuesDirect.Last(x3, false);
                    }
                }
            } else if (c instanceof NValues.NValuesCst) {
                assert (c instanceof NValues.NValuesCst.NValuesCstLE);
                if (strong) {
                    for (Variable x4 : c.scp) {
                        x4.heuristic = new HeuristicValuesDirect.Values(x4, false, c.scp);
                    }
                }
            } else if (c instanceof Sum.SumWeighted && (vars = this.prioritySumVars(c.scp, coeffs = c instanceof Sum.SumSimple ? null : ((Sum.SumWeighted)c).coeffs)) != null) {
                for (Variable x5 : vars) {
                    int coeff = c instanceof Sum.SumSimple ? 1 : coeffs[c.positionOf(x5)];
                    boolean f = this.optimizer.minimization && coeff >= 0 || !this.optimizer.minimization && coeff < 0;
                    System.out.println("before " + x5 + " " + x5.heuristic);
                    x5.heuristic = f ? new HeuristicValuesDirect.First(x5, false) : new HeuristicValuesDirect.Last(x5, false);
                    System.out.println("after " + x5.heuristic);
                }
                this.priorityVars = vars;
            }
        }
    }

    @Override
    public void afterSolverConstruction() {
        Stream.of(this.variables).forEach(x -> x.dom.setPropagation(this.solver.propagation));
    }

    @Override
    public final String name() {
        String name = super.name();
        return name.matches("XCSP[23]-.*") ? name.substring(6) : name;
    }

    public final CtrEntities.CtrAlone post(Constraint c, Types.TypeClass ... classes) {
        c.num = this.features.addCollectedConstraint(c);
        CtrEntities ctrEntities = this.ctrEntities;
        Objects.requireNonNull(ctrEntities);
        return new CtrEntities.CtrAlone(ctrEntities, c, classes);
    }

    public final Optimizable addOptimizable(Constraint c) {
        c.num = this.features.addCollectedConstraint(c);
        return (Optimizable)((Object)c);
    }

    public void annotateValh(Variable[] vars, Class<? extends HeuristicValues> clazz) {
        if (this.settings.enableAnnotations) {
            for (Variable x : vars) {
                x.heuristic = Reflector.buildObject(clazz.getSimpleName(), HeuristicValues.class, x, null);
            }
        }
    }

    public void reset() {
        Stream.of(this.variables).forEach(x -> x.reset());
        Stream.of(this.constraints).forEach(c -> c.reset());
        Stream.of(this.constraints).forEach(c -> {
            c.ignored = false;
        });
        this.nValuesRemoved = 0;
        if (this.settings.verbose > 0) {
            Kit.log.info("Reset of problem instance");
        }
    }

    public void reduceTo(boolean[] presentVariables, boolean[] presentConstraints) {
        Problem.control(this.symmetryGroupGenerators.size() == 0 && presentVariables.length == this.variables.length && presentConstraints.length == this.constraints.length, new Object[0]);
        assert (Variable.firstWipeoutVariableIn(this.variables) == null && Variable.areNumsNormalized(this.variables) && Constraint.areNumsNormalized(this.constraints));
        for (Variable x : this.priorityVars = (Variable[])IntStream.range(0, this.variables.length).filter(i -> presentVariables[i]).mapToObj(i -> this.variables[i]).toArray(Variable[]::new)) {
            x.reset();
        }
        for (int i2 = 0; i2 < this.constraints.length; ++i2) {
            this.constraints[i2].ignored = !presentConstraints[i2];
            if (this.constraints[i2].ignored) continue;
            this.constraints[i2].reset();
        }
        this.nValuesRemoved = 0;
        if (this.settings.verbose > 0) {
            Kit.log.info("Reduction to (#V=" + this.priorityVars.length + ",#C=" + Kit.countIn(true, presentConstraints) + ")");
        }
    }

    public final Constraint addUniversalConstraintDynamicallyBetween(Variable x, Variable y) {
        assert (x.getClass() == y.getClass());
        assert (!Stream.of(y.ctrs).anyMatch(c -> c.scp.length == 2 && c.involves(x)));
        assert (this.solver.propagation instanceof Forward);
        CtrEntities.CtrAlone ca = this.extension(this.vars(new Object[]{x, y}), (Object[])new int[0][], false, DONT_KNOW);
        Constraint c2 = (Constraint)ca.ctr;
        c2.cloneStructures(false);
        this.constraints = this.features.collectedCtrsAtInit.toArray(new Constraint[this.features.collectedCtrsAtInit.size()]);
        x.whenFinishedProblemConstruction();
        y.whenFinishedProblemConstruction();
        if (x.assigned()) {
            c2.doPastVariable(x);
        }
        if (y.assigned()) {
            c2.doPastVariable(y);
        }
        return c2;
    }

    private void inferAdditionalConstraints() {
        if (this.head.control.problem.isSymmetryBreaking()) {
            int nBefore = this.features.collectedCtrsAtInit.size();
            Remodeler.DeducingAutomorphism automorphismIdentification = new Remodeler.DeducingAutomorphism(this);
            for (Constraint c : automorphismIdentification.buildVariableSymmetriesFor(this.variables, this.features.collectedCtrsAtInit)) {
                this.post(c, new Types.TypeClass[0]);
            }
            this.features.addToMapForAutomorphismIdentification(automorphismIdentification);
            this.symmetryGroupGenerators.addAll(automorphismIdentification.generators);
            this.features.nAddedCtrs += this.features.collectedCtrsAtInit.size() - nBefore;
        }
        if (this.head.control.constraints.inferAllDifferentNb > 0) {
            this.features.addToMapForAllDifferentIdentification(new Remodeler.DeducingAllDifferent(this));
        }
    }

    public final void storeConstraintsToArray() {
        this.inferAdditionalConstraints();
        this.constraints = this.features.collectedCtrsAtInit.toArray(new Constraint[0]);
        for (Variable x : this.variables) {
            x.whenFinishedProblemConstruction();
            this.features.varDegrees.add(x.deg());
        }
        assert (Variable.areNumsNormalized(this.variables));
    }

    public Variable findVarWithNumOrId(Object o) {
        String msg = "Check your configuration parameters -ins -pr1 or -pr2";
        if (o instanceof Integer) {
            int num = (Integer)o;
            Problem.control(0 <= num && num < this.variables.length, num + " is not a valid variable num. " + msg);
            Problem.control(this.variables[num].num != -2, "You cannot use the discarded variable whose (initial) num is " + num + ". " + msg);
            return this.variables[num];
        }
        Variable x = this.mapForVars.get(o);
        Problem.control(x != null, "The variable " + o + " cannot be found. " + msg);
        Problem.control(x.num != -2, "You cannot use the discarded variable " + o + ". " + msg);
        return x;
    }

    private final void addUnaryConstraintsOfUserInstantiation() {
        Control.SettingVars settings = this.head.control.variables;
        Problem.control(settings.instantiatedVars.length == settings.instantiatedVals.length, "In the given instantiation, the number of variables (ids or names) is different from the number of values.");
        for (int i = 0; i < settings.instantiatedVars.length; ++i) {
            Variable x = this.findVarWithNumOrId(settings.instantiatedVars[i]);
            int v = settings.instantiatedVals[i];
            Problem.control(x.dom.presentValue(v), "Value " + v + " not present in domain of " + x + ". Check  -ins.");
            x.dom.removeValuesAtConstructionTime(w -> w != v);
        }
    }

    private final void reduceDomainsOfIsolatedVariables() {
        boolean reduceIsolatedVars = this.head.control.variables.reduceIsolatedVars && this.settings.nSearchedSolutions == 1L && !this.head.control.problem.isSymmetryBreaking() && this.settings.framework == Types.TypeFramework.CSP;
        ArrayList<Variable> isolatedVars = new ArrayList<Variable>();
        ArrayList<Variable> fixedVars = new ArrayList<Variable>();
        int nRemovedValues = 0;
        for (Variable x : this.features.collectedVarsAtInit) {
            if (x.ctrs.length == 0) {
                isolatedVars.add(x);
                if (reduceIsolatedVars) {
                    nRemovedValues += x.dom.size() - 1;
                    x.dom.removeValuesAtConstructionTime(v -> v.intValue() != x.dom.firstValue());
                }
            }
            if (x.dom.size() != 1) continue;
            fixedVars.add(x);
        }
        if (isolatedVars.size() > 0) {
            this.features.nIsolatedVars += isolatedVars.size();
            Kit.log.info("Isolated variables : " + Kit.join(isolatedVars, new String[0]));
            Kit.log.info("Nb values removed due to isolated variables : " + nRemovedValues + "\n");
        }
        if (fixedVars.size() > 0) {
            this.features.nFixedVars += fixedVars.size();
            Kit.log.info("Fixed variables : " + (fixedVars.size() <= 100 ? Kit.join(fixedVars, new String[0]) : "more than 100") + "\n");
        }
    }

    public Problem(ProblemAPI api, String modelVariant, String data, String dataFormat, boolean dataSaving, String[] argsForPb, Head head) {
        super(api, modelVariant, argsForPb);
        this.head = head;
        head.problem = this;
        head.observersConstruction.add(0, this);
        this.settings = head.control.general;
        this.features = new Features(this);
        head.output.beforeData();
        this.loadData(data, dataFormat, dataSaving);
        head.output.afterData();
        api.model();
        this.variables = this.features.collectedVarsAtInit.toArray(new Variable[this.features.collectedVarsAtInit.size()]);
        this.addUnaryConstraintsOfUserInstantiation();
        this.storeConstraintsToArray();
        this.reduceDomainsOfIsolatedVariables();
    }

    public final void display() {
        if (this.settings.verbose >= 2) {
            Kit.log.finer("\nProblem " + this.name());
            Stream.of(this.variables).forEach(x -> x.display(this.settings.verbose == 3));
            Stream.of(this.constraints).forEach(c -> c.display(this.settings.verbose == 3));
        }
    }

    public void undisplay(String ... names) {
        this.undisplay = Arrays.asList(names);
    }

    public Class<Variable.VariableInteger> classVI() {
        return Variable.VariableInteger.class;
    }

    public Class<Variable.VariableSymbolic> classVS() {
        return Variable.VariableSymbolic.class;
    }

    @Override
    public Types.TypeFramework typeFramework() {
        return this.settings.framework;
    }

    public final Variable addVar(Variable x) {
        Problem.control(!this.mapForVars.containsKey(x.id()), x.id() + " duplicated");
        if (this.features.mustDiscard(x)) {
            return null;
        }
        x.num = this.features.addCollectedVariable(x);
        this.mapForVars.put(x.id(), x);
        return x;
    }

    @Override
    public Variable.VariableInteger buildVarInteger(String id, Domains.Dom dom) {
        Variable.VariableInteger x = null;
        x = dom.values.length == 1 && dom.values[0] instanceof Values.IntegerInterval ? new Variable.VariableInteger(this, id, (Values.IntegerInterval)dom.values[0]) : new Variable.VariableInteger(this, id, Values.IntegerEntity.toIntArray((Values.IntegerEntity[])dom.values, Integer.MAX_VALUE));
        return (Variable.VariableInteger)this.addVar(x);
    }

    @Override
    public Variable.VariableSymbolic buildVarSymbolic(String id, Domains.DomSymbolic dom) {
        return (Variable.VariableSymbolic)this.addVar(new Variable.VariableSymbolic(this, id, (String[])dom.values));
    }

    public final boolean isBasicType(int type) {
        return type == 0;
    }

    private CtrEntities.CtrEntity unimplemented(String msg) {
        return (CtrEntities.CtrEntity)Kit.exit("\nunimplemented case for " + msg);
    }

    private CtrEntities.CtrEntity unimplementedIf(boolean b, String msg) {
        return b ? this.unimplemented(msg) : null;
    }

    public Variable[] translate(IVar[] t) {
        return t instanceof Variable[] ? (Variable[])t : (Variable[])Stream.of(t).map(x -> (Variable)x).toArray(Variable[]::new);
    }

    private Variable[][] translate2D(IVar[][] m) {
        return m instanceof Variable[][] ? (Variable[][])m : (Variable[][])Stream.of(m).map(t -> this.translate((IVar[])t)).toArray(x$0 -> new Variable[x$0][]);
    }

    private Range range(int length) {
        return new Range(length);
    }

    private String idAux() {
        return AUXILIARY_VARIABLE_PREFIX + this.varEntities.allEntities.size();
    }

    private IVar.Var newAuxVar(Object values) {
        Domains.Dom dom = values instanceof Range ? this.api.dom((Range)values) : this.api.dom((int[])values);
        ++this.nAuxVariables;
        return this.api.var(this.idAux(), dom, "auxiliary variable", new Types.TypeClass[0]);
    }

    private IVar.Var[] newAuxVarArray(int length, Object values) {
        Problem.control(length > 1, new Object[0]);
        this.nAuxVariables += length;
        Object object = values instanceof Range ? this.api.dom((Range)values) : (values = values instanceof int[] ? this.api.dom((int[])values) : values);
        if (values instanceof Domains.Dom) {
            return this.api.array(this.idAux(), this.api.size(length), (Domains.Dom)values, "auxiliary variables", new Types.TypeClass[0]);
        }
        return this.api.array(this.idAux(), this.api.size(length), (FunctionalInterfaces.IntToDom)values, "auxiliary variables", new Types.TypeClass[0]);
    }

    private void replacement(IVar.Var aux, XNode<IVar> tree, boolean tuplesComputed, int[][] tuples) {
        Variable[] treeVars = (Variable[])tree.vars();
        if (!tuplesComputed && this.head.control.extension.convertingIntension(treeVars)) {
            tuples = new TreeEvaluator(tree).computeTuples(Variable.currDomainValues(treeVars));
        }
        if (tuples != null) {
            this.extension((IVar.Var[])this.vars(new Object[]{treeVars, aux}), tuples, true);
            ++this.features.nConvertedConstraints;
        } else {
            this.equal(aux, tree);
        }
    }

    public Variable replaceByVariable(XNode<IVar> tree) {
        IVar.Var aux = this.newAuxVar(tree.possibleValues());
        this.replacement(aux, tree, false, null);
        return (Variable)((Object)aux);
    }

    private boolean areSimilar(XNode<IVar> tree1, XNode<IVar> tree2) {
        if (tree1.type != tree2.type || tree1.arity() != tree2.arity()) {
            return false;
        }
        if (tree1.arity() == 0) {
            Object value1 = ((XNodeLeaf)tree1).value;
            Object value2 = ((XNodeLeaf)tree2).value;
            return tree1.type == Types.TypeExpr.VAR ? ((Variable)value1).dom.typeIdentifier() == ((Variable)value2).dom.typeIdentifier() : value1.equals(value2);
        }
        return IntStream.range(0, tree1.arity()).allMatch(i -> this.areSimilar(tree1.sons[i], tree2.sons[i]));
    }

    private IVar.Var[] replaceByVariables(XNode<IVar>[] trees) {
        Variable[] treeVars;
        FunctionalInterfaces.IntToDom doms = i -> {
            Object values = trees[i].possibleValues();
            return values instanceof Range ? this.api.dom((Range)values) : this.api.dom((int[])values);
        };
        boolean similarTrees = trees.length > 1 && Stream.of(trees).allMatch(tree -> tree.listOfVars().size() == tree.vars().length);
        similarTrees = similarTrees && IntStream.range(1, trees.length).allMatch(i -> this.areSimilar(trees[0], trees[i]));
        IVar.Var[] aux = this.newAuxVarArray(trees.length, similarTrees ? doms.apply(0) : doms);
        int[][] tuples = null;
        if (similarTrees && this.head.control.extension.convertingIntension(treeVars = (Variable[])trees[0].vars())) {
            tuples = new TreeEvaluator(trees[0]).computeTuples(Variable.initDomainValues(treeVars));
        }
        for (int i2 = 0; i2 < trees.length; ++i2) {
            this.replacement(aux[i2], trees[i2], similarTrees, tuples);
        }
        return aux;
    }

    private IVar.Var[] replaceByVariables(Stream<XNode<IVar>> trees) {
        return this.replaceByVariables((XNode[])trees.toArray(XNode[]::new));
    }

    private Condition basicCondition(XNodeParent<IVar> tree) {
        if (tree.type.isRelationalOperator() && tree.sons.length == 2 && tree.sons[1].type.oneOf(Types.TypeExpr.VAR, Types.TypeExpr.LONG)) {
            return tree.sons[1].type == Types.TypeExpr.VAR ? new Condition.ConditionVar(tree.relop(0), (IVar)tree.sons[1].var(0)) : new Condition.ConditionVal(tree.relop(0), tree.sons[1].val(0).intValue());
        }
        return null;
    }

    public final CtrEntities.CtrEntity intension1(XNodeParent<IVar> tree) {
        assert (tree.vars().length == 1);
        tree = (XNodeParent)tree.canonization();
        Variable x = (Variable)tree.var(0);
        if (this.head.mustPreserveUnaryConstraints()) {
            if (!this.head.control.constraints.intensionToExtensionUnaryCtrs) {
                return this.post(new Intension(this, new Variable[]{x}, tree), new Types.TypeClass[0]);
            }
            TreeEvaluator evaluator = new TreeEvaluator(tree, this.symbolic.mapOfSymbols);
            int[] conflicts = x.dom.valuesChecking(va -> evaluator.evaluate((int)va) != 1L);
            if (conflicts.length < x.dom.size() / 2) {
                return this.post(new Extension.Extension1(this, x, conflicts, false), new Types.TypeClass[0]);
            }
            return this.post(new Extension.Extension1(this, x, x.dom.valuesChecking(va -> evaluator.evaluate((int)va) == 1L), true), new Types.TypeClass[0]);
        }
        TreeEvaluator evaluator = new TreeEvaluator(tree, this.symbolic.mapOfSymbols);
        x.dom.removeValuesAtConstructionTime(v -> evaluator.evaluate((int)v) != 1L);
        ++this.features.nRemovedUnaryCtrs;
        CtrEntities ctrEntities = this.ctrEntities;
        Objects.requireNonNull(ctrEntities);
        return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed unary constraint by domain reduction", new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrEntity intension(XNodeParent<IVar> tree) {
        IVar.Var[] list;
        Constraint c;
        if (tree.vars().length == 1) {
            return this.intension1(tree);
        }
        tree = (XNodeParent)tree.canonization();
        Variable[] scp = (Variable[])tree.vars();
        assert (Variable.haveSameType(scp));
        if (this.head.control.extension.convertingIntension(scp) && Stream.of(scp).allMatch(x -> x instanceof IVar.Var)) {
            ++this.features.nConvertedConstraints;
            return this.extension(tree);
        }
        int arity = scp.length;
        Control.SettingXml settings = this.head.control.xml;
        if (arity == 2 && this.x_mul_y__eq_k.matches(tree)) {
            IVar.Var[] t = (IVar.Var[])tree.arrayOfVars();
            int k = tree.val(0);
            if (k == 0) {
                return this.intension(this.api.or(this.api.eq(t[0], 0), this.api.eq(t[1], 0)));
            }
            if (k == 1) {
                return this.forall(this.range(2), (int i) -> this.api.equal(t[i], 1));
            }
        }
        if (arity == 2 && settings.primitiveBinaryInSolver) {
            c = null;
            if (this.x_relop_y.matches(tree)) {
                c = PrimitiveBinary.PrimitiveBinarySub.buildFrom(this, scp[0], scp[1], tree.relop(0), 0);
            } else if (this.x_ariop_y__relop_k.matches(tree)) {
                c = PrimitiveBinary.PrimitiveBinaryWithCst.buildFrom(this, scp[0], tree.ariop(0), scp[1], tree.relop(0), (int)tree.val(0));
            } else if (this.k_relop__x_ariop_y.matches(tree)) {
                c = PrimitiveBinary.PrimitiveBinaryWithCst.buildFrom(this, scp[0], tree.ariop(0), scp[1], tree.relop(0).arithmeticInversion(), (int)tree.val(0));
            } else if (this.x_relop__y_ariop_k.matches(tree)) {
                c = PrimitiveBinary.PrimitiveBinaryWithCst.buildFrom(this, scp[0], tree.relop(0), scp[1], tree.ariop(0), (int)tree.val(0));
            } else if (this.y_ariop_k__relop_x.matches(tree)) {
                c = PrimitiveBinary.PrimitiveBinaryWithCst.buildFrom(this, scp[1], tree.relop(0).arithmeticInversion(), scp[0], tree.ariop(0), (int)tree.val(0));
            } else if (this.logic_y_relop_k__eq_x.matches(tree)) {
                c = PrimitiveBinary.PrimitiveBinaryLog.buildFrom(this, scp[1], scp[0], tree.relop(1), tree.val(0));
            } else if (this.logic_y_relop_k__iff_x.matches(tree)) {
                c = PrimitiveBinary.PrimitiveBinaryLog.buildFrom(this, scp[1], scp[0], tree.relop(0), tree.val(0));
            } else if (this.logic_k_relop_y__eq_x.matches(tree)) {
                c = PrimitiveBinary.PrimitiveBinaryLog.buildFrom(this, scp[1], scp[0], tree.relop(1).arithmeticInversion(), tree.val(0));
            } else if (this.unalop_x__eq_y.matches(tree)) {
                c = PrimitiveBinary.PrimitiveBinaryEQWithUnaryOperator.buildFrom(this, scp[1], tree.unalop(0), scp[0]);
            } else if (this.disjonctive.matches(tree)) {
                Variable[] scp0 = (Variable[])tree.sons[0].vars();
                Variable[] scp1 = (Variable[])tree.sons[1].vars();
                if (scp0.length == 2 && scp1.length == 2 && scp0[0] == scp1[1] && scp0[1] == scp1[0]) {
                    int k0 = tree.sons[0].val(0);
                    int k1 = tree.sons[1].val(0);
                    c = new PrimitiveBinary.Disjonctive(this, scp0[0], k0, scp[1], k1);
                }
            }
            if (c != null) {
                return this.post(c, new Types.TypeClass[0]);
            }
        }
        if (arity == 3 && settings.primitiveTernaryInSolver) {
            c = null;
            if (this.x_ariop_y__relop_z.matches(tree)) {
                c = PrimitiveTernary.buildFrom(this, scp[0], tree.ariop(0), scp[1], tree.relop(0), scp[2]);
            } else if (this.z_relop__x_ariop_y.matches(tree)) {
                c = PrimitiveTernary.buildFrom(this, scp[1], tree.ariop(0), scp[2], tree.relop(0).arithmeticInversion(), scp[0]);
            } else if (this.logic_y_relop_z__eq_x.matches(tree)) {
                c = PrimitiveTernary.PrimitiveTernaryLog.buildFrom(this, scp[2], scp[0], tree.relop(1), scp[1]);
            }
            if (c != null) {
                return this.post(c, new Types.TypeClass[0]);
            }
        }
        if (settings.recognizeLogicInSolver) {
            c = null;
            if (this.logic_X__eq_x.matches(tree)) {
                Variable[] list2 = (Variable[])IntStream.range(0, scp.length - 1).mapToObj(i -> scp[i]).toArray(Variable[]::new);
                c = PrimitiveLogic.PrimitiveLogicEq.buildFrom(this, scp[scp.length - 1], tree.logop(0), list2);
            }
            if (c != null) {
                return this.post(c, new Types.TypeClass[0]);
            }
        }
        if (settings.recognizeExtremumInSolver) {
            if (this.min_relop.matches(tree)) {
                return this.minimum((IVar.Var[])tree.sons[0].vars(), this.basicCondition(tree));
            }
            if (this.max_relop.matches(tree)) {
                return this.maximum((IVar.Var[])tree.sons[0].vars(), this.basicCondition(tree));
            }
        }
        if (settings.recognizeSumInSolver) {
            if (this.add_vars__relop.matches(tree)) {
                list = (IVar.Var[])tree.sons[0].arrayOfVars();
                return this.sum(list, Kit.repeat(1, list.length), this.basicCondition(tree));
            }
            if (this.add_mul_vals__relop.matches(tree)) {
                list = (IVar.Var[])tree.sons[0].arrayOfVars();
                int[] coeffs = Stream.of(tree.sons[0].sons).mapToInt(s -> s.type == Types.TypeExpr.VAR ? 1 : s.val(0)).toArray();
                return this.sum(list, coeffs, this.basicCondition(tree));
            }
            if (this.add_mul_vars__relop.matches(tree)) {
                list = (IVar.Var[])Stream.of(tree.sons[0].sons).map(s -> s.var(0)).toArray(IVar.Var[]::new);
                IVar.Var[] coeffs = (IVar.Var[])Stream.of(tree.sons[0].sons).map(s -> s.var(1)).toArray(IVar.Var[]::new);
                return this.sum(list, coeffs, this.basicCondition(tree));
            }
        }
        if (this.mul_vars__relop.matches(tree)) {
            list = (IVar.Var[])tree.arrayOfVars();
            if (tree.relop(0) == Types.TypeConditionOperatorRel.EQ && tree.sons[1].type == Types.TypeExpr.LONG) {
                Integer k = tree.sons[1].val(0);
                if (k == 0) {
                    return this.intension(this.api.or(Stream.of(list).map(x -> this.api.eq(x, 0))));
                }
                if (k == 1) {
                    return this.forall(this.range(list.length), (int i) -> this.api.equal(list[i], 1));
                }
            }
            return this.product(list, this.basicCondition(tree));
        }
        boolean b = this.head.control.constraints.decomposeIntention > 0 && scp[0] instanceof Variable.VariableInteger && scp.length + 1 >= tree.listOfVars().size();
        boolean bl = b = b || this.head.control.constraints.decomposeIntention == 2;
        if (b) {
            XNode[] sons = tree.sons;
            int nParentSons = 0;
            if (tree.type == Types.TypeExpr.EQ) {
                for (XNode son : sons) {
                    if (!(son instanceof XNodeParent)) continue;
                    ++nParentSons;
                    XNode<V>[] grandsons = son.sons;
                    boolean modified = false;
                    for (int j = 0; j < grandsons.length; ++j) {
                        if (!(grandsons[j] instanceof XNodeParent) || grandsons[j].type == Types.TypeExpr.SET) continue;
                        grandsons[j] = new XNodeLeaf(Types.TypeExpr.VAR, this.replaceByVariable(grandsons[j]));
                        modified = true;
                    }
                    if (!modified) continue;
                    return this.intension(tree);
                }
            }
            if (tree.type != Types.TypeExpr.EQ || nParentSons > 1) {
                for (int i2 = 0; i2 < sons.length; ++i2) {
                    if (!(sons[i2] instanceof XNodeParent) || sons[i2].type == Types.TypeExpr.SET) continue;
                    sons[i2] = new XNodeLeaf(Types.TypeExpr.VAR, this.replaceByVariable(sons[i2]));
                    return this.intension(tree);
                }
            }
        }
        return this.post(new Intension(this, scp, tree), new Types.TypeClass[0]);
    }

    @Override
    protected ProblemIMP.Converter getConverter() {
        return this.converter;
    }

    public final CtrEntities.CtrAlone extension(Variable x, int[] values, boolean positive) {
        assert (Kit.isStrictlyIncreasing(values) && IntStream.of(values).noneMatch(v -> v == 0x7FFFFFFE));
        if (this.head.mustPreserveUnaryConstraints()) {
            return this.post(new Extension.Extension1(this, x, values, positive), new Types.TypeClass[0]);
        }
        boolean b = positive;
        x.dom.removeValuesAtConstructionTime(v -> Arrays.binarySearch(values, v) < 0 == b);
        ++this.features.nRemovedUnaryCtrs;
        return null;
    }

    public final CtrEntities.CtrAlone extension(IVar[] scp, Object[] tuples, boolean positive, Boolean starred) {
        if (tuples.length == 0) {
            return this.post(positive ? new Constraint.CtrFalse(this, this.translate(scp), "Extension with 0 support") : new Constraint.CtrTrue(this, this.translate(scp)), new Types.TypeClass[0]);
        }
        if (scp.length == 1) {
            Kit.control(starred == null);
            int[][] m = scp[0] instanceof Variable.VariableSymbolic ? this.symbolic.replaceSymbols((String[][])tuples) : (int[][])tuples;
            int[] values = Stream.of(m).mapToInt(t -> t[0]).toArray();
            return this.extension((Variable)scp[0], values, positive);
        }
        return this.post(Extension.build(this, this.translate(scp), tuples, positive, starred), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrAlone extension(IVar.Var[] scp, int[][] tuples, boolean positive) {
        return this.extension(scp, (Object[])tuples, positive, DONT_KNOW);
    }

    @Override
    public final CtrEntities.CtrAlone extension(IVar.VarSymbolic[] scp, String[][] tuples, boolean positive) {
        return this.extension(scp, (Object[])tuples, positive, DONT_KNOW);
    }

    @Override
    public final CtrEntities.CtrAlone extension(IVar.Var[] scp, AbstractTuple[] tuples, boolean positive) {
        return (CtrEntities.CtrAlone)this.unimplemented("extension with abstract tuples");
    }

    @Override
    public final CtrEntities.CtrAlone regular(IVar.Var[] list, Automaton automaton) {
        return this.post(new CMDD(this, this.translate(list), automaton), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrAlone mdd(IVar.Var[] list, Transition[] transitions) {
        return this.post(new CMDD(this, this.translate(list), transitions), new Types.TypeClass[0]);
    }

    public final CtrEntities.CtrAlone mdd(IVar.Var[] list, int[][] tuples) {
        return this.post(new CMDD(this, this.translate(list), tuples), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity allDifferent(Variable[] scp) {
        if (scp.length <= 1) {
            CtrEntities ctrEntities = this.ctrEntities;
            Objects.requireNonNull(ctrEntities);
            return new CtrEntities.CtrAloneDummy(ctrEntities, "Removed alldiff constraint with scope length = " + scp.length, new Types.TypeClass[0]);
        }
        if (this.isBasicType(this.head.control.global.typeAllDifferent)) {
            return this.post(Variable.isPermutationElligible(scp) ? new AllDifferent.AllDifferentPermutation(this, scp) : new AllDifferent.AllDifferentComplete(this, scp), new Types.TypeClass[0]);
        }
        if (this.head.control.global.typeAllDifferent == 1) {
            return this.forall(this.range(scp.length).range(scp.length), (int i, int j) -> {
                if (i < j) {
                    this.post(new PrimitiveBinary.PrimitiveBinarySub.SubNE2(this, scp[i], scp[j], 0), new Types.TypeClass[0]);
                }
            });
        }
        if (this.head.control.global.typeAllDifferent == 2) {
            return this.post(new AllDifferent.AllDifferentWeak(this, scp), new Types.TypeClass[0]);
        }
        if (this.head.control.global.typeAllDifferent == 3) {
            return this.post(new AllDifferent.AllDifferentCounting(this, scp), new Types.TypeClass[0]);
        }
        if (this.head.control.global.typeAllDifferent == 4) {
            return this.post(new AllDifferent.AllDifferentBound(this, scp), new Types.TypeClass[0]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final CtrEntities.CtrEntity allDifferent(IVar.Var[] list) {
        return this.allDifferent(this.translate(list));
    }

    @Override
    public final CtrEntities.CtrEntity allDifferent(IVar.VarSymbolic[] list) {
        return this.allDifferent(this.translate(list));
    }

    @Override
    public final CtrEntities.CtrEntity allDifferent(IVar.Var[] list, int[] exceptValues) {
        Problem.control(exceptValues.length >= 1 && Kit.isStrictlyIncreasing(exceptValues), new Object[0]);
        Variable[] scp = this.translate(list);
        if (this.head.control.global.typeAllDifferent == 0) {
            return this.post(new AllDifferent.AllDifferentExceptWeak(this, scp, exceptValues), new Types.TypeClass[0]);
        }
        return this.forall(this.range(scp.length).range(scp.length), (int i, int j) -> {
            if (i < j) {
                ArrayList<int[]> conflicts = new ArrayList<int[]>();
                Domain domi = scp[i].dom;
                Domain domj = scp[j].dom;
                int a = domi.first();
                while (a != -1) {
                    int va = domi.toVal(a);
                    if (!Kit.isPresent(va, exceptValues) && domj.presentValue(va)) {
                        conflicts.add(new int[]{va, va});
                    }
                    a = domi.next(a);
                }
                this.extension(this.vars(new Object[]{scp[i], scp[j]}), (Object[])Kit.intArray2D(conflicts), false, false);
            }
        });
    }

    private CtrEntities.CtrEntity distinctVectors(Variable[] t1, Variable[] t2) {
        Variable[] list2;
        Problem.control(t1.length == t2.length, new Object[0]);
        boolean normalized = IntStream.range(0, t1.length).allMatch(i -> t1[i] != t2[i]);
        Variable[] list1 = normalized ? t1 : (Variable[])IntStream.range(0, t1.length).filter(i -> t1[i] != t2[i]).mapToObj(i -> t1[i]).toArray(Variable[]::new);
        Variable[] variableArray = list2 = normalized ? t2 : (Variable[])IntStream.range(0, t2.length).filter(i -> t1[i] != t2[i]).mapToObj(i -> t2[i]).toArray(Variable[]::new);
        if (this.isBasicType(this.head.control.global.typeDistinctVectors)) {
            return this.post(new DistinctVectors(this, list1, list2), new Types.TypeClass[0]);
        }
        if (this.head.control.global.smartTable) {
            return this.post(CSmart.buildDistinctVectors(this, list1, list2), new Types.TypeClass[0]);
        }
        return this.api.disjunction(IntStream.range(0, list1.length).mapToObj(i -> this.api.ne(list1[i], list2[i])));
    }

    private CtrEntities.CtrEntity distinctVectors(Variable[][] lists) {
        return this.forall(this.range(lists.length).range(lists.length), (int i, int j) -> {
            if (i < j) {
                this.distinctVectors(lists[i], lists[j]);
            }
        });
    }

    @Override
    public final CtrEntities.CtrEntity allDifferentList(IVar.Var[] ... lists) {
        Problem.control(lists.length >= 2, new Object[0]);
        Variable[][] m = this.translate2D(lists);
        return lists.length == 2 ? this.distinctVectors(m[0], m[1]) : this.distinctVectors(m);
    }

    @Override
    public final CtrEntities.CtrEntity allDifferentMatrix(IVar.Var[][] matrix) {
        CtrEntities.CtrArray ctrSet1 = this.forall(this.range(matrix.length), (int i) -> this.allDifferent(matrix[i]));
        CtrEntities.CtrArray ctrSet2 = this.forall(this.range(matrix[0].length), (int i) -> this.allDifferent(this.api.columnOf(matrix, i)));
        return ctrSet1.append(ctrSet2);
    }

    @Override
    public CtrEntities.CtrEntity allDifferent(XNode<IVar>[] trees) {
        return this.allDifferent(this.replaceByVariables(trees));
    }

    @Override
    public final CtrEntities.CtrEntity allEqual(IVar.Var ... scp) {
        return this.post(new AllEqual(this, this.translate(scp)), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrEntity allEqual(IVar.VarSymbolic ... scp) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public final CtrEntities.CtrEntity allEqualList(IVar.Var[] ... lists) {
        throw new UnsupportedOperationException("Not implemnted");
    }

    @Override
    public final CtrEntities.CtrEntity ordered(IVar.Var[] list, int[] lengths, Types.TypeOperatorRel op) {
        Problem.control(list.length == lengths.length + 1, new Object[0]);
        return this.forall(this.range(list.length - 1), (int i) -> this.post(PrimitiveBinary.PrimitiveBinarySub.buildFrom(this, (Variable)((Object)list[i]), (Variable)((Object)list[i + 1]), op, -lengths[i]), new Types.TypeClass[0]));
    }

    @Override
    public final CtrEntities.CtrEntity ordered(IVar.Var[] list, IVar.Var[] lengths, Types.TypeOperatorRel op) {
        Problem.control(list.length == lengths.length + 1, new Object[0]);
        return this.forall(this.range(list.length - 1), (int i) -> this.post(PrimitiveTernary.PrimitiveTernaryAdd.buildFrom(this, (Variable)((Object)list[i]), (Variable)((Object)lengths[i]), op, (Variable)((Object)list[i + 1])), new Types.TypeClass[0]));
    }

    private final CtrEntities.CtrAlone lexSimple(IVar.Var[] t1, IVar.Var[] t2, Types.TypeOperatorRel op) {
        return this.post(Lexicographic.buildFrom(this, this.translate(t1), this.translate(t2), op), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrEntity lex(IVar.Var[][] lists, Types.TypeOperatorRel op) {
        return this.forall(this.range(lists.length - 1), (int i) -> this.lexSimple(lists[i], lists[i + 1], op));
    }

    @Override
    public final CtrEntities.CtrEntity lexMatrix(IVar.Var[][] matrix, Types.TypeOperatorRel op) {
        this.forall(this.range(matrix.length - 1), (int i) -> this.lexSimple(matrix[i], matrix[i + 1], op));
        return this.forall(this.range(matrix[0].length - 1), (int j) -> this.lexSimple(this.api.columnOf(matrix, j), this.api.columnOf(matrix, j + 1), op));
    }

    private CtrEntities.CtrAlone sum(Variable[] list, int[] coeffs, Types.TypeConditionOperatorRel op, long limit, boolean inversable) {
        boolean postTwoConstraints;
        boolean only1;
        Term[] terms = new Term[list.length];
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = new Term(coeffs == null ? 1L : (long)coeffs[i], list[i]);
        }
        if (!Variable.areAllDistinct(list)) {
            Set<Map.Entry<Object, Long>> entries = Stream.of(terms).collect(Collectors.groupingBy(t -> t.obj, Collectors.summingLong(t -> (int)t.coeff))).entrySet();
            terms = (Term[])entries.stream().map(e -> new Term((Long)e.getValue(), e.getKey())).toArray(Term[]::new);
            Kit.log.info("Sum constraint with several ocurrences of the same variable");
        }
        terms = (Term[])Stream.of(terms).filter(t -> t.coeff != 0L).sorted().toArray(Term[]::new);
        list = (Variable[])Stream.of(terms).map(t -> t.obj).toArray(Variable[]::new);
        Problem.control(Stream.of(terms).allMatch(t -> Utilities.isSafeInt(t.coeff)), new Object[0]);
        coeffs = Stream.of(terms).mapToInt(t -> (int)t.coeff).toArray();
        if (inversable && coeffs[0] == -1 && coeffs[coeffs.length - 1] == -1) {
            Arrays.fill(coeffs, 1);
            op = op.arithmeticInversion();
            limit = -limit;
        }
        boolean bl = only1 = coeffs[0] == 1 && coeffs[coeffs.length - 1] == 1;
        if (op == Types.TypeConditionOperatorRel.EQ && (postTwoConstraints = false)) {
            if (only1) {
                this.post(new Sum.SumSimple.SumSimpleLE(this, list, limit), new Types.TypeClass[0]);
                this.post(new Sum.SumSimple.SumSimpleGE(this, list, limit), new Types.TypeClass[0]);
            } else {
                this.post(new Sum.SumWeighted.SumWeightedLE(this, list, coeffs, limit), new Types.TypeClass[0]);
                this.post(new Sum.SumWeighted.SumWeightedGE(this, list, coeffs, limit), new Types.TypeClass[0]);
            }
            return null;
        }
        if (only1) {
            return this.post(Sum.SumSimple.buildFrom(this, list, op, limit), new Types.TypeClass[0]);
        }
        return this.post(Sum.SumWeighted.buildFrom(this, list, coeffs, op, limit), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity sum(IVar[] list, int[] coeffs, Types.TypeConditionOperatorRel op, long limit) {
        return this.sum(this.translate(list), coeffs, op, limit, true);
    }

    @Override
    public final CtrEntities.CtrEntity sum(IVar.Var[] list, int[] coeffs, Condition condition) {
        Enum op;
        Problem.control(list.length > 0, "A constraint sum is posted with a scope of 0 variable");
        Problem.control(Stream.of(list).noneMatch(x -> x == null), "A variable is null");
        Problem.control(list.length == coeffs.length, "the number of variables is different from the number of coefficients");
        XNode<IVar> rightTerm = condition.rightTerm();
        if (IntStream.of(coeffs).anyMatch(v -> v == 0)) {
            int[] copy = (int[])coeffs.clone();
            Problem.control((coeffs = this.api.selectFromIndexing(coeffs, i -> copy[i] != 0)).length > 0, new Object[0]);
            list = this.api.select(list, i -> copy[i] != 0);
        }
        if (list.length == 1) {
            assert (coeffs[0] != 0);
            if (condition instanceof Condition.ConditionSet) {
                rightTerm = this.api.set(rightTerm);
            }
            XNodeParent<IVar> tree = XNodeParent.build(condition.operatorTypeExpr(), coeffs[0] == 1 ? list[0] : this.api.mul(list[0], coeffs[0]), rightTerm);
            return this.extension(tree);
        }
        if (condition instanceof Condition.ConditionSet) {
            int max;
            op = ((Condition.ConditionSet)condition).operator;
            int[] t = condition instanceof Condition.ConditionIntset ? (int[])rightTerm : null;
            int min = condition instanceof Condition.ConditionIntvl ? ((Range)((Object)rightTerm)).start : t[0];
            int n = max = condition instanceof Condition.ConditionIntvl ? ((Range)((Object)rightTerm)).stop - 1 : t[t.length - 1];
            if (op == Types.TypeConditionOperatorSet.IN) {
                boolean mdd = false;
                if (mdd) {
                    return this.post(new CMDD(this, this.translate(list), coeffs, rightTerm), new Types.TypeClass[0]);
                }
                this.sum(list, coeffs, Types.TypeConditionOperatorRel.GE, min);
                this.sum(list, coeffs, Types.TypeConditionOperatorRel.LE, max);
                if (condition instanceof Condition.ConditionIntset) {
                    int index = 0;
                    for (int v2 = t[0]; v2 < t[t.length - 1]; ++v2) {
                        if (v2 < t[index]) {
                            this.sum(list, coeffs, Types.TypeConditionOperatorRel.NE, v2);
                            continue;
                        }
                        ++index;
                    }
                }
            } else if (condition instanceof Condition.ConditionIntvl) {
                for (int v3 = min; v3 <= max; ++v3) {
                    this.sum(list, coeffs, Types.TypeConditionOperatorRel.NE, v3);
                }
            } else {
                for (int v4 : t) {
                    this.sum(list, coeffs, Types.TypeConditionOperatorRel.NE, v4);
                }
            }
            return null;
        }
        op = ((Condition.ConditionRel)condition).operator;
        return condition instanceof Condition.ConditionVal ? this.sum(list, coeffs, (Types.TypeConditionOperatorRel)op, (Long)((Object)rightTerm)) : this.sum(this.vars(new Object[]{list, (Variable)((Object)rightTerm)}), this.api.vals(coeffs, -1), (Types.TypeConditionOperatorRel)op, 0L);
    }

    @Override
    public final CtrEntities.CtrEntity sum(IVar.Var[] list, IVar.Var[] coeffs, Condition condition) {
        Problem.control(list.length > 0, "A constraint sum is posted with a scope of 0 variable");
        assert (Stream.of(list).noneMatch(x -> x == null) && Stream.of(coeffs).noneMatch(x -> x == null)) : "A variable is null in these arrays";
        Problem.control(list.length == coeffs.length, "The number of variables is different from the number of coefficients");
        if (condition instanceof Condition.ConditionRel && Variable.areAllInitiallyBoolean(this.translate(list)) && Variable.areAllInitiallyBoolean(this.translate(coeffs))) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            Object rightTerm = condition.rightTerm();
            if (condition instanceof Condition.ConditionVal && op != Types.TypeConditionOperatorRel.NE) {
                return this.post(SumScalarBoolean.SumScalarBooleanCst.buildFrom(this, this.translate(list), this.translate(coeffs), op, Utilities.safeInt((long)((Long)rightTerm))), new Types.TypeClass[0]);
            }
            if (condition instanceof Condition.ConditionVar && op != Types.TypeConditionOperatorRel.NE && op != Types.TypeConditionOperatorRel.EQ) {
                return this.post(SumScalarBoolean.SumScalarBooleanVar.buildFrom(this, this.translate(list), this.translate(coeffs), op, (Variable)rightTerm), new Types.TypeClass[0]);
            }
        }
        IVar.Var[] aux = this.replaceByVariables(IntStream.range(0, list.length).mapToObj(i -> this.api.mul(list[i], coeffs[i])));
        return this.sum(aux, Kit.repeat(1, list.length), condition);
    }

    @Override
    public CtrEntities.CtrEntity sum(XNode<IVar>[] trees, int[] coeffs, Condition condition) {
        Problem.control(trees.length > 0, "A constraint sum is posted with a scope of 0 variable");
        if (this.head.control.constraints.viewForSum && condition instanceof Condition.ConditionRel) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            Object rightTerm = condition.rightTerm();
            if (op != Types.TypeConditionOperatorRel.NE && Stream.of(trees).allMatch(tree -> tree.type.isPredicateOperator() && tree.vars().length == 1)) {
                if (condition instanceof Condition.ConditionVar) {
                    Term[] terms = new Term[trees.length + 1];
                    for (int i = 0; i < trees.length; ++i) {
                        terms[i] = new Term(coeffs == null ? 1L : (long)coeffs[i], trees[i]);
                    }
                    terms[terms.length - 1] = new Term(-1L, new XNodeLeaf(Types.TypeExpr.VAR, (Variable)rightTerm));
                    terms = (Term[])Stream.of(terms).filter(t -> t.coeff != 0L).sorted().toArray(Term[]::new);
                    XNode[] tt = (XNode[])Stream.of(terms).map(t -> t.obj).toArray(XNode[]::new);
                    Problem.control(Stream.of(terms).allMatch(t -> Utilities.isSafeInt(t.coeff)), new Object[0]);
                    coeffs = Stream.of(terms).mapToInt(t -> (int)t.coeff).toArray();
                    return this.post(Sum.SumViewWeighted.buildFrom(this, tt, coeffs, op, 0L), new Types.TypeClass[0]);
                }
                if (condition instanceof Condition.ConditionVal) {
                    return this.post(Sum.SumViewWeighted.buildFrom(this, trees, coeffs, op, (Long)rightTerm), new Types.TypeClass[0]);
                }
            }
        }
        return this.sum(this.replaceByVariables(trees), coeffs, condition);
    }

    public CtrEntities.CtrEntity sum(Stream<XNode<IVar>> trees, int[] coeffs, Condition condition) {
        return this.sum((XNode[])trees.toArray(XNode[]::new), coeffs, condition);
    }

    public final CtrEntities.CtrEntity product(IVar.Var[] list, Condition condition) {
        if (condition instanceof Condition.ConditionRel) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            Object rightTerm = condition.rightTerm();
            Variable[] scp = (Variable.VariableInteger[])this.translate(this.clean(list));
            if (condition instanceof Condition.ConditionVal) {
                return this.post(Product.ProductSimple.buildFrom(this, scp, op, (Long)rightTerm), new Types.TypeClass[0]);
            }
        }
        return this.unimplemented("product");
    }

    private CtrEntities.CtrEntity atLeast(Variable.VariableInteger[] scp, int value, int k) {
        if (k == 0) {
            CtrEntities ctrEntities = this.ctrEntities;
            Objects.requireNonNull(ctrEntities);
            return new CtrEntities.CtrAloneDummy(ctrEntities, "atleast witk k = 0", new Types.TypeClass[0]);
        }
        if (k == scp.length) {
            return this.instantiation((IVar.Var[])scp, value);
        }
        return k == 1 ? this.post(new Count.CountCst.AtLeast1(this, scp, value), new Types.TypeClass[0]) : this.post(new Count.CountCst.AtLeastK(this, (Variable[])scp, value, k), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity atMost(Variable.VariableInteger[] scp, int value, int k) {
        if (k == 0) {
            return this.refutation((IVar.Var[])scp, value);
        }
        if (k == scp.length) {
            CtrEntities ctrEntities = this.ctrEntities;
            Objects.requireNonNull(ctrEntities);
            return new CtrEntities.CtrAloneDummy(ctrEntities, "atMost with k = scp.length", new Types.TypeClass[0]);
        }
        return k == 1 ? this.post(new Count.CountCst.AtMost1(this, scp, value), new Types.TypeClass[0]) : this.post(new Count.CountCst.AtMostK(this, (Variable[])scp, value, k), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity exactly(Variable.VariableInteger[] scp, int value, int k) {
        if (k == 0) {
            return this.refutation((IVar.Var[])scp, value);
        }
        if (k == scp.length) {
            return this.instantiation((IVar.Var[])scp, value);
        }
        return k == 1 ? this.post(new Count.CountCst.Exactly1(this, scp, value), new Types.TypeClass[0]) : this.post(new Count.CountCst.ExactlyK(this, (Variable[])scp, value, k), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrEntity count(Variable.VariableInteger[] list, int[] values, Types.TypeConditionOperatorRel op, long limit) {
        int l = Utilities.safeInt(limit);
        Problem.control(0 <= l && l <= list.length, new Object[0]);
        if (values.length == 1) {
            int value = values[0];
            Variable.VariableInteger[] scp = (Variable.VariableInteger[])Stream.of(list).filter(x -> x.dom.presentValue(value) && x.dom.size() > 1).toArray(Variable.VariableInteger[]::new);
            int k = l - (int)Stream.of(list).filter(x -> x.dom.onlyContainsValue(value)).count();
            Problem.control(scp.length > 0 && 0 <= k && k <= scp.length, new Object[0]);
            if (op == Types.TypeConditionOperatorRel.LT) {
                return this.atMost(scp, value, k - 1);
            }
            if (op == Types.TypeConditionOperatorRel.LE) {
                return this.atMost(scp, value, k);
            }
            if (op == Types.TypeConditionOperatorRel.GE) {
                return this.atLeast(scp, value, k);
            }
            if (op == Types.TypeConditionOperatorRel.GT) {
                return this.atLeast(scp, value, k + 1);
            }
            if (op == Types.TypeConditionOperatorRel.EQ) {
                return this.exactly(scp, value, k);
            }
        } else if (op == Types.TypeConditionOperatorRel.EQ) {
            if (l == list.length) {
                return this.forall(this.range(list.length), (int i) -> this.intension(XNodeParent.in(list[i], this.api.set(values))));
            }
            return this.post(new Among(this, list, values, l), new Types.TypeClass[0]);
        }
        return this.unimplemented("count");
    }

    @Override
    public final CtrEntities.CtrEntity count(IVar.Var[] list, int[] values, Condition condition) {
        Problem.control(list.length > 0, "A constraint Count is posted with a scope of 0 variable");
        if (condition instanceof Condition.ConditionRel) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            Object rightTerm = condition.rightTerm();
            Variable[] scp = (Variable.VariableInteger[])this.translate(this.clean(list));
            if (condition instanceof Condition.ConditionVal) {
                return this.count((Variable.VariableInteger[])scp, values, op, (Long)rightTerm);
            }
            assert (condition instanceof Condition.ConditionVar);
            if (values.length == 1 && op == Types.TypeConditionOperatorRel.EQ) {
                return this.post(new Count.CountVar.ExactlyVarK(this, scp, values[0], (Variable)rightTerm), new Types.TypeClass[0]);
            }
        }
        return this.unimplemented("count");
    }

    @Override
    public final CtrEntities.CtrEntity count(IVar.Var[] list, IVar.Var[] values, Condition condition) {
        return this.unimplemented("count");
    }

    @Override
    public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition) {
        if (condition instanceof Condition.ConditionRel) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            Object rightTerm = condition.rightTerm();
            Variable[] scp = this.translate(this.clean(list));
            Constraint c = null;
            c = condition instanceof Condition.ConditionVal ? NValues.NValuesCst.buildFrom(this, scp, op, (Long)rightTerm) : NValues.NValuesVar.buildFrom(this, scp, op, (Variable)rightTerm);
            if (c != null) {
                return this.post(c, new Types.TypeClass[0]);
            }
        }
        return this.unimplemented("nValues");
    }

    @Override
    public CtrEntities.CtrEntity nValues(IVar.Var[] list, Condition condition, int[] exceptValues) {
        return this.unimplemented("nValues");
    }

    private CtrEntities.CtrArray postClosed(Variable[] list, int[] values) {
        return this.forall(this.range(list.length), (int i) -> {
            if (!list[i].dom.areInitValuesSubsetOf(values)) {
                this.extension(list[i], this.api.select(values, v -> list[i].dom.presentValue(v)), true);
            }
        });
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, int[] occurs) {
        Problem.control(values.length == occurs.length, new Object[0]);
        Variable[] scp = this.translate(this.clean(list));
        if (mustBeClosed) {
            this.postClosed(scp, values);
        }
        return this.post(new Cardinality.CardinalityConstant(this, scp, values, occurs), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, IVar.Var[] occurs) {
        Problem.control(values.length == occurs.length && Stream.of(occurs).noneMatch(x -> x == null), new Object[0]);
        Variable[] scp = this.translate(this.clean(list));
        if (mustBeClosed) {
            this.postClosed(scp, values);
        }
        return this.forall(this.range(values.length), (int i) -> this.post(new Count.CountVar.ExactlyVarK(this, scp, values[i], (Variable)((Object)occurs[i])), new Types.TypeClass[0]));
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, int[] values, boolean mustBeClosed, int[] occursMin, int[] occursMax) {
        Problem.control(values.length == occursMin.length && values.length == occursMax.length, new Object[0]);
        return this.post(new Cardinality.CardinalityConstant(this, this.translate(this.clean(list)), values, occursMin, occursMax), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, int[] occurs) {
        Problem.control(values.length == occurs.length && Stream.of(values).noneMatch(x -> x == null), new Object[0]);
        return this.unimplemented("cardinality");
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, IVar.Var[] occurs) {
        Problem.control(values.length == occurs.length && Stream.of(values).noneMatch(x -> x == null) && Stream.of(occurs).noneMatch(x -> x == null), new Object[0]);
        return this.unimplemented("cardinality");
    }

    @Override
    public final CtrEntities.CtrEntity cardinality(IVar.Var[] list, IVar.Var[] values, boolean mustBeClosed, int[] occursMin, int[] occursMax) {
        Problem.control(values.length == occursMin.length && values.length == occursMax.length && Stream.of(values).noneMatch(x -> x == null), new Object[0]);
        return this.unimplemented("cardinality");
    }

    private final CtrEntities.CtrEntity extremum(IVar.Var[] list, Condition condition, boolean minimum) {
        if (condition instanceof Condition.ConditionRel) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            Object rightTerm = condition.rightTerm();
            Variable[] vars = this.translate(this.clean(list));
            Constraint c = null;
            if (condition instanceof Condition.ConditionVal) {
                if (vars.length == 1) {
                    return this.intension(XNodeParent.build(op.toExpr(), vars[0], (Long)rightTerm));
                }
                c = Extremum.ExtremumCst.buildFrom(this, vars, op, (Long)rightTerm, minimum);
            } else if (op == Types.TypeConditionOperatorRel.EQ) {
                Variable y = (Variable)rightTerm;
                if (vars.length == 1) {
                    return this.equal(vars[0], y);
                }
                if (Stream.of(vars).anyMatch(x -> x == y)) {
                    return this.forall(this.range(vars.length), (int i) -> {
                        if (y != vars[i]) {
                            if (minimum) {
                                this.lessEqual(y, vars[i]);
                            } else {
                                this.greaterEqual(y, vars[i]);
                            }
                        }
                    });
                }
                if (this.head.control.global.smartTable) {
                    c = minimum ? CSmart.buildMinimum(this, vars, y) : CSmart.buildMaximum(this, vars, y);
                } else {
                    Constraint constraint = c = minimum ? new Extremum.ExtremumVar.Minimum(this, vars, y) : new Extremum.ExtremumVar.Maximum(this, vars, y);
                }
            }
            if (c != null) {
                return this.post(c, new Types.TypeClass[0]);
            }
        }
        return this.unimplemented(minimum ? "minimum" : "maximum");
    }

    private final CtrEntities.CtrEntity extremum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition, boolean minimum) {
        return this.unimplemented(minimum ? "minimum" : "maximum");
    }

    @Override
    public final CtrEntities.CtrEntity minimum(IVar.Var[] list, Condition condition) {
        return this.extremum(list, condition, true);
    }

    @Override
    public final CtrEntities.CtrEntity minimum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank) {
        return this.extremum(list, startIndex, index, rank, null, true);
    }

    @Override
    public final CtrEntities.CtrEntity minimum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        return this.extremum(list, startIndex, index, rank, condition, true);
    }

    @Override
    public final CtrEntities.CtrEntity minimum(XNode<IVar>[] trees, Condition condition) {
        return this.minimum(this.replaceByVariables(trees), condition);
    }

    @Override
    public final CtrEntities.CtrEntity maximum(IVar.Var[] list, Condition condition) {
        return this.extremum(list, condition, false);
    }

    @Override
    public final CtrEntities.CtrEntity maximum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank) {
        return this.extremum(list, startIndex, index, rank, null, false);
    }

    @Override
    public final CtrEntities.CtrEntity maximum(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        return this.extremum(list, startIndex, index, rank, condition, false);
    }

    @Override
    public final CtrEntities.CtrEntity maximum(XNode<IVar>[] trees, Condition condition) {
        return this.maximum(this.replaceByVariables(trees), condition);
    }

    @Override
    public final CtrEntities.CtrAlone element(IVar.Var[] list, Condition condition) {
        if (condition instanceof Condition.ConditionVal && ((Condition.ConditionRel)condition).operator == Types.TypeConditionOperatorRel.EQ) {
            return (CtrEntities.CtrAlone)this.atLeast((Variable.VariableInteger[])this.translate(list), Utilities.safeInt(((Condition.ConditionVal)condition).k), 1);
        }
        return (CtrEntities.CtrAlone)this.unimplemented("element");
    }

    private CtrEntities.CtrAlone element(IVar.Var[] list, IVar.Var index, int value) {
        if (this.head.control.global.jokerTable) {
            return this.extension((IVar.Var[])this.vars(new Object[]{index, list}), constraints.extension.structures.Table.shortTuplesForElement(this.translate(list), (Variable)((Object)index), value), true);
        }
        return this.post(new Element.ElementConstant(this, this.translate(list), (Variable)((Object)index), value), new Types.TypeClass[0]);
    }

    private CtrEntities.CtrAlone element(IVar.Var[] list, IVar.Var index, IVar.Var value) {
        if (this.head.control.global.smartTable) {
            return this.post(CSmart.buildElement(this, this.translate(list), (Variable)((Object)index), (Variable)((Object)value)), new Types.TypeClass[0]);
        }
        if (this.head.control.global.jokerTable) {
            return this.extension(Utilities.indexOf(value, list) == -1 ? (IVar.Var[])this.vars(new Object[]{index, list, value}) : (IVar.Var[])this.vars(new Object[]{index, list}), constraints.extension.structures.Table.shortTuplesForElement(this.translate(list), (Variable)((Object)index), (Variable)((Object)value)), true);
        }
        return this.post(new Element.ElementVariable(this, this.translate(list), (Variable)((Object)index), (Variable)((Object)value)), new Types.TypeClass[0]);
    }

    @Override
    public final CtrEntities.CtrAlone element(IVar.Var[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        this.unimplementedIf(startIndex != 0 || rank != null && rank != Types.TypeRank.ANY, "element");
        Domain idom = ((Variable)((Object)index)).dom;
        if (!idom.areInitValuesExactly(this.api.range(0, list.length))) {
            ArrayList<Variable> tmp = new ArrayList<Variable>();
            int a = idom.first();
            while (a != -1) {
                int va = idom.toVal(a);
                if (0 > va || va >= list.length) {
                    return (CtrEntities.CtrAlone)this.unimplemented("element with an index (variable) with a bad value");
                }
                tmp.add((Variable)((Object)list[va]));
                a = idom.next(a);
            }
            list = (IVar.Var[])tmp.stream().toArray(IVar.Var[]::new);
        }
        if (condition instanceof Condition.ConditionRel && ((Condition.ConditionRel)condition).operator == Types.TypeConditionOperatorRel.EQ) {
            if (condition instanceof Condition.ConditionVal) {
                return this.element(list, index, Utilities.safeInt(((Condition.ConditionVal)condition).k));
            }
            return this.element(list, index, (IVar.Var)((Condition.ConditionVar)condition).x);
        }
        int min = Stream.of(list).mapToInt(x -> ((Variable)((Object)x)).dom.firstValue()).min().getAsInt();
        int max = Stream.of(list).mapToInt(x -> ((Variable)((Object)x)).dom.lastValue()).max().getAsInt();
        IVar.Var aux = this.newAuxVar(new Range(min, max + 1));
        if (!(condition instanceof Condition.ConditionRel)) {
            return (CtrEntities.CtrAlone)this.unimplemented("element " + condition);
        }
        this.intension(XNodeParent.build(((Condition.ConditionRel)condition).operator.toExpr(), aux, condition.rightTerm()));
        return this.element(list, index, aux);
    }

    private CtrEntities.CtrEntity element(int[] list, int startIndex, IVar.Var index, IVar.Var value, int startValue) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        Domain dx = ((Variable)((Object)index)).dom;
        Domain dz = ((Variable)((Object)value)).dom;
        int a = dx.first();
        while (a != -1) {
            int va = dx.toVal(a) - startIndex;
            if (0 <= va && va < list.length && dz.presentValue(list[va] - startValue)) {
                l.add(new int[]{va + startIndex, list[va] - startValue});
            }
            a = dx.next(a);
        }
        return this.extension((IVar.Var[])this.vars(new Object[]{index, value}), Table.clean(l), true);
    }

    private CtrEntities.CtrEntity element(int[] list, int startIndex, IVar.Var index, Types.TypeRank rank, IVar.Var value) {
        this.unimplementedIf(rank != null && rank != Types.TypeRank.ANY, "element");
        return this.element(list, startIndex, index, value, 0);
    }

    @Override
    public final CtrEntities.CtrEntity element(int[] list, int startIndex, IVar.Var index, Types.TypeRank rank, Condition condition) {
        this.unimplementedIf(rank != null && rank != Types.TypeRank.ANY, "element");
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionRel)condition).operator == Types.TypeConditionOperatorRel.EQ) {
            return this.element(list, startIndex, index, rank, (IVar.Var)condition.rightTerm());
        }
        return (CtrEntities.CtrAlone)this.unimplemented("element");
    }

    private CtrEntities.CtrEntity element(int[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, IVar.Var value) {
        this.unimplementedIf(startRowIndex != 0 && startColIndex != 0, "element");
        ArrayList<int[]> tuples = new ArrayList<int[]>();
        Domain dx = ((Variable)((Object)rowIndex)).dom;
        Domain dy = ((Variable)((Object)colIndex)).dom;
        Domain dz = ((Variable)((Object)value)).dom;
        int a = dx.first();
        while (a != -1) {
            int b = dy.first();
            while (b != -1) {
                int i = dx.toVal(a);
                int j = dy.toVal(b);
                if (0 <= i && i < matrix.length && 0 <= j && j < matrix[i].length && dz.presentValue(matrix[i][j])) {
                    tuples.add(new int[]{i, j, matrix[i][j]});
                }
                b = dy.next(b);
            }
            a = dx.next(a);
        }
        return this.extension((IVar.Var[])this.vars(new Object[]{rowIndex, colIndex, value}), Table.clean(tuples), true);
    }

    @Override
    public CtrEntities.CtrEntity element(int[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, Condition condition) {
        this.unimplementedIf(startRowIndex != 0 && startColIndex != 0, "element");
        if (condition instanceof Condition.ConditionVar && ((Condition.ConditionRel)condition).operator == Types.TypeConditionOperatorRel.EQ) {
            return this.element(matrix, startRowIndex, rowIndex, startColIndex, colIndex, (IVar.Var)condition.rightTerm());
        }
        return (CtrEntities.CtrAlone)this.unimplemented("element");
    }

    private CtrEntities.CtrEntity element(IVar.Var[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, int value) {
        this.unimplementedIf(startRowIndex != 0 && startColIndex != 0, "element");
        if (rowIndex == colIndex) {
            Problem.control(matrix.length == matrix[0].length, new Object[0]);
            IVar.Var[] t = (IVar.Var[])IntStream.range(0, matrix.length).mapToObj(i -> matrix[i][i]).toArray(IVar.Var[]::new);
            return this.element(t, rowIndex, value);
        }
        return this.post(new ElementMatrix(this, (Variable[][])matrix, (Variable)((Object)rowIndex), (Variable)((Object)colIndex), value), new Types.TypeClass[0]);
    }

    public CtrEntities.CtrEntity element(IVar.Var[][] matrix, int startRowIndex, IVar.Var rowIndex, int startColIndex, IVar.Var colIndex, Condition condition) {
        this.unimplementedIf(startRowIndex != 0 && startColIndex != 0, "element");
        if (condition instanceof Condition.ConditionVal && ((Condition.ConditionRel)condition).operator == Types.TypeConditionOperatorRel.EQ) {
            return this.element(matrix, startRowIndex, rowIndex, startColIndex, colIndex, Utilities.safeInt(((Condition.ConditionVal)condition).k));
        }
        return (CtrEntities.CtrAlone)this.unimplemented("element");
    }

    @Override
    public CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex) {
        return this.unimplemented("channel");
    }

    @Override
    public CtrEntities.CtrEntity channel(IVar.Var[] list1, int startIndex1, IVar.Var[] list2, int startIndex2) {
        Problem.control(Stream.of(list1).noneMatch(x -> x == null) && Stream.of(list2).noneMatch(x -> x == null), new Object[0]);
        Problem.control(startIndex1 == 0 && startIndex2 == 0, "unimplemented case for channel");
        if (list1.length == list2.length) {
            this.allDifferent(list1);
            this.allDifferent(list2);
        }
        return this.forall(this.range(list1.length), (int i) -> this.element(list2, list1[i], i));
    }

    @Override
    public final CtrEntities.CtrEntity channel(IVar.Var[] list, int startIndex, IVar.Var value) {
        Problem.control(Stream.of(list).noneMatch(x -> x == null) && startIndex == 0, new Object[0]);
        Problem.control(Variable.areAllInitiallyBoolean((Variable[])list) && ((Variable)((Object)value)).dom.areInitValuesExactly(this.range(list.length)), new Object[0]);
        return this.forall(this.range(list.length), (int i) -> this.post(new PrimitiveBinary.PrimitiveBinaryLog.LogEQ2(this, (Variable)((Object)list[i]), (Variable)((Object)value), i), new Types.TypeClass[0]));
    }

    @Override
    public CtrEntities.CtrEntity stretch(IVar.Var[] list, int[] values, int[] widthsMin, int[] widthsMax, int[][] patterns) {
        Problem.control(values.length == widthsMin.length && values.length == widthsMax.length, new Object[0]);
        Problem.control(IntStream.range(0, values.length).allMatch(i -> widthsMin[i] <= widthsMax[i]), new Object[0]);
        Problem.control(patterns == null || Stream.of(patterns).allMatch(t -> ((int[])t).length == 2), new Object[0]);
        return this.unimplemented("stretch");
    }

    @Override
    public final CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, int[] lengths, boolean zeroIgnored) {
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        if (this.head.control.global.redundNoOverlap) {
            IVar.Var[] aux = this.newAuxVarArray(origins.length, this.range(origins.length));
            this.allDifferent(aux);
            for (int i = 0; i < origins.length; ++i) {
                for (int j = i + 1; j < origins.length; ++j) {
                    this.intension(XNodeParent.iff(XNodeParent.le(aux[i], aux[j]), XNodeParent.le(origins[i], origins[j])));
                }
            }
        }
        for (int i = 0; i < origins.length; ++i) {
            for (int j = i + 1; j < origins.length; ++j) {
                Variable xi = (Variable)((Object)origins[i]);
                Variable xj = (Variable)((Object)origins[j]);
                int li = lengths[i];
                int lj = lengths[j];
                if (this.head.control.global.typeNoOverlap == 1) {
                    this.intension(XNodeParent.or(XNodeParent.le(XNodeParent.add(xi, li), xj), XNodeParent.le(XNodeParent.add(xj, lj), xi)));
                    continue;
                }
                if (this.head.control.global.typeNoOverlap == 222) {
                    this.post(CSmart.buildNoOverlap(this, xi, xj, li, lj), new Types.TypeClass[0]);
                    continue;
                }
                this.post(new PrimitiveBinary.Disjonctive(this, xi, li, xj, lj), new Types.TypeClass[0]);
            }
        }
        return null;
    }

    @Override
    public final CtrEntities.CtrEntity noOverlap(IVar.Var[] origins, IVar.Var[] lengths, boolean zeroIgnored) {
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        for (int i = 0; i < origins.length; ++i) {
            for (int j = i + 1; j < origins.length; ++j) {
                Variable xi = (Variable)((Object)origins[i]);
                Variable xj = (Variable)((Object)origins[j]);
                Variable wi = (Variable)((Object)lengths[i]);
                Variable wj = (Variable)((Object)lengths[j]);
                if (this.head.control.global.typeNoOverlap == 1) {
                    this.intension(XNodeParent.or(XNodeParent.le(XNodeParent.add(xi, wi), xj), XNodeParent.le(XNodeParent.add(xj, wj), xi)));
                    continue;
                }
                this.post(new Primitive.DisjonctiveVar(this, xi, xj, wi, wj), new Types.TypeClass[0]);
            }
        }
        return null;
    }

    @Override
    public final CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, int[][] lengths, boolean zeroIgnored) {
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        if (this.head.control.global.redundNoOverlap) {
            IVar[] ox = (IVar.Var[])Stream.of(origins).map(t -> t[0]).toArray(IVar.Var[]::new);
            IVar[] oy = (IVar.Var[])Stream.of(origins).map(t -> t[1]).toArray(IVar.Var[]::new);
            int[] tx = Stream.of(lengths).mapToInt(t -> t[0]).toArray();
            int[] ty = Stream.of(lengths).mapToInt(t -> t[1]).toArray();
            int minX = Stream.of(ox).mapToInt(x -> ((Variable)((Object)x)).dom.firstValue()).min().orElseThrow();
            int maxX = IntStream.range(0, ox.length).map(arg_0 -> Problem.lambda$noOverlap$123((IVar.Var[])ox, tx, arg_0)).max().orElseThrow();
            int minY = Stream.of(oy).mapToInt(x -> ((Variable)((Object)x)).dom.firstValue()).min().orElseThrow();
            int maxY = IntStream.range(0, oy.length).map(arg_0 -> Problem.lambda$noOverlap$125((IVar.Var[])oy, ty, arg_0)).max().orElseThrow();
            this.cumulative((IVar.Var[])ox, tx, null, ty, this.api.condition(Types.TypeConditionOperatorRel.LE, maxY - minY));
            this.cumulative((IVar.Var[])oy, ty, null, tx, this.api.condition(Types.TypeConditionOperatorRel.LE, maxX - minX));
            this.post(new NoOverlap(this, this.translate(ox), tx, this.translate(oy), ty), new Types.TypeClass[0]);
        }
        for (int i = 0; i < origins.length; ++i) {
            for (int j = i + 1; j < origins.length; ++j) {
                Variable xi = (Variable)((Object)origins[i][0]);
                Variable xj = (Variable)((Object)origins[j][0]);
                Variable yi = (Variable)((Object)origins[i][1]);
                Variable yj = (Variable)((Object)origins[j][1]);
                int wi = lengths[i][0];
                int wj = lengths[j][0];
                int hi = lengths[i][1];
                int hj = lengths[j][1];
                if (this.head.control.global.typeNoOverlap == 1) {
                    this.intension(XNodeParent.or(XNodeParent.le(XNodeParent.add(xi, wi), xj), XNodeParent.le(XNodeParent.add(xj, wj), xi), XNodeParent.le(XNodeParent.add(yi, hi), yj), XNodeParent.le(XNodeParent.add(yj, hj), yi)));
                    continue;
                }
                if (this.head.control.global.typeNoOverlap == 22) {
                    this.extension(this.vars(new Object[]{xi, xj, yi, yj}), (Object[])constraints.extension.structures.Table.shortTuplesForNoOverlap(xi, xj, yi, yj, wi, wj, hi, hj), true, true);
                    continue;
                }
                if (this.head.control.global.typeNoOverlap == 222) {
                    this.post(CSmart.buildNoOverlap(this, xi, yi, xj, yj, wi, hi, wj, hj), new Types.TypeClass[0]);
                    continue;
                }
                this.post(new Primitive.Disjonctive2D(this, xi, xj, yi, yj, wi, wj, hi, hj), new Types.TypeClass[0]);
            }
        }
        return null;
    }

    @Override
    public final CtrEntities.CtrEntity noOverlap(IVar.Var[][] origins, IVar.Var[][] lengths, boolean zeroIgnored) {
        this.unimplementedIf(!zeroIgnored, "noOverlap");
        for (int i = 0; i < origins.length; ++i) {
            for (int j = i + 1; j < origins.length; ++j) {
                Variable xi = (Variable)((Object)origins[i][0]);
                Variable xj = (Variable)((Object)origins[j][0]);
                Variable yi = (Variable)((Object)origins[i][1]);
                Variable yj = (Variable)((Object)origins[j][1]);
                Variable wi = (Variable)((Object)lengths[i][0]);
                Variable wj = (Variable)((Object)lengths[j][0]);
                Variable hi = (Variable)((Object)lengths[i][1]);
                Variable hj = (Variable)((Object)lengths[j][1]);
                if (this.head.control.global.typeNoOverlap == 222 && Stream.of(wi, wj, hi, hj).allMatch(x -> x.dom.initSize() == 2)) {
                    this.post(CSmart.buildNoOverlap(this, xi, yi, xj, yj, wi, hi, wj, hj), new Types.TypeClass[0]);
                    continue;
                }
                this.intension(XNodeParent.or(XNodeParent.le(XNodeParent.add(xi, wi), xj), XNodeParent.le(XNodeParent.add(xj, wj), xi), XNodeParent.le(XNodeParent.add(yi, hi), yj), XNodeParent.le(XNodeParent.add(yj, hj), yi)));
            }
        }
        return null;
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        this.unimplementedIf(ends != null, "cumulative");
        if (condition instanceof Condition.ConditionVal) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionVal)condition).operator;
            Problem.control(op == Types.TypeConditionOperatorRel.LT || op == Types.TypeConditionOperatorRel.LE, new Object[0]);
            int limit = Utilities.safeInt(((Condition.ConditionVal)condition).k);
            return this.post(new Cumulative.CumulativeCst(this, this.translate(origins), lengths, heights, op == Types.TypeConditionOperatorRel.LT ? limit + 1 : limit), new Types.TypeClass[0]);
        }
        return this.unimplemented("cumulative");
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, int[] heights, Condition condition) {
        return this.unimplemented("cumulative");
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, int[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        return this.unimplemented("cumulative");
    }

    @Override
    public final CtrEntities.CtrEntity cumulative(IVar.Var[] origins, IVar.Var[] lengths, IVar.Var[] ends, IVar.Var[] heights, Condition condition) {
        return this.unimplemented("cumulative");
    }

    public final CtrEntities.CtrEntity binpacking(IVar.Var[] list, int[] sizes, Condition condition) {
        Problem.control(list.length > 2 && list.length == sizes.length, new Object[0]);
        Variable[] vars = this.translate(list);
        boolean sameType = Variable.haveSameDomainType(vars);
        if (!sameType || this.head.control.global.typeBinpacking == 1) {
            int[] values = Variable.setOfvaluesIn(vars).stream().mapToInt(v -> v).toArray();
            return this.forall(this.range(values.length), (int v) -> this.sum(Stream.of(list).map(x -> this.api.eq(x, v)), sizes, condition));
        }
        if (condition instanceof Condition.ConditionVal) {
            Types.TypeConditionOperatorRel op = ((Condition.ConditionVal)condition).operator;
            Problem.control(op == Types.TypeConditionOperatorRel.LT || op == Types.TypeConditionOperatorRel.LE, new Object[0]);
            int limit = Utilities.safeInt(((Condition.ConditionVal)condition).k);
            return this.post(new BinPacking.BinPacking2(this, vars, sizes, limit - (op == Types.TypeConditionOperatorRel.LT ? 1 : 0)), new Types.TypeClass[0]);
        }
        return this.unimplemented("binPacking");
    }

    @Override
    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex) {
        this.unimplementedIf(startIndex != 0, "circuit");
        return this.post(new Circuit(this, this.translate(list)), new Types.TypeClass[0]);
    }

    @Override
    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, int size) {
        return this.unimplemented("circuit");
    }

    @Override
    public CtrEntities.CtrEntity circuit(IVar.Var[] list, int startIndex, IVar.Var size) {
        return this.unimplemented("circuit");
    }

    @Override
    public final CtrEntities.CtrEntity clause(IVar.Var[] list, Boolean[] phases) {
        Problem.control(Stream.of(list).noneMatch(x -> x == null), "A variable in array list is null");
        Problem.control(list.length == phases.length, "Bad form of clause");
        Problem.control(Variable.areAllInitiallyBoolean((Variable[])list), "A variable is not Boolean in the array list.");
        return this.sum(list, Stream.of(phases).mapToInt(p -> p != false ? 1 : -1).toArray(), this.api.condition(Types.TypeConditionOperatorRel.NE, -Stream.of(phases).filter(p -> p == false).count()));
    }

    public final CtrEntities.CtrEntity clause(IVar.Var[] pos, IVar.Var[] neg) {
        Problem.control(Stream.of(pos).noneMatch(x -> x == null) && Stream.of(neg).noneMatch(x -> x == null), "No null values is allowed in the specified arrays.");
        Boolean[] phases = (Boolean[])IntStream.range(0, pos.length + neg.length).mapToObj(i -> i < pos.length).toArray(Boolean[]::new);
        return this.clause((IVar.Var[])this.vars(new Object[]{pos, neg}), phases);
    }

    @Override
    public final CtrEntities.CtrEntity instantiation(IVar.Var[] list, int[] values) {
        Problem.control(list.length == values.length && list.length > 0, new Object[0]);
        return this.forall(this.range(list.length), (int i) -> this.equal(list[i], values[i]));
    }

    public final CtrEntities.CtrEntity instantiation(IVar.Var[] list, int value) {
        return this.instantiation(list, Kit.repeat(value, list.length));
    }

    public final CtrEntities.CtrEntity refutation(IVar.Var[] list, int[] values) {
        Problem.control(list.length == values.length && list.length > 0, new Object[0]);
        return this.forall(this.range(list.length), (int i) -> this.different(list[i], values[i]));
    }

    public final CtrEntities.CtrEntity refutation(IVar.Var[] list, int value) {
        return this.refutation(list, Kit.repeat(value, list.length));
    }

    @Override
    public final CtrEntities.CtrEntity slide(IVar[] list, Range range, IntFunction<CtrEntities.CtrEntity> template) {
        Problem.control(range.start == 0 && range.length() > 0, new Object[0]);
        if (range.length() == 1) {
            return template.apply(0);
        }
        return this.manageLoop(() -> IntStream.range(0, range.stop).filter(i -> i % range.step == 0).mapToObj(i -> (Constraint)((CtrEntities.CtrAlone)template.apply((int)i)).ctr).toArray(Constraint[]::new));
    }

    @Override
    public final CtrEntities.CtrEntity ifThen(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2) {
        return this.unimplemented("ifthen");
    }

    @Override
    public final CtrEntities.CtrEntity ifThenElse(CtrEntities.CtrEntity c1, CtrEntities.CtrEntity c2, CtrEntities.CtrEntity c3) {
        return this.unimplemented("ifthenElse");
    }

    public final CtrEntities.CtrAlone smart(IVar[] scp, TableSmart.SmartTuple ... smartTuples) {
        return this.post(new CSmart(this, this.translate(scp), smartTuples), new Types.TypeClass[0]);
    }

    private Optimizer buildOptimizer(Types.TypeOptimization opt, Optimizable clb, Optimizable cub) {
        Problem.control(this.optimizer == null, "Only mono-objective currently supported");
        String suffix = Kit.camelCaseOf(this.head.control.optimization.strategy.name());
        if (suffix.equals("Decreasing")) {
            return new Optimizer.OptimizerDecreasing(this, opt, clb, cub);
        }
        if (suffix.equals("Increasing")) {
            return new Optimizer.OptimizerIncreasing(this, opt, clb, cub);
        }
        Problem.control(suffix.equals("Dichotomic"), new Object[0]);
        return new Optimizer.OptimizerDichotomic(this, opt, clb, cub);
    }

    private boolean switchToSatisfaction(Types.TypeOptimization opt, Types.TypeObjective obj, int[] coeffs, Variable ... list) {
        int limit = this.settings.limitForSatisfaction;
        if (limit == Integer.MAX_VALUE) {
            return false;
        }
        if (obj == Types.TypeObjective.EXPRESSION) {
            Problem.control(list.length == 1 && coeffs == null, new Object[0]);
            this.intension(opt == Types.TypeOptimization.MINIMIZE ? XNodeParent.le(list[0], limit) : XNodeParent.ge(list[0], limit));
        } else if (coeffs != null) {
            Problem.control(obj == Types.TypeObjective.SUM, new Object[0]);
            this.sum(list, coeffs, opt == Types.TypeOptimization.MINIMIZE ? Types.TypeConditionOperatorRel.LE : Types.TypeConditionOperatorRel.GE, limit);
        } else {
            Problem.control(obj.generalizable(), new Object[0]);
            if (opt == Types.TypeOptimization.MINIMIZE) {
                if (obj == Types.TypeObjective.SUM) {
                    this.post(new Sum.SumSimple.SumSimpleLE(this, list, limit), new Types.TypeClass[0]);
                } else if (obj == Types.TypeObjective.MINIMUM) {
                    this.post(new Extremum.ExtremumCst.MinimumCst.MinimumCstLE(this, list, limit), new Types.TypeClass[0]);
                } else if (obj == Types.TypeObjective.MAXIMUM) {
                    this.forall(this.range(list.length), (int i) -> this.lessEqual(list[i], limit));
                } else {
                    this.post(new NValues.NValuesCst.NValuesCstLE(this, list, limit), new Types.TypeClass[0]);
                }
            } else if (obj == Types.TypeObjective.SUM) {
                this.post(new Sum.SumSimple.SumSimpleGE(this, list, limit), new Types.TypeClass[0]);
            } else if (obj == Types.TypeObjective.MINIMUM) {
                this.forall(this.range(list.length), (int i) -> this.greaterEqual(list[i], limit));
            } else if (obj == Types.TypeObjective.MAXIMUM) {
                this.post(new Extremum.ExtremumCst.MaximumCst.MaximumCstGE(this, list, limit), new Types.TypeClass[0]);
            } else {
                this.post(new NValues.NValuesCst.NValuesCstGE(this, list, limit), new Types.TypeClass[0]);
            }
        }
        return true;
    }

    private ObjEntities.ObjEntity optimize(Types.TypeOptimization opt, IVar x) {
        if (!this.switchToSatisfaction(opt, Types.TypeObjective.EXPRESSION, null, (Variable)x)) {
            long lb = this.head.control.optimization.lb;
            long ub = this.head.control.optimization.ub;
            this.optimizer = this.buildOptimizer(opt, this.addOptimizable(new ObjectiveVariable.ObjVarGE(this, (Variable)x, lb)), this.addOptimizable(new ObjectiveVariable.ObjVarLE(this, (Variable)x, ub)));
        }
        return null;
    }

    @Override
    public final ObjEntities.ObjEntity minimize(IVar x) {
        return this.optimize(Types.TypeOptimization.MINIMIZE, x);
    }

    @Override
    public final ObjEntities.ObjEntity maximize(IVar x) {
        return this.optimize(Types.TypeOptimization.MAXIMIZE, x);
    }

    @Override
    public final ObjEntities.ObjEntity minimize(XNode<IVar> tree) {
        return this.minimize(this.replaceByVariable(tree));
    }

    @Override
    public final ObjEntities.ObjEntity maximize(XNode<IVar> tree) {
        return this.maximize(this.replaceByVariable(tree));
    }

    private ObjEntities.ObjEntity optimize(Types.TypeOptimization opt, Types.TypeObjective type, Variable[] list) {
        Problem.control(type.generalizable(), new Object[0]);
        if (!this.switchToSatisfaction(opt, type, null, list)) {
            Constraint.CtrGlobal clb;
            long lb = this.head.control.optimization.lb;
            long ub = this.head.control.optimization.ub;
            Constraint.CtrGlobal ctrGlobal = type == Types.TypeObjective.SUM ? new Sum.SumSimple.SumSimpleGE(this, list, lb) : (type == Types.TypeObjective.MINIMUM ? new Extremum.ExtremumCst.MinimumCst.MinimumCstGE(this, list, lb) : (clb = type == Types.TypeObjective.MAXIMUM ? new Extremum.ExtremumCst.MaximumCst.MaximumCstGE(this, list, lb) : new NValues.NValuesCst.NValuesCstGE(this, list, lb)));
            Constraint.CtrGlobal cub = type == Types.TypeObjective.SUM ? new Sum.SumSimple.SumSimpleLE(this, list, ub) : (type == Types.TypeObjective.MINIMUM ? new Extremum.ExtremumCst.MinimumCst.MinimumCstLE(this, list, ub) : (type == Types.TypeObjective.MAXIMUM ? new Extremum.ExtremumCst.MaximumCst.MaximumCstLE(this, list, ub) : new NValues.NValuesCst.NValuesCstLE(this, list, ub)));
            this.optimizer = this.buildOptimizer(opt, this.addOptimizable(clb), this.addOptimizable(cub));
        }
        return null;
    }

    @Override
    public final ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list) {
        return this.optimize(Types.TypeOptimization.MINIMIZE, type, this.translate(list));
    }

    @Override
    public final ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list) {
        return this.optimize(Types.TypeOptimization.MAXIMIZE, type, this.translate(list));
    }

    private ObjEntities.ObjEntity optimize(Types.TypeOptimization opt, Types.TypeObjective type, Variable[] list, int[] coeffs) {
        Problem.control(type == Types.TypeObjective.SUM && coeffs != null, new Object[0]);
        if (!this.switchToSatisfaction(opt, type, coeffs, list)) {
            long lb = this.head.control.optimization.lb;
            long ub = this.head.control.optimization.ub;
            this.optimizer = this.buildOptimizer(opt, (Optimizable)((Object)this.sum((Variable[])list, (int[])coeffs, (Types.TypeConditionOperatorRel)Types.TypeConditionOperatorRel.GE, (long)lb, (boolean)false).ctr), (Optimizable)((Object)this.sum((Variable[])list, (int[])coeffs, (Types.TypeConditionOperatorRel)Types.TypeConditionOperatorRel.LE, (long)ub, (boolean)false).ctr));
        }
        return null;
    }

    @Override
    public final ObjEntities.ObjEntity minimize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        Problem.control(type == Types.TypeObjective.SUM && coeffs != null && list.length == coeffs.length, new Object[0]);
        if (list.length == 1) {
            return this.minimize(XNodeParent.mul(list[0], coeffs[0]));
        }
        return this.optimize(Types.TypeOptimization.MINIMIZE, type, this.translate(list), coeffs);
    }

    @Override
    public final ObjEntities.ObjEntity maximize(Types.TypeObjective type, IVar[] list, int[] coeffs) {
        Problem.control(type == Types.TypeObjective.SUM && coeffs != null && list.length == coeffs.length, new Object[0]);
        if (list.length == 1) {
            return this.maximize(XNodeParent.mul(list[0], coeffs[0]));
        }
        return this.optimize(Types.TypeOptimization.MAXIMIZE, type, this.translate(list), coeffs);
    }

    @Override
    public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees) {
        Problem.control(type != Types.TypeObjective.EXPRESSION && type != Types.TypeObjective.LEX, new Object[0]);
        if (trees.length == 1) {
            Problem.control(type != Types.TypeObjective.NVALUES, new Object[0]);
            return this.minimize(trees[0]);
        }
        return this.minimize(type, this.replaceByVariables(trees));
    }

    @Override
    public ObjEntities.ObjEntity minimize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        Problem.control(type != Types.TypeObjective.EXPRESSION && type != Types.TypeObjective.LEX && trees.length == coeffs.length, new Object[0]);
        if (trees.length == 1) {
            Problem.control(type != Types.TypeObjective.NVALUES, new Object[0]);
            return this.minimize(XNodeParent.mul(trees[0], coeffs[0]));
        }
        return this.minimize(type, this.replaceByVariables(trees), coeffs);
    }

    @Override
    public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees) {
        Problem.control(type != Types.TypeObjective.EXPRESSION && type != Types.TypeObjective.LEX, new Object[0]);
        if (trees.length == 1) {
            Problem.control(type != Types.TypeObjective.NVALUES, new Object[0]);
            return this.maximize(trees[0]);
        }
        return this.maximize(type, this.replaceByVariables(trees));
    }

    @Override
    public ObjEntities.ObjEntity maximize(Types.TypeObjective type, XNode<IVar>[] trees, int[] coeffs) {
        Problem.control(type != Types.TypeObjective.EXPRESSION && type != Types.TypeObjective.LEX && trees.length == coeffs.length, new Object[0]);
        if (trees.length == 1) {
            Problem.control(type != Types.TypeObjective.NVALUES, new Object[0]);
            return this.maximize(XNodeParent.mul(trees[0], coeffs[0]));
        }
        return this.maximize(type, this.replaceByVariables(trees), coeffs);
    }

    @Override
    public void decisionVariables(IVar[] list) {
        if (this.settings.enableAnnotations) {
            super.decisionVariables(list);
        }
    }

    private static /* synthetic */ int lambda$noOverlap$125(IVar.Var[] oy, int[] ty, int i) {
        return ((Variable)((Object)oy[i])).dom.lastValue() + ty[i];
    }

    private static /* synthetic */ int lambda$noOverlap$123(IVar.Var[] ox, int[] tx, int i) {
        return ((Variable)((Object)ox[i])).dom.lastValue() + tx[i];
    }

    private static class Term
    implements Comparable<Term> {
        long coeff;
        Object obj;

        @Override
        public int compareTo(Term term) {
            return Long.compare(this.coeff, term.coeff);
        }

        private Term(long coeff, Object obj) {
            this.coeff = coeff;
            this.obj = obj;
        }

        public String toString() {
            return this.coeff + "*" + this.obj;
        }
    }

    public static final class Symbolic {
        public final Map<String, Integer> mapOfSymbols = new HashMap<String, Integer>();

        public int[] manageSymbols(String[] symbols) {
            int[] t = new int[symbols.length];
            for (int i = 0; i < t.length; ++i) {
                assert (!symbols[i].equals("*"));
                t[i] = this.mapOfSymbols.computeIfAbsent(symbols[i], k -> this.mapOfSymbols.size());
            }
            return t;
        }

        public String[] replaceSymbols(String[] tokens) {
            String[] t = new String[tokens.length];
            for (int i = 0; i < t.length; ++i) {
                Integer v = this.mapOfSymbols.get(tokens[i]);
                t[i] = v != null ? v.toString() : tokens[i];
            }
            return t;
        }

        public int[][] replaceSymbols(String[][] tuples) {
            int[][] m = new int[tuples.length][];
            for (int i = 0; i < m.length; ++i) {
                m[i] = new int[tuples[i].length];
                for (int j = 0; j < m[i].length; ++j) {
                    Integer v = this.mapOfSymbols.get(tuples[i][j]);
                    m[i][j] = v != null ? v : (tuples[i][j].equals("*") ? 0x7FFFFFFE : Integer.parseInt(tuples[i][j]));
                }
            }
            return m;
        }
    }
}

